#!/bin/bash



#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Josef Stribny <jstribny@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "ruby"
COMPONENT="ruby"
#END GENERATED SECTION

FOUND=0
SITE_LIB_DIR="/usr/lib/ruby/site_ruby/*/*"
GEM_DIR="/usr/lib/ruby/gems/*/gems/*"
RUBY_DIRS="$SITE_LIB_DIR $GEM_DIR"

for rb_dir_or_file in `find -P $RUBY_DIRS -maxdepth 0 -type d && find -P $SITE_LIB_DIR -maxdepth 0 -type f`
do
  RPM=`rpm -qf $rb_dir_or_file`
  if [ $? -ne 0 ]; then
    log_slight_risk "$rb_dir_or_file is not owned by any RPM package."
    FOUND=1
    continue
  fi
  RPM_NAME=`rpm -q --qf "%{NAME}" $RPM`
  is_dist_native "$RPM_NAME"
  if [ $? -ne 0 ]; then
    log_slight_risk "$rb_dir_or_file is owned by an RPM package that was not signed by Red Hat."
    FOUND=1
  fi
done
if [ $FOUND -eq 1 ]; then
  exit_fail
fi

exit_pass
