#!/bin/bash

#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

export LVM_SUPPRESS_FD_WARNINGS=1
cp /proc/partitions $VALUE_TMP_PREUPGRADE/kickstart/
cp /etc/fstab $VALUE_TMP_PREUPGRADE/kickstart/
lsblk -r --noheadings > $VALUE_TMP_PREUPGRADE/kickstart/lsblk_list
pvs --noheadings --separator ':' > $VALUE_TMP_PREUPGRADE/kickstart/pvs_list
vgs --noheadings --separator ':' > $VALUE_TMP_PREUPGRADE/kickstart/vgs_list
lvdisplay -C --noheadings --separator ':' > $VALUE_TMP_PREUPGRADE/kickstart/lvdisplay

echo " * partitions - copy of system /proc/partitions file, may be used in kickstart for disk layout" >>"$KICKSTART_README"
echo " * fstab - copy of automated system mountpoints from /etc/fstab" >>"$KICKSTART_README"
echo " * lsblk_list - generated list of block devices by lsblk --list" >>"$KICKSTART_README"
echo " * pvs_list - generated list of physical volumes by pvs command " >>"$KICKSTART_README"
echo " * vgs_list - generated list of volume groups by vgs command " >>"$KICKSTART_README"

grep "[[:space:]]ext4[[:space:]]" /etc/fstab >/dev/null && exit $RESULT_INFORMATIONAL

exit $RESULT_PASS
