#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" "lscpu"
COMPONENT="distribution"
#END GENERATED SECTION

myarch=`arch`

#strange output of myarch? Bad luck...
[ -z $myarch ] && exit $RESULT_ERROR
#Do we have 32 bit architecture?
if [ $myarch == "i686" ] || [ $myarch == "ppc" ] || [ $myarch == "s390" ];
then
  lscpu | grep "64-bit" >/dev/null && log_extreme_risk "Your system has 64 bit capabilities, but the installation is 32 bit. This may very likely break the in-place upgrade. You should consider clean installation." && exit $RESULT_FAIL
  log_extreme_risk "Your system has only 32 bit capabilities. Red Hat Enterprise Linux 7 32 bit installations are not supported. You should consider keeping Red Hat Enterprise Linux 6 or getting new hardware/CPU."
fi
if [ $myarch == "ppc64" ] || [ $myarch == "x86_64" ] || [ $myarch == "s390x" ];
then
exit $RESULT_PASS
fi
#Should not happen, but for safety.
log_extreme_risk "Invalid architecture $myarch - this is not supported for Red Hat Enterprise Linux 6."
exit $RESULT_ERROR
