#! /usr/bin/env bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Boris Ranto <branto@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "policycoreutils-python"
COMPONENT="policycoreutils-python"
#END GENERATED SECTION

# This check can be used if you need root privilegues
check_root

SEMANAGE_EXPORT_FILE=semanage_export

RESULT=$RESULT_PASS

semanage -o "$SEMANAGE_EXPORT_FILE"

TARGET_DIR="${POSTUPGRADE_DIR}/selinux"
TARGET_SCRIPT_NAME="01-restoreConfig.sh"

if test -s "$SEMANAGE_EXPORT_FILE"; then
	mkdir -p ${TARGET_DIR}
	mv "$SEMANAGE_EXPORT_FILE" ${TARGET_DIR}
	cp postupgrade.d/restoreConfig.sh ${TARGET_DIR}/${TARGET_SCRIPT_NAME}
	chmod a+x ${TARGET_DIR}/${TARGET_SCRIPT_NAME}
	RESULT="$RESULT_FIXED"
	log_info "Custom selinux configuration has been saved and it will be restored by a postupgrade script after the system upgrade."
fi

exit $RESULT
