#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Jakub Dornak <jdornak@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to ""
COMPONENT=""
#END GENERATED SECTION

# check whether the system is registered with RHN Classic
if [ -e /etc/sysconfig/rhn/systemid ]; then
    serverURL="$(egrep '^\s*serverURL\s*=' /etc/sysconfig/rhn/up2date | tail -n 1 | sed -r -e 's/^\s*serverURL\s*=\s*//' -e 's/\s+$//')"
    if [ "$serverURL" = "https://xmlrpc.rhn.redhat.com/XMLRPC" ]; then
        log_high_risk "The system is registered with RHN Classic, which is not supported in RHEL 7."
    else
        log_medium_risk "The system is registered either with RHN Sattelite or RHN Proxy. Ensure that Your RHN Sattelite or RHN Proxy doesn't use RHN Classic as the source of updates. RHN Classic does not provide updates for RHEL 7."
    fi
    exit_fail
else
    exit_not_applicable
fi

