#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" ""
COMPONENT="distribution"
#END GENERATED SECTION

COMPONENT="distribution"
[ ! -f "$VALUE_RPM_QA" ] && exit $RESULT_NOT_APPLICABLE

#check for Red Hat RHEL 6 keys and filter them out.
#based on https://access.redhat.com/site/security/team/key/
grep -v "199e2f91fd431d51" "$VALUE_RPM_QA" | grep -v "5326810137017186" | \
grep -v "938a80caf21541eb" | grep -v "fd372689897da07a" | \
grep -v "45689c882fa658e0" >"$VALUE_TMP_PREUPGRADE/kickstart/nonrhpkgs" || \
(log_none_risk "All packages are RH signed, no 3rd party keys detected" && exit $RESULT_PASS)
echo " * nonrhpkgs - this file contains all RHEL 6 packages not signed by RH keys - you will have to handle them yourself." >>"$KICKSTART_README"

#We detected some non-redhat package
log_high_risk "We detected some non-RH signed packages, you can find the list in [link:kickstart/nonrhpkgs]. You need to handle them yourself!"
exit $RESULT_FAIL
