#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Pavel Raiskup <praiskup@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to ""
check_rpm_to "perl" ""
COMPONENT=""
#END GENERATED SECTION

perl_wrapper="$(dirname ${BASH_SOURCE})"/parse

packages=$(cat /root/preupgrade/RHEL6_7/common/default*_downgraded | \
    cut -d'|' -f1 | sort | uniq | $perl_wrapper $VALUE_RPM_RHSIGNED)

rv=$?

postupgradedir=$VALUE_TMP_PREUPGRADE/postupgrade.d/pkgdowngrades
fixfile=$postupgradedir/fixpkgdowngrades.sh

generate_postupgrade_script()
{
    mkdir -p $postupgradedir &>/dev/null
    cat <<EOF >>$fixfile
if [ "\$(id -u)" != 0 ]; then
    echo >&2 "please, run this under 'root' user"
    exit 1
fi
yum distro-sync -y $*
EOF

    chmod +x $fixfile
}

case "$rv" in
    0)
        exit_pass
        ;;
    1)
        packages=`echo $packages`
        log_error "packages $packages are downgraded in RHEL7"
        log_medium_risk "having one of [$packages] package installed breaks upgrade"

        generate_postupgrade_script "$packages"

        #sed -i "s|@fix_command@|$fixfile|" $SOLUTION_FILE
        exit_fixed
        ;;
    *)
        log_error "unknown error"
        exit_error
        ;;
esac
