#!/bin/bash



#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Jaromir Koncicky <jkoncicky@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "dhcp"
COMPONENT="dhcp"
#END GENERATED SECTION

for servicename in dhcpd dhcpd6 dhcrelay; do
  if [ -f /etc/sysconfig/${servicename} ]; then
    source /etc/sysconfig/${servicename}
    if [ "${servicename}" == "dhcrelay" ]; then
        args=$DHCRELAYARGS
    else
        args=$DHCPDARGS
    fi
    # value is non-empty, inform user that it will be moved into .service file
    if [ -n "${args}" ]; then
      exit $RESULT_INFORMATIONAL
    fi
  fi
done

exit $RESULT_PASS
