#!/bin/bash
#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Pisar <ppisar@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "quota"
check_rpm_to "" ""
COMPONENT="quota"
#END GENERATED SECTION

function solution() {
    printf '%s\n\n' "$@" | fold -s >> "$SOLUTION_FILE" || exit_error
}

solution 'Quota netlink daemon has been moved from "quota" package into "quota-nld" package.'

if service_is_enabled 'quota_nld'; then
    solution '"quota_nld" service is enabled on the old system.'

    mkdir postupgrade.d || exit_error
    cat <<'EOM' >postupgrade.d/install_package.sh || exit_error
#/bin/sh
yum --assumeyes install quota-nld
EOM
    chmod +x postupgrade.d/install_package.sh || exit_error

    solution '"quota-nld" package will be installed by a postupgrade scriptlet.'
    solution 'You can reenable "quota_nld" service with "systemctl enable
quota_nld.service" command and then reboot, or start it with "systemctl
start quota_nld.service" immediately on the new system.'
    exit_fixed
else
    solution '"quota_nld" service is not enabled on the old system.'
    solution '"quota-nld" package will not be installed into the new system.'
    exit_pass
fi

exit_unknown
