#!/bin/bash

#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" ""
COMPONENT="distribution"
#END GENERATED SECTION

ObsoletedPkgs=$(mktemp .obsoletedpkgsXXX --tmpdir=/tmp)
cat /root/preupgrade/RHEL6_7/common/default*_obsoleted* | grep -v "\.so" | cut -f1,3 -d' ' | tr ' ' '|' | sort | uniq >"$ObsoletedPkgs"


[ ! -f "$VALUE_RPM_RHSIGNED" ] && \
  log_error generic Common content part is missing! &&
  exit $RESULT_ERROR

[ ! -r "$ObsoletedPkgs" ] && \
  log_error generic Part of the content is missing! && \
  exit $RESULT_ERROR

found=0
rm -f solution.txt
echo \
"Some of the packages were obsoleted between RHEL 6 and RHEL 7. This means
Red Hat provides some alternative for them, but these alternatives may be
not 100% compatible - thus we don't replace them automatically. For some of
the obsoletes you will get the incompatibilities from separate preupgrade
contents and you can adjust your workflow according to the changes. Sometimes,
package might be replaced by several others.

Following packages were obsoleted by different ones:" >solution.txt

#Check for package obsolete type replacements in packages
while read i
do
  l=$(echo $i | cut -d'|' -f1)
  m=$(echo $i | cut -d'|' -f2)
  #skip non-rh and unavailable packages
  grep -e "^$l[[:space:]]" "$VALUE_RPM_RHSIGNED" >/dev/null || continue
  j=" (required by NonRH signed package(s):"
  for k in $(rpm -q --whatrequires $l | grep -v "^no package requires" | \
   rev | cut -d'-' -f3- | rev)
  do
    grep -e "^$k[[:space:]]" "$VALUE_RPM_RHSIGNED" >/dev/null || j="$j$k "
  done
  j="$j)"
  [ "$j" == " (required by NonRH signed package(s):)" ] && j=""
  [ -n "$j" ] && log_high_risk "Package $l $j removed (obsoleted) between RHEL 6 and RHEL 7"
  echo "$l$j was obsoleted by $m" >>solution.txt
  found=1
done < "$ObsoletedPkgs"
rm -f "$ObsoletedPkgs"

grep required solution.txt >>"$VALUE_TMP_PREUPGRADE/kickstart/ObsoletedPkg-required"
grep "obsoleted by" solution.txt | grep -v required >> "$VALUE_TMP_PREUPGRADE/kickstart/ObsoletedPkg-optional"
grep required "$VALUE_TMP_PREUPGRADE/kickstart/ObsoletedPkg-required" >/dev/null || rm "$VALUE_TMP_PREUPGRADE/kickstart/ObsoletedPkg-required"
grep obsoleted "$VALUE_TMP_PREUPGRADE/kickstart/ObsoletedPkg-optional" >/dev/null || rm "$VALUE_TMP_PREUPGRADE/kickstart/ObsoletedPkg-optional"
[ -f "$VALUE_TMP_PREUPGRADE/kickstart/ObsoletedPkg-required" ] && \
  echo " * ObsoletedPkg-required - This file contains all RHEL 6 packages, which were in RHEL 7 replaced by some alternative which is not 100% compatible. As some of your packages depends on it, you should very closely check the changes. Replacements may or may not be handled by rhelup automatically." >>"$VALUE_TMP_PREUPGRADE/kickstart/README"
[ -f "$VALUE_TMP_PREUPGRADE/kickstart/ObsoletedPkg-optional" ] && \
  echo " * ObsoletedPkg-optional - Similar to ObsoletedPkg-required, but in this case no non-rh package requires this. It is up to you how you deal with these." >>"$VALUE_TMP_PREUPGRADE/kickstart/README"


echo \
"
If some NonRH signed package requires these packages, you may need to check if the
alternative solution provided by Red Hat does work for you or get the missing package
from different sources than RHEL. You need to install these new packages yourself
after the assessment, as Red Hat can't assess the compatibility for you." >>solution.txt

[ $found -eq 1 ] && log_medium_risk "\
We detected some packages installed on the system were removed (obsoleted) between RHEL 6 and RHEL 7. This may break the functionality of the packages depending on them." && exit $RESULT_FAIL

rm -f solution.txt && touch solution.txt

exit $RESULT_PASS
