#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" ""
COMPONENT="distribution"
#END GENERATED SECTION

[ ! -f "$VALUE_EXECUTABLES" ] && \
  log_error "generic Part content part is missing!" &&
  exit $RESULT_ERROR

[ ! -f safelibs ] && \
  log_error "safelibs file is missing!" &&
  exit $RESULT_ERROR


BINARIES="binaries"
touch $BINARIES
SCRIPTS="scripts"
touch $SCRIPTS
FOUND_BIN=0
FOUND_SCR=0
# Check what binaries are not handled by our package and which needs to be
# rebuilded on the new system
while read line
do
	if [ ${line:0:4} = "/tmp" ]; then
		continue
	fi
	if [ -d "$line" ]; then
		continue
	fi
	if [ ! -L "$line" ]; then
        TYPE=`file "$line"`
        echo $TYPE | grep "ELF" > /dev/null 2>&1
        if [ $? -eq 0 ]; then
            #we need to use -w -F - to prevent escaping and "substring matches" issues
            grep -m1 -w -F "$line" $VALUE_RPMTRACKEDFILES > /dev/null 2>&1 && continue
            if [ $? -ne 0 ]; then
                FOUND_BIN=1
                unsafe=0
                #todo - check for redhat signed rpm, add postupgrade to install
                #potentially changed lib
                for i in $(ldd "$line" | cut -d' ' -f1);do
                    grep -m1 $i safelibs >/dev/null || unsafe=1
                done
                SAFETY=""
                [ $unsafe -eq 0 ] && SAFETY="(Can be used on RHEL 7 without rebuild)"
                echo "$line $SAFETY" >> $BINARIES
            fi
        else
            echo $TYPE | grep "script" > /dev/null 2>&1
            if [ $? -eq 0 ]; then
                #we need to use -w -F - to prevent escaping and "substring matches" issues
                grep -m1 -w -F "$line" $VALUE_RPMTRACKEDFILES > /dev/null 2>&1 && continue
                FOUND_SCR=1
                echo "$line" >> $SCRIPTS
            fi
        fi
	fi
done < $VALUE_EXECUTABLES

if [ $FOUND_BIN -eq 1 -o $FOUND_SCR -eq 1 ]; then
    if [ $FOUND_BIN -eq 1 ]; then
        log_slight_risk "Some binaries untracked by RPM were discovered on the system and may need rebuild after upgrade."
        cp $BINARIES $VALUE_TMP_PREUPGRADE/kickstart/$BINARIES
    fi
    if [ $FOUND_SCR -eq 1 ]; then
        log_slight_risk "Some scripts untracked by RPM were discovered on the system and may not work properly after upgrade."
        cp $SCRIPTS $VALUE_TMP_PREUPGRADE/kickstart/$SCRIPTS
    fi
    exit_fail
fi

exit_pass
