#!/bin/bash

#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

FSTAB="/etc/fstab"

log_debug "The script checks whether /usr directory is on separate partition."
log_debug "Checking $FSTAB file"
grep [[:space:]]/usr[[:space:]] $FSTAB > /dev/null
if [ $? -eq 0 ]; then
    log_extreme_risk "/usr directory is on separate partition. In-place Upgrade is NOT possible."
    exit $RESULT_FAIL
fi
log_debug "Checking $FSTAB file done"
log_debug "/usr directory is not on separate partition. In-place upgrade is possible"
exit $RESULT_PASS
