#!/bin/bash

CONFIG_FILE=/etc/httpd/conf/httpd.conf
CONFIG_PATH=/etc/httpd
DATA_DIR=./httpd-data

if [ ! -f "$CONFIG_FILE" ]; then
    echo "Configuration file does not exist"
    exit 0
fi


grep -i "Include conf.modules.d/\\*.conf" $CONFIG_FILE
if [ $? -ne 0 ]; then
    sed -i -e '/^ServerRoot/{s/$/\nInclude conf.modules.d\/\*.conf/}' $CONFIG_FILE
fi

while read line
do
    grep -i "^[ \t]*LoadModule.*$line" $CONFIG_FILE
    if [ $? -eq 0 ]; then
	sed -i -e "/^[ \t]*LoadModule.*$line/d" $CONFIG_FILE
    fi
done <"$DATA_DIR/default_modules"

while read line
do
    grep -i "^[ \t]*LoadModule.*$line" $CONFIG_FILE
    if [ $? -eq 0 ]; then
	sed -i -e "/^[ \t]*LoadModule.*$line/d" $CONFIG_FILE
    fi
done <"$DATA_DIR/removed_modules"

grep -i "^[ \t]*LoadModule ldap_module" $CONFIG_FILE && \
grep -i "^[ \t]*LDAP.*\|^[ \t]*AuthLDAP.*" $CONFIG_FILE
if [ $? -eq 0 ]; then
    yum install -y mod_ldap
fi

grep -i "^[ \t]*LoadModule speling_module" $CONFIG_FILE && \
grep -i "^[ \t]*CheckSpelling" $CONFIG_FILE
if [ $? -eq 0 ]; then
    sed -i -e 's/#LoadModule speling_module/LoadModule speling_module/' $CONFIG_FILE
fi

grep -i "^[ \t]*LoadModule usertrack_module" $CONFIG_FILE && \
grep -i "^[ \t]*Cookie.*" $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf
if [ $? -eq 0 ]; then
    sed -i -e 's/#LoadModule usertrack_module/LoadModule usertrack_module/' $CONFIG_FILE
fi

grep -i "^[ \t]*HTTPD=.*worker.*" /etc/sysconfig/httpd
if [ $? -eq 0 ]; then
    sed -i -e 's/#LoadModule mpm_worker_module/LoadModule mpm_worker_module/' $CONFIG_PATH/conf.modules.d/00-mpm.conf
    sed -i -e 's/LoadModule mpm_prefork_module/#LoadModule mpm_prefork_module/' $CONFIG_PATH/conf.modules.d/00-mpm.conf
fi

grep -i "^[ \t]*HTTPD=.*event.*" /etc/sysconfig/httpd
if [ $? -eq 0 ]; then
    sed -i -e 's/#LoadModule mpm_event_module/LoadModule mpm_event_module/' $CONFIG_PATH/conf.modules.d/00-mpm.conf
    sed -i -e 's/LoadModule mpm_prefork_module/#LoadModule mpm_prefork_module/' $CONFIG_PATH/conf.modules.d/00-mpm.conf
fi

grep -i "^[ \t]*LoadModule perl_module" $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf
if [ $? -eq 0 ]; then
    grep -i "^[ \t]*Perl.*" $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf
    if [ $? -ne 0 ]; then
	ls $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf | xargs sed -i -e 's/LoadModule perl_module/#LoadModule perl_module/'
    fi
fi

grep -i "^[ \t]*LoadModule dnssd_module" $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf
if [ $? -eq 0 ]; then
    grep -i "^[ \t]*DNSSDEnable" $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf
    if [ $? -ne 0 ]; then
	ls $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf | xargs sed -i -e 's/LoadModule dnssd_module/#LoadModule dnssd_module/'
    fi
fi

grep -i "^[ \t]*LoadModule auth_pgsql_module" $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf
if [ $? -eq 0 ]; then
    grep -i "^[ \t]*Auth_PG.*" $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf
    if [ $? -ne 0 ]; then
	ls $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf | xargs sed -i -e 's/LoadModule auth_pgsql_module/#LoadModule auth_pgsql_module/'
    fi
fi

grep -i "^[ \t]*LoadModule mysql_auth_module" $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf
if [ $? -eq 0 ]; then
    grep -i "^[ \t]*AuthMySQL.*" $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf
    if [ $? -ne 0 ]; then
	ls $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf | xargs sed -i -e 's/LoadModule mysql_auth_module/#LoadModule mysql_auth_module/'
    fi
fi

grep -i "^[ \t]*SSLMutex default" $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf
if [ $? -eq 0 ]; then
    ls $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf | xargs sed -i -e 's/SSLMutex default/#SSLMutex default/'
fi

grep -i "^[ \t]*SSLPassPhraseDialog[ \t]*builtin" $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf
if [ $? -eq 0 ]; then
    ls $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf | xargs sed -i -e 's|SSLPassPhraseDialog[ \t]*builtin|SSLPassPhraseDialog exec:/usr/libexec/httpd-ssl-pass-dialog|'
fi

grep -i "^[ \t]*SSLSessionCache[ \t]*shmcb:/var/cache/mod_ssl/scache" $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf
if [ $? -eq 0 ]; then
    ls $CONFIG_FILE $CONFIG_PATH/conf.d/*.conf | xargs sed -i -e 's|shmcb:/var/cache/mod_ssl/scache|shmcb:/run/httpd/sslcache|'
fi

exit 0
