#!/bin/bash

#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Stodulka <pstodulk@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

truncate -s 0 solution.txt
cat /etc/libuser.conf | sed -r "s/^([^#]*)#.*/\1/" | grep -E "^\s*(create_)?modules" \
  | grep -E "files|shadow" | grep -q "ldap"

[ $? -eq 0 ] && {
  log_high_risk "/etc/libuser.conf contains rejected configuration - please resolve this before upgrade"
  echo \
'You must remove "ldap" or "files" and "shadow" modules from the "modules"
and "create_modules" directives in /etc/libuser.conf.

Reason:
As of Red Hat Enterprise Linux 7, the libuser library no longer supports
configurations that contain both the ldap and files modules, or both the ldap
and shadow modules. Combining these modules results in ambiguity in password
handling, and such configurations are now rejected during the initialization
process.' > solution.txt
  exit $RESULT_FAIL
}

exit $RESULT_PASS
