#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Hracek <phracek@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
COMPONENT="distribution"
#END GENERATED SECTION

COMPONENT="kernel-kdump"
myarch=`arch`
ZIPL_CONF="/etc/zipl.conf"
KERNEL_SCRIPT="kernel-kdump.sh"
KERNEL_PYTHON="kernel-kdump.py"
#strange output of myarch? Bad luck...
[ -z $myarch ] && exit $RESULT_ERROR
#Do we have 32 bit architecture?
if [[ x"$myarch" == x"s390x" ]]; then
    grep "kernel-kdump" $VALUE_RPM_RHSIGNED
    if [[ $? -eq 0 ]]; then
        # Copy Python script for manipulation with /etc/zipl.conf file
        RHELUP_PREUPGRADE_DIR="$VALUE_TMP_PREUPGRADE/preupgrade-scripts"
        KERNEL_PREUPGRADE="$RHELUP_PREUPGRADE_DIR/kernel-dump"
        mkdir -p $KERNEL_PREUPGRADE
        # Copy kernel-kdump.sh script for calling during preupgrade section
        cp -a $KERNEL_SCRIPT $RHELUP_PREUPGRADE_DIR/$KERNEL_SCRIPT
        cp -a $KERNEL_PYTHON $KERNEL_PREUPGRADE/$KERNEL_PYTHON
        log_high_risk "Kernel package is mentioned in $ZIPL_CONF file and is going to be removed from the file during upgrade."
        exit $RESULT_FAILED
    else
        exit $RESULT_PASS
    fi
fi
exit $RESULT_NOT_APPLICABLE
