#!/bin/bash



#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Pisar <ppisar@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "perl-libs"
check_rpm_to "perl" ""
COMPONENT="perl-libs"
#END GENERATED SECTION

FOREIGN_FOUND=0
function log_file() {
        printf '%s\n' "$@" >> "$SOLUTION_FILE" || exit_error
        FOREIGN_FOUND=1
}

cat > "$SOLUTION_FILE" <<'EOM'
Perl was updated from version 5.10 to version 5.16. Please read Perl
section in the Red Hat Enterprise Linux 7 Developer Guide for more details.

Following Perl module files located in system Perl paths are either not
handled by any package or not signed by Red Hat:

EOM

PERL_DIRS=$(perl -MConfig -e '$,=q{ }; print @Config{installarchlib,installprivlib,installvendorarch,installvendorlib}') \
    || exit_error
for file in $(find -P $PERL_DIRS -type f -name '*.pm'); do
    RPM=$(rpm -qf "$file")
	if [ $? -ne 0 ]; then
	    log_slight_risk "The perl module $file is not handled by any package."
        log_file "$file"
        continue
	fi
    RPM_NAME=$(rpm -q --qf '%{NAME}' "$RPM")
    grep -q "${RPM_NAME}[[:space:]]" "$VALUE_RPM_RHSIGNED"
	if [ $? -ne 0 ]; then
	    log_slight_risk "The perl module $file was not installed by any Red Hat-signed package."
        log_file "$file"
	fi
done

test "$FOREIGN_FOUND" = 0 && exit_informational || exit_fail
