#!/bin/bash
#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Peter Rajnoha <prajnoha@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "device-mapper-event lvm2"
check_rpm_to "" ""
COMPONENT="device-mapper-event lvm2"
#END GENERATED SECTION

check_root

POSTUPGRADE_DIR=$VALUE_TMP_PREUPGRADE/postupgrade.d/lvm2-services
POSTUPGRADE_UNIT_LIST=units_to_enable
POSTUPGRADE_SCRIPT=enable_units.sh
POSTUPGRADE_SCRIPT_PATH=$POSTUPGRADE_DIR/$POSTUPGRADE_SCRIPT

# Check if lvm2-monitor service is enabled and if yes, make sure it's
# also enabled after upgrade where systemd is used instead of initscripts.
if service_is_enabled "lvm2-monitor"; then
	log_info "The lvm2-monitor service is enabled."
	echo "lvm2-monitor.service" >> $POSTUPGRADE_UNIT_LIST
fi

# Create postupgrade script to enable lvm2 services which are needed.
mkdir -p $POSTUPGRADE_DIR
cp $POSTUPGRADE_UNIT_LIST $POSTUPGRADE_DIR
cat >> $POSTUPGRADE_SCRIPT_PATH << EOF
#!/usr/bin/bash
test -f $POSTUPGRADE_UNIT_LIST || exit 0
for unit in \$(cat $POSTUPGRADE_UNIT_LIST); do
	systemctl enable \$unit
done
EOF
chmod +x $POSTUPGRADE_SCRIPT_PATH

exit $RESULT_FIXED
