#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Pavel Raiskup <praiskup@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to ""
check_rpm_to "yum" ""
COMPONENT=""
#END GENERATED SECTION

export LANG=C
set -o pipefail

perl_wrapper=$(readlink -f "$(dirname ${BASH_SOURCE})"/parse)

repos="$(yum repolist 2>/dev/null | cut -d' ' -f 1)"
test $? -ne 0 \
    && log_high_risk "yum: can not list available repositories" \
    && exit_error

fail=0
for i in $repos; do
    case $i in
        rhel-6-*-optional-rpms|rhel-*-*-optional*)
            log_high_risk "RHEL Optional channel '$i' is enabled on your system."
            fail=1
            ;;
    esac
done

rhel6_release=`cat /etc/redhat-release | sed 's|Red Hat Enterprise Linux \([^[:space:]]*\) .*|\1|'`

for opt in `ls -1 /root/preupgrade/RHEL6_7/common/default*_moved_optional`
do
    # Determine the channel name
    repo_name=$rhel6_release
    if [[ $opt =~ .*default(-?(.*))_moved_optional ]]; then
        case ${BASH_REMATCH[2]} in
            "") ;;
            *)
                repo_name=${BASH_REMATCH[2]}
                ;;
        esac
    else
        log_high_risk "unable to detect optional channel"
        exit_error
    fi

    log_debug "checking problems from $repo_name"
    packages=$(cat "$opt" | cut -d' ' -f 1 | $perl_wrapper $VALUE_RPM_RHSIGNED)
    if test $? -ne 0; then
        packages=`echo $packages`
        log_high_risk "Packages [$packages] have been moved to $repo_name Optional channel."
        fail=1
    fi
done

test $fail -eq 0 && exit_pass || exit_fail
