#!/bin/bash


#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Frantisek Kluknavsky <fkluknav@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" "efibootmgr"
COMPONENT="distribution"
#END GENERATED SECTION

if efibootmgr >/dev/null 2>&1; then
	DIR=uefi
	FILE=postupgrade.sh
	mkdir -p $POSTUPGRADE_DIR/$DIR
	cp  $FILE $POSTUPGRADE_DIR/$DIR/$FILE
	chmod a+x $POSTUPGRADE_DIR/$DIR/$FILE
	if [ ! -f "/etc/default/grub" ]; then
	    log_high_risk "EFI detected. Migration to GRUB2 is necessary. Manual creation of /etc/defaults/grub is advised."
	    exit_fail
	fi
	exit_informational
fi

echo "This system does not use EFI. Preupgrade Assistant will not replace your current bootloader automatically, it is too dangerous. If you wish to use GRUB2, do it manually after the upgrade using grub2-install and grub2-mkconfig." > solution.txt
exit_informational
