#!/bin/bash



#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Bohuslav Kabrda <bkabrda@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "python"
COMPONENT="python"
#END GENERATED SECTION

PYTHON_DIRS="python_dirs.txt"
if [ -f "$PYTHON_DIRS" ]; then
    rm -f $PYTHON_DIRS
fi

COMPONENT="python"
FOUND=0
for py_dir in `find -P /usr/lib*/python*/site-packages/* -maxdepth 0 -type d`
do
	RPM=`rpm -qf $py_dir`
	if [ $? -ne 0 ]; then
	    log_slight_risk "$py_dir is not owned by any RPM package."
        FOUND=1
        continue
	fi
	RPM_NAME=`rpm -q --qf "%{NAME}" $RPM`
	grep "$RPM_NAME[[:space:]]" $VALUE_RPM_RHSIGNED > /dev/null
	if [ $? -ne 0 ]; then
	    log_slight_risk "$py_dir is owned by an RPM package that was not signed by Red Hat."
        FOUND=1
	fi
done
if [ $FOUND -eq 1 ]; then
    exit_fail
fi

exit_pass
