#!/bin/bash

#Preupgrade assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Stodulka <pstodulk@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "openssh-server"
COMPONENT="openssh-server"
#END GENERATED SECTION

grep -E "^\s*AuthorizedKeysCommand /usr/libexec/openssh/ssh-keycat" /etc/ssh/sshd_config

[[ $? -ne 0 ]] && {
  log_medium_risk "ssh-keycat files are moved to openssh-keycat"
  echo "ssh-keycat files (below) are moved to new package 'openssh-keycat':
/etc/pam.d/ssh-keycat
/usr/libexec/openssh/ssh-keycat
/usr/share/doc/openssh-server-5.3p1/HOWTO.ssh-keycat

If you want ssh-keycat anymore, you need install openssh-keycat package.
" >> solution.txt
  exit $RESULT_FAIL
}


log_slight_risk "ssh-keycat is used! But is part of else package on RHEL-7"
echo "ssh-keycat is moved to own package 'openssh-keycat'. This package
will be automatically installed by postupgrade script.
" >> solution.txt

cp install-openssh-keycat.sh $POSTUPGRADE_DIR/install-openssh-keycat.sh
exit $RESULT_FIXED

