/*
 * Copyright 2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package demo.org.powermock.examples.tutorial.staticmocking;

/**
 * An interface to be implemented by services that performs service
 * registrations.
 */
public interface IServiceRegistrator {
	/**
	 * Registers a service to the service framework.
	 * 
	 * @param name
	 *            The name of the service the register.
	 * @param serviceImplementation
	 *            The implementation of the service.
	 * @return An id of the service that got registered. Should be used when
	 *         unregistering the service.
	 */
	long registerService(String name, Object serviceImplementation);

	/**
	 * Unregisters a service from the service framework.
	 * 
	 * @param id
	 *            The id of the service that should be removed. The id was
	 *            generated by {@link #registerService(String, Object)}.
	 * 
	 * @throws IllegalStateException
	 *             If this <code>ServiceRegistration</code> object has already
	 *             been unregistered.
	 */
	void unregisterService(long id);
}
