package containers

import (
	"github.com/containers/podman/v2/cmd/podman/registry"
	"github.com/containers/podman/v2/cmd/podman/validate"
	"github.com/containers/podman/v2/pkg/domain/entities"
	"github.com/spf13/cobra"
)

var (
	// podman container _list_
	listCmd = &cobra.Command{
		Use:     "list",
		Aliases: []string{"ls"},
		Args:    validate.NoArgs,
		Short:   "List containers",
		Long:    "Prints out information about the containers",
		RunE:    ps,
		Example: `podman container list -a
  podman container list -a --format "{{.ID}}  {{.Image}}  {{.Labels}}  {{.Mounts}}"
  podman container list --size --sort names`,
	}
)

func init() {
	registry.Commands = append(registry.Commands, registry.CliCommand{
		Mode:    []entities.EngineMode{entities.ABIMode, entities.TunnelMode},
		Command: listCmd,
		Parent:  containerCmd,
	})
	listFlagSet(listCmd.Flags())
	validate.AddLatestFlag(listCmd, &listOpts.Latest)
}
