// +build  seccomp   ostree selinux  varlink exclude_graphdriver_devicemapper

// Code generated by easyjson for marshaling/unmarshaling. DO NOT EDIT .

package libpod

import (
	json "encoding/json"
	types "github.com/containernetworking/cni/pkg/types"
	current "github.com/containernetworking/cni/pkg/types/current"
	namespaces "github.com/containers/libpod/pkg/namespaces"
	storage "github.com/containers/storage"
	idtools "github.com/containers/storage/pkg/idtools"
	ocicni "github.com/cri-o/ocicni/pkg/ocicni"
	easyjson "github.com/mailru/easyjson"
	jlexer "github.com/mailru/easyjson/jlexer"
	jwriter "github.com/mailru/easyjson/jwriter"
	specs_go "github.com/opencontainers/runtime-spec/specs-go"
	net "net"
	os "os"
)

// suppress unused package warning
var (
	_ *json.RawMessage
	_ *jlexer.Lexer
	_ *jwriter.Writer
	_ easyjson.Marshaler
)

func easyjson1dbef17bDecodeGithubComContainersLibpodLibpod(in *jlexer.Lexer, out *containerState) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "state":
			out.State = ContainerStatus(in.Int())
		case "configPath":
			out.ConfigPath = string(in.String())
		case "runDir":
			out.RunDir = string(in.String())
		case "destinationRunDir":
			out.DestinationRunDir = string(in.String())
		case "mounted":
			out.Mounted = bool(in.Bool())
		case "mountPoint":
			out.Mountpoint = string(in.String())
		case "realMountPoint":
			out.RealMountpoint = string(in.String())
		case "startedTime":
			if data := in.Raw(); in.Ok() {
				in.AddError((out.StartedTime).UnmarshalJSON(data))
			}
		case "finishedTime":
			if data := in.Raw(); in.Ok() {
				in.AddError((out.FinishedTime).UnmarshalJSON(data))
			}
		case "exitCode":
			out.ExitCode = int32(in.Int32())
		case "exited":
			out.Exited = bool(in.Bool())
		case "oomKilled":
			out.OOMKilled = bool(in.Bool())
		case "pid":
			out.PID = int(in.Int())
		case "execSessions":
			if in.IsNull() {
				in.Skip()
			} else {
				in.Delim('{')
				if !in.IsDelim('}') {
					out.ExecSessions = make(map[string]*ExecSession)
				} else {
					out.ExecSessions = nil
				}
				for !in.IsDelim('}') {
					key := string(in.String())
					in.WantColon()
					var v1 *ExecSession
					if in.IsNull() {
						in.Skip()
						v1 = nil
					} else {
						if v1 == nil {
							v1 = new(ExecSession)
						}
						if data := in.Raw(); in.Ok() {
							in.AddError((*v1).UnmarshalJSON(data))
						}
					}
					(out.ExecSessions)[key] = v1
					in.WantComma()
				}
				in.Delim('}')
			}
		case "networkResults":
			if in.IsNull() {
				in.Skip()
				out.NetworkStatus = nil
			} else {
				in.Delim('[')
				if out.NetworkStatus == nil {
					if !in.IsDelim(']') {
						out.NetworkStatus = make([]*current.Result, 0, 8)
					} else {
						out.NetworkStatus = []*current.Result{}
					}
				} else {
					out.NetworkStatus = (out.NetworkStatus)[:0]
				}
				for !in.IsDelim(']') {
					var v2 *current.Result
					if in.IsNull() {
						in.Skip()
						v2 = nil
					} else {
						if v2 == nil {
							v2 = new(current.Result)
						}
						easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComContainernetworkingCniPkgTypesCurrent(in, &*v2)
					}
					out.NetworkStatus = append(out.NetworkStatus, v2)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "bindMounts":
			if in.IsNull() {
				in.Skip()
			} else {
				in.Delim('{')
				if !in.IsDelim('}') {
					out.BindMounts = make(map[string]string)
				} else {
					out.BindMounts = nil
				}
				for !in.IsDelim('}') {
					key := string(in.String())
					in.WantColon()
					var v3 string
					v3 = string(in.String())
					(out.BindMounts)[key] = v3
					in.WantComma()
				}
				in.Delim('}')
			}
		case "userNSRoot":
			out.UserNSRoot = string(in.String())
		case "extensionStageHooks":
			if in.IsNull() {
				in.Skip()
			} else {
				in.Delim('{')
				if !in.IsDelim('}') {
					out.ExtensionStageHooks = make(map[string][]specs_go.Hook)
				} else {
					out.ExtensionStageHooks = nil
				}
				for !in.IsDelim('}') {
					key := string(in.String())
					in.WantColon()
					var v4 []specs_go.Hook
					if in.IsNull() {
						in.Skip()
						v4 = nil
					} else {
						in.Delim('[')
						if v4 == nil {
							if !in.IsDelim(']') {
								v4 = make([]specs_go.Hook, 0, 1)
							} else {
								v4 = []specs_go.Hook{}
							}
						} else {
							v4 = (v4)[:0]
						}
						for !in.IsDelim(']') {
							var v5 specs_go.Hook
							easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo(in, &v5)
							v4 = append(v4, v5)
							in.WantComma()
						}
						in.Delim(']')
					}
					(out.ExtensionStageHooks)[key] = v4
					in.WantComma()
				}
				in.Delim('}')
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodLibpod(out *jwriter.Writer, in containerState) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"state\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int(int(in.State))
	}
	if in.ConfigPath != "" {
		const prefix string = ",\"configPath\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.ConfigPath))
	}
	if in.RunDir != "" {
		const prefix string = ",\"runDir\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.RunDir))
	}
	if in.DestinationRunDir != "" {
		const prefix string = ",\"destinationRunDir\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.DestinationRunDir))
	}
	if in.Mounted {
		const prefix string = ",\"mounted\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.Mounted))
	}
	if in.Mountpoint != "" {
		const prefix string = ",\"mountPoint\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Mountpoint))
	}
	if in.RealMountpoint != "" {
		const prefix string = ",\"realMountPoint\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.RealMountpoint))
	}
	if true {
		const prefix string = ",\"startedTime\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Raw((in.StartedTime).MarshalJSON())
	}
	if true {
		const prefix string = ",\"finishedTime\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Raw((in.FinishedTime).MarshalJSON())
	}
	if in.ExitCode != 0 {
		const prefix string = ",\"exitCode\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int32(int32(in.ExitCode))
	}
	if in.Exited {
		const prefix string = ",\"exited\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.Exited))
	}
	if in.OOMKilled {
		const prefix string = ",\"oomKilled\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.OOMKilled))
	}
	if in.PID != 0 {
		const prefix string = ",\"pid\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int(int(in.PID))
	}
	if len(in.ExecSessions) != 0 {
		const prefix string = ",\"execSessions\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('{')
			v6First := true
			for v6Name, v6Value := range in.ExecSessions {
				if v6First {
					v6First = false
				} else {
					out.RawByte(',')
				}
				out.String(string(v6Name))
				out.RawByte(':')
				if v6Value == nil {
					out.RawString("null")
				} else {
					out.Raw((*v6Value).MarshalJSON())
				}
			}
			out.RawByte('}')
		}
	}
	if len(in.NetworkStatus) != 0 {
		const prefix string = ",\"networkResults\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v7, v8 := range in.NetworkStatus {
				if v7 > 0 {
					out.RawByte(',')
				}
				if v8 == nil {
					out.RawString("null")
				} else {
					easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComContainernetworkingCniPkgTypesCurrent(out, *v8)
				}
			}
			out.RawByte(']')
		}
	}
	if len(in.BindMounts) != 0 {
		const prefix string = ",\"bindMounts\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('{')
			v9First := true
			for v9Name, v9Value := range in.BindMounts {
				if v9First {
					v9First = false
				} else {
					out.RawByte(',')
				}
				out.String(string(v9Name))
				out.RawByte(':')
				out.String(string(v9Value))
			}
			out.RawByte('}')
		}
	}
	if in.UserNSRoot != "" {
		const prefix string = ",\"userNSRoot\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.UserNSRoot))
	}
	if len(in.ExtensionStageHooks) != 0 {
		const prefix string = ",\"extensionStageHooks\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('{')
			v10First := true
			for v10Name, v10Value := range in.ExtensionStageHooks {
				if v10First {
					v10First = false
				} else {
					out.RawByte(',')
				}
				out.String(string(v10Name))
				out.RawByte(':')
				if v10Value == nil && (out.Flags&jwriter.NilSliceAsEmpty) == 0 {
					out.RawString("null")
				} else {
					out.RawByte('[')
					for v11, v12 := range v10Value {
						if v11 > 0 {
							out.RawByte(',')
						}
						easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo(out, v12)
					}
					out.RawByte(']')
				}
			}
			out.RawByte('}')
		}
	}
	out.RawByte('}')
}

// MarshalJSON supports json.Marshaler interface
func (v containerState) MarshalJSON() ([]byte, error) {
	w := jwriter.Writer{}
	easyjson1dbef17bEncodeGithubComContainersLibpodLibpod(&w, v)
	return w.Buffer.BuildBytes(), w.Error
}

// MarshalEasyJSON supports easyjson.Marshaler interface
func (v containerState) MarshalEasyJSON(w *jwriter.Writer) {
	easyjson1dbef17bEncodeGithubComContainersLibpodLibpod(w, v)
}

// UnmarshalJSON supports json.Unmarshaler interface
func (v *containerState) UnmarshalJSON(data []byte) error {
	r := jlexer.Lexer{Data: data}
	easyjson1dbef17bDecodeGithubComContainersLibpodLibpod(&r, v)
	return r.Error()
}

// UnmarshalEasyJSON supports easyjson.Unmarshaler interface
func (v *containerState) UnmarshalEasyJSON(l *jlexer.Lexer) {
	easyjson1dbef17bDecodeGithubComContainersLibpodLibpod(l, v)
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo(in *jlexer.Lexer, out *specs_go.Hook) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "path":
			out.Path = string(in.String())
		case "args":
			if in.IsNull() {
				in.Skip()
				out.Args = nil
			} else {
				in.Delim('[')
				if out.Args == nil {
					if !in.IsDelim(']') {
						out.Args = make([]string, 0, 4)
					} else {
						out.Args = []string{}
					}
				} else {
					out.Args = (out.Args)[:0]
				}
				for !in.IsDelim(']') {
					var v13 string
					v13 = string(in.String())
					out.Args = append(out.Args, v13)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "env":
			if in.IsNull() {
				in.Skip()
				out.Env = nil
			} else {
				in.Delim('[')
				if out.Env == nil {
					if !in.IsDelim(']') {
						out.Env = make([]string, 0, 4)
					} else {
						out.Env = []string{}
					}
				} else {
					out.Env = (out.Env)[:0]
				}
				for !in.IsDelim(']') {
					var v14 string
					v14 = string(in.String())
					out.Env = append(out.Env, v14)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "timeout":
			if in.IsNull() {
				in.Skip()
				out.Timeout = nil
			} else {
				if out.Timeout == nil {
					out.Timeout = new(int)
				}
				*out.Timeout = int(in.Int())
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo(out *jwriter.Writer, in specs_go.Hook) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"path\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Path))
	}
	if len(in.Args) != 0 {
		const prefix string = ",\"args\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v15, v16 := range in.Args {
				if v15 > 0 {
					out.RawByte(',')
				}
				out.String(string(v16))
			}
			out.RawByte(']')
		}
	}
	if len(in.Env) != 0 {
		const prefix string = ",\"env\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v17, v18 := range in.Env {
				if v17 > 0 {
					out.RawByte(',')
				}
				out.String(string(v18))
			}
			out.RawByte(']')
		}
	}
	if in.Timeout != nil {
		const prefix string = ",\"timeout\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int(int(*in.Timeout))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComContainernetworkingCniPkgTypesCurrent(in *jlexer.Lexer, out *current.Result) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "cniVersion":
			out.CNIVersion = string(in.String())
		case "interfaces":
			if in.IsNull() {
				in.Skip()
				out.Interfaces = nil
			} else {
				in.Delim('[')
				if out.Interfaces == nil {
					if !in.IsDelim(']') {
						out.Interfaces = make([]*current.Interface, 0, 8)
					} else {
						out.Interfaces = []*current.Interface{}
					}
				} else {
					out.Interfaces = (out.Interfaces)[:0]
				}
				for !in.IsDelim(']') {
					var v19 *current.Interface
					if in.IsNull() {
						in.Skip()
						v19 = nil
					} else {
						if v19 == nil {
							v19 = new(current.Interface)
						}
						easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComContainernetworkingCniPkgTypesCurrent1(in, &*v19)
					}
					out.Interfaces = append(out.Interfaces, v19)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "ips":
			if in.IsNull() {
				in.Skip()
				out.IPs = nil
			} else {
				in.Delim('[')
				if out.IPs == nil {
					if !in.IsDelim(']') {
						out.IPs = make([]*current.IPConfig, 0, 8)
					} else {
						out.IPs = []*current.IPConfig{}
					}
				} else {
					out.IPs = (out.IPs)[:0]
				}
				for !in.IsDelim(']') {
					var v20 *current.IPConfig
					if in.IsNull() {
						in.Skip()
						v20 = nil
					} else {
						if v20 == nil {
							v20 = new(current.IPConfig)
						}
						if data := in.Raw(); in.Ok() {
							in.AddError((*v20).UnmarshalJSON(data))
						}
					}
					out.IPs = append(out.IPs, v20)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "routes":
			if in.IsNull() {
				in.Skip()
				out.Routes = nil
			} else {
				in.Delim('[')
				if out.Routes == nil {
					if !in.IsDelim(']') {
						out.Routes = make([]*types.Route, 0, 8)
					} else {
						out.Routes = []*types.Route{}
					}
				} else {
					out.Routes = (out.Routes)[:0]
				}
				for !in.IsDelim(']') {
					var v21 *types.Route
					if in.IsNull() {
						in.Skip()
						v21 = nil
					} else {
						if v21 == nil {
							v21 = new(types.Route)
						}
						if data := in.Raw(); in.Ok() {
							in.AddError((*v21).UnmarshalJSON(data))
						}
					}
					out.Routes = append(out.Routes, v21)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "dns":
			easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComContainernetworkingCniPkgTypes(in, &out.DNS)
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComContainernetworkingCniPkgTypesCurrent(out *jwriter.Writer, in current.Result) {
	out.RawByte('{')
	first := true
	_ = first
	if in.CNIVersion != "" {
		const prefix string = ",\"cniVersion\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.CNIVersion))
	}
	if len(in.Interfaces) != 0 {
		const prefix string = ",\"interfaces\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v22, v23 := range in.Interfaces {
				if v22 > 0 {
					out.RawByte(',')
				}
				if v23 == nil {
					out.RawString("null")
				} else {
					easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComContainernetworkingCniPkgTypesCurrent1(out, *v23)
				}
			}
			out.RawByte(']')
		}
	}
	if len(in.IPs) != 0 {
		const prefix string = ",\"ips\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v24, v25 := range in.IPs {
				if v24 > 0 {
					out.RawByte(',')
				}
				if v25 == nil {
					out.RawString("null")
				} else {
					out.Raw((*v25).MarshalJSON())
				}
			}
			out.RawByte(']')
		}
	}
	if len(in.Routes) != 0 {
		const prefix string = ",\"routes\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v26, v27 := range in.Routes {
				if v26 > 0 {
					out.RawByte(',')
				}
				if v27 == nil {
					out.RawString("null")
				} else {
					out.Raw((*v27).MarshalJSON())
				}
			}
			out.RawByte(']')
		}
	}
	if true {
		const prefix string = ",\"dns\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComContainernetworkingCniPkgTypes(out, in.DNS)
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComContainernetworkingCniPkgTypes(in *jlexer.Lexer, out *types.DNS) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "nameservers":
			if in.IsNull() {
				in.Skip()
				out.Nameservers = nil
			} else {
				in.Delim('[')
				if out.Nameservers == nil {
					if !in.IsDelim(']') {
						out.Nameservers = make([]string, 0, 4)
					} else {
						out.Nameservers = []string{}
					}
				} else {
					out.Nameservers = (out.Nameservers)[:0]
				}
				for !in.IsDelim(']') {
					var v28 string
					v28 = string(in.String())
					out.Nameservers = append(out.Nameservers, v28)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "domain":
			out.Domain = string(in.String())
		case "search":
			if in.IsNull() {
				in.Skip()
				out.Search = nil
			} else {
				in.Delim('[')
				if out.Search == nil {
					if !in.IsDelim(']') {
						out.Search = make([]string, 0, 4)
					} else {
						out.Search = []string{}
					}
				} else {
					out.Search = (out.Search)[:0]
				}
				for !in.IsDelim(']') {
					var v29 string
					v29 = string(in.String())
					out.Search = append(out.Search, v29)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "options":
			if in.IsNull() {
				in.Skip()
				out.Options = nil
			} else {
				in.Delim('[')
				if out.Options == nil {
					if !in.IsDelim(']') {
						out.Options = make([]string, 0, 4)
					} else {
						out.Options = []string{}
					}
				} else {
					out.Options = (out.Options)[:0]
				}
				for !in.IsDelim(']') {
					var v30 string
					v30 = string(in.String())
					out.Options = append(out.Options, v30)
					in.WantComma()
				}
				in.Delim(']')
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComContainernetworkingCniPkgTypes(out *jwriter.Writer, in types.DNS) {
	out.RawByte('{')
	first := true
	_ = first
	if len(in.Nameservers) != 0 {
		const prefix string = ",\"nameservers\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v31, v32 := range in.Nameservers {
				if v31 > 0 {
					out.RawByte(',')
				}
				out.String(string(v32))
			}
			out.RawByte(']')
		}
	}
	if in.Domain != "" {
		const prefix string = ",\"domain\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Domain))
	}
	if len(in.Search) != 0 {
		const prefix string = ",\"search\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v33, v34 := range in.Search {
				if v33 > 0 {
					out.RawByte(',')
				}
				out.String(string(v34))
			}
			out.RawByte(']')
		}
	}
	if len(in.Options) != 0 {
		const prefix string = ",\"options\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v35, v36 := range in.Options {
				if v35 > 0 {
					out.RawByte(',')
				}
				out.String(string(v36))
			}
			out.RawByte(']')
		}
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComContainernetworkingCniPkgTypesCurrent1(in *jlexer.Lexer, out *current.Interface) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "name":
			out.Name = string(in.String())
		case "mac":
			out.Mac = string(in.String())
		case "sandbox":
			out.Sandbox = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComContainernetworkingCniPkgTypesCurrent1(out *jwriter.Writer, in current.Interface) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"name\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Name))
	}
	if in.Mac != "" {
		const prefix string = ",\"mac\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Mac))
	}
	if in.Sandbox != "" {
		const prefix string = ",\"sandbox\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Sandbox))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodLibpod1(in *jlexer.Lexer, out *ExecSession) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "id":
			out.ID = string(in.String())
		case "command":
			if in.IsNull() {
				in.Skip()
				out.Command = nil
			} else {
				in.Delim('[')
				if out.Command == nil {
					if !in.IsDelim(']') {
						out.Command = make([]string, 0, 4)
					} else {
						out.Command = []string{}
					}
				} else {
					out.Command = (out.Command)[:0]
				}
				for !in.IsDelim(']') {
					var v37 string
					v37 = string(in.String())
					out.Command = append(out.Command, v37)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "pid":
			out.PID = int(in.Int())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodLibpod1(out *jwriter.Writer, in ExecSession) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"id\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.ID))
	}
	{
		const prefix string = ",\"command\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		if in.Command == nil && (out.Flags&jwriter.NilSliceAsEmpty) == 0 {
			out.RawString("null")
		} else {
			out.RawByte('[')
			for v38, v39 := range in.Command {
				if v38 > 0 {
					out.RawByte(',')
				}
				out.String(string(v39))
			}
			out.RawByte(']')
		}
	}
	{
		const prefix string = ",\"pid\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int(int(in.PID))
	}
	out.RawByte('}')
}

// MarshalJSON supports json.Marshaler interface
func (v ExecSession) MarshalJSON() ([]byte, error) {
	w := jwriter.Writer{}
	easyjson1dbef17bEncodeGithubComContainersLibpodLibpod1(&w, v)
	return w.Buffer.BuildBytes(), w.Error
}

// MarshalEasyJSON supports easyjson.Marshaler interface
func (v ExecSession) MarshalEasyJSON(w *jwriter.Writer) {
	easyjson1dbef17bEncodeGithubComContainersLibpodLibpod1(w, v)
}

// UnmarshalJSON supports json.Unmarshaler interface
func (v *ExecSession) UnmarshalJSON(data []byte) error {
	r := jlexer.Lexer{Data: data}
	easyjson1dbef17bDecodeGithubComContainersLibpodLibpod1(&r, v)
	return r.Error()
}

// UnmarshalEasyJSON supports easyjson.Unmarshaler interface
func (v *ExecSession) UnmarshalEasyJSON(l *jlexer.Lexer) {
	easyjson1dbef17bDecodeGithubComContainersLibpodLibpod1(l, v)
}
func easyjson1dbef17bDecodeGithubComContainersLibpodLibpod2(in *jlexer.Lexer, out *ContainerConfig) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "spec":
			if in.IsNull() {
				in.Skip()
				out.Spec = nil
			} else {
				if out.Spec == nil {
					out.Spec = new(specs_go.Spec)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo1(in, &*out.Spec)
			}
		case "id":
			out.ID = string(in.String())
		case "name":
			out.Name = string(in.String())
		case "pod":
			out.Pod = string(in.String())
		case "namespace":
			out.Namespace = string(in.String())
		case "idMappingsOptions":
			easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComContainersStorage(in, &out.IDMappings)
		case "rootfsImageID":
			out.RootfsImageID = string(in.String())
		case "rootfsImageName":
			out.RootfsImageName = string(in.String())
		case "rootfs":
			out.Rootfs = string(in.String())
		case "imageVolumes":
			out.ImageVolumes = bool(in.Bool())
		case "ShmDir":
			out.ShmDir = string(in.String())
		case "shmSize":
			out.ShmSize = int64(in.Int64())
		case "staticDir":
			out.StaticDir = string(in.String())
		case "mounts":
			if in.IsNull() {
				in.Skip()
				out.Mounts = nil
			} else {
				in.Delim('[')
				if out.Mounts == nil {
					if !in.IsDelim(']') {
						out.Mounts = make([]string, 0, 4)
					} else {
						out.Mounts = []string{}
					}
				} else {
					out.Mounts = (out.Mounts)[:0]
				}
				for !in.IsDelim(']') {
					var v40 string
					v40 = string(in.String())
					out.Mounts = append(out.Mounts, v40)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "privileged":
			out.Privileged = bool(in.Bool())
		case "ProcessLabel":
			out.ProcessLabel = string(in.String())
		case "MountLabel":
			out.MountLabel = string(in.String())
		case "labelopts":
			if in.IsNull() {
				in.Skip()
				out.LabelOpts = nil
			} else {
				in.Delim('[')
				if out.LabelOpts == nil {
					if !in.IsDelim(']') {
						out.LabelOpts = make([]string, 0, 4)
					} else {
						out.LabelOpts = []string{}
					}
				} else {
					out.LabelOpts = (out.LabelOpts)[:0]
				}
				for !in.IsDelim(']') {
					var v41 string
					v41 = string(in.String())
					out.LabelOpts = append(out.LabelOpts, v41)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "user":
			out.User = string(in.String())
		case "groups":
			if in.IsNull() {
				in.Skip()
				out.Groups = nil
			} else {
				in.Delim('[')
				if out.Groups == nil {
					if !in.IsDelim(']') {
						out.Groups = make([]string, 0, 4)
					} else {
						out.Groups = []string{}
					}
				} else {
					out.Groups = (out.Groups)[:0]
				}
				for !in.IsDelim(']') {
					var v42 string
					v42 = string(in.String())
					out.Groups = append(out.Groups, v42)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "ipcNsCtr":
			out.IPCNsCtr = string(in.String())
		case "mountNsCtr":
			out.MountNsCtr = string(in.String())
		case "netNsCtr":
			out.NetNsCtr = string(in.String())
		case "pidNsCtr":
			out.PIDNsCtr = string(in.String())
		case "userNsCtr":
			out.UserNsCtr = string(in.String())
		case "utsNsCtr":
			out.UTSNsCtr = string(in.String())
		case "cgroupNsCtr":
			out.CgroupNsCtr = string(in.String())
		case "Dependencies":
			if in.IsNull() {
				in.Skip()
				out.Dependencies = nil
			} else {
				in.Delim('[')
				if out.Dependencies == nil {
					if !in.IsDelim(']') {
						out.Dependencies = make([]string, 0, 4)
					} else {
						out.Dependencies = []string{}
					}
				} else {
					out.Dependencies = (out.Dependencies)[:0]
				}
				for !in.IsDelim(']') {
					var v43 string
					v43 = string(in.String())
					out.Dependencies = append(out.Dependencies, v43)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "createNetNS":
			out.CreateNetNS = bool(in.Bool())
		case "staticIP":
			if data := in.UnsafeBytes(); in.Ok() {
				in.AddError((out.StaticIP).UnmarshalText(data))
			}
		case "portMappings":
			if in.IsNull() {
				in.Skip()
				out.PortMappings = nil
			} else {
				in.Delim('[')
				if out.PortMappings == nil {
					if !in.IsDelim(']') {
						out.PortMappings = make([]ocicni.PortMapping, 0, 1)
					} else {
						out.PortMappings = []ocicni.PortMapping{}
					}
				} else {
					out.PortMappings = (out.PortMappings)[:0]
				}
				for !in.IsDelim(']') {
					var v44 ocicni.PortMapping
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComCriOOcicniPkgOcicni(in, &v44)
					out.PortMappings = append(out.PortMappings, v44)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "dnsServer":
			if in.IsNull() {
				in.Skip()
				out.DNSServer = nil
			} else {
				in.Delim('[')
				if out.DNSServer == nil {
					if !in.IsDelim(']') {
						out.DNSServer = make([]net.IP, 0, 2)
					} else {
						out.DNSServer = []net.IP{}
					}
				} else {
					out.DNSServer = (out.DNSServer)[:0]
				}
				for !in.IsDelim(']') {
					var v45 net.IP
					if data := in.UnsafeBytes(); in.Ok() {
						in.AddError((v45).UnmarshalText(data))
					}
					out.DNSServer = append(out.DNSServer, v45)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "dnsSearch":
			if in.IsNull() {
				in.Skip()
				out.DNSSearch = nil
			} else {
				in.Delim('[')
				if out.DNSSearch == nil {
					if !in.IsDelim(']') {
						out.DNSSearch = make([]string, 0, 4)
					} else {
						out.DNSSearch = []string{}
					}
				} else {
					out.DNSSearch = (out.DNSSearch)[:0]
				}
				for !in.IsDelim(']') {
					var v46 string
					v46 = string(in.String())
					out.DNSSearch = append(out.DNSSearch, v46)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "dnsOption":
			if in.IsNull() {
				in.Skip()
				out.DNSOption = nil
			} else {
				in.Delim('[')
				if out.DNSOption == nil {
					if !in.IsDelim(']') {
						out.DNSOption = make([]string, 0, 4)
					} else {
						out.DNSOption = []string{}
					}
				} else {
					out.DNSOption = (out.DNSOption)[:0]
				}
				for !in.IsDelim(']') {
					var v47 string
					v47 = string(in.String())
					out.DNSOption = append(out.DNSOption, v47)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "hostsAdd":
			if in.IsNull() {
				in.Skip()
				out.HostAdd = nil
			} else {
				in.Delim('[')
				if out.HostAdd == nil {
					if !in.IsDelim(']') {
						out.HostAdd = make([]string, 0, 4)
					} else {
						out.HostAdd = []string{}
					}
				} else {
					out.HostAdd = (out.HostAdd)[:0]
				}
				for !in.IsDelim(']') {
					var v48 string
					v48 = string(in.String())
					out.HostAdd = append(out.HostAdd, v48)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "networks":
			if in.IsNull() {
				in.Skip()
				out.Networks = nil
			} else {
				in.Delim('[')
				if out.Networks == nil {
					if !in.IsDelim(']') {
						out.Networks = make([]string, 0, 4)
					} else {
						out.Networks = []string{}
					}
				} else {
					out.Networks = (out.Networks)[:0]
				}
				for !in.IsDelim(']') {
					var v49 string
					v49 = string(in.String())
					out.Networks = append(out.Networks, v49)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "networkMode":
			out.NetMode = namespaces.NetworkMode(in.String())
		case "userVolumes":
			if in.IsNull() {
				in.Skip()
				out.UserVolumes = nil
			} else {
				in.Delim('[')
				if out.UserVolumes == nil {
					if !in.IsDelim(']') {
						out.UserVolumes = make([]string, 0, 4)
					} else {
						out.UserVolumes = []string{}
					}
				} else {
					out.UserVolumes = (out.UserVolumes)[:0]
				}
				for !in.IsDelim(']') {
					var v50 string
					v50 = string(in.String())
					out.UserVolumes = append(out.UserVolumes, v50)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "entrypoint":
			if in.IsNull() {
				in.Skip()
				out.Entrypoint = nil
			} else {
				in.Delim('[')
				if out.Entrypoint == nil {
					if !in.IsDelim(']') {
						out.Entrypoint = make([]string, 0, 4)
					} else {
						out.Entrypoint = []string{}
					}
				} else {
					out.Entrypoint = (out.Entrypoint)[:0]
				}
				for !in.IsDelim(']') {
					var v51 string
					v51 = string(in.String())
					out.Entrypoint = append(out.Entrypoint, v51)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "command":
			if in.IsNull() {
				in.Skip()
				out.Command = nil
			} else {
				in.Delim('[')
				if out.Command == nil {
					if !in.IsDelim(']') {
						out.Command = make([]string, 0, 4)
					} else {
						out.Command = []string{}
					}
				} else {
					out.Command = (out.Command)[:0]
				}
				for !in.IsDelim(']') {
					var v52 string
					v52 = string(in.String())
					out.Command = append(out.Command, v52)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "stdin":
			out.Stdin = bool(in.Bool())
		case "labels":
			if in.IsNull() {
				in.Skip()
			} else {
				in.Delim('{')
				if !in.IsDelim('}') {
					out.Labels = make(map[string]string)
				} else {
					out.Labels = nil
				}
				for !in.IsDelim('}') {
					key := string(in.String())
					in.WantColon()
					var v53 string
					v53 = string(in.String())
					(out.Labels)[key] = v53
					in.WantComma()
				}
				in.Delim('}')
			}
		case "stopSignal":
			out.StopSignal = uint(in.Uint())
		case "stopTimeout":
			out.StopTimeout = uint(in.Uint())
		case "createdTime":
			if data := in.Raw(); in.Ok() {
				in.AddError((out.CreatedTime).UnmarshalJSON(data))
			}
		case "cgroupParent":
			out.CgroupParent = string(in.String())
		case "logPath":
			out.LogPath = string(in.String())
		case "conmonPidFile":
			out.ConmonPidFile = string(in.String())
		case "postConfigureNetNS":
			out.PostConfigureNetNS = bool(in.Bool())
		case "exitCommand":
			if in.IsNull() {
				in.Skip()
				out.ExitCommand = nil
			} else {
				in.Delim('[')
				if out.ExitCommand == nil {
					if !in.IsDelim(']') {
						out.ExitCommand = make([]string, 0, 4)
					} else {
						out.ExitCommand = []string{}
					}
				} else {
					out.ExitCommand = (out.ExitCommand)[:0]
				}
				for !in.IsDelim(']') {
					var v54 string
					v54 = string(in.String())
					out.ExitCommand = append(out.ExitCommand, v54)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "LocalVolumes":
			if in.IsNull() {
				in.Skip()
				out.LocalVolumes = nil
			} else {
				in.Delim('[')
				if out.LocalVolumes == nil {
					if !in.IsDelim(']') {
						out.LocalVolumes = make([]string, 0, 4)
					} else {
						out.LocalVolumes = []string{}
					}
				} else {
					out.LocalVolumes = (out.LocalVolumes)[:0]
				}
				for !in.IsDelim(']') {
					var v55 string
					v55 = string(in.String())
					out.LocalVolumes = append(out.LocalVolumes, v55)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "pause":
			out.IsInfra = bool(in.Bool())
		case "systemd":
			out.Systemd = bool(in.Bool())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodLibpod2(out *jwriter.Writer, in ContainerConfig) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"spec\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		if in.Spec == nil {
			out.RawString("null")
		} else {
			easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo1(out, *in.Spec)
		}
	}
	{
		const prefix string = ",\"id\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.ID))
	}
	{
		const prefix string = ",\"name\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Name))
	}
	if in.Pod != "" {
		const prefix string = ",\"pod\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Pod))
	}
	if in.Namespace != "" {
		const prefix string = ",\"namespace\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Namespace))
	}
	if true {
		const prefix string = ",\"idMappingsOptions\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComContainersStorage(out, in.IDMappings)
	}
	if in.RootfsImageID != "" {
		const prefix string = ",\"rootfsImageID\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.RootfsImageID))
	}
	if in.RootfsImageName != "" {
		const prefix string = ",\"rootfsImageName\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.RootfsImageName))
	}
	if in.Rootfs != "" {
		const prefix string = ",\"rootfs\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Rootfs))
	}
	{
		const prefix string = ",\"imageVolumes\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.ImageVolumes))
	}
	if in.ShmDir != "" {
		const prefix string = ",\"ShmDir\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.ShmDir))
	}
	{
		const prefix string = ",\"shmSize\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(in.ShmSize))
	}
	{
		const prefix string = ",\"staticDir\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.StaticDir))
	}
	if len(in.Mounts) != 0 {
		const prefix string = ",\"mounts\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v56, v57 := range in.Mounts {
				if v56 > 0 {
					out.RawByte(',')
				}
				out.String(string(v57))
			}
			out.RawByte(']')
		}
	}
	{
		const prefix string = ",\"privileged\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.Privileged))
	}
	if in.ProcessLabel != "" {
		const prefix string = ",\"ProcessLabel\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.ProcessLabel))
	}
	if in.MountLabel != "" {
		const prefix string = ",\"MountLabel\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.MountLabel))
	}
	if len(in.LabelOpts) != 0 {
		const prefix string = ",\"labelopts\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v58, v59 := range in.LabelOpts {
				if v58 > 0 {
					out.RawByte(',')
				}
				out.String(string(v59))
			}
			out.RawByte(']')
		}
	}
	if in.User != "" {
		const prefix string = ",\"user\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.User))
	}
	if len(in.Groups) != 0 {
		const prefix string = ",\"groups\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v60, v61 := range in.Groups {
				if v60 > 0 {
					out.RawByte(',')
				}
				out.String(string(v61))
			}
			out.RawByte(']')
		}
	}
	if in.IPCNsCtr != "" {
		const prefix string = ",\"ipcNsCtr\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.IPCNsCtr))
	}
	if in.MountNsCtr != "" {
		const prefix string = ",\"mountNsCtr\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.MountNsCtr))
	}
	if in.NetNsCtr != "" {
		const prefix string = ",\"netNsCtr\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.NetNsCtr))
	}
	if in.PIDNsCtr != "" {
		const prefix string = ",\"pidNsCtr\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.PIDNsCtr))
	}
	if in.UserNsCtr != "" {
		const prefix string = ",\"userNsCtr\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.UserNsCtr))
	}
	if in.UTSNsCtr != "" {
		const prefix string = ",\"utsNsCtr\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.UTSNsCtr))
	}
	if in.CgroupNsCtr != "" {
		const prefix string = ",\"cgroupNsCtr\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.CgroupNsCtr))
	}
	{
		const prefix string = ",\"Dependencies\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		if in.Dependencies == nil && (out.Flags&jwriter.NilSliceAsEmpty) == 0 {
			out.RawString("null")
		} else {
			out.RawByte('[')
			for v62, v63 := range in.Dependencies {
				if v62 > 0 {
					out.RawByte(',')
				}
				out.String(string(v63))
			}
			out.RawByte(']')
		}
	}
	{
		const prefix string = ",\"createNetNS\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.CreateNetNS))
	}
	{
		const prefix string = ",\"staticIP\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.RawText((in.StaticIP).MarshalText())
	}
	if len(in.PortMappings) != 0 {
		const prefix string = ",\"portMappings\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v64, v65 := range in.PortMappings {
				if v64 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComCriOOcicniPkgOcicni(out, v65)
			}
			out.RawByte(']')
		}
	}
	if len(in.DNSServer) != 0 {
		const prefix string = ",\"dnsServer\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v66, v67 := range in.DNSServer {
				if v66 > 0 {
					out.RawByte(',')
				}
				out.RawText((v67).MarshalText())
			}
			out.RawByte(']')
		}
	}
	if len(in.DNSSearch) != 0 {
		const prefix string = ",\"dnsSearch\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v68, v69 := range in.DNSSearch {
				if v68 > 0 {
					out.RawByte(',')
				}
				out.String(string(v69))
			}
			out.RawByte(']')
		}
	}
	if len(in.DNSOption) != 0 {
		const prefix string = ",\"dnsOption\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v70, v71 := range in.DNSOption {
				if v70 > 0 {
					out.RawByte(',')
				}
				out.String(string(v71))
			}
			out.RawByte(']')
		}
	}
	if len(in.HostAdd) != 0 {
		const prefix string = ",\"hostsAdd\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v72, v73 := range in.HostAdd {
				if v72 > 0 {
					out.RawByte(',')
				}
				out.String(string(v73))
			}
			out.RawByte(']')
		}
	}
	if len(in.Networks) != 0 {
		const prefix string = ",\"networks\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v74, v75 := range in.Networks {
				if v74 > 0 {
					out.RawByte(',')
				}
				out.String(string(v75))
			}
			out.RawByte(']')
		}
	}
	if in.NetMode != "" {
		const prefix string = ",\"networkMode\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.NetMode))
	}
	if len(in.UserVolumes) != 0 {
		const prefix string = ",\"userVolumes\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v76, v77 := range in.UserVolumes {
				if v76 > 0 {
					out.RawByte(',')
				}
				out.String(string(v77))
			}
			out.RawByte(']')
		}
	}
	if len(in.Entrypoint) != 0 {
		const prefix string = ",\"entrypoint\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v78, v79 := range in.Entrypoint {
				if v78 > 0 {
					out.RawByte(',')
				}
				out.String(string(v79))
			}
			out.RawByte(']')
		}
	}
	if len(in.Command) != 0 {
		const prefix string = ",\"command\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v80, v81 := range in.Command {
				if v80 > 0 {
					out.RawByte(',')
				}
				out.String(string(v81))
			}
			out.RawByte(']')
		}
	}
	if in.Stdin {
		const prefix string = ",\"stdin\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.Stdin))
	}
	if len(in.Labels) != 0 {
		const prefix string = ",\"labels\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('{')
			v82First := true
			for v82Name, v82Value := range in.Labels {
				if v82First {
					v82First = false
				} else {
					out.RawByte(',')
				}
				out.String(string(v82Name))
				out.RawByte(':')
				out.String(string(v82Value))
			}
			out.RawByte('}')
		}
	}
	if in.StopSignal != 0 {
		const prefix string = ",\"stopSignal\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint(uint(in.StopSignal))
	}
	if in.StopTimeout != 0 {
		const prefix string = ",\"stopTimeout\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint(uint(in.StopTimeout))
	}
	{
		const prefix string = ",\"createdTime\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Raw((in.CreatedTime).MarshalJSON())
	}
	{
		const prefix string = ",\"cgroupParent\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.CgroupParent))
	}
	{
		const prefix string = ",\"logPath\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.LogPath))
	}
	if in.ConmonPidFile != "" {
		const prefix string = ",\"conmonPidFile\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.ConmonPidFile))
	}
	{
		const prefix string = ",\"postConfigureNetNS\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.PostConfigureNetNS))
	}
	if len(in.ExitCommand) != 0 {
		const prefix string = ",\"exitCommand\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v83, v84 := range in.ExitCommand {
				if v83 > 0 {
					out.RawByte(',')
				}
				out.String(string(v84))
			}
			out.RawByte(']')
		}
	}
	{
		const prefix string = ",\"LocalVolumes\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		if in.LocalVolumes == nil && (out.Flags&jwriter.NilSliceAsEmpty) == 0 {
			out.RawString("null")
		} else {
			out.RawByte('[')
			for v85, v86 := range in.LocalVolumes {
				if v85 > 0 {
					out.RawByte(',')
				}
				out.String(string(v86))
			}
			out.RawByte(']')
		}
	}
	{
		const prefix string = ",\"pause\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.IsInfra))
	}
	{
		const prefix string = ",\"systemd\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.Systemd))
	}
	out.RawByte('}')
}

// MarshalJSON supports json.Marshaler interface
func (v ContainerConfig) MarshalJSON() ([]byte, error) {
	w := jwriter.Writer{}
	easyjson1dbef17bEncodeGithubComContainersLibpodLibpod2(&w, v)
	return w.Buffer.BuildBytes(), w.Error
}

// MarshalEasyJSON supports easyjson.Marshaler interface
func (v ContainerConfig) MarshalEasyJSON(w *jwriter.Writer) {
	easyjson1dbef17bEncodeGithubComContainersLibpodLibpod2(w, v)
}

// UnmarshalJSON supports json.Unmarshaler interface
func (v *ContainerConfig) UnmarshalJSON(data []byte) error {
	r := jlexer.Lexer{Data: data}
	easyjson1dbef17bDecodeGithubComContainersLibpodLibpod2(&r, v)
	return r.Error()
}

// UnmarshalEasyJSON supports easyjson.Unmarshaler interface
func (v *ContainerConfig) UnmarshalEasyJSON(l *jlexer.Lexer) {
	easyjson1dbef17bDecodeGithubComContainersLibpodLibpod2(l, v)
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComCriOOcicniPkgOcicni(in *jlexer.Lexer, out *ocicni.PortMapping) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "hostPort":
			out.HostPort = int32(in.Int32())
		case "containerPort":
			out.ContainerPort = int32(in.Int32())
		case "protocol":
			out.Protocol = string(in.String())
		case "hostIP":
			out.HostIP = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComCriOOcicniPkgOcicni(out *jwriter.Writer, in ocicni.PortMapping) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"hostPort\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int32(int32(in.HostPort))
	}
	{
		const prefix string = ",\"containerPort\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int32(int32(in.ContainerPort))
	}
	{
		const prefix string = ",\"protocol\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Protocol))
	}
	{
		const prefix string = ",\"hostIP\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.HostIP))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComContainersStorage(in *jlexer.Lexer, out *storage.IDMappingOptions) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "HostUIDMapping":
			out.HostUIDMapping = bool(in.Bool())
		case "HostGIDMapping":
			out.HostGIDMapping = bool(in.Bool())
		case "UIDMap":
			if in.IsNull() {
				in.Skip()
				out.UIDMap = nil
			} else {
				in.Delim('[')
				if out.UIDMap == nil {
					if !in.IsDelim(']') {
						out.UIDMap = make([]idtools.IDMap, 0, 2)
					} else {
						out.UIDMap = []idtools.IDMap{}
					}
				} else {
					out.UIDMap = (out.UIDMap)[:0]
				}
				for !in.IsDelim(']') {
					var v87 idtools.IDMap
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComContainersStoragePkgIdtools(in, &v87)
					out.UIDMap = append(out.UIDMap, v87)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "GIDMap":
			if in.IsNull() {
				in.Skip()
				out.GIDMap = nil
			} else {
				in.Delim('[')
				if out.GIDMap == nil {
					if !in.IsDelim(']') {
						out.GIDMap = make([]idtools.IDMap, 0, 2)
					} else {
						out.GIDMap = []idtools.IDMap{}
					}
				} else {
					out.GIDMap = (out.GIDMap)[:0]
				}
				for !in.IsDelim(']') {
					var v88 idtools.IDMap
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComContainersStoragePkgIdtools(in, &v88)
					out.GIDMap = append(out.GIDMap, v88)
					in.WantComma()
				}
				in.Delim(']')
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComContainersStorage(out *jwriter.Writer, in storage.IDMappingOptions) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"HostUIDMapping\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.HostUIDMapping))
	}
	{
		const prefix string = ",\"HostGIDMapping\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.HostGIDMapping))
	}
	{
		const prefix string = ",\"UIDMap\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		if in.UIDMap == nil && (out.Flags&jwriter.NilSliceAsEmpty) == 0 {
			out.RawString("null")
		} else {
			out.RawByte('[')
			for v89, v90 := range in.UIDMap {
				if v89 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComContainersStoragePkgIdtools(out, v90)
			}
			out.RawByte(']')
		}
	}
	{
		const prefix string = ",\"GIDMap\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		if in.GIDMap == nil && (out.Flags&jwriter.NilSliceAsEmpty) == 0 {
			out.RawString("null")
		} else {
			out.RawByte('[')
			for v91, v92 := range in.GIDMap {
				if v91 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComContainersStoragePkgIdtools(out, v92)
			}
			out.RawByte(']')
		}
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComContainersStoragePkgIdtools(in *jlexer.Lexer, out *idtools.IDMap) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "container_id":
			out.ContainerID = int(in.Int())
		case "host_id":
			out.HostID = int(in.Int())
		case "size":
			out.Size = int(in.Int())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComContainersStoragePkgIdtools(out *jwriter.Writer, in idtools.IDMap) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"container_id\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int(int(in.ContainerID))
	}
	{
		const prefix string = ",\"host_id\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int(int(in.HostID))
	}
	{
		const prefix string = ",\"size\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int(int(in.Size))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo1(in *jlexer.Lexer, out *specs_go.Spec) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "ociVersion":
			out.Version = string(in.String())
		case "process":
			if in.IsNull() {
				in.Skip()
				out.Process = nil
			} else {
				if out.Process == nil {
					out.Process = new(specs_go.Process)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo2(in, &*out.Process)
			}
		case "root":
			if in.IsNull() {
				in.Skip()
				out.Root = nil
			} else {
				if out.Root == nil {
					out.Root = new(specs_go.Root)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo3(in, &*out.Root)
			}
		case "hostname":
			out.Hostname = string(in.String())
		case "mounts":
			if in.IsNull() {
				in.Skip()
				out.Mounts = nil
			} else {
				in.Delim('[')
				if out.Mounts == nil {
					if !in.IsDelim(']') {
						out.Mounts = make([]specs_go.Mount, 0, 1)
					} else {
						out.Mounts = []specs_go.Mount{}
					}
				} else {
					out.Mounts = (out.Mounts)[:0]
				}
				for !in.IsDelim(']') {
					var v93 specs_go.Mount
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo4(in, &v93)
					out.Mounts = append(out.Mounts, v93)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "hooks":
			if in.IsNull() {
				in.Skip()
				out.Hooks = nil
			} else {
				if out.Hooks == nil {
					out.Hooks = new(specs_go.Hooks)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo5(in, &*out.Hooks)
			}
		case "annotations":
			if in.IsNull() {
				in.Skip()
			} else {
				in.Delim('{')
				if !in.IsDelim('}') {
					out.Annotations = make(map[string]string)
				} else {
					out.Annotations = nil
				}
				for !in.IsDelim('}') {
					key := string(in.String())
					in.WantColon()
					var v94 string
					v94 = string(in.String())
					(out.Annotations)[key] = v94
					in.WantComma()
				}
				in.Delim('}')
			}
		case "linux":
			if in.IsNull() {
				in.Skip()
				out.Linux = nil
			} else {
				if out.Linux == nil {
					out.Linux = new(specs_go.Linux)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo6(in, &*out.Linux)
			}
		case "solaris":
			if in.IsNull() {
				in.Skip()
				out.Solaris = nil
			} else {
				if out.Solaris == nil {
					out.Solaris = new(specs_go.Solaris)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo7(in, &*out.Solaris)
			}
		case "windows":
			if in.IsNull() {
				in.Skip()
				out.Windows = nil
			} else {
				if out.Windows == nil {
					out.Windows = new(specs_go.Windows)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo8(in, &*out.Windows)
			}
		case "vm":
			if in.IsNull() {
				in.Skip()
				out.VM = nil
			} else {
				if out.VM == nil {
					out.VM = new(specs_go.VM)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo9(in, &*out.VM)
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo1(out *jwriter.Writer, in specs_go.Spec) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"ociVersion\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Version))
	}
	if in.Process != nil {
		const prefix string = ",\"process\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo2(out, *in.Process)
	}
	if in.Root != nil {
		const prefix string = ",\"root\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo3(out, *in.Root)
	}
	if in.Hostname != "" {
		const prefix string = ",\"hostname\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Hostname))
	}
	if len(in.Mounts) != 0 {
		const prefix string = ",\"mounts\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v95, v96 := range in.Mounts {
				if v95 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo4(out, v96)
			}
			out.RawByte(']')
		}
	}
	if in.Hooks != nil {
		const prefix string = ",\"hooks\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo5(out, *in.Hooks)
	}
	if len(in.Annotations) != 0 {
		const prefix string = ",\"annotations\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('{')
			v97First := true
			for v97Name, v97Value := range in.Annotations {
				if v97First {
					v97First = false
				} else {
					out.RawByte(',')
				}
				out.String(string(v97Name))
				out.RawByte(':')
				out.String(string(v97Value))
			}
			out.RawByte('}')
		}
	}
	if in.Linux != nil {
		const prefix string = ",\"linux\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo6(out, *in.Linux)
	}
	if in.Solaris != nil {
		const prefix string = ",\"solaris\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo7(out, *in.Solaris)
	}
	if in.Windows != nil {
		const prefix string = ",\"windows\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo8(out, *in.Windows)
	}
	if in.VM != nil {
		const prefix string = ",\"vm\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo9(out, *in.VM)
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo9(in *jlexer.Lexer, out *specs_go.VM) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "hypervisor":
			easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo10(in, &out.Hypervisor)
		case "kernel":
			easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo11(in, &out.Kernel)
		case "image":
			easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo12(in, &out.Image)
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo9(out *jwriter.Writer, in specs_go.VM) {
	out.RawByte('{')
	first := true
	_ = first
	if true {
		const prefix string = ",\"hypervisor\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo10(out, in.Hypervisor)
	}
	{
		const prefix string = ",\"kernel\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo11(out, in.Kernel)
	}
	if true {
		const prefix string = ",\"image\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo12(out, in.Image)
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo12(in *jlexer.Lexer, out *specs_go.VMImage) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "path":
			out.Path = string(in.String())
		case "format":
			out.Format = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo12(out *jwriter.Writer, in specs_go.VMImage) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"path\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Path))
	}
	{
		const prefix string = ",\"format\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Format))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo11(in *jlexer.Lexer, out *specs_go.VMKernel) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "path":
			out.Path = string(in.String())
		case "parameters":
			out.Parameters = string(in.String())
		case "initrd":
			out.InitRD = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo11(out *jwriter.Writer, in specs_go.VMKernel) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"path\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Path))
	}
	if in.Parameters != "" {
		const prefix string = ",\"parameters\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Parameters))
	}
	if in.InitRD != "" {
		const prefix string = ",\"initrd\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.InitRD))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo10(in *jlexer.Lexer, out *specs_go.VMHypervisor) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "path":
			out.Path = string(in.String())
		case "parameters":
			out.Parameters = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo10(out *jwriter.Writer, in specs_go.VMHypervisor) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"path\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Path))
	}
	if in.Parameters != "" {
		const prefix string = ",\"parameters\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Parameters))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo8(in *jlexer.Lexer, out *specs_go.Windows) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "layerFolders":
			if in.IsNull() {
				in.Skip()
				out.LayerFolders = nil
			} else {
				in.Delim('[')
				if out.LayerFolders == nil {
					if !in.IsDelim(']') {
						out.LayerFolders = make([]string, 0, 4)
					} else {
						out.LayerFolders = []string{}
					}
				} else {
					out.LayerFolders = (out.LayerFolders)[:0]
				}
				for !in.IsDelim(']') {
					var v98 string
					v98 = string(in.String())
					out.LayerFolders = append(out.LayerFolders, v98)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "devices":
			if in.IsNull() {
				in.Skip()
				out.Devices = nil
			} else {
				in.Delim('[')
				if out.Devices == nil {
					if !in.IsDelim(']') {
						out.Devices = make([]specs_go.WindowsDevice, 0, 2)
					} else {
						out.Devices = []specs_go.WindowsDevice{}
					}
				} else {
					out.Devices = (out.Devices)[:0]
				}
				for !in.IsDelim(']') {
					var v99 specs_go.WindowsDevice
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo13(in, &v99)
					out.Devices = append(out.Devices, v99)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "resources":
			if in.IsNull() {
				in.Skip()
				out.Resources = nil
			} else {
				if out.Resources == nil {
					out.Resources = new(specs_go.WindowsResources)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo14(in, &*out.Resources)
			}
		case "credentialSpec":
			if m, ok := out.CredentialSpec.(easyjson.Unmarshaler); ok {
				m.UnmarshalEasyJSON(in)
			} else if m, ok := out.CredentialSpec.(json.Unmarshaler); ok {
				_ = m.UnmarshalJSON(in.Raw())
			} else {
				out.CredentialSpec = in.Interface()
			}
		case "servicing":
			out.Servicing = bool(in.Bool())
		case "ignoreFlushesDuringBoot":
			out.IgnoreFlushesDuringBoot = bool(in.Bool())
		case "hyperv":
			if in.IsNull() {
				in.Skip()
				out.HyperV = nil
			} else {
				if out.HyperV == nil {
					out.HyperV = new(specs_go.WindowsHyperV)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo15(in, &*out.HyperV)
			}
		case "network":
			if in.IsNull() {
				in.Skip()
				out.Network = nil
			} else {
				if out.Network == nil {
					out.Network = new(specs_go.WindowsNetwork)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo16(in, &*out.Network)
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo8(out *jwriter.Writer, in specs_go.Windows) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"layerFolders\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		if in.LayerFolders == nil && (out.Flags&jwriter.NilSliceAsEmpty) == 0 {
			out.RawString("null")
		} else {
			out.RawByte('[')
			for v100, v101 := range in.LayerFolders {
				if v100 > 0 {
					out.RawByte(',')
				}
				out.String(string(v101))
			}
			out.RawByte(']')
		}
	}
	if len(in.Devices) != 0 {
		const prefix string = ",\"devices\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v102, v103 := range in.Devices {
				if v102 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo13(out, v103)
			}
			out.RawByte(']')
		}
	}
	if in.Resources != nil {
		const prefix string = ",\"resources\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo14(out, *in.Resources)
	}
	if in.CredentialSpec != nil {
		const prefix string = ",\"credentialSpec\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		if m, ok := in.CredentialSpec.(easyjson.Marshaler); ok {
			m.MarshalEasyJSON(out)
		} else if m, ok := in.CredentialSpec.(json.Marshaler); ok {
			out.Raw(m.MarshalJSON())
		} else {
			out.Raw(json.Marshal(in.CredentialSpec))
		}
	}
	if in.Servicing {
		const prefix string = ",\"servicing\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.Servicing))
	}
	if in.IgnoreFlushesDuringBoot {
		const prefix string = ",\"ignoreFlushesDuringBoot\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.IgnoreFlushesDuringBoot))
	}
	if in.HyperV != nil {
		const prefix string = ",\"hyperv\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo15(out, *in.HyperV)
	}
	if in.Network != nil {
		const prefix string = ",\"network\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo16(out, *in.Network)
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo16(in *jlexer.Lexer, out *specs_go.WindowsNetwork) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "endpointList":
			if in.IsNull() {
				in.Skip()
				out.EndpointList = nil
			} else {
				in.Delim('[')
				if out.EndpointList == nil {
					if !in.IsDelim(']') {
						out.EndpointList = make([]string, 0, 4)
					} else {
						out.EndpointList = []string{}
					}
				} else {
					out.EndpointList = (out.EndpointList)[:0]
				}
				for !in.IsDelim(']') {
					var v104 string
					v104 = string(in.String())
					out.EndpointList = append(out.EndpointList, v104)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "allowUnqualifiedDNSQuery":
			out.AllowUnqualifiedDNSQuery = bool(in.Bool())
		case "DNSSearchList":
			if in.IsNull() {
				in.Skip()
				out.DNSSearchList = nil
			} else {
				in.Delim('[')
				if out.DNSSearchList == nil {
					if !in.IsDelim(']') {
						out.DNSSearchList = make([]string, 0, 4)
					} else {
						out.DNSSearchList = []string{}
					}
				} else {
					out.DNSSearchList = (out.DNSSearchList)[:0]
				}
				for !in.IsDelim(']') {
					var v105 string
					v105 = string(in.String())
					out.DNSSearchList = append(out.DNSSearchList, v105)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "networkSharedContainerName":
			out.NetworkSharedContainerName = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo16(out *jwriter.Writer, in specs_go.WindowsNetwork) {
	out.RawByte('{')
	first := true
	_ = first
	if len(in.EndpointList) != 0 {
		const prefix string = ",\"endpointList\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v106, v107 := range in.EndpointList {
				if v106 > 0 {
					out.RawByte(',')
				}
				out.String(string(v107))
			}
			out.RawByte(']')
		}
	}
	if in.AllowUnqualifiedDNSQuery {
		const prefix string = ",\"allowUnqualifiedDNSQuery\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.AllowUnqualifiedDNSQuery))
	}
	if len(in.DNSSearchList) != 0 {
		const prefix string = ",\"DNSSearchList\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v108, v109 := range in.DNSSearchList {
				if v108 > 0 {
					out.RawByte(',')
				}
				out.String(string(v109))
			}
			out.RawByte(']')
		}
	}
	if in.NetworkSharedContainerName != "" {
		const prefix string = ",\"networkSharedContainerName\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.NetworkSharedContainerName))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo15(in *jlexer.Lexer, out *specs_go.WindowsHyperV) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "utilityVMPath":
			out.UtilityVMPath = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo15(out *jwriter.Writer, in specs_go.WindowsHyperV) {
	out.RawByte('{')
	first := true
	_ = first
	if in.UtilityVMPath != "" {
		const prefix string = ",\"utilityVMPath\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.UtilityVMPath))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo14(in *jlexer.Lexer, out *specs_go.WindowsResources) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "memory":
			if in.IsNull() {
				in.Skip()
				out.Memory = nil
			} else {
				if out.Memory == nil {
					out.Memory = new(specs_go.WindowsMemoryResources)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo17(in, &*out.Memory)
			}
		case "cpu":
			if in.IsNull() {
				in.Skip()
				out.CPU = nil
			} else {
				if out.CPU == nil {
					out.CPU = new(specs_go.WindowsCPUResources)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo18(in, &*out.CPU)
			}
		case "storage":
			if in.IsNull() {
				in.Skip()
				out.Storage = nil
			} else {
				if out.Storage == nil {
					out.Storage = new(specs_go.WindowsStorageResources)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo19(in, &*out.Storage)
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo14(out *jwriter.Writer, in specs_go.WindowsResources) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Memory != nil {
		const prefix string = ",\"memory\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo17(out, *in.Memory)
	}
	if in.CPU != nil {
		const prefix string = ",\"cpu\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo18(out, *in.CPU)
	}
	if in.Storage != nil {
		const prefix string = ",\"storage\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo19(out, *in.Storage)
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo19(in *jlexer.Lexer, out *specs_go.WindowsStorageResources) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "iops":
			if in.IsNull() {
				in.Skip()
				out.Iops = nil
			} else {
				if out.Iops == nil {
					out.Iops = new(uint64)
				}
				*out.Iops = uint64(in.Uint64())
			}
		case "bps":
			if in.IsNull() {
				in.Skip()
				out.Bps = nil
			} else {
				if out.Bps == nil {
					out.Bps = new(uint64)
				}
				*out.Bps = uint64(in.Uint64())
			}
		case "sandboxSize":
			if in.IsNull() {
				in.Skip()
				out.SandboxSize = nil
			} else {
				if out.SandboxSize == nil {
					out.SandboxSize = new(uint64)
				}
				*out.SandboxSize = uint64(in.Uint64())
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo19(out *jwriter.Writer, in specs_go.WindowsStorageResources) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Iops != nil {
		const prefix string = ",\"iops\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(*in.Iops))
	}
	if in.Bps != nil {
		const prefix string = ",\"bps\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(*in.Bps))
	}
	if in.SandboxSize != nil {
		const prefix string = ",\"sandboxSize\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(*in.SandboxSize))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo18(in *jlexer.Lexer, out *specs_go.WindowsCPUResources) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "count":
			if in.IsNull() {
				in.Skip()
				out.Count = nil
			} else {
				if out.Count == nil {
					out.Count = new(uint64)
				}
				*out.Count = uint64(in.Uint64())
			}
		case "shares":
			if in.IsNull() {
				in.Skip()
				out.Shares = nil
			} else {
				if out.Shares == nil {
					out.Shares = new(uint16)
				}
				*out.Shares = uint16(in.Uint16())
			}
		case "maximum":
			if in.IsNull() {
				in.Skip()
				out.Maximum = nil
			} else {
				if out.Maximum == nil {
					out.Maximum = new(uint16)
				}
				*out.Maximum = uint16(in.Uint16())
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo18(out *jwriter.Writer, in specs_go.WindowsCPUResources) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Count != nil {
		const prefix string = ",\"count\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(*in.Count))
	}
	if in.Shares != nil {
		const prefix string = ",\"shares\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint16(uint16(*in.Shares))
	}
	if in.Maximum != nil {
		const prefix string = ",\"maximum\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint16(uint16(*in.Maximum))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo17(in *jlexer.Lexer, out *specs_go.WindowsMemoryResources) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "limit":
			if in.IsNull() {
				in.Skip()
				out.Limit = nil
			} else {
				if out.Limit == nil {
					out.Limit = new(uint64)
				}
				*out.Limit = uint64(in.Uint64())
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo17(out *jwriter.Writer, in specs_go.WindowsMemoryResources) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Limit != nil {
		const prefix string = ",\"limit\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(*in.Limit))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo13(in *jlexer.Lexer, out *specs_go.WindowsDevice) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "id":
			out.ID = string(in.String())
		case "idType":
			out.IDType = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo13(out *jwriter.Writer, in specs_go.WindowsDevice) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"id\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.ID))
	}
	{
		const prefix string = ",\"idType\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.IDType))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo7(in *jlexer.Lexer, out *specs_go.Solaris) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "milestone":
			out.Milestone = string(in.String())
		case "limitpriv":
			out.LimitPriv = string(in.String())
		case "maxShmMemory":
			out.MaxShmMemory = string(in.String())
		case "anet":
			if in.IsNull() {
				in.Skip()
				out.Anet = nil
			} else {
				in.Delim('[')
				if out.Anet == nil {
					if !in.IsDelim(']') {
						out.Anet = make([]specs_go.SolarisAnet, 0, 1)
					} else {
						out.Anet = []specs_go.SolarisAnet{}
					}
				} else {
					out.Anet = (out.Anet)[:0]
				}
				for !in.IsDelim(']') {
					var v110 specs_go.SolarisAnet
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo20(in, &v110)
					out.Anet = append(out.Anet, v110)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "cappedCPU":
			if in.IsNull() {
				in.Skip()
				out.CappedCPU = nil
			} else {
				if out.CappedCPU == nil {
					out.CappedCPU = new(specs_go.SolarisCappedCPU)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo21(in, &*out.CappedCPU)
			}
		case "cappedMemory":
			if in.IsNull() {
				in.Skip()
				out.CappedMemory = nil
			} else {
				if out.CappedMemory == nil {
					out.CappedMemory = new(specs_go.SolarisCappedMemory)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo22(in, &*out.CappedMemory)
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo7(out *jwriter.Writer, in specs_go.Solaris) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Milestone != "" {
		const prefix string = ",\"milestone\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Milestone))
	}
	if in.LimitPriv != "" {
		const prefix string = ",\"limitpriv\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.LimitPriv))
	}
	if in.MaxShmMemory != "" {
		const prefix string = ",\"maxShmMemory\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.MaxShmMemory))
	}
	if len(in.Anet) != 0 {
		const prefix string = ",\"anet\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v111, v112 := range in.Anet {
				if v111 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo20(out, v112)
			}
			out.RawByte(']')
		}
	}
	if in.CappedCPU != nil {
		const prefix string = ",\"cappedCPU\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo21(out, *in.CappedCPU)
	}
	if in.CappedMemory != nil {
		const prefix string = ",\"cappedMemory\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo22(out, *in.CappedMemory)
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo22(in *jlexer.Lexer, out *specs_go.SolarisCappedMemory) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "physical":
			out.Physical = string(in.String())
		case "swap":
			out.Swap = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo22(out *jwriter.Writer, in specs_go.SolarisCappedMemory) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Physical != "" {
		const prefix string = ",\"physical\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Physical))
	}
	if in.Swap != "" {
		const prefix string = ",\"swap\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Swap))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo21(in *jlexer.Lexer, out *specs_go.SolarisCappedCPU) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "ncpus":
			out.Ncpus = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo21(out *jwriter.Writer, in specs_go.SolarisCappedCPU) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Ncpus != "" {
		const prefix string = ",\"ncpus\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Ncpus))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo20(in *jlexer.Lexer, out *specs_go.SolarisAnet) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "linkname":
			out.Linkname = string(in.String())
		case "lowerLink":
			out.Lowerlink = string(in.String())
		case "allowedAddress":
			out.Allowedaddr = string(in.String())
		case "configureAllowedAddress":
			out.Configallowedaddr = string(in.String())
		case "defrouter":
			out.Defrouter = string(in.String())
		case "linkProtection":
			out.Linkprotection = string(in.String())
		case "macAddress":
			out.Macaddress = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo20(out *jwriter.Writer, in specs_go.SolarisAnet) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Linkname != "" {
		const prefix string = ",\"linkname\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Linkname))
	}
	if in.Lowerlink != "" {
		const prefix string = ",\"lowerLink\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Lowerlink))
	}
	if in.Allowedaddr != "" {
		const prefix string = ",\"allowedAddress\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Allowedaddr))
	}
	if in.Configallowedaddr != "" {
		const prefix string = ",\"configureAllowedAddress\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Configallowedaddr))
	}
	if in.Defrouter != "" {
		const prefix string = ",\"defrouter\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Defrouter))
	}
	if in.Linkprotection != "" {
		const prefix string = ",\"linkProtection\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Linkprotection))
	}
	if in.Macaddress != "" {
		const prefix string = ",\"macAddress\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Macaddress))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo6(in *jlexer.Lexer, out *specs_go.Linux) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "uidMappings":
			if in.IsNull() {
				in.Skip()
				out.UIDMappings = nil
			} else {
				in.Delim('[')
				if out.UIDMappings == nil {
					if !in.IsDelim(']') {
						out.UIDMappings = make([]specs_go.LinuxIDMapping, 0, 5)
					} else {
						out.UIDMappings = []specs_go.LinuxIDMapping{}
					}
				} else {
					out.UIDMappings = (out.UIDMappings)[:0]
				}
				for !in.IsDelim(']') {
					var v113 specs_go.LinuxIDMapping
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo23(in, &v113)
					out.UIDMappings = append(out.UIDMappings, v113)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "gidMappings":
			if in.IsNull() {
				in.Skip()
				out.GIDMappings = nil
			} else {
				in.Delim('[')
				if out.GIDMappings == nil {
					if !in.IsDelim(']') {
						out.GIDMappings = make([]specs_go.LinuxIDMapping, 0, 5)
					} else {
						out.GIDMappings = []specs_go.LinuxIDMapping{}
					}
				} else {
					out.GIDMappings = (out.GIDMappings)[:0]
				}
				for !in.IsDelim(']') {
					var v114 specs_go.LinuxIDMapping
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo23(in, &v114)
					out.GIDMappings = append(out.GIDMappings, v114)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "sysctl":
			if in.IsNull() {
				in.Skip()
			} else {
				in.Delim('{')
				if !in.IsDelim('}') {
					out.Sysctl = make(map[string]string)
				} else {
					out.Sysctl = nil
				}
				for !in.IsDelim('}') {
					key := string(in.String())
					in.WantColon()
					var v115 string
					v115 = string(in.String())
					(out.Sysctl)[key] = v115
					in.WantComma()
				}
				in.Delim('}')
			}
		case "resources":
			if in.IsNull() {
				in.Skip()
				out.Resources = nil
			} else {
				if out.Resources == nil {
					out.Resources = new(specs_go.LinuxResources)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo24(in, &*out.Resources)
			}
		case "cgroupsPath":
			out.CgroupsPath = string(in.String())
		case "namespaces":
			if in.IsNull() {
				in.Skip()
				out.Namespaces = nil
			} else {
				in.Delim('[')
				if out.Namespaces == nil {
					if !in.IsDelim(']') {
						out.Namespaces = make([]specs_go.LinuxNamespace, 0, 2)
					} else {
						out.Namespaces = []specs_go.LinuxNamespace{}
					}
				} else {
					out.Namespaces = (out.Namespaces)[:0]
				}
				for !in.IsDelim(']') {
					var v116 specs_go.LinuxNamespace
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo25(in, &v116)
					out.Namespaces = append(out.Namespaces, v116)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "devices":
			if in.IsNull() {
				in.Skip()
				out.Devices = nil
			} else {
				in.Delim('[')
				if out.Devices == nil {
					if !in.IsDelim(']') {
						out.Devices = make([]specs_go.LinuxDevice, 0, 1)
					} else {
						out.Devices = []specs_go.LinuxDevice{}
					}
				} else {
					out.Devices = (out.Devices)[:0]
				}
				for !in.IsDelim(']') {
					var v117 specs_go.LinuxDevice
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo26(in, &v117)
					out.Devices = append(out.Devices, v117)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "seccomp":
			if in.IsNull() {
				in.Skip()
				out.Seccomp = nil
			} else {
				if out.Seccomp == nil {
					out.Seccomp = new(specs_go.LinuxSeccomp)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo27(in, &*out.Seccomp)
			}
		case "rootfsPropagation":
			out.RootfsPropagation = string(in.String())
		case "maskedPaths":
			if in.IsNull() {
				in.Skip()
				out.MaskedPaths = nil
			} else {
				in.Delim('[')
				if out.MaskedPaths == nil {
					if !in.IsDelim(']') {
						out.MaskedPaths = make([]string, 0, 4)
					} else {
						out.MaskedPaths = []string{}
					}
				} else {
					out.MaskedPaths = (out.MaskedPaths)[:0]
				}
				for !in.IsDelim(']') {
					var v118 string
					v118 = string(in.String())
					out.MaskedPaths = append(out.MaskedPaths, v118)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "readonlyPaths":
			if in.IsNull() {
				in.Skip()
				out.ReadonlyPaths = nil
			} else {
				in.Delim('[')
				if out.ReadonlyPaths == nil {
					if !in.IsDelim(']') {
						out.ReadonlyPaths = make([]string, 0, 4)
					} else {
						out.ReadonlyPaths = []string{}
					}
				} else {
					out.ReadonlyPaths = (out.ReadonlyPaths)[:0]
				}
				for !in.IsDelim(']') {
					var v119 string
					v119 = string(in.String())
					out.ReadonlyPaths = append(out.ReadonlyPaths, v119)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "mountLabel":
			out.MountLabel = string(in.String())
		case "intelRdt":
			if in.IsNull() {
				in.Skip()
				out.IntelRdt = nil
			} else {
				if out.IntelRdt == nil {
					out.IntelRdt = new(specs_go.LinuxIntelRdt)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo28(in, &*out.IntelRdt)
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo6(out *jwriter.Writer, in specs_go.Linux) {
	out.RawByte('{')
	first := true
	_ = first
	if len(in.UIDMappings) != 0 {
		const prefix string = ",\"uidMappings\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v120, v121 := range in.UIDMappings {
				if v120 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo23(out, v121)
			}
			out.RawByte(']')
		}
	}
	if len(in.GIDMappings) != 0 {
		const prefix string = ",\"gidMappings\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v122, v123 := range in.GIDMappings {
				if v122 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo23(out, v123)
			}
			out.RawByte(']')
		}
	}
	if len(in.Sysctl) != 0 {
		const prefix string = ",\"sysctl\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('{')
			v124First := true
			for v124Name, v124Value := range in.Sysctl {
				if v124First {
					v124First = false
				} else {
					out.RawByte(',')
				}
				out.String(string(v124Name))
				out.RawByte(':')
				out.String(string(v124Value))
			}
			out.RawByte('}')
		}
	}
	if in.Resources != nil {
		const prefix string = ",\"resources\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo24(out, *in.Resources)
	}
	if in.CgroupsPath != "" {
		const prefix string = ",\"cgroupsPath\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.CgroupsPath))
	}
	if len(in.Namespaces) != 0 {
		const prefix string = ",\"namespaces\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v125, v126 := range in.Namespaces {
				if v125 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo25(out, v126)
			}
			out.RawByte(']')
		}
	}
	if len(in.Devices) != 0 {
		const prefix string = ",\"devices\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v127, v128 := range in.Devices {
				if v127 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo26(out, v128)
			}
			out.RawByte(']')
		}
	}
	if in.Seccomp != nil {
		const prefix string = ",\"seccomp\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo27(out, *in.Seccomp)
	}
	if in.RootfsPropagation != "" {
		const prefix string = ",\"rootfsPropagation\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.RootfsPropagation))
	}
	if len(in.MaskedPaths) != 0 {
		const prefix string = ",\"maskedPaths\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v129, v130 := range in.MaskedPaths {
				if v129 > 0 {
					out.RawByte(',')
				}
				out.String(string(v130))
			}
			out.RawByte(']')
		}
	}
	if len(in.ReadonlyPaths) != 0 {
		const prefix string = ",\"readonlyPaths\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v131, v132 := range in.ReadonlyPaths {
				if v131 > 0 {
					out.RawByte(',')
				}
				out.String(string(v132))
			}
			out.RawByte(']')
		}
	}
	if in.MountLabel != "" {
		const prefix string = ",\"mountLabel\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.MountLabel))
	}
	if in.IntelRdt != nil {
		const prefix string = ",\"intelRdt\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo28(out, *in.IntelRdt)
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo28(in *jlexer.Lexer, out *specs_go.LinuxIntelRdt) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "l3CacheSchema":
			out.L3CacheSchema = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo28(out *jwriter.Writer, in specs_go.LinuxIntelRdt) {
	out.RawByte('{')
	first := true
	_ = first
	if in.L3CacheSchema != "" {
		const prefix string = ",\"l3CacheSchema\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.L3CacheSchema))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo27(in *jlexer.Lexer, out *specs_go.LinuxSeccomp) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "defaultAction":
			out.DefaultAction = specs_go.LinuxSeccompAction(in.String())
		case "architectures":
			if in.IsNull() {
				in.Skip()
				out.Architectures = nil
			} else {
				in.Delim('[')
				if out.Architectures == nil {
					if !in.IsDelim(']') {
						out.Architectures = make([]specs_go.Arch, 0, 4)
					} else {
						out.Architectures = []specs_go.Arch{}
					}
				} else {
					out.Architectures = (out.Architectures)[:0]
				}
				for !in.IsDelim(']') {
					var v133 specs_go.Arch
					v133 = specs_go.Arch(in.String())
					out.Architectures = append(out.Architectures, v133)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "syscalls":
			if in.IsNull() {
				in.Skip()
				out.Syscalls = nil
			} else {
				in.Delim('[')
				if out.Syscalls == nil {
					if !in.IsDelim(']') {
						out.Syscalls = make([]specs_go.LinuxSyscall, 0, 1)
					} else {
						out.Syscalls = []specs_go.LinuxSyscall{}
					}
				} else {
					out.Syscalls = (out.Syscalls)[:0]
				}
				for !in.IsDelim(']') {
					var v134 specs_go.LinuxSyscall
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo29(in, &v134)
					out.Syscalls = append(out.Syscalls, v134)
					in.WantComma()
				}
				in.Delim(']')
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo27(out *jwriter.Writer, in specs_go.LinuxSeccomp) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"defaultAction\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.DefaultAction))
	}
	if len(in.Architectures) != 0 {
		const prefix string = ",\"architectures\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v135, v136 := range in.Architectures {
				if v135 > 0 {
					out.RawByte(',')
				}
				out.String(string(v136))
			}
			out.RawByte(']')
		}
	}
	if len(in.Syscalls) != 0 {
		const prefix string = ",\"syscalls\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v137, v138 := range in.Syscalls {
				if v137 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo29(out, v138)
			}
			out.RawByte(']')
		}
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo29(in *jlexer.Lexer, out *specs_go.LinuxSyscall) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "names":
			if in.IsNull() {
				in.Skip()
				out.Names = nil
			} else {
				in.Delim('[')
				if out.Names == nil {
					if !in.IsDelim(']') {
						out.Names = make([]string, 0, 4)
					} else {
						out.Names = []string{}
					}
				} else {
					out.Names = (out.Names)[:0]
				}
				for !in.IsDelim(']') {
					var v139 string
					v139 = string(in.String())
					out.Names = append(out.Names, v139)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "action":
			out.Action = specs_go.LinuxSeccompAction(in.String())
		case "args":
			if in.IsNull() {
				in.Skip()
				out.Args = nil
			} else {
				in.Delim('[')
				if out.Args == nil {
					if !in.IsDelim(']') {
						out.Args = make([]specs_go.LinuxSeccompArg, 0, 1)
					} else {
						out.Args = []specs_go.LinuxSeccompArg{}
					}
				} else {
					out.Args = (out.Args)[:0]
				}
				for !in.IsDelim(']') {
					var v140 specs_go.LinuxSeccompArg
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo30(in, &v140)
					out.Args = append(out.Args, v140)
					in.WantComma()
				}
				in.Delim(']')
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo29(out *jwriter.Writer, in specs_go.LinuxSyscall) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"names\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		if in.Names == nil && (out.Flags&jwriter.NilSliceAsEmpty) == 0 {
			out.RawString("null")
		} else {
			out.RawByte('[')
			for v141, v142 := range in.Names {
				if v141 > 0 {
					out.RawByte(',')
				}
				out.String(string(v142))
			}
			out.RawByte(']')
		}
	}
	{
		const prefix string = ",\"action\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Action))
	}
	if len(in.Args) != 0 {
		const prefix string = ",\"args\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v143, v144 := range in.Args {
				if v143 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo30(out, v144)
			}
			out.RawByte(']')
		}
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo30(in *jlexer.Lexer, out *specs_go.LinuxSeccompArg) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "index":
			out.Index = uint(in.Uint())
		case "value":
			out.Value = uint64(in.Uint64())
		case "valueTwo":
			out.ValueTwo = uint64(in.Uint64())
		case "op":
			out.Op = specs_go.LinuxSeccompOperator(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo30(out *jwriter.Writer, in specs_go.LinuxSeccompArg) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"index\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint(uint(in.Index))
	}
	{
		const prefix string = ",\"value\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(in.Value))
	}
	if in.ValueTwo != 0 {
		const prefix string = ",\"valueTwo\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(in.ValueTwo))
	}
	{
		const prefix string = ",\"op\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Op))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo26(in *jlexer.Lexer, out *specs_go.LinuxDevice) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "path":
			out.Path = string(in.String())
		case "type":
			out.Type = string(in.String())
		case "major":
			out.Major = int64(in.Int64())
		case "minor":
			out.Minor = int64(in.Int64())
		case "fileMode":
			if in.IsNull() {
				in.Skip()
				out.FileMode = nil
			} else {
				if out.FileMode == nil {
					out.FileMode = new(os.FileMode)
				}
				*out.FileMode = os.FileMode(in.Uint32())
			}
		case "uid":
			if in.IsNull() {
				in.Skip()
				out.UID = nil
			} else {
				if out.UID == nil {
					out.UID = new(uint32)
				}
				*out.UID = uint32(in.Uint32())
			}
		case "gid":
			if in.IsNull() {
				in.Skip()
				out.GID = nil
			} else {
				if out.GID == nil {
					out.GID = new(uint32)
				}
				*out.GID = uint32(in.Uint32())
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo26(out *jwriter.Writer, in specs_go.LinuxDevice) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"path\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Path))
	}
	{
		const prefix string = ",\"type\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Type))
	}
	{
		const prefix string = ",\"major\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(in.Major))
	}
	{
		const prefix string = ",\"minor\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(in.Minor))
	}
	if in.FileMode != nil {
		const prefix string = ",\"fileMode\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint32(uint32(*in.FileMode))
	}
	if in.UID != nil {
		const prefix string = ",\"uid\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint32(uint32(*in.UID))
	}
	if in.GID != nil {
		const prefix string = ",\"gid\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint32(uint32(*in.GID))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo25(in *jlexer.Lexer, out *specs_go.LinuxNamespace) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "type":
			out.Type = specs_go.LinuxNamespaceType(in.String())
		case "path":
			out.Path = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo25(out *jwriter.Writer, in specs_go.LinuxNamespace) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"type\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Type))
	}
	if in.Path != "" {
		const prefix string = ",\"path\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Path))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo24(in *jlexer.Lexer, out *specs_go.LinuxResources) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "devices":
			if in.IsNull() {
				in.Skip()
				out.Devices = nil
			} else {
				in.Delim('[')
				if out.Devices == nil {
					if !in.IsDelim(']') {
						out.Devices = make([]specs_go.LinuxDeviceCgroup, 0, 1)
					} else {
						out.Devices = []specs_go.LinuxDeviceCgroup{}
					}
				} else {
					out.Devices = (out.Devices)[:0]
				}
				for !in.IsDelim(']') {
					var v145 specs_go.LinuxDeviceCgroup
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo31(in, &v145)
					out.Devices = append(out.Devices, v145)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "memory":
			if in.IsNull() {
				in.Skip()
				out.Memory = nil
			} else {
				if out.Memory == nil {
					out.Memory = new(specs_go.LinuxMemory)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo32(in, &*out.Memory)
			}
		case "cpu":
			if in.IsNull() {
				in.Skip()
				out.CPU = nil
			} else {
				if out.CPU == nil {
					out.CPU = new(specs_go.LinuxCPU)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo33(in, &*out.CPU)
			}
		case "pids":
			if in.IsNull() {
				in.Skip()
				out.Pids = nil
			} else {
				if out.Pids == nil {
					out.Pids = new(specs_go.LinuxPids)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo34(in, &*out.Pids)
			}
		case "blockIO":
			if in.IsNull() {
				in.Skip()
				out.BlockIO = nil
			} else {
				if out.BlockIO == nil {
					out.BlockIO = new(specs_go.LinuxBlockIO)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo35(in, &*out.BlockIO)
			}
		case "hugepageLimits":
			if in.IsNull() {
				in.Skip()
				out.HugepageLimits = nil
			} else {
				in.Delim('[')
				if out.HugepageLimits == nil {
					if !in.IsDelim(']') {
						out.HugepageLimits = make([]specs_go.LinuxHugepageLimit, 0, 2)
					} else {
						out.HugepageLimits = []specs_go.LinuxHugepageLimit{}
					}
				} else {
					out.HugepageLimits = (out.HugepageLimits)[:0]
				}
				for !in.IsDelim(']') {
					var v146 specs_go.LinuxHugepageLimit
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo36(in, &v146)
					out.HugepageLimits = append(out.HugepageLimits, v146)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "network":
			if in.IsNull() {
				in.Skip()
				out.Network = nil
			} else {
				if out.Network == nil {
					out.Network = new(specs_go.LinuxNetwork)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo37(in, &*out.Network)
			}
		case "rdma":
			if in.IsNull() {
				in.Skip()
			} else {
				in.Delim('{')
				if !in.IsDelim('}') {
					out.Rdma = make(map[string]specs_go.LinuxRdma)
				} else {
					out.Rdma = nil
				}
				for !in.IsDelim('}') {
					key := string(in.String())
					in.WantColon()
					var v147 specs_go.LinuxRdma
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo38(in, &v147)
					(out.Rdma)[key] = v147
					in.WantComma()
				}
				in.Delim('}')
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo24(out *jwriter.Writer, in specs_go.LinuxResources) {
	out.RawByte('{')
	first := true
	_ = first
	if len(in.Devices) != 0 {
		const prefix string = ",\"devices\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v148, v149 := range in.Devices {
				if v148 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo31(out, v149)
			}
			out.RawByte(']')
		}
	}
	if in.Memory != nil {
		const prefix string = ",\"memory\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo32(out, *in.Memory)
	}
	if in.CPU != nil {
		const prefix string = ",\"cpu\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo33(out, *in.CPU)
	}
	if in.Pids != nil {
		const prefix string = ",\"pids\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo34(out, *in.Pids)
	}
	if in.BlockIO != nil {
		const prefix string = ",\"blockIO\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo35(out, *in.BlockIO)
	}
	if len(in.HugepageLimits) != 0 {
		const prefix string = ",\"hugepageLimits\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v150, v151 := range in.HugepageLimits {
				if v150 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo36(out, v151)
			}
			out.RawByte(']')
		}
	}
	if in.Network != nil {
		const prefix string = ",\"network\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo37(out, *in.Network)
	}
	if len(in.Rdma) != 0 {
		const prefix string = ",\"rdma\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('{')
			v152First := true
			for v152Name, v152Value := range in.Rdma {
				if v152First {
					v152First = false
				} else {
					out.RawByte(',')
				}
				out.String(string(v152Name))
				out.RawByte(':')
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo38(out, v152Value)
			}
			out.RawByte('}')
		}
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo38(in *jlexer.Lexer, out *specs_go.LinuxRdma) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "hcaHandles":
			if in.IsNull() {
				in.Skip()
				out.HcaHandles = nil
			} else {
				if out.HcaHandles == nil {
					out.HcaHandles = new(uint32)
				}
				*out.HcaHandles = uint32(in.Uint32())
			}
		case "hcaObjects":
			if in.IsNull() {
				in.Skip()
				out.HcaObjects = nil
			} else {
				if out.HcaObjects == nil {
					out.HcaObjects = new(uint32)
				}
				*out.HcaObjects = uint32(in.Uint32())
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo38(out *jwriter.Writer, in specs_go.LinuxRdma) {
	out.RawByte('{')
	first := true
	_ = first
	if in.HcaHandles != nil {
		const prefix string = ",\"hcaHandles\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint32(uint32(*in.HcaHandles))
	}
	if in.HcaObjects != nil {
		const prefix string = ",\"hcaObjects\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint32(uint32(*in.HcaObjects))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo37(in *jlexer.Lexer, out *specs_go.LinuxNetwork) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "classID":
			if in.IsNull() {
				in.Skip()
				out.ClassID = nil
			} else {
				if out.ClassID == nil {
					out.ClassID = new(uint32)
				}
				*out.ClassID = uint32(in.Uint32())
			}
		case "priorities":
			if in.IsNull() {
				in.Skip()
				out.Priorities = nil
			} else {
				in.Delim('[')
				if out.Priorities == nil {
					if !in.IsDelim(']') {
						out.Priorities = make([]specs_go.LinuxInterfacePriority, 0, 2)
					} else {
						out.Priorities = []specs_go.LinuxInterfacePriority{}
					}
				} else {
					out.Priorities = (out.Priorities)[:0]
				}
				for !in.IsDelim(']') {
					var v153 specs_go.LinuxInterfacePriority
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo39(in, &v153)
					out.Priorities = append(out.Priorities, v153)
					in.WantComma()
				}
				in.Delim(']')
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo37(out *jwriter.Writer, in specs_go.LinuxNetwork) {
	out.RawByte('{')
	first := true
	_ = first
	if in.ClassID != nil {
		const prefix string = ",\"classID\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint32(uint32(*in.ClassID))
	}
	if len(in.Priorities) != 0 {
		const prefix string = ",\"priorities\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v154, v155 := range in.Priorities {
				if v154 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo39(out, v155)
			}
			out.RawByte(']')
		}
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo39(in *jlexer.Lexer, out *specs_go.LinuxInterfacePriority) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "name":
			out.Name = string(in.String())
		case "priority":
			out.Priority = uint32(in.Uint32())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo39(out *jwriter.Writer, in specs_go.LinuxInterfacePriority) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"name\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Name))
	}
	{
		const prefix string = ",\"priority\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint32(uint32(in.Priority))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo36(in *jlexer.Lexer, out *specs_go.LinuxHugepageLimit) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "pageSize":
			out.Pagesize = string(in.String())
		case "limit":
			out.Limit = uint64(in.Uint64())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo36(out *jwriter.Writer, in specs_go.LinuxHugepageLimit) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"pageSize\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Pagesize))
	}
	{
		const prefix string = ",\"limit\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(in.Limit))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo35(in *jlexer.Lexer, out *specs_go.LinuxBlockIO) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "weight":
			if in.IsNull() {
				in.Skip()
				out.Weight = nil
			} else {
				if out.Weight == nil {
					out.Weight = new(uint16)
				}
				*out.Weight = uint16(in.Uint16())
			}
		case "leafWeight":
			if in.IsNull() {
				in.Skip()
				out.LeafWeight = nil
			} else {
				if out.LeafWeight == nil {
					out.LeafWeight = new(uint16)
				}
				*out.LeafWeight = uint16(in.Uint16())
			}
		case "weightDevice":
			if in.IsNull() {
				in.Skip()
				out.WeightDevice = nil
			} else {
				in.Delim('[')
				if out.WeightDevice == nil {
					if !in.IsDelim(']') {
						out.WeightDevice = make([]specs_go.LinuxWeightDevice, 0, 2)
					} else {
						out.WeightDevice = []specs_go.LinuxWeightDevice{}
					}
				} else {
					out.WeightDevice = (out.WeightDevice)[:0]
				}
				for !in.IsDelim(']') {
					var v156 specs_go.LinuxWeightDevice
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo40(in, &v156)
					out.WeightDevice = append(out.WeightDevice, v156)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "throttleReadBpsDevice":
			if in.IsNull() {
				in.Skip()
				out.ThrottleReadBpsDevice = nil
			} else {
				in.Delim('[')
				if out.ThrottleReadBpsDevice == nil {
					if !in.IsDelim(']') {
						out.ThrottleReadBpsDevice = make([]specs_go.LinuxThrottleDevice, 0, 2)
					} else {
						out.ThrottleReadBpsDevice = []specs_go.LinuxThrottleDevice{}
					}
				} else {
					out.ThrottleReadBpsDevice = (out.ThrottleReadBpsDevice)[:0]
				}
				for !in.IsDelim(']') {
					var v157 specs_go.LinuxThrottleDevice
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo41(in, &v157)
					out.ThrottleReadBpsDevice = append(out.ThrottleReadBpsDevice, v157)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "throttleWriteBpsDevice":
			if in.IsNull() {
				in.Skip()
				out.ThrottleWriteBpsDevice = nil
			} else {
				in.Delim('[')
				if out.ThrottleWriteBpsDevice == nil {
					if !in.IsDelim(']') {
						out.ThrottleWriteBpsDevice = make([]specs_go.LinuxThrottleDevice, 0, 2)
					} else {
						out.ThrottleWriteBpsDevice = []specs_go.LinuxThrottleDevice{}
					}
				} else {
					out.ThrottleWriteBpsDevice = (out.ThrottleWriteBpsDevice)[:0]
				}
				for !in.IsDelim(']') {
					var v158 specs_go.LinuxThrottleDevice
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo41(in, &v158)
					out.ThrottleWriteBpsDevice = append(out.ThrottleWriteBpsDevice, v158)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "throttleReadIOPSDevice":
			if in.IsNull() {
				in.Skip()
				out.ThrottleReadIOPSDevice = nil
			} else {
				in.Delim('[')
				if out.ThrottleReadIOPSDevice == nil {
					if !in.IsDelim(']') {
						out.ThrottleReadIOPSDevice = make([]specs_go.LinuxThrottleDevice, 0, 2)
					} else {
						out.ThrottleReadIOPSDevice = []specs_go.LinuxThrottleDevice{}
					}
				} else {
					out.ThrottleReadIOPSDevice = (out.ThrottleReadIOPSDevice)[:0]
				}
				for !in.IsDelim(']') {
					var v159 specs_go.LinuxThrottleDevice
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo41(in, &v159)
					out.ThrottleReadIOPSDevice = append(out.ThrottleReadIOPSDevice, v159)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "throttleWriteIOPSDevice":
			if in.IsNull() {
				in.Skip()
				out.ThrottleWriteIOPSDevice = nil
			} else {
				in.Delim('[')
				if out.ThrottleWriteIOPSDevice == nil {
					if !in.IsDelim(']') {
						out.ThrottleWriteIOPSDevice = make([]specs_go.LinuxThrottleDevice, 0, 2)
					} else {
						out.ThrottleWriteIOPSDevice = []specs_go.LinuxThrottleDevice{}
					}
				} else {
					out.ThrottleWriteIOPSDevice = (out.ThrottleWriteIOPSDevice)[:0]
				}
				for !in.IsDelim(']') {
					var v160 specs_go.LinuxThrottleDevice
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo41(in, &v160)
					out.ThrottleWriteIOPSDevice = append(out.ThrottleWriteIOPSDevice, v160)
					in.WantComma()
				}
				in.Delim(']')
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo35(out *jwriter.Writer, in specs_go.LinuxBlockIO) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Weight != nil {
		const prefix string = ",\"weight\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint16(uint16(*in.Weight))
	}
	if in.LeafWeight != nil {
		const prefix string = ",\"leafWeight\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint16(uint16(*in.LeafWeight))
	}
	if len(in.WeightDevice) != 0 {
		const prefix string = ",\"weightDevice\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v161, v162 := range in.WeightDevice {
				if v161 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo40(out, v162)
			}
			out.RawByte(']')
		}
	}
	if len(in.ThrottleReadBpsDevice) != 0 {
		const prefix string = ",\"throttleReadBpsDevice\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v163, v164 := range in.ThrottleReadBpsDevice {
				if v163 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo41(out, v164)
			}
			out.RawByte(']')
		}
	}
	if len(in.ThrottleWriteBpsDevice) != 0 {
		const prefix string = ",\"throttleWriteBpsDevice\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v165, v166 := range in.ThrottleWriteBpsDevice {
				if v165 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo41(out, v166)
			}
			out.RawByte(']')
		}
	}
	if len(in.ThrottleReadIOPSDevice) != 0 {
		const prefix string = ",\"throttleReadIOPSDevice\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v167, v168 := range in.ThrottleReadIOPSDevice {
				if v167 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo41(out, v168)
			}
			out.RawByte(']')
		}
	}
	if len(in.ThrottleWriteIOPSDevice) != 0 {
		const prefix string = ",\"throttleWriteIOPSDevice\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v169, v170 := range in.ThrottleWriteIOPSDevice {
				if v169 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo41(out, v170)
			}
			out.RawByte(']')
		}
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo41(in *jlexer.Lexer, out *specs_go.LinuxThrottleDevice) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "rate":
			out.Rate = uint64(in.Uint64())
		case "major":
			out.Major = int64(in.Int64())
		case "minor":
			out.Minor = int64(in.Int64())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo41(out *jwriter.Writer, in specs_go.LinuxThrottleDevice) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"rate\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(in.Rate))
	}
	{
		const prefix string = ",\"major\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(in.Major))
	}
	{
		const prefix string = ",\"minor\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(in.Minor))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo40(in *jlexer.Lexer, out *specs_go.LinuxWeightDevice) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "weight":
			if in.IsNull() {
				in.Skip()
				out.Weight = nil
			} else {
				if out.Weight == nil {
					out.Weight = new(uint16)
				}
				*out.Weight = uint16(in.Uint16())
			}
		case "leafWeight":
			if in.IsNull() {
				in.Skip()
				out.LeafWeight = nil
			} else {
				if out.LeafWeight == nil {
					out.LeafWeight = new(uint16)
				}
				*out.LeafWeight = uint16(in.Uint16())
			}
		case "major":
			out.Major = int64(in.Int64())
		case "minor":
			out.Minor = int64(in.Int64())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo40(out *jwriter.Writer, in specs_go.LinuxWeightDevice) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Weight != nil {
		const prefix string = ",\"weight\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint16(uint16(*in.Weight))
	}
	if in.LeafWeight != nil {
		const prefix string = ",\"leafWeight\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint16(uint16(*in.LeafWeight))
	}
	{
		const prefix string = ",\"major\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(in.Major))
	}
	{
		const prefix string = ",\"minor\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(in.Minor))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo34(in *jlexer.Lexer, out *specs_go.LinuxPids) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "limit":
			out.Limit = int64(in.Int64())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo34(out *jwriter.Writer, in specs_go.LinuxPids) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"limit\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(in.Limit))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo33(in *jlexer.Lexer, out *specs_go.LinuxCPU) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "shares":
			if in.IsNull() {
				in.Skip()
				out.Shares = nil
			} else {
				if out.Shares == nil {
					out.Shares = new(uint64)
				}
				*out.Shares = uint64(in.Uint64())
			}
		case "quota":
			if in.IsNull() {
				in.Skip()
				out.Quota = nil
			} else {
				if out.Quota == nil {
					out.Quota = new(int64)
				}
				*out.Quota = int64(in.Int64())
			}
		case "period":
			if in.IsNull() {
				in.Skip()
				out.Period = nil
			} else {
				if out.Period == nil {
					out.Period = new(uint64)
				}
				*out.Period = uint64(in.Uint64())
			}
		case "realtimeRuntime":
			if in.IsNull() {
				in.Skip()
				out.RealtimeRuntime = nil
			} else {
				if out.RealtimeRuntime == nil {
					out.RealtimeRuntime = new(int64)
				}
				*out.RealtimeRuntime = int64(in.Int64())
			}
		case "realtimePeriod":
			if in.IsNull() {
				in.Skip()
				out.RealtimePeriod = nil
			} else {
				if out.RealtimePeriod == nil {
					out.RealtimePeriod = new(uint64)
				}
				*out.RealtimePeriod = uint64(in.Uint64())
			}
		case "cpus":
			out.Cpus = string(in.String())
		case "mems":
			out.Mems = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo33(out *jwriter.Writer, in specs_go.LinuxCPU) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Shares != nil {
		const prefix string = ",\"shares\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(*in.Shares))
	}
	if in.Quota != nil {
		const prefix string = ",\"quota\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(*in.Quota))
	}
	if in.Period != nil {
		const prefix string = ",\"period\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(*in.Period))
	}
	if in.RealtimeRuntime != nil {
		const prefix string = ",\"realtimeRuntime\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(*in.RealtimeRuntime))
	}
	if in.RealtimePeriod != nil {
		const prefix string = ",\"realtimePeriod\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(*in.RealtimePeriod))
	}
	if in.Cpus != "" {
		const prefix string = ",\"cpus\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Cpus))
	}
	if in.Mems != "" {
		const prefix string = ",\"mems\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Mems))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo32(in *jlexer.Lexer, out *specs_go.LinuxMemory) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "limit":
			if in.IsNull() {
				in.Skip()
				out.Limit = nil
			} else {
				if out.Limit == nil {
					out.Limit = new(int64)
				}
				*out.Limit = int64(in.Int64())
			}
		case "reservation":
			if in.IsNull() {
				in.Skip()
				out.Reservation = nil
			} else {
				if out.Reservation == nil {
					out.Reservation = new(int64)
				}
				*out.Reservation = int64(in.Int64())
			}
		case "swap":
			if in.IsNull() {
				in.Skip()
				out.Swap = nil
			} else {
				if out.Swap == nil {
					out.Swap = new(int64)
				}
				*out.Swap = int64(in.Int64())
			}
		case "kernel":
			if in.IsNull() {
				in.Skip()
				out.Kernel = nil
			} else {
				if out.Kernel == nil {
					out.Kernel = new(int64)
				}
				*out.Kernel = int64(in.Int64())
			}
		case "kernelTCP":
			if in.IsNull() {
				in.Skip()
				out.KernelTCP = nil
			} else {
				if out.KernelTCP == nil {
					out.KernelTCP = new(int64)
				}
				*out.KernelTCP = int64(in.Int64())
			}
		case "swappiness":
			if in.IsNull() {
				in.Skip()
				out.Swappiness = nil
			} else {
				if out.Swappiness == nil {
					out.Swappiness = new(uint64)
				}
				*out.Swappiness = uint64(in.Uint64())
			}
		case "disableOOMKiller":
			if in.IsNull() {
				in.Skip()
				out.DisableOOMKiller = nil
			} else {
				if out.DisableOOMKiller == nil {
					out.DisableOOMKiller = new(bool)
				}
				*out.DisableOOMKiller = bool(in.Bool())
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo32(out *jwriter.Writer, in specs_go.LinuxMemory) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Limit != nil {
		const prefix string = ",\"limit\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(*in.Limit))
	}
	if in.Reservation != nil {
		const prefix string = ",\"reservation\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(*in.Reservation))
	}
	if in.Swap != nil {
		const prefix string = ",\"swap\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(*in.Swap))
	}
	if in.Kernel != nil {
		const prefix string = ",\"kernel\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(*in.Kernel))
	}
	if in.KernelTCP != nil {
		const prefix string = ",\"kernelTCP\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(*in.KernelTCP))
	}
	if in.Swappiness != nil {
		const prefix string = ",\"swappiness\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(*in.Swappiness))
	}
	if in.DisableOOMKiller != nil {
		const prefix string = ",\"disableOOMKiller\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(*in.DisableOOMKiller))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo31(in *jlexer.Lexer, out *specs_go.LinuxDeviceCgroup) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "allow":
			out.Allow = bool(in.Bool())
		case "type":
			out.Type = string(in.String())
		case "major":
			if in.IsNull() {
				in.Skip()
				out.Major = nil
			} else {
				if out.Major == nil {
					out.Major = new(int64)
				}
				*out.Major = int64(in.Int64())
			}
		case "minor":
			if in.IsNull() {
				in.Skip()
				out.Minor = nil
			} else {
				if out.Minor == nil {
					out.Minor = new(int64)
				}
				*out.Minor = int64(in.Int64())
			}
		case "access":
			out.Access = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo31(out *jwriter.Writer, in specs_go.LinuxDeviceCgroup) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"allow\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.Allow))
	}
	if in.Type != "" {
		const prefix string = ",\"type\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Type))
	}
	if in.Major != nil {
		const prefix string = ",\"major\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(*in.Major))
	}
	if in.Minor != nil {
		const prefix string = ",\"minor\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int64(int64(*in.Minor))
	}
	if in.Access != "" {
		const prefix string = ",\"access\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Access))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo23(in *jlexer.Lexer, out *specs_go.LinuxIDMapping) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "containerID":
			out.ContainerID = uint32(in.Uint32())
		case "hostID":
			out.HostID = uint32(in.Uint32())
		case "size":
			out.Size = uint32(in.Uint32())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo23(out *jwriter.Writer, in specs_go.LinuxIDMapping) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"containerID\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint32(uint32(in.ContainerID))
	}
	{
		const prefix string = ",\"hostID\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint32(uint32(in.HostID))
	}
	{
		const prefix string = ",\"size\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint32(uint32(in.Size))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo5(in *jlexer.Lexer, out *specs_go.Hooks) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "prestart":
			if in.IsNull() {
				in.Skip()
				out.Prestart = nil
			} else {
				in.Delim('[')
				if out.Prestart == nil {
					if !in.IsDelim(']') {
						out.Prestart = make([]specs_go.Hook, 0, 1)
					} else {
						out.Prestart = []specs_go.Hook{}
					}
				} else {
					out.Prestart = (out.Prestart)[:0]
				}
				for !in.IsDelim(']') {
					var v171 specs_go.Hook
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo(in, &v171)
					out.Prestart = append(out.Prestart, v171)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "poststart":
			if in.IsNull() {
				in.Skip()
				out.Poststart = nil
			} else {
				in.Delim('[')
				if out.Poststart == nil {
					if !in.IsDelim(']') {
						out.Poststart = make([]specs_go.Hook, 0, 1)
					} else {
						out.Poststart = []specs_go.Hook{}
					}
				} else {
					out.Poststart = (out.Poststart)[:0]
				}
				for !in.IsDelim(']') {
					var v172 specs_go.Hook
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo(in, &v172)
					out.Poststart = append(out.Poststart, v172)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "poststop":
			if in.IsNull() {
				in.Skip()
				out.Poststop = nil
			} else {
				in.Delim('[')
				if out.Poststop == nil {
					if !in.IsDelim(']') {
						out.Poststop = make([]specs_go.Hook, 0, 1)
					} else {
						out.Poststop = []specs_go.Hook{}
					}
				} else {
					out.Poststop = (out.Poststop)[:0]
				}
				for !in.IsDelim(']') {
					var v173 specs_go.Hook
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo(in, &v173)
					out.Poststop = append(out.Poststop, v173)
					in.WantComma()
				}
				in.Delim(']')
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo5(out *jwriter.Writer, in specs_go.Hooks) {
	out.RawByte('{')
	first := true
	_ = first
	if len(in.Prestart) != 0 {
		const prefix string = ",\"prestart\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v174, v175 := range in.Prestart {
				if v174 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo(out, v175)
			}
			out.RawByte(']')
		}
	}
	if len(in.Poststart) != 0 {
		const prefix string = ",\"poststart\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v176, v177 := range in.Poststart {
				if v176 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo(out, v177)
			}
			out.RawByte(']')
		}
	}
	if len(in.Poststop) != 0 {
		const prefix string = ",\"poststop\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v178, v179 := range in.Poststop {
				if v178 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo(out, v179)
			}
			out.RawByte(']')
		}
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo4(in *jlexer.Lexer, out *specs_go.Mount) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "destination":
			out.Destination = string(in.String())
		case "type":
			out.Type = string(in.String())
		case "source":
			out.Source = string(in.String())
		case "options":
			if in.IsNull() {
				in.Skip()
				out.Options = nil
			} else {
				in.Delim('[')
				if out.Options == nil {
					if !in.IsDelim(']') {
						out.Options = make([]string, 0, 4)
					} else {
						out.Options = []string{}
					}
				} else {
					out.Options = (out.Options)[:0]
				}
				for !in.IsDelim(']') {
					var v180 string
					v180 = string(in.String())
					out.Options = append(out.Options, v180)
					in.WantComma()
				}
				in.Delim(']')
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo4(out *jwriter.Writer, in specs_go.Mount) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"destination\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Destination))
	}
	if in.Type != "" {
		const prefix string = ",\"type\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Type))
	}
	if in.Source != "" {
		const prefix string = ",\"source\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Source))
	}
	if len(in.Options) != 0 {
		const prefix string = ",\"options\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v181, v182 := range in.Options {
				if v181 > 0 {
					out.RawByte(',')
				}
				out.String(string(v182))
			}
			out.RawByte(']')
		}
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo3(in *jlexer.Lexer, out *specs_go.Root) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "path":
			out.Path = string(in.String())
		case "readonly":
			out.Readonly = bool(in.Bool())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo3(out *jwriter.Writer, in specs_go.Root) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"path\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Path))
	}
	if in.Readonly {
		const prefix string = ",\"readonly\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.Readonly))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo2(in *jlexer.Lexer, out *specs_go.Process) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "terminal":
			out.Terminal = bool(in.Bool())
		case "consoleSize":
			if in.IsNull() {
				in.Skip()
				out.ConsoleSize = nil
			} else {
				if out.ConsoleSize == nil {
					out.ConsoleSize = new(specs_go.Box)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo42(in, &*out.ConsoleSize)
			}
		case "user":
			easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo43(in, &out.User)
		case "args":
			if in.IsNull() {
				in.Skip()
				out.Args = nil
			} else {
				in.Delim('[')
				if out.Args == nil {
					if !in.IsDelim(']') {
						out.Args = make([]string, 0, 4)
					} else {
						out.Args = []string{}
					}
				} else {
					out.Args = (out.Args)[:0]
				}
				for !in.IsDelim(']') {
					var v183 string
					v183 = string(in.String())
					out.Args = append(out.Args, v183)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "env":
			if in.IsNull() {
				in.Skip()
				out.Env = nil
			} else {
				in.Delim('[')
				if out.Env == nil {
					if !in.IsDelim(']') {
						out.Env = make([]string, 0, 4)
					} else {
						out.Env = []string{}
					}
				} else {
					out.Env = (out.Env)[:0]
				}
				for !in.IsDelim(']') {
					var v184 string
					v184 = string(in.String())
					out.Env = append(out.Env, v184)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "cwd":
			out.Cwd = string(in.String())
		case "capabilities":
			if in.IsNull() {
				in.Skip()
				out.Capabilities = nil
			} else {
				if out.Capabilities == nil {
					out.Capabilities = new(specs_go.LinuxCapabilities)
				}
				easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo44(in, &*out.Capabilities)
			}
		case "rlimits":
			if in.IsNull() {
				in.Skip()
				out.Rlimits = nil
			} else {
				in.Delim('[')
				if out.Rlimits == nil {
					if !in.IsDelim(']') {
						out.Rlimits = make([]specs_go.POSIXRlimit, 0, 2)
					} else {
						out.Rlimits = []specs_go.POSIXRlimit{}
					}
				} else {
					out.Rlimits = (out.Rlimits)[:0]
				}
				for !in.IsDelim(']') {
					var v185 specs_go.POSIXRlimit
					easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo45(in, &v185)
					out.Rlimits = append(out.Rlimits, v185)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "noNewPrivileges":
			out.NoNewPrivileges = bool(in.Bool())
		case "apparmorProfile":
			out.ApparmorProfile = string(in.String())
		case "oomScoreAdj":
			if in.IsNull() {
				in.Skip()
				out.OOMScoreAdj = nil
			} else {
				if out.OOMScoreAdj == nil {
					out.OOMScoreAdj = new(int)
				}
				*out.OOMScoreAdj = int(in.Int())
			}
		case "selinuxLabel":
			out.SelinuxLabel = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo2(out *jwriter.Writer, in specs_go.Process) {
	out.RawByte('{')
	first := true
	_ = first
	if in.Terminal {
		const prefix string = ",\"terminal\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.Terminal))
	}
	if in.ConsoleSize != nil {
		const prefix string = ",\"consoleSize\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo42(out, *in.ConsoleSize)
	}
	{
		const prefix string = ",\"user\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo43(out, in.User)
	}
	{
		const prefix string = ",\"args\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		if in.Args == nil && (out.Flags&jwriter.NilSliceAsEmpty) == 0 {
			out.RawString("null")
		} else {
			out.RawByte('[')
			for v186, v187 := range in.Args {
				if v186 > 0 {
					out.RawByte(',')
				}
				out.String(string(v187))
			}
			out.RawByte(']')
		}
	}
	if len(in.Env) != 0 {
		const prefix string = ",\"env\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v188, v189 := range in.Env {
				if v188 > 0 {
					out.RawByte(',')
				}
				out.String(string(v189))
			}
			out.RawByte(']')
		}
	}
	{
		const prefix string = ",\"cwd\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Cwd))
	}
	if in.Capabilities != nil {
		const prefix string = ",\"capabilities\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo44(out, *in.Capabilities)
	}
	if len(in.Rlimits) != 0 {
		const prefix string = ",\"rlimits\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v190, v191 := range in.Rlimits {
				if v190 > 0 {
					out.RawByte(',')
				}
				easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo45(out, v191)
			}
			out.RawByte(']')
		}
	}
	if in.NoNewPrivileges {
		const prefix string = ",\"noNewPrivileges\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Bool(bool(in.NoNewPrivileges))
	}
	if in.ApparmorProfile != "" {
		const prefix string = ",\"apparmorProfile\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.ApparmorProfile))
	}
	if in.OOMScoreAdj != nil {
		const prefix string = ",\"oomScoreAdj\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Int(int(*in.OOMScoreAdj))
	}
	if in.SelinuxLabel != "" {
		const prefix string = ",\"selinuxLabel\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.SelinuxLabel))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo45(in *jlexer.Lexer, out *specs_go.POSIXRlimit) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "type":
			out.Type = string(in.String())
		case "hard":
			out.Hard = uint64(in.Uint64())
		case "soft":
			out.Soft = uint64(in.Uint64())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo45(out *jwriter.Writer, in specs_go.POSIXRlimit) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"type\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Type))
	}
	{
		const prefix string = ",\"hard\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(in.Hard))
	}
	{
		const prefix string = ",\"soft\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint64(uint64(in.Soft))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo44(in *jlexer.Lexer, out *specs_go.LinuxCapabilities) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "bounding":
			if in.IsNull() {
				in.Skip()
				out.Bounding = nil
			} else {
				in.Delim('[')
				if out.Bounding == nil {
					if !in.IsDelim(']') {
						out.Bounding = make([]string, 0, 4)
					} else {
						out.Bounding = []string{}
					}
				} else {
					out.Bounding = (out.Bounding)[:0]
				}
				for !in.IsDelim(']') {
					var v192 string
					v192 = string(in.String())
					out.Bounding = append(out.Bounding, v192)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "effective":
			if in.IsNull() {
				in.Skip()
				out.Effective = nil
			} else {
				in.Delim('[')
				if out.Effective == nil {
					if !in.IsDelim(']') {
						out.Effective = make([]string, 0, 4)
					} else {
						out.Effective = []string{}
					}
				} else {
					out.Effective = (out.Effective)[:0]
				}
				for !in.IsDelim(']') {
					var v193 string
					v193 = string(in.String())
					out.Effective = append(out.Effective, v193)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "inheritable":
			if in.IsNull() {
				in.Skip()
				out.Inheritable = nil
			} else {
				in.Delim('[')
				if out.Inheritable == nil {
					if !in.IsDelim(']') {
						out.Inheritable = make([]string, 0, 4)
					} else {
						out.Inheritable = []string{}
					}
				} else {
					out.Inheritable = (out.Inheritable)[:0]
				}
				for !in.IsDelim(']') {
					var v194 string
					v194 = string(in.String())
					out.Inheritable = append(out.Inheritable, v194)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "permitted":
			if in.IsNull() {
				in.Skip()
				out.Permitted = nil
			} else {
				in.Delim('[')
				if out.Permitted == nil {
					if !in.IsDelim(']') {
						out.Permitted = make([]string, 0, 4)
					} else {
						out.Permitted = []string{}
					}
				} else {
					out.Permitted = (out.Permitted)[:0]
				}
				for !in.IsDelim(']') {
					var v195 string
					v195 = string(in.String())
					out.Permitted = append(out.Permitted, v195)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "ambient":
			if in.IsNull() {
				in.Skip()
				out.Ambient = nil
			} else {
				in.Delim('[')
				if out.Ambient == nil {
					if !in.IsDelim(']') {
						out.Ambient = make([]string, 0, 4)
					} else {
						out.Ambient = []string{}
					}
				} else {
					out.Ambient = (out.Ambient)[:0]
				}
				for !in.IsDelim(']') {
					var v196 string
					v196 = string(in.String())
					out.Ambient = append(out.Ambient, v196)
					in.WantComma()
				}
				in.Delim(']')
			}
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo44(out *jwriter.Writer, in specs_go.LinuxCapabilities) {
	out.RawByte('{')
	first := true
	_ = first
	if len(in.Bounding) != 0 {
		const prefix string = ",\"bounding\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v197, v198 := range in.Bounding {
				if v197 > 0 {
					out.RawByte(',')
				}
				out.String(string(v198))
			}
			out.RawByte(']')
		}
	}
	if len(in.Effective) != 0 {
		const prefix string = ",\"effective\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v199, v200 := range in.Effective {
				if v199 > 0 {
					out.RawByte(',')
				}
				out.String(string(v200))
			}
			out.RawByte(']')
		}
	}
	if len(in.Inheritable) != 0 {
		const prefix string = ",\"inheritable\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v201, v202 := range in.Inheritable {
				if v201 > 0 {
					out.RawByte(',')
				}
				out.String(string(v202))
			}
			out.RawByte(']')
		}
	}
	if len(in.Permitted) != 0 {
		const prefix string = ",\"permitted\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v203, v204 := range in.Permitted {
				if v203 > 0 {
					out.RawByte(',')
				}
				out.String(string(v204))
			}
			out.RawByte(']')
		}
	}
	if len(in.Ambient) != 0 {
		const prefix string = ",\"ambient\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v205, v206 := range in.Ambient {
				if v205 > 0 {
					out.RawByte(',')
				}
				out.String(string(v206))
			}
			out.RawByte(']')
		}
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo43(in *jlexer.Lexer, out *specs_go.User) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "uid":
			out.UID = uint32(in.Uint32())
		case "gid":
			out.GID = uint32(in.Uint32())
		case "additionalGids":
			if in.IsNull() {
				in.Skip()
				out.AdditionalGids = nil
			} else {
				in.Delim('[')
				if out.AdditionalGids == nil {
					if !in.IsDelim(']') {
						out.AdditionalGids = make([]uint32, 0, 16)
					} else {
						out.AdditionalGids = []uint32{}
					}
				} else {
					out.AdditionalGids = (out.AdditionalGids)[:0]
				}
				for !in.IsDelim(']') {
					var v207 uint32
					v207 = uint32(in.Uint32())
					out.AdditionalGids = append(out.AdditionalGids, v207)
					in.WantComma()
				}
				in.Delim(']')
			}
		case "username":
			out.Username = string(in.String())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo43(out *jwriter.Writer, in specs_go.User) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"uid\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint32(uint32(in.UID))
	}
	{
		const prefix string = ",\"gid\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint32(uint32(in.GID))
	}
	if len(in.AdditionalGids) != 0 {
		const prefix string = ",\"additionalGids\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		{
			out.RawByte('[')
			for v208, v209 := range in.AdditionalGids {
				if v208 > 0 {
					out.RawByte(',')
				}
				out.Uint32(uint32(v209))
			}
			out.RawByte(']')
		}
	}
	if in.Username != "" {
		const prefix string = ",\"username\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.String(string(in.Username))
	}
	out.RawByte('}')
}
func easyjson1dbef17bDecodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo42(in *jlexer.Lexer, out *specs_go.Box) {
	isTopLevel := in.IsStart()
	if in.IsNull() {
		if isTopLevel {
			in.Consumed()
		}
		in.Skip()
		return
	}
	in.Delim('{')
	for !in.IsDelim('}') {
		key := in.UnsafeString()
		in.WantColon()
		if in.IsNull() {
			in.Skip()
			in.WantComma()
			continue
		}
		switch key {
		case "height":
			out.Height = uint(in.Uint())
		case "width":
			out.Width = uint(in.Uint())
		default:
			in.SkipRecursive()
		}
		in.WantComma()
	}
	in.Delim('}')
	if isTopLevel {
		in.Consumed()
	}
}
func easyjson1dbef17bEncodeGithubComContainersLibpodVendorGithubComOpencontainersRuntimeSpecSpecsGo42(out *jwriter.Writer, in specs_go.Box) {
	out.RawByte('{')
	first := true
	_ = first
	{
		const prefix string = ",\"height\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint(uint(in.Height))
	}
	{
		const prefix string = ",\"width\":"
		if first {
			first = false
			out.RawString(prefix[1:])
		} else {
			out.RawString(prefix)
		}
		out.Uint(uint(in.Width))
	}
	out.RawByte('}')
}
