% podman-pod(1)

## NAME
podman\-pod - Simple management tool for groups of containers, called pods.

## SYNOPSIS
**podman pod** *subcommand*

## DESCRIPTION
podman pod is a set of subcommands that manage pods, or groups of containers.

## SUBCOMMANDS

| Command | Man Page                                                 | Description                                                                    |
| ------- | -------------------------------------------------------- | ------------------------------------------------------------------------------ |
| create  | [podman-pod-create(1)](podman-pod-create.1.md)           | Create a new pod.                                                              |
| exists  | [podman-pod-exists(1)](podman-pod-exists.1.md)           | Check if a pod exists in local storage.                                        |
| inspect | [podman-pod-inspect(1)](podman-pod-inspect.1.md)         | Displays information describing a pod.                                         |
| kill    | [podman-pod-kill(1)](podman-pod-kill.1.md)               | Kill the main process of each container in pod.                                |
| pause   | [podman-pod-pause(1)](podman-pod-pause.1.md)             | Pause one or more pods.                                                        |
| prune   | [podman-container-prune(1)](podman-container-prune.1.md) | Remove all stopped containers from local storage.                        |
| ps      | [podman-pod-ps(1)](podman-pod-ps.1.md)                   | Prints out information about pods.                                             |
| restart | [podman-pod-restart(1)](podman-pod-restart.1.md)         | Restart one or more pods.                                                      |
| rm      | [podman-pod-rm(1)](podman-pod-rm.1.md)                   | Remove one or more pods.                                                       |
| start   | [podman-pod-start(1)](podman-pod-start.1.md)             | Start one or more pods.                                                        |
| stats   | [podman-pod-stats(1)](podman-pod-stats.1.md)             | Display live stream resource usage stats for containers in one or more pods.   |
| stop    | [podman-pod-stop(1)](podman-pod-stop.1.md)               | Stop one or more pods.                                                         |
| top     | [podman-pod-top(1)](podman-pod-top.1.md)                 | Display the running processes of containers in a pod.                          |
| unpause | [podman-pod-unpause(1)](podman-pod-unpause.1.md)         | Unpause one or more pods.                                                      |

## SEE ALSO
podman(1)

## HISTORY
July 2018, Originally compiled by Peter Hunt <pehunt@redhat.com>
