#
# Copyright 2014-2016, Intel Corporation
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in
#       the documentation and/or other materials provided with the
#       distribution.
#
#     * Neither the name of the copyright holder nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#
# pmempool_info/TEST14 -- test for info command
#
[CmdletBinding(PositionalBinding=$false)]
Param(
    [alias("d")]
    $DIR = ""
    )
$Env:UNITTEST_NAME = "pmempool_info\TEST14"
$Env:UNITTEST_NUM = "14"


. ..\unittest\unittest.ps1

require_test_type medium

require_fs_type any

setup

$POOL="$DIR\file.pool"
$LOG="out$Env:UNITTEST_NUM.log"
rm $LOG -Force -Recurse -ea si

expect_normal_exit $PMEMPOOL create --layout "pmempool" obj $POOL
expect_abnormal_exit $PMEMALLOC -o 1 -t 1 -ea $POOL
expect_normal_exit $PMEMPOOL info -l -R -a $POOL >> $LOG
echo "" >> $LOG
expect_abnormal_exit $PMEMALLOC -o 1 -t 1 -s -es $POOL
expect_normal_exit $PMEMPOOL info -l -R -Stx $POOL >> $LOG
echo "" >> $LOG
expect_abnormal_exit $PMEMALLOC -o 1024 -t 1 -s -es $POOL
expect_normal_exit $PMEMPOOL info -l -R -Stx $POOL >> $LOG
echo "" >> $LOG
expect_abnormal_exit $PMEMALLOC -o 1 -t 1 -s -f -ef $POOL
expect_normal_exit $PMEMPOOL info -l -R -a -Stx $POOL >> $LOG

check

pass
