/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.bzip2;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.bzip2.CBZip2OutputStream;
import org.codehaus.plexus.archiver.util.Compressor;

public class BZip2Compressor
extends Compressor {
    private CBZip2OutputStream zOut;

    public void compress() throws ArchiverException {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.getDestFile()));
            bos.write(66);
            bos.write(90);
            this.zOut = new CBZip2OutputStream(bos);
            this.compressFile(this.getSourceFile(), this.zOut);
        }
        catch (IOException ioe) {
            String msg = "Problem creating bzip2 " + ioe.getMessage();
            throw new ArchiverException(msg, ioe);
        }
    }

    public void close() {
        if (this.zOut != null) {
            try {
                this.zOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zOut = null;
        }
    }
}

