# Authors:
#     Ade Lee <alee@redhat.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Copyright (C) 2013 Red Hat, Inc.
# All rights reserved.
#

from __future__ import absolute_import
import re
import pki.server.upgrade


class FixJavaOpts(pki.server.upgrade.PKIServerUpgradeScriptlet):

    def __init__(self):
        super(FixJavaOpts, self).__init__()
        self.message = 'Fix JAVA_OPTS in tomcat startup'

    def upgrade_instance(self, instance):
        fname = "/etc/sysconfig/" + instance.name
        with open(fname, "r", encoding='utf-8') as infile:
            lines = infile.readlines()
        with open(fname, "w", encoding='utf-8') as outfile:
            for line in lines:
                outfile.write(re.sub(r'\$JAVA_OPTS *', '', line))
