/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.Date;
import java.util.TimeZone;
import netscape.security.x509.CertificateSerialNumber;
import netscape.security.x509.CertificateSubjectName;
import netscape.security.x509.SerialNumber;
import netscape.security.x509.X509CertImpl;
import netscape.security.x509.X509CertInfo;
import sun.misc.BASE64Decoder;

public class Utilities {
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = " \t\r\n\f";
    private static final String whiteSpaceChars = " \t\r\n\f";

    public String cleanupQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            n2 = 1;
            --n;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"') {
                bl2 = bl;
                bl = true;
            } else {
                bl = false;
                bl2 = false;
            }
            if (bl2) {
                bl2 = false;
                bl = false;
                ++n2;
                continue;
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String removechar(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        if (string.endsWith(";")) {
            --n;
        }
        while (n2 < n) {
            char c = string.charAt(n2);
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String parse_httpresponse(String string) {
        String string2 = string.substring(string.indexOf("=") + 1);
        return this.cleanupQuotes(this.removechar(string2.trim()));
    }

    public String remove_newline(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\' && string.charAt(i + 1) == 'n') {
                ++i;
                continue;
            }
            if (string.charAt(i) == '\\' && string.charAt(i + 1) == 'r') {
                ++i;
                continue;
            }
            if (string.charAt(i) == '\"') continue;
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }

    public String normalize(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\' && string.charAt(i + 1) == 'n') {
                string2 = string2 + '\n';
                ++i;
                continue;
            }
            if (string.charAt(i) == '\\' && string.charAt(i + 1) == 'r') {
                ++i;
                continue;
            }
            if (string.charAt(i) == '\"') continue;
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }

    public String getcertfromfile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            while (dataInputStream.available() != 0) {
                String string2 = dataInputStream.readLine();
                if (string2.equalsIgnoreCase("-----BEGIN CERTIFICATE-----") || string2.equalsIgnoreCase("-----END CERTIFICATE-----")) continue;
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println("ERROR: getcertfromfile" + exception.toString());
            return null;
        }
    }

    public String getcertfromfile_withheaders(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            while (dataInputStream.available() != 0) {
                String string2 = dataInputStream.readLine();
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println("ERROR: getcertfromfile_withheaders" + exception.toString());
            return null;
        }
    }

    public String getcrlfromfile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            while (dataInputStream.available() != 0) {
                String string2 = dataInputStream.readLine();
                string2 = string2 + "\r\n";
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println("ERROR: getcrlfromfile" + exception.toString());
            return null;
        }
    }

    public String getcafromfile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            while (dataInputStream.available() != 0) {
                String string2 = dataInputStream.readLine();
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println("ERROR: getcafromfile" + exception.toString());
            return null;
        }
    }

    public static String escapeBinaryData(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(0xFF & byArray[i]);
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            string = string + "\\" + string2;
        }
        System.out.println("LDAP_FILTER=" + string);
        return string;
    }

    public Certificate_Record decode_cert(String string) {
        String string2 = "-----BEGIN CERTIFICATE-----";
        String string3 = "-----END CERTIFICATE-----";
        Certificate_Record certificate_Record = new Certificate_Record();
        int n = string.indexOf(string2);
        int n2 = string.indexOf(string3);
        if (n == -1 || n2 == -1) {
            return null;
        }
        String string4 = string.substring(n + string2.length(), n2);
        string4 = string4.replaceAll("\\r", "");
        string4 = string4.replaceAll("\\n", "");
        try {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray = bASE64Decoder.decodeBuffer(string4);
            X509CertImpl x509CertImpl = new X509CertImpl(byArray);
            X509CertInfo x509CertInfo = (X509CertInfo)x509CertImpl.get("x509.INFO");
            CertificateSerialNumber certificateSerialNumber = (CertificateSerialNumber)x509CertInfo.get("serialNumber");
            SerialNumber serialNumber = (SerialNumber)certificateSerialNumber.get("NUMBER");
            certificate_Record.serialNumber = serialNumber.getNumber().toString().trim();
            System.out.println("Serial Number =" + serialNumber.getNumber().toString().trim());
            CertificateSubjectName certificateSubjectName = (CertificateSubjectName)x509CertInfo.get("subject");
        }
        catch (Exception exception) {
            System.out.println("ERROR: Exception when decoding certificate=" + exception);
            exception.printStackTrace();
            return null;
        }
        return certificate_Record;
    }

    Date adjustDate(int n) {
        long l = System.currentTimeMillis();
        long l2 = n * 86400000;
        String string = Long.toString(l + l2);
        Date date = new Date(l + l2);
        System.out.println("Current time in milliseconds = " + string + " => " + date.toString());
        System.out.println("Current time zone: " + TimeZone.getDefault().getID());
        return date;
    }
}

