// --- BEGIN COPYRIGHT BLOCK ---
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//
// (C) 2007 Red Hat, Inc.
// All rights reserved.
// --- END COPYRIGHT BLOCK ---
package org.dogtagpki.server.ca;

import org.mozilla.jss.netscape.security.x509.Extension;

import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cmscore.base.ConfigStore;

/**
 * An interface representing a CRL extension plugin.
 * <P>
 *
 * @version $Revision$, $Date$
 */
public abstract class CMSCRLExtension {

    /**
     * Returns CRL extension OID string.
     *
     * @return OID of CRL extension
     */
    public abstract String getCRLExtOID();

    /**
     * Sets extension criticality and returns extension
     * with new criticality.
     *
     * @param ext CRL extension that will change criticality
     * @param critical new criticality to be assigned to CRL extension
     * @return extension with new criticality
     */
    public abstract Extension setCRLExtensionCriticality(Extension ext,
            boolean critical);

    /**
     * Builds new CRL extension based on configuration data,
     * issuing point information, and criticality.
     *
     * @param config configuration store
     * @param crlIssuingPoint CRL issuing point
     * @param critical criticality to be assigned to CRL extension
     * @return extension new CRL extension
     */
    public abstract Extension getCRLExtension(ConfigStore config, Object crlIssuingPoint, boolean critical);

    /**
     * Reads configuration data and converts them to name value pairs.
     *
     * @param config configuration store
     * @param nvp name value pairs obtained from configuration data
     */
    public abstract void getConfigParams(ConfigStore config, NameValuePairs nvp);
}
