# Authors:
#     Endi S. Dewata <edewata@redhat.com>
#
# Copyright Red Hat, Inc.
#
# SPDX-License-Identifier: GPL-2.0-or-later

import logging
import re

import pki

logger = logging.getLogger(__name__)


class RemoveUnusedParams(pki.server.upgrade.PKIServerUpgradeScriptlet):

    def __init__(self):
        super().__init__()
        self.message = 'Remove unused params'

    def upgrade_subsystem(self, instance, subsystem):

        self.backup(subsystem.cs_conf)

        for name in list(subsystem.config.keys()):

            remove = False

            if re.match(r'log\.instance\.System\.', name):
                remove = True

            elif re.match(r'log\.instance\.Transactions\.', name):
                remove = True

            elif re.match(r'os\.', name):
                remove = True

            elif re.match(r'pkicreate\.', name):
                remove = True

            elif re.match(r'pkiremove\.', name):
                remove = True

            elif re.match(r'tokendb\.hostport$', name):
                remove = True

            elif re.match(r'logAudit\.', name):
                remove = True

            elif re.match(r'logError\.', name):
                remove = True

            elif re.match(r'service\.clientauth_securePort$', name):
                remove = True

            elif re.match(r'service\.instanceDir$', name):
                remove = True

            elif re.match(r'service\.instanceID$', name):
                remove = True

            elif re.match(r'service\.machineName$', name):
                remove = True

            elif re.match(r'service\.non_clientauth_securePort$', name):
                remove = True

            elif re.match(r'service\.securePort$', name):
                remove = True

            elif re.match(r'service\.unsecurePort$', name):
                remove = True

            if not remove:
                continue

            logger.info('Removing %s', name)
            subsystem.config.pop(name, None)

        subsystem.save()
