/******************************************************************************
*
*   Copyright (c) 2020 Intel.
*
*   Licensed under the Apache License, Version 2.0 (the "License");
*   you may not use this file except in compliance with the License.
*   You may obtain a copy of the License at
*
*       http://www.apache.org/licenses/LICENSE-2.0
*
*   Unless required by applicable law or agreed to in writing, software
*   distributed under the License is distributed on an "AS IS" BASIS,
*   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*   See the License for the specific language governing permissions and
*   limitations under the License.
*
*******************************************************************************/

#ifndef _ACC100_PF_ENUM_H_
#define _ACC100_PF_ENUM_H_

/*
 * ACC100 Register mapping on PF BAR0
 * This is automatically generated from RDL, format may change with new RDL
 * Release.
 * Variable names are as is
 */
enum {
	HWPfQmgrEgressQueuesTemplate          =  0x0007FE00,
	HWPfQmgrIngressAq                     =  0x00080000,
	HWPfQmgrArbQAvail                     =  0x00A00010,
	HWPfQmgrArbQBlock                     =  0x00A00014,
	HWPfQmgrAqueueDropNotifEn             =  0x00A00024,
	HWPfQmgrAqueueDisableNotifEn          =  0x00A00028,
	HWPfQmgrSoftReset                     =  0x00A00038,
	HWPfQmgrInitStatus                    =  0x00A0003C,
	HWPfQmgrAramWatchdogCount             =  0x00A00040,
	HWPfQmgrAramWatchdogCounterEn         =  0x00A00044,
	HWPfQmgrAxiWatchdogCount              =  0x00A00048,
	HWPfQmgrAxiWatchdogCounterEn          =  0x00A0004C,
	HWPfQmgrProcessWatchdogCount          =  0x00A00050,
	HWPfQmgrProcessWatchdogCounterEn      =  0x00A00054,
	HWPfQmgrProcessUl4GWatchdogCounter    =  0x00A00058,
	HWPfQmgrProcessDl4GWatchdogCounter    =  0x00A0005C,
	HWPfQmgrProcessUl5GWatchdogCounter    =  0x00A00060,
	HWPfQmgrProcessDl5GWatchdogCounter    =  0x00A00064,
	HWPfQmgrProcessMldWatchdogCounter     =  0x00A00068,
	HWPfQmgrMsiOverflowUpperVf            =  0x00A00070,
	HWPfQmgrMsiOverflowLowerVf            =  0x00A00074,
	HWPfQmgrMsiWatchdogOverflow           =  0x00A00078,
	HWPfQmgrMsiOverflowEnable             =  0x00A0007C,
	HWPfQmgrDebugAqPointerMemGrp          =  0x00A00100,
	HWPfQmgrDebugOutputArbQFifoGrp        =  0x00A00140,
	HWPfQmgrDebugMsiFifoGrp               =  0x00A00180,
	HWPfQmgrDebugAxiWdTimeoutMsiFifo      =  0x00A001C0,
	HWPfQmgrDebugProcessWdTimeoutMsiFifo  =  0x00A001C4,
	HWPfQmgrDepthLog2Grp                  =  0x00A00200,
	HWPfQmgrTholdGrp                      =  0x00A00300,
	HWPfQmgrGrpTmplateReg0Indx            =  0x00A00600,
	HWPfQmgrGrpTmplateReg1Indx            =  0x00A00680,
	HWPfQmgrGrpTmplateReg2indx            =  0x00A00700,
	HWPfQmgrGrpTmplateReg3Indx            =  0x00A00780,
	HWPfQmgrGrpTmplateReg4Indx            =  0x00A00800,
	HWPfQmgrVfBaseAddr                    =  0x00A01000,
	HWPfQmgrUl4GWeightRrVf                =  0x00A02000,
	HWPfQmgrDl4GWeightRrVf                =  0x00A02100,
	HWPfQmgrUl5GWeightRrVf                =  0x00A02200,
	HWPfQmgrDl5GWeightRrVf                =  0x00A02300,
	HWPfQmgrMldWeightRrVf                 =  0x00A02400,
	HWPfQmgrArbQDepthGrp                  =  0x00A02F00,
	HWPfQmgrGrpFunction0                  =  0x00A02F40,
	HWPfQmgrGrpFunction1                  =  0x00A02F44,
	HWPfQmgrGrpPriority                   =  0x00A02F48,
	HWPfQmgrWeightSync                    =  0x00A03000,
	HWPfQmgrAqEnableVf                    =  0x00A10000,
	HWPfQmgrAqResetVf                     =  0x00A20000,
	HWPfQmgrRingSizeVf                    =  0x00A20004,
	HWPfQmgrGrpDepthLog20Vf               =  0x00A20008,
	HWPfQmgrGrpDepthLog21Vf               =  0x00A2000C,
	HWPfQmgrGrpFunction0Vf                =  0x00A20010,
	HWPfQmgrGrpFunction1Vf                =  0x00A20014,
	HWPfDmaConfig0Reg                     =  0x00B80000,
	HWPfDmaConfig1Reg                     =  0x00B80004,
	HWPfDmaQmgrAddrReg                    =  0x00B80008,
	HWPfDmaSoftResetReg                   =  0x00B8000C,
	HWPfDmaAxcacheReg                     =  0x00B80010,
	HWPfDmaVersionReg                     =  0x00B80014,
	HWPfDmaFrameThreshold                 =  0x00B80018,
	HWPfDmaTimestampLo                    =  0x00B8001C,
	HWPfDmaTimestampHi                    =  0x00B80020,
	HWPfDmaAxiStatus                      =  0x00B80028,
	HWPfDmaAxiControl                     =  0x00B8002C,
	HWPfDmaNoQmgr                         =  0x00B80030,
	HWPfDmaQosScale                       =  0x00B80034,
	HWPfDmaQmanen                         =  0x00B80040,
	HWPfDmaQmgrQosBase                    =  0x00B80060,
	HWPfDmaFecClkGatingEnable             =  0x00B80080,
	HWPfDmaPmEnable                       =  0x00B80084,
	HWPfDmaQosEnable                      =  0x00B80088,
	HWPfDmaHarqWeightedRrFrameThreshold   =  0x00B800B0,
	HWPfDmaDataSmallWeightedRrFrameThresh  = 0x00B800B4,
	HWPfDmaDataLargeWeightedRrFrameThresh  = 0x00B800B8,
	HWPfDmaInboundCbMaxSize               =  0x00B800BC,
	HWPfDmaInboundDrainDataSize           =  0x00B800C0,
	HWPfDmaVfDdrBaseRw                    =  0x00B80400,
	HWPfDmaCmplTmOutCnt                   =  0x00B80800,
	HWPfDmaProcTmOutCnt                   =  0x00B80804,
	HWPfDmaStatusRrespBresp               =  0x00B80810,
	HWPfDmaCfgRrespBresp                  =  0x00B80814,
	HWPfDmaStatusMemParErr                =  0x00B80818,
	HWPfDmaCfgMemParErrEn                 =  0x00B8081C,
	HWPfDmaStatusDmaHwErr                 =  0x00B80820,
	HWPfDmaCfgDmaHwErrEn                  =  0x00B80824,
	HWPfDmaStatusFecCoreErr               =  0x00B80828,
	HWPfDmaCfgFecCoreErrEn                =  0x00B8082C,
	HWPfDmaStatusFcwDescrErr              =  0x00B80830,
	HWPfDmaCfgFcwDescrErrEn               =  0x00B80834,
	HWPfDmaStatusBlockTransmit            =  0x00B80838,
	HWPfDmaBlockOnErrEn                   =  0x00B8083C,
	HWPfDmaStatusFlushDma                 =  0x00B80840,
	HWPfDmaFlushDmaOnErrEn                =  0x00B80844,
	HWPfDmaStatusSdoneFifoFull            =  0x00B80848,
	HWPfDmaStatusDescriptorErrLoVf        =  0x00B8084C,
	HWPfDmaStatusDescriptorErrHiVf        =  0x00B80850,
	HWPfDmaStatusFcwErrLoVf               =  0x00B80854,
	HWPfDmaStatusFcwErrHiVf               =  0x00B80858,
	HWPfDmaStatusDataErrLoVf              =  0x00B8085C,
	HWPfDmaStatusDataErrHiVf              =  0x00B80860,
	HWPfDmaCfgMsiEnSoftwareErr            =  0x00B80864,
	HWPfDmaDescriptorSignatuture          =  0x00B80868,
	HWPfDmaFcwSignature                   =  0x00B8086C,
	HWPfDmaErrorDetectionEn               =  0x00B80870,
	HWPfDmaErrCntrlFifoDebug              =  0x00B8087C,
	HWPfDmaStatusToutData                 =  0x00B80880,
	HWPfDmaStatusToutDesc                 =  0x00B80884,
	HWPfDmaStatusToutUnexpData            =  0x00B80888,
	HWPfDmaStatusToutUnexpDesc            =  0x00B8088C,
	HWPfDmaStatusToutProcess              =  0x00B80890,
	HWPfDmaConfigCtoutOutDataEn           =  0x00B808A0,
	HWPfDmaConfigCtoutOutDescrEn          =  0x00B808A4,
	HWPfDmaConfigUnexpComplDataEn         =  0x00B808A8,
	HWPfDmaConfigUnexpComplDescrEn        =  0x00B808AC,
	HWPfDmaConfigPtoutOutEn               =  0x00B808B0,
	HWPfDmaFec5GulDescBaseLoRegVf         =  0x00B88020,
	HWPfDmaFec5GulDescBaseHiRegVf         =  0x00B88024,
	HWPfDmaFec5GulRespPtrLoRegVf          =  0x00B88028,
	HWPfDmaFec5GulRespPtrHiRegVf          =  0x00B8802C,
	HWPfDmaFec5GdlDescBaseLoRegVf         =  0x00B88040,
	HWPfDmaFec5GdlDescBaseHiRegVf         =  0x00B88044,
	HWPfDmaFec5GdlRespPtrLoRegVf          =  0x00B88048,
	HWPfDmaFec5GdlRespPtrHiRegVf          =  0x00B8804C,
	HWPfDmaFec4GulDescBaseLoRegVf         =  0x00B88060,
	HWPfDmaFec4GulDescBaseHiRegVf         =  0x00B88064,
	HWPfDmaFec4GulRespPtrLoRegVf          =  0x00B88068,
	HWPfDmaFec4GulRespPtrHiRegVf          =  0x00B8806C,
	HWPfDmaFec4GdlDescBaseLoRegVf         =  0x00B88080,
	HWPfDmaFec4GdlDescBaseHiRegVf         =  0x00B88084,
	HWPfDmaFec4GdlRespPtrLoRegVf          =  0x00B88088,
	HWPfDmaFec4GdlRespPtrHiRegVf          =  0x00B8808C,
	HWPfDmaVfDdrBaseRangeRo               =  0x00B880A0,
	HWPfQosmonACntrlReg                   =  0x00B90000,
	HWPfQosmonAEvalOverflow0              =  0x00B90008,
	HWPfQosmonAEvalOverflow1              =  0x00B9000C,
	HWPfQosmonADivTerm                    =  0x00B90010,
	HWPfQosmonATickTerm                   =  0x00B90014,
	HWPfQosmonAEvalTerm                   =  0x00B90018,
	HWPfQosmonAAveTerm                    =  0x00B9001C,
	HWPfQosmonAForceEccErr                =  0x00B90020,
	HWPfQosmonAEccErrDetect               =  0x00B90024,
	HWPfQosmonAIterationConfig0Low        =  0x00B90060,
	HWPfQosmonAIterationConfig0High       =  0x00B90064,
	HWPfQosmonAIterationConfig1Low        =  0x00B90068,
	HWPfQosmonAIterationConfig1High       =  0x00B9006C,
	HWPfQosmonAIterationConfig2Low        =  0x00B90070,
	HWPfQosmonAIterationConfig2High       =  0x00B90074,
	HWPfQosmonAIterationConfig3Low        =  0x00B90078,
	HWPfQosmonAIterationConfig3High       =  0x00B9007C,
	HWPfQosmonAEvalMemAddr                =  0x00B90080,
	HWPfQosmonAEvalMemData                =  0x00B90084,
	HWPfQosmonAXaction                    =  0x00B900C0,
	HWPfQosmonARemThres1Vf                =  0x00B90400,
	HWPfQosmonAThres2Vf                   =  0x00B90404,
	HWPfQosmonAWeiFracVf                  =  0x00B90408,
	HWPfQosmonARrWeiVf                    =  0x00B9040C,
	HWPfPermonACntrlRegVf                 =  0x00B98000,
	HWPfPermonACountVf                    =  0x00B98008,
	HWPfPermonAKCntLoVf                   =  0x00B98010,
	HWPfPermonAKCntHiVf                   =  0x00B98014,
	HWPfPermonADeltaCntLoVf               =  0x00B98020,
	HWPfPermonADeltaCntHiVf               =  0x00B98024,
	HWPfPermonAVersionReg                 =  0x00B9C000,
	HWPfPermonACbControlFec               =  0x00B9C0F0,
	HWPfPermonADltTimerLoFec              =  0x00B9C0F4,
	HWPfPermonADltTimerHiFec              =  0x00B9C0F8,
	HWPfPermonACbCountFec                 =  0x00B9C100,
	HWPfPermonAAccExecTimerLoFec          =  0x00B9C104,
	HWPfPermonAAccExecTimerHiFec          =  0x00B9C108,
	HWPfPermonAExecTimerMinFec            =  0x00B9C200,
	HWPfPermonAExecTimerMaxFec            =  0x00B9C204,
	HWPfPermonAControlBusMon              =  0x00B9C400,
	HWPfPermonAConfigBusMon               =  0x00B9C404,
	HWPfPermonASkipCountBusMon            =  0x00B9C408,
	HWPfPermonAMinLatBusMon               =  0x00B9C40C,
	HWPfPermonAMaxLatBusMon               =  0x00B9C500,
	HWPfPermonATotalLatLowBusMon          =  0x00B9C504,
	HWPfPermonATotalLatUpperBusMon        =  0x00B9C508,
	HWPfPermonATotalReqCntBusMon          =  0x00B9C50C,
	HWPfQosmonBCntrlReg                   =  0x00BA0000,
	HWPfQosmonBEvalOverflow0              =  0x00BA0008,
	HWPfQosmonBEvalOverflow1              =  0x00BA000C,
	HWPfQosmonBDivTerm                    =  0x00BA0010,
	HWPfQosmonBTickTerm                   =  0x00BA0014,
	HWPfQosmonBEvalTerm                   =  0x00BA0018,
	HWPfQosmonBAveTerm                    =  0x00BA001C,
	HWPfQosmonBForceEccErr                =  0x00BA0020,
	HWPfQosmonBEccErrDetect               =  0x00BA0024,
	HWPfQosmonBIterationConfig0Low        =  0x00BA0060,
	HWPfQosmonBIterationConfig0High       =  0x00BA0064,
	HWPfQosmonBIterationConfig1Low        =  0x00BA0068,
	HWPfQosmonBIterationConfig1High       =  0x00BA006C,
	HWPfQosmonBIterationConfig2Low        =  0x00BA0070,
	HWPfQosmonBIterationConfig2High       =  0x00BA0074,
	HWPfQosmonBIterationConfig3Low        =  0x00BA0078,
	HWPfQosmonBIterationConfig3High       =  0x00BA007C,
	HWPfQosmonBEvalMemAddr                =  0x00BA0080,
	HWPfQosmonBEvalMemData                =  0x00BA0084,
	HWPfQosmonBXaction                    =  0x00BA00C0,
	HWPfQosmonBRemThres1Vf                =  0x00BA0400,
	HWPfQosmonBThres2Vf                   =  0x00BA0404,
	HWPfQosmonBWeiFracVf                  =  0x00BA0408,
	HWPfQosmonBRrWeiVf                    =  0x00BA040C,
	HWPfPermonBCntrlRegVf                 =  0x00BA8000,
	HWPfPermonBCountVf                    =  0x00BA8008,
	HWPfPermonBKCntLoVf                   =  0x00BA8010,
	HWPfPermonBKCntHiVf                   =  0x00BA8014,
	HWPfPermonBDeltaCntLoVf               =  0x00BA8020,
	HWPfPermonBDeltaCntHiVf               =  0x00BA8024,
	HWPfPermonBVersionReg                 =  0x00BAC000,
	HWPfPermonBCbControlFec               =  0x00BAC0F0,
	HWPfPermonBDltTimerLoFec              =  0x00BAC0F4,
	HWPfPermonBDltTimerHiFec              =  0x00BAC0F8,
	HWPfPermonBCbCountFec                 =  0x00BAC100,
	HWPfPermonBAccExecTimerLoFec          =  0x00BAC104,
	HWPfPermonBAccExecTimerHiFec          =  0x00BAC108,
	HWPfPermonBExecTimerMinFec            =  0x00BAC200,
	HWPfPermonBExecTimerMaxFec            =  0x00BAC204,
	HWPfPermonBControlBusMon              =  0x00BAC400,
	HWPfPermonBConfigBusMon               =  0x00BAC404,
	HWPfPermonBSkipCountBusMon            =  0x00BAC408,
	HWPfPermonBMinLatBusMon               =  0x00BAC40C,
	HWPfPermonBMaxLatBusMon               =  0x00BAC500,
	HWPfPermonBTotalLatLowBusMon          =  0x00BAC504,
	HWPfPermonBTotalLatUpperBusMon        =  0x00BAC508,
	HWPfPermonBTotalReqCntBusMon          =  0x00BAC50C,
	HWPfFabricMode                        =  0x00BB1000,
	HWPfFecUl5gCntrlReg                   =  0x00BC0000,
	HWPfFecUl5gI2MThreshReg               =  0x00BC0004,
	HWPfFecUl5gVersionReg                 =  0x00BC0100,
	HWPfFecUl5gFcwStatusReg               =  0x00BC0104,
	HWPfFecUl5gWarnReg                    =  0x00BC0108,
	HwPfFecUl5gIbDebugReg                 =  0x00BC0200,
	HwPfFecUl5gObLlrDebugReg              =  0x00BC0204,
	HwPfFecUl5gObHarqDebugReg             =  0x00BC0208,
	HwPfFecUl5g1CntrlReg                  =  0x00BC1000,
	HwPfFecUl5g1I2MThreshReg              =  0x00BC1004,
	HwPfFecUl5g1VersionReg                =  0x00BC1100,
	HwPfFecUl5g1FcwStatusReg              =  0x00BC1104,
	HwPfFecUl5g1WarnReg                   =  0x00BC1108,
	HwPfFecUl5g1IbDebugReg                =  0x00BC1200,
	HwPfFecUl5g1ObLlrDebugReg             =  0x00BC1204,
	HwPfFecUl5g1ObHarqDebugReg            =  0x00BC1208,
	HwPfFecUl5g2CntrlReg                  =  0x00BC2000,
	HwPfFecUl5g2I2MThreshReg              =  0x00BC2004,
	HwPfFecUl5g2VersionReg                =  0x00BC2100,
	HwPfFecUl5g2FcwStatusReg              =  0x00BC2104,
	HwPfFecUl5g2WarnReg                   =  0x00BC2108,
	HwPfFecUl5g2IbDebugReg                =  0x00BC2200,
	HwPfFecUl5g2ObLlrDebugReg             =  0x00BC2204,
	HwPfFecUl5g2ObHarqDebugReg            =  0x00BC2208,
	HwPfFecUl5g3CntrlReg                  =  0x00BC3000,
	HwPfFecUl5g3I2MThreshReg              =  0x00BC3004,
	HwPfFecUl5g3VersionReg                =  0x00BC3100,
	HwPfFecUl5g3FcwStatusReg              =  0x00BC3104,
	HwPfFecUl5g3WarnReg                   =  0x00BC3108,
	HwPfFecUl5g3IbDebugReg                =  0x00BC3200,
	HwPfFecUl5g3ObLlrDebugReg             =  0x00BC3204,
	HwPfFecUl5g3ObHarqDebugReg            =  0x00BC3208,
	HwPfFecUl5g4CntrlReg                  =  0x00BC4000,
	HwPfFecUl5g4I2MThreshReg              =  0x00BC4004,
	HwPfFecUl5g4VersionReg                =  0x00BC4100,
	HwPfFecUl5g4FcwStatusReg              =  0x00BC4104,
	HwPfFecUl5g4WarnReg                   =  0x00BC4108,
	HwPfFecUl5g4IbDebugReg                =  0x00BC4200,
	HwPfFecUl5g4ObLlrDebugReg             =  0x00BC4204,
	HwPfFecUl5g4ObHarqDebugReg            =  0x00BC4208,
	HwPfFecUl5g5CntrlReg                  =  0x00BC5000,
	HwPfFecUl5g5I2MThreshReg              =  0x00BC5004,
	HwPfFecUl5g5VersionReg                =  0x00BC5100,
	HwPfFecUl5g5FcwStatusReg              =  0x00BC5104,
	HwPfFecUl5g5WarnReg                   =  0x00BC5108,
	HwPfFecUl5g5IbDebugReg                =  0x00BC5200,
	HwPfFecUl5g5ObLlrDebugReg             =  0x00BC5204,
	HwPfFecUl5g5ObHarqDebugReg            =  0x00BC5208,
	HwPfFecUl5g6CntrlReg                  =  0x00BC6000,
	HwPfFecUl5g6I2MThreshReg              =  0x00BC6004,
	HwPfFecUl5g6VersionReg                =  0x00BC6100,
	HwPfFecUl5g6FcwStatusReg              =  0x00BC6104,
	HwPfFecUl5g6WarnReg                   =  0x00BC6108,
	HwPfFecUl5g6IbDebugReg                =  0x00BC6200,
	HwPfFecUl5g6ObLlrDebugReg             =  0x00BC6204,
	HwPfFecUl5g6ObHarqDebugReg            =  0x00BC6208,
	HwPfFecUl5g7CntrlReg                  =  0x00BC7000,
	HwPfFecUl5g7I2MThreshReg              =  0x00BC7004,
	HwPfFecUl5g7VersionReg                =  0x00BC7100,
	HwPfFecUl5g7FcwStatusReg              =  0x00BC7104,
	HwPfFecUl5g7WarnReg                   =  0x00BC7108,
	HwPfFecUl5g7IbDebugReg                =  0x00BC7200,
	HwPfFecUl5g7ObLlrDebugReg             =  0x00BC7204,
	HwPfFecUl5g7ObHarqDebugReg            =  0x00BC7208,
	HwPfFecUl5g8CntrlReg                  =  0x00BC8000,
	HwPfFecUl5g8I2MThreshReg              =  0x00BC8004,
	HwPfFecUl5g8VersionReg                =  0x00BC8100,
	HwPfFecUl5g8FcwStatusReg              =  0x00BC8104,
	HwPfFecUl5g8WarnReg                   =  0x00BC8108,
	HwPfFecUl5g8IbDebugReg                =  0x00BC8200,
	HwPfFecUl5g8ObLlrDebugReg             =  0x00BC8204,
	HwPfFecUl5g8ObHarqDebugReg            =  0x00BC8208,
	HWPfFecDl5gCntrlReg                   =  0x00BCF000,
	HWPfFecDl5gI2MThreshReg               =  0x00BCF004,
	HWPfFecDl5gVersionReg                 =  0x00BCF100,
	HWPfFecDl5gFcwStatusReg               =  0x00BCF104,
	HWPfFecDl5gWarnReg                    =  0x00BCF108,
	HWPfFecUlVersionReg                   =  0x00BD0000,
	HWPfFecUlControlReg                   =  0x00BD0004,
	HWPfFecUlStatusReg                    =  0x00BD0008,
	HWPfFecDlVersionReg                   =  0x00BDF000,
	HWPfFecDlClusterConfigReg             =  0x00BDF004,
	HWPfFecDlBurstThres                   =  0x00BDF00C,
	HWPfFecDlClusterStatusReg0            =  0x00BDF040,
	HWPfFecDlClusterStatusReg1            =  0x00BDF044,
	HWPfFecDlClusterStatusReg2            =  0x00BDF048,
	HWPfFecDlClusterStatusReg3            =  0x00BDF04C,
	HWPfFecDlClusterStatusReg4            =  0x00BDF050,
	HWPfFecDlClusterStatusReg5            =  0x00BDF054,
	HWPfChaFabPllPllrst                   =  0x00C40000,
	HWPfChaFabPllClk0                     =  0x00C40004,
	HWPfChaFabPllClk1                     =  0x00C40008,
	HWPfChaFabPllBwadj                    =  0x00C4000C,
	HWPfChaFabPllLbw                      =  0x00C40010,
	HWPfChaFabPllResetq                   =  0x00C40014,
	HWPfChaFabPllPhshft0                  =  0x00C40018,
	HWPfChaFabPllPhshft1                  =  0x00C4001C,
	HWPfChaFabPllDivq0                    =  0x00C40020,
	HWPfChaFabPllDivq1                    =  0x00C40024,
	HWPfChaFabPllDivq2                    =  0x00C40028,
	HWPfChaFabPllDivq3                    =  0x00C4002C,
	HWPfChaFabPllDivq4                    =  0x00C40030,
	HWPfChaFabPllDivq5                    =  0x00C40034,
	HWPfChaFabPllDivq6                    =  0x00C40038,
	HWPfChaFabPllDivq7                    =  0x00C4003C,
	HWPfChaDl5gPllPllrst                  =  0x00C40080,
	HWPfChaDl5gPllClk0                    =  0x00C40084,
	HWPfChaDl5gPllClk1                    =  0x00C40088,
	HWPfChaDl5gPllBwadj                   =  0x00C4008C,
	HWPfChaDl5gPllLbw                     =  0x00C40090,
	HWPfChaDl5gPllResetq                  =  0x00C40094,
	HWPfChaDl5gPllPhshft0                 =  0x00C40098,
	HWPfChaDl5gPllPhshft1                 =  0x00C4009C,
	HWPfChaDl5gPllDivq0                   =  0x00C400A0,
	HWPfChaDl5gPllDivq1                   =  0x00C400A4,
	HWPfChaDl5gPllDivq2                   =  0x00C400A8,
	HWPfChaDl5gPllDivq3                   =  0x00C400AC,
	HWPfChaDl5gPllDivq4                   =  0x00C400B0,
	HWPfChaDl5gPllDivq5                   =  0x00C400B4,
	HWPfChaDl5gPllDivq6                   =  0x00C400B8,
	HWPfChaDl5gPllDivq7                   =  0x00C400BC,
	HWPfChaDl4gPllPllrst                  =  0x00C40100,
	HWPfChaDl4gPllClk0                    =  0x00C40104,
	HWPfChaDl4gPllClk1                    =  0x00C40108,
	HWPfChaDl4gPllBwadj                   =  0x00C4010C,
	HWPfChaDl4gPllLbw                     =  0x00C40110,
	HWPfChaDl4gPllResetq                  =  0x00C40114,
	HWPfChaDl4gPllPhshft0                 =  0x00C40118,
	HWPfChaDl4gPllPhshft1                 =  0x00C4011C,
	HWPfChaDl4gPllDivq0                   =  0x00C40120,
	HWPfChaDl4gPllDivq1                   =  0x00C40124,
	HWPfChaDl4gPllDivq2                   =  0x00C40128,
	HWPfChaDl4gPllDivq3                   =  0x00C4012C,
	HWPfChaDl4gPllDivq4                   =  0x00C40130,
	HWPfChaDl4gPllDivq5                   =  0x00C40134,
	HWPfChaDl4gPllDivq6                   =  0x00C40138,
	HWPfChaDl4gPllDivq7                   =  0x00C4013C,
	HWPfChaUl5gPllPllrst                  =  0x00C40180,
	HWPfChaUl5gPllClk0                    =  0x00C40184,
	HWPfChaUl5gPllClk1                    =  0x00C40188,
	HWPfChaUl5gPllBwadj                   =  0x00C4018C,
	HWPfChaUl5gPllLbw                     =  0x00C40190,
	HWPfChaUl5gPllResetq                  =  0x00C40194,
	HWPfChaUl5gPllPhshft0                 =  0x00C40198,
	HWPfChaUl5gPllPhshft1                 =  0x00C4019C,
	HWPfChaUl5gPllDivq0                   =  0x00C401A0,
	HWPfChaUl5gPllDivq1                   =  0x00C401A4,
	HWPfChaUl5gPllDivq2                   =  0x00C401A8,
	HWPfChaUl5gPllDivq3                   =  0x00C401AC,
	HWPfChaUl5gPllDivq4                   =  0x00C401B0,
	HWPfChaUl5gPllDivq5                   =  0x00C401B4,
	HWPfChaUl5gPllDivq6                   =  0x00C401B8,
	HWPfChaUl5gPllDivq7                   =  0x00C401BC,
	HWPfChaUl4gPllPllrst                  =  0x00C40200,
	HWPfChaUl4gPllClk0                    =  0x00C40204,
	HWPfChaUl4gPllClk1                    =  0x00C40208,
	HWPfChaUl4gPllBwadj                   =  0x00C4020C,
	HWPfChaUl4gPllLbw                     =  0x00C40210,
	HWPfChaUl4gPllResetq                  =  0x00C40214,
	HWPfChaUl4gPllPhshft0                 =  0x00C40218,
	HWPfChaUl4gPllPhshft1                 =  0x00C4021C,
	HWPfChaUl4gPllDivq0                   =  0x00C40220,
	HWPfChaUl4gPllDivq1                   =  0x00C40224,
	HWPfChaUl4gPllDivq2                   =  0x00C40228,
	HWPfChaUl4gPllDivq3                   =  0x00C4022C,
	HWPfChaUl4gPllDivq4                   =  0x00C40230,
	HWPfChaUl4gPllDivq5                   =  0x00C40234,
	HWPfChaUl4gPllDivq6                   =  0x00C40238,
	HWPfChaUl4gPllDivq7                   =  0x00C4023C,
	HWPfChaDdrPllPllrst                   =  0x00C40280,
	HWPfChaDdrPllClk0                     =  0x00C40284,
	HWPfChaDdrPllClk1                     =  0x00C40288,
	HWPfChaDdrPllBwadj                    =  0x00C4028C,
	HWPfChaDdrPllLbw                      =  0x00C40290,
	HWPfChaDdrPllResetq                   =  0x00C40294,
	HWPfChaDdrPllPhshft0                  =  0x00C40298,
	HWPfChaDdrPllPhshft1                  =  0x00C4029C,
	HWPfChaDdrPllDivq0                    =  0x00C402A0,
	HWPfChaDdrPllDivq1                    =  0x00C402A4,
	HWPfChaDdrPllDivq2                    =  0x00C402A8,
	HWPfChaDdrPllDivq3                    =  0x00C402AC,
	HWPfChaDdrPllDivq4                    =  0x00C402B0,
	HWPfChaDdrPllDivq5                    =  0x00C402B4,
	HWPfChaDdrPllDivq6                    =  0x00C402B8,
	HWPfChaDdrPllDivq7                    =  0x00C402BC,
	HWPfChaErrStatus                      =  0x00C40400,
	HWPfChaErrMask                        =  0x00C40404,
	HWPfChaDebugPcieMsiFifo               =  0x00C40410,
	HWPfChaDebugDdrMsiFifo                =  0x00C40414,
	HWPfChaDebugMiscMsiFifo               =  0x00C40418,
	HWPfChaPwmSet                         =  0x00C40420,
	HWPfChaDdrRstStatus                   =  0x00C40430,
	HWPfChaDdrStDoneStatus                =  0x00C40434,
	HWPfChaDdrWbRstCfg                    =  0x00C40438,
	HWPfChaDdrApbRstCfg                   =  0x00C4043C,
	HWPfChaDdrPhyRstCfg                   =  0x00C40440,
	HWPfChaDdrCpuRstCfg                   =  0x00C40444,
	HWPfChaDdrSifRstCfg                   =  0x00C40448,
	HWPfChaPadcfgPcomp0                   =  0x00C41000,
	HWPfChaPadcfgNcomp0                   =  0x00C41004,
	HWPfChaPadcfgOdt0                     =  0x00C41008,
	HWPfChaPadcfgProtect0                 =  0x00C4100C,
	HWPfChaPreemphasisProtect0            =  0x00C41010,
	HWPfChaPreemphasisCompen0             =  0x00C41040,
	HWPfChaPreemphasisOdten0              =  0x00C41044,
	HWPfChaPadcfgPcomp1                   =  0x00C41100,
	HWPfChaPadcfgNcomp1                   =  0x00C41104,
	HWPfChaPadcfgOdt1                     =  0x00C41108,
	HWPfChaPadcfgProtect1                 =  0x00C4110C,
	HWPfChaPreemphasisProtect1            =  0x00C41110,
	HWPfChaPreemphasisCompen1             =  0x00C41140,
	HWPfChaPreemphasisOdten1              =  0x00C41144,
	HWPfChaPadcfgPcomp2                   =  0x00C41200,
	HWPfChaPadcfgNcomp2                   =  0x00C41204,
	HWPfChaPadcfgOdt2                     =  0x00C41208,
	HWPfChaPadcfgProtect2                 =  0x00C4120C,
	HWPfChaPreemphasisProtect2            =  0x00C41210,
	HWPfChaPreemphasisCompen2             =  0x00C41240,
	HWPfChaPreemphasisOdten4              =  0x00C41444,
	HWPfChaPreemphasisOdten2              =  0x00C41244,
	HWPfChaPadcfgPcomp3                   =  0x00C41300,
	HWPfChaPadcfgNcomp3                   =  0x00C41304,
	HWPfChaPadcfgOdt3                     =  0x00C41308,
	HWPfChaPadcfgProtect3                 =  0x00C4130C,
	HWPfChaPreemphasisProtect3            =  0x00C41310,
	HWPfChaPreemphasisCompen3             =  0x00C41340,
	HWPfChaPreemphasisOdten3              =  0x00C41344,
	HWPfChaPadcfgPcomp4                   =  0x00C41400,
	HWPfChaPadcfgNcomp4                   =  0x00C41404,
	HWPfChaPadcfgOdt4                     =  0x00C41408,
	HWPfChaPadcfgProtect4                 =  0x00C4140C,
	HWPfChaPreemphasisProtect4            =  0x00C41410,
	HWPfChaPreemphasisCompen4             =  0x00C41440,
	HWPfHiVfToPfDbellVf                   =  0x00C80000,
	HWPfHiPfToVfDbellVf                   =  0x00C80008,
	HWPfHiInfoRingBaseLoVf                =  0x00C80010,
	HWPfHiInfoRingBaseHiVf                =  0x00C80014,
	HWPfHiInfoRingPointerVf               =  0x00C80018,
	HWPfHiInfoRingIntWrEnVf               =  0x00C80020,
	HWPfHiInfoRingPf2VfWrEnVf             =  0x00C80024,
	HWPfHiMsixVectorMapperVf              =  0x00C80060,
	HWPfHiModuleVersionReg                =  0x00C84000,
	HWPfHiIosf2axiErrLogReg               =  0x00C84004,
	HWPfHiHardResetReg                    =  0x00C84008,
	HWPfHi5GHardResetReg                  =  0x00C8400C,
	HWPfHiInfoRingBaseLoRegPf             =  0x00C84010,
	HWPfHiInfoRingBaseHiRegPf             =  0x00C84014,
	HWPfHiInfoRingPointerRegPf            =  0x00C84018,
	HWPfHiInfoRingIntWrEnRegPf            =  0x00C84020,
	HWPfHiInfoRingVf2pfLoWrEnReg          =  0x00C84024,
	HWPfHiInfoRingVf2pfHiWrEnReg          =  0x00C84028,
	HWPfHiLogParityErrStatusReg           =  0x00C8402C,
	HWPfHiLogDataParityErrorVfStatusLo    =  0x00C84030,
	HWPfHiLogDataParityErrorVfStatusHi    =  0x00C84034,
	HWPfHiBlockTransmitOnErrorEn          =  0x00C84038,
	HWPfHiCfgMsiIntWrEnRegPf              =  0x00C84040,
	HWPfHiCfgMsiVf2pfLoWrEnReg            =  0x00C84044,
	HWPfHiCfgMsiVf2pfHighWrEnReg          =  0x00C84048,
	HWPfHiMsixVectorMapperPf              =  0x00C84060,
	HWPfHiApbWrWaitTime                   =  0x00C84100,
	HWPfHiXCounterMaxValue                =  0x00C84104,
	HWPfHiPfMode                          =  0x00C84108,
	HWPfHiClkGateHystReg                  =  0x00C8410C,
	HWPfHiSnoopBitsReg                    =  0x00C84110,
	HWPfHiMsiDropEnableReg                =  0x00C84114,
	HWPfHiMsiStatReg                      =  0x00C84120,
	HWPfHiFifoOflStatReg                  =  0x00C84124,
	HWPfHiHiDebugReg                      =  0x00C841F4,
	HWPfHiDebugMemSnoopMsiFifo            =  0x00C841F8,
	HWPfHiDebugMemSnoopInputFifo          =  0x00C841FC,
	HWPfHiMsixMappingConfig               =  0x00C84200,
	HWPfHiJunkReg                         =  0x00C8FF00,
	HWPfDdrUmmcVer                        =  0x00D00000,
	HWPfDdrUmmcCap                        =  0x00D00010,
	HWPfDdrUmmcCtrl                       =  0x00D00020,
	HWPfDdrMpcPe                          =  0x00D00080,
	HWPfDdrMpcPpri3                       =  0x00D00090,
	HWPfDdrMpcPpri2                       =  0x00D000A0,
	HWPfDdrMpcPpri1                       =  0x00D000B0,
	HWPfDdrMpcPpri0                       =  0x00D000C0,
	HWPfDdrMpcPrwgrpCtrl                  =  0x00D000D0,
	HWPfDdrMpcPbw7                        =  0x00D000E0,
	HWPfDdrMpcPbw6                        =  0x00D000F0,
	HWPfDdrMpcPbw5                        =  0x00D00100,
	HWPfDdrMpcPbw4                        =  0x00D00110,
	HWPfDdrMpcPbw3                        =  0x00D00120,
	HWPfDdrMpcPbw2                        =  0x00D00130,
	HWPfDdrMpcPbw1                        =  0x00D00140,
	HWPfDdrMpcPbw0                        =  0x00D00150,
	HWPfDdrMemoryInit                     =  0x00D00200,
	HWPfDdrMemoryInitDone                 =  0x00D00210,
	HWPfDdrMemInitPhyTrng0                =  0x00D00240,
	HWPfDdrMemInitPhyTrng1                =  0x00D00250,
	HWPfDdrMemInitPhyTrng2                =  0x00D00260,
	HWPfDdrMemInitPhyTrng3                =  0x00D00270,
	HWPfDdrBcDram                         =  0x00D003C0,
	HWPfDdrBcAddrMap                      =  0x00D003D0,
	HWPfDdrBcRef                          =  0x00D003E0,
	HWPfDdrBcTim0                         =  0x00D00400,
	HWPfDdrBcTim1                         =  0x00D00410,
	HWPfDdrBcTim2                         =  0x00D00420,
	HWPfDdrBcTim3                         =  0x00D00430,
	HWPfDdrBcTim4                         =  0x00D00440,
	HWPfDdrBcTim5                         =  0x00D00450,
	HWPfDdrBcTim6                         =  0x00D00460,
	HWPfDdrBcTim7                         =  0x00D00470,
	HWPfDdrBcTim8                         =  0x00D00480,
	HWPfDdrBcTim9                         =  0x00D00490,
	HWPfDdrBcTim10                        =  0x00D004A0,
	HWPfDdrBcTim12                        =  0x00D004C0,
	HWPfDdrDfiInit                        =  0x00D004D0,
	HWPfDdrDfiInitComplete                =  0x00D004E0,
	HWPfDdrDfiTim0                        =  0x00D004F0,
	HWPfDdrDfiTim1                        =  0x00D00500,
	HWPfDdrDfiPhyUpdEn                    =  0x00D00530,
	HWPfDdrMemStatus                      =  0x00D00540,
	HWPfDdrUmmcErrStatus                  =  0x00D00550,
	HWPfDdrUmmcIntStatus                  =  0x00D00560,
	HWPfDdrUmmcIntEn                      =  0x00D00570,
	HWPfDdrPhyRdLatency                   =  0x00D48400,
	HWPfDdrPhyRdLatencyDbi                =  0x00D48410,
	HWPfDdrPhyWrLatency                   =  0x00D48420,
	HWPfDdrPhyTrngType                    =  0x00D48430,
	HWPfDdrPhyMrsTiming2                  =  0x00D48440,
	HWPfDdrPhyMrsTiming0                  =  0x00D48450,
	HWPfDdrPhyMrsTiming1                  =  0x00D48460,
	HWPfDdrPhyDramTmrd                    =  0x00D48470,
	HWPfDdrPhyDramTmod                    =  0x00D48480,
	HWPfDdrPhyDramTwpre                   =  0x00D48490,
	HWPfDdrPhyDramTrfc                    =  0x00D484A0,
	HWPfDdrPhyDramTrwtp                   =  0x00D484B0,
	HWPfDdrPhyMr01Dimm                    =  0x00D484C0,
	HWPfDdrPhyMr01DimmDbi                 =  0x00D484D0,
	HWPfDdrPhyMr23Dimm                    =  0x00D484E0,
	HWPfDdrPhyMr45Dimm                    =  0x00D484F0,
	HWPfDdrPhyMr67Dimm                    =  0x00D48500,
	HWPfDdrPhyWrlvlWwRdlvlRr              =  0x00D48510,
	HWPfDdrPhyOdtEn                       =  0x00D48520,
	HWPfDdrPhyFastTrng                    =  0x00D48530,
	HWPfDdrPhyDynTrngGap                  =  0x00D48540,
	HWPfDdrPhyDynRcalGap                  =  0x00D48550,
	HWPfDdrPhyIdletimeout                 =  0x00D48560,
	HWPfDdrPhyRstCkeGap                   =  0x00D48570,
	HWPfDdrPhyCkeMrsGap                   =  0x00D48580,
	HWPfDdrPhyMemVrefMidVal               =  0x00D48590,
	HWPfDdrPhyVrefStep                    =  0x00D485A0,
	HWPfDdrPhyVrefThreshold               =  0x00D485B0,
	HWPfDdrPhyPhyVrefMidVal               =  0x00D485C0,
	HWPfDdrPhyDqsCountMax                 =  0x00D485D0,
	HWPfDdrPhyDqsCountNum                 =  0x00D485E0,
	HWPfDdrPhyDramRow                     =  0x00D485F0,
	HWPfDdrPhyDramCol                     =  0x00D48600,
	HWPfDdrPhyDramBgBa                    =  0x00D48610,
	HWPfDdrPhyDynamicUpdreqrel            =  0x00D48620,
	HWPfDdrPhyVrefLimits                  =  0x00D48630,
	HWPfDdrPhyIdtmTcStatus                =  0x00D6C020,
	HWPfDdrPhyIdtmFwVersion               =  0x00D6C410,
	HWPfDdrPhyRdlvlGateInitDelay          =  0x00D70000,
	HWPfDdrPhyRdenSmplabc                 =  0x00D70008,
	HWPfDdrPhyVrefNibble0                 =  0x00D7000C,
	HWPfDdrPhyVrefNibble1                 =  0x00D70010,
	HWPfDdrPhyRdlvlGateDqsSmpl0           =  0x00D70014,
	HWPfDdrPhyRdlvlGateDqsSmpl1           =  0x00D70018,
	HWPfDdrPhyRdlvlGateDqsSmpl2           =  0x00D7001C,
	HWPfDdrPhyDqsCount                    =  0x00D70020,
	HWPfDdrPhyWrlvlRdlvlGateStatus        =  0x00D70024,
	HWPfDdrPhyErrorFlags                  =  0x00D70028,
	HWPfDdrPhyPowerDown                   =  0x00D70030,
	HWPfDdrPhyPrbsSeedByte0               =  0x00D70034,
	HWPfDdrPhyPrbsSeedByte1               =  0x00D70038,
	HWPfDdrPhyPcompDq                     =  0x00D70040,
	HWPfDdrPhyNcompDq                     =  0x00D70044,
	HWPfDdrPhyPcompDqs                    =  0x00D70048,
	HWPfDdrPhyNcompDqs                    =  0x00D7004C,
	HWPfDdrPhyPcompCmd                    =  0x00D70050,
	HWPfDdrPhyNcompCmd                    =  0x00D70054,
	HWPfDdrPhyPcompCk                     =  0x00D70058,
	HWPfDdrPhyNcompCk                     =  0x00D7005C,
	HWPfDdrPhyRcalOdtDq                   =  0x00D70060,
	HWPfDdrPhyRcalOdtDqs                  =  0x00D70064,
	HWPfDdrPhyRcalMask1                   =  0x00D70068,
	HWPfDdrPhyRcalMask2                   =  0x00D7006C,
	HWPfDdrPhyRcalCtrl                    =  0x00D70070,
	HWPfDdrPhyRcalCnt                     =  0x00D70074,
	HWPfDdrPhyRcalOverride                =  0x00D70078,
	HWPfDdrPhyRcalGateen                  =  0x00D7007C,
	HWPfDdrPhyCtrl                        =  0x00D70080,
	HWPfDdrPhyWrlvlAlg                    =  0x00D70084,
	HWPfDdrPhyRcalVreftTxcmdOdt           =  0x00D70088,
	HWPfDdrPhyRdlvlGateParam              =  0x00D7008C,
	HWPfDdrPhyRdlvlGateParam2             =  0x00D70090,
	HWPfDdrPhyRcalVreftTxdata             =  0x00D70094,
	HWPfDdrPhyCmdIntDelay                 =  0x00D700A4,
	HWPfDdrPhyAlertN                      =  0x00D700A8,
	HWPfDdrPhyTrngReqWpre2tck             =  0x00D700AC,
	HWPfDdrPhyCmdPhaseSel                 =  0x00D700B4,
	HWPfDdrPhyCmdDcdl                     =  0x00D700B8,
	HWPfDdrPhyCkDcdl                      =  0x00D700BC,
	HWPfDdrPhySwTrngCtrl1                 =  0x00D700C0,
	HWPfDdrPhySwTrngCtrl2                 =  0x00D700C4,
	HWPfDdrPhyRcalPcompRden               =  0x00D700C8,
	HWPfDdrPhyRcalNcompRden               =  0x00D700CC,
	HWPfDdrPhyRcalCompen                  =  0x00D700D0,
	HWPfDdrPhySwTrngRdqs                  =  0x00D700D4,
	HWPfDdrPhySwTrngWdqs                  =  0x00D700D8,
	HWPfDdrPhySwTrngRdena                 =  0x00D700DC,
	HWPfDdrPhySwTrngRdenb                 =  0x00D700E0,
	HWPfDdrPhySwTrngRdenc                 =  0x00D700E4,
	HWPfDdrPhySwTrngWdq                   =  0x00D700E8,
	HWPfDdrPhySwTrngRdq                   =  0x00D700EC,
	HWPfDdrPhyPcfgHmValue                 =  0x00D700F0,
	HWPfDdrPhyPcfgTimerValue              =  0x00D700F4,
	HWPfDdrPhyPcfgSoftwareTraining        =  0x00D700F8,
	HWPfDdrPhyPcfgMcStatus                =  0x00D700FC,
	HWPfDdrPhyWrlvlPhRank0                =  0x00D70100,
	HWPfDdrPhyRdenPhRank0                 =  0x00D70104,
	HWPfDdrPhyRdenIntRank0                =  0x00D70108,
	HWPfDdrPhyRdqsDcdlRank0               =  0x00D7010C,
	HWPfDdrPhyRdqsShadowDcdlRank0         =  0x00D70110,
	HWPfDdrPhyWdqsDcdlRank0               =  0x00D70114,
	HWPfDdrPhyWdmDcdlShadowRank0          =  0x00D70118,
	HWPfDdrPhyWdmDcdlRank0                =  0x00D7011C,
	HWPfDdrPhyDbiDcdlRank0                =  0x00D70120,
	HWPfDdrPhyRdenDcdlaRank0              =  0x00D70124,
	HWPfDdrPhyDbiDcdlShadowRank0          =  0x00D70128,
	HWPfDdrPhyRdenDcdlbRank0              =  0x00D7012C,
	HWPfDdrPhyWdqsShadowDcdlRank0         =  0x00D70130,
	HWPfDdrPhyRdenDcdlcRank0              =  0x00D70134,
	HWPfDdrPhyRdenShadowDcdlaRank0        =  0x00D70138,
	HWPfDdrPhyWrlvlIntRank0               =  0x00D7013C,
	HWPfDdrPhyRdqDcdlBit0Rank0            =  0x00D70200,
	HWPfDdrPhyRdqDcdlShadowBit0Rank0      =  0x00D70204,
	HWPfDdrPhyWdqDcdlBit0Rank0            =  0x00D70208,
	HWPfDdrPhyWdqDcdlShadowBit0Rank0      =  0x00D7020C,
	HWPfDdrPhyRdqDcdlBit1Rank0            =  0x00D70240,
	HWPfDdrPhyRdqDcdlShadowBit1Rank0      =  0x00D70244,
	HWPfDdrPhyWdqDcdlBit1Rank0            =  0x00D70248,
	HWPfDdrPhyWdqDcdlShadowBit1Rank0      =  0x00D7024C,
	HWPfDdrPhyRdqDcdlBit2Rank0            =  0x00D70280,
	HWPfDdrPhyRdqDcdlShadowBit2Rank0      =  0x00D70284,
	HWPfDdrPhyWdqDcdlBit2Rank0            =  0x00D70288,
	HWPfDdrPhyWdqDcdlShadowBit2Rank0      =  0x00D7028C,
	HWPfDdrPhyRdqDcdlBit3Rank0            =  0x00D702C0,
	HWPfDdrPhyRdqDcdlShadowBit3Rank0      =  0x00D702C4,
	HWPfDdrPhyWdqDcdlBit3Rank0            =  0x00D702C8,
	HWPfDdrPhyWdqDcdlShadowBit3Rank0      =  0x00D702CC,
	HWPfDdrPhyRdqDcdlBit4Rank0            =  0x00D70300,
	HWPfDdrPhyRdqDcdlShadowBit4Rank0      =  0x00D70304,
	HWPfDdrPhyWdqDcdlBit4Rank0            =  0x00D70308,
	HWPfDdrPhyWdqDcdlShadowBit4Rank0      =  0x00D7030C,
	HWPfDdrPhyRdqDcdlBit5Rank0            =  0x00D70340,
	HWPfDdrPhyRdqDcdlShadowBit5Rank0      =  0x00D70344,
	HWPfDdrPhyWdqDcdlBit5Rank0            =  0x00D70348,
	HWPfDdrPhyWdqDcdlShadowBit5Rank0      =  0x00D7034C,
	HWPfDdrPhyRdqDcdlBit6Rank0            =  0x00D70380,
	HWPfDdrPhyRdqDcdlShadowBit6Rank0      =  0x00D70384,
	HWPfDdrPhyWdqDcdlBit6Rank0            =  0x00D70388,
	HWPfDdrPhyWdqDcdlShadowBit6Rank0      =  0x00D7038C,
	HWPfDdrPhyRdqDcdlBit7Rank0            =  0x00D703C0,
	HWPfDdrPhyRdqDcdlShadowBit7Rank0      =  0x00D703C4,
	HWPfDdrPhyWdqDcdlBit7Rank0            =  0x00D703C8,
	HWPfDdrPhyWdqDcdlShadowBit7Rank0      =  0x00D703CC,
	HWPfDdrPhyIdtmStatus                  =  0x00D740D0,
	HWPfDdrPhyIdtmError                   =  0x00D74110,
	HWPfDdrPhyIdtmDebug                   =  0x00D74120,
	HWPfDdrPhyIdtmDebugInt                =  0x00D74130,
	HwPfPcieLnAsicCfgovr                  =  0x00D80000,
	HwPfPcieLnAclkmixer                   =  0x00D80004,
	HwPfPcieLnTxrampfreq                  =  0x00D80008,
	HwPfPcieLnLanetest                    =  0x00D8000C,
	HwPfPcieLnDcctrl                      =  0x00D80010,
	HwPfPcieLnDccmeas                     =  0x00D80014,
	HwPfPcieLnDccovrAclk                  =  0x00D80018,
	HwPfPcieLnDccovrTxa                   =  0x00D8001C,
	HwPfPcieLnDccovrTxk                   =  0x00D80020,
	HwPfPcieLnDccovrDclk                  =  0x00D80024,
	HwPfPcieLnDccovrEclk                  =  0x00D80028,
	HwPfPcieLnDcctrimAclk                 =  0x00D8002C,
	HwPfPcieLnDcctrimTx                   =  0x00D80030,
	HwPfPcieLnDcctrimDclk                 =  0x00D80034,
	HwPfPcieLnDcctrimEclk                 =  0x00D80038,
	HwPfPcieLnQuadCtrl                    =  0x00D8003C,
	HwPfPcieLnQuadCorrIndex               =  0x00D80040,
	HwPfPcieLnQuadCorrStatus              =  0x00D80044,
	HwPfPcieLnAsicRxovr1                  =  0x00D80048,
	HwPfPcieLnAsicRxovr2                  =  0x00D8004C,
	HwPfPcieLnAsicEqinfovr                =  0x00D80050,
	HwPfPcieLnRxcsr                       =  0x00D80054,
	HwPfPcieLnRxfectrl                    =  0x00D80058,
	HwPfPcieLnRxtest                      =  0x00D8005C,
	HwPfPcieLnEscount                     =  0x00D80060,
	HwPfPcieLnCdrctrl                     =  0x00D80064,
	HwPfPcieLnCdrctrl2                    =  0x00D80068,
	HwPfPcieLnCdrcfg0Ctrl0                =  0x00D8006C,
	HwPfPcieLnCdrcfg0Ctrl1                =  0x00D80070,
	HwPfPcieLnCdrcfg0Ctrl2                =  0x00D80074,
	HwPfPcieLnCdrcfg1Ctrl0                =  0x00D80078,
	HwPfPcieLnCdrcfg1Ctrl1                =  0x00D8007C,
	HwPfPcieLnCdrcfg1Ctrl2                =  0x00D80080,
	HwPfPcieLnCdrcfg2Ctrl0                =  0x00D80084,
	HwPfPcieLnCdrcfg2Ctrl1                =  0x00D80088,
	HwPfPcieLnCdrcfg2Ctrl2                =  0x00D8008C,
	HwPfPcieLnCdrcfg3Ctrl0                =  0x00D80090,
	HwPfPcieLnCdrcfg3Ctrl1                =  0x00D80094,
	HwPfPcieLnCdrcfg3Ctrl2                =  0x00D80098,
	HwPfPcieLnCdrphase                    =  0x00D8009C,
	HwPfPcieLnCdrfreq                     =  0x00D800A0,
	HwPfPcieLnCdrstatusPhase              =  0x00D800A4,
	HwPfPcieLnCdrstatusFreq               =  0x00D800A8,
	HwPfPcieLnCdroffset                   =  0x00D800AC,
	HwPfPcieLnRxvosctl                    =  0x00D800B0,
	HwPfPcieLnRxvosctl2                   =  0x00D800B4,
	HwPfPcieLnRxlosctl                    =  0x00D800B8,
	HwPfPcieLnRxlos                       =  0x00D800BC,
	HwPfPcieLnRxlosvval                   =  0x00D800C0,
	HwPfPcieLnRxvosd0                     =  0x00D800C4,
	HwPfPcieLnRxvosd1                     =  0x00D800C8,
	HwPfPcieLnRxvosep0                    =  0x00D800CC,
	HwPfPcieLnRxvosep1                    =  0x00D800D0,
	HwPfPcieLnRxvosen0                    =  0x00D800D4,
	HwPfPcieLnRxvosen1                    =  0x00D800D8,
	HwPfPcieLnRxvosafe                    =  0x00D800DC,
	HwPfPcieLnRxvosa0                     =  0x00D800E0,
	HwPfPcieLnRxvosa0Out                  =  0x00D800E4,
	HwPfPcieLnRxvosa1                     =  0x00D800E8,
	HwPfPcieLnRxvosa1Out                  =  0x00D800EC,
	HwPfPcieLnRxmisc                      =  0x00D800F0,
	HwPfPcieLnRxbeacon                    =  0x00D800F4,
	HwPfPcieLnRxdssout                    =  0x00D800F8,
	HwPfPcieLnRxdssout2                   =  0x00D800FC,
	HwPfPcieLnAlphapctrl                  =  0x00D80100,
	HwPfPcieLnAlphanctrl                  =  0x00D80104,
	HwPfPcieLnAdaptctrl                   =  0x00D80108,
	HwPfPcieLnAdaptctrl1                  =  0x00D8010C,
	HwPfPcieLnAdaptstatus                 =  0x00D80110,
	HwPfPcieLnAdaptvga1                   =  0x00D80114,
	HwPfPcieLnAdaptvga2                   =  0x00D80118,
	HwPfPcieLnAdaptvga3                   =  0x00D8011C,
	HwPfPcieLnAdaptvga4                   =  0x00D80120,
	HwPfPcieLnAdaptboost1                 =  0x00D80124,
	HwPfPcieLnAdaptboost2                 =  0x00D80128,
	HwPfPcieLnAdaptboost3                 =  0x00D8012C,
	HwPfPcieLnAdaptboost4                 =  0x00D80130,
	HwPfPcieLnAdaptsslms1                 =  0x00D80134,
	HwPfPcieLnAdaptsslms2                 =  0x00D80138,
	HwPfPcieLnAdaptvgaStatus              =  0x00D8013C,
	HwPfPcieLnAdaptboostStatus            =  0x00D80140,
	HwPfPcieLnAdaptsslmsStatus1           =  0x00D80144,
	HwPfPcieLnAdaptsslmsStatus2           =  0x00D80148,
	HwPfPcieLnAfectrl1                    =  0x00D8014C,
	HwPfPcieLnAfectrl2                    =  0x00D80150,
	HwPfPcieLnAfectrl3                    =  0x00D80154,
	HwPfPcieLnAfedefault1                 =  0x00D80158,
	HwPfPcieLnAfedefault2                 =  0x00D8015C,
	HwPfPcieLnDfectrl1                    =  0x00D80160,
	HwPfPcieLnDfectrl2                    =  0x00D80164,
	HwPfPcieLnDfectrl3                    =  0x00D80168,
	HwPfPcieLnDfectrl4                    =  0x00D8016C,
	HwPfPcieLnDfectrl5                    =  0x00D80170,
	HwPfPcieLnDfectrl6                    =  0x00D80174,
	HwPfPcieLnAfestatus1                  =  0x00D80178,
	HwPfPcieLnAfestatus2                  =  0x00D8017C,
	HwPfPcieLnDfestatus1                  =  0x00D80180,
	HwPfPcieLnDfestatus2                  =  0x00D80184,
	HwPfPcieLnDfestatus3                  =  0x00D80188,
	HwPfPcieLnDfestatus4                  =  0x00D8018C,
	HwPfPcieLnDfestatus5                  =  0x00D80190,
	HwPfPcieLnAlphastatus                 =  0x00D80194,
	HwPfPcieLnFomctrl1                    =  0x00D80198,
	HwPfPcieLnFomctrl2                    =  0x00D8019C,
	HwPfPcieLnFomctrl3                    =  0x00D801A0,
	HwPfPcieLnAclkcalStatus               =  0x00D801A4,
	HwPfPcieLnOffscorrStatus              =  0x00D801A8,
	HwPfPcieLnEyewidthStatus              =  0x00D801AC,
	HwPfPcieLnEyeheightStatus             =  0x00D801B0,
	HwPfPcieLnAsicTxovr1                  =  0x00D801B4,
	HwPfPcieLnAsicTxovr2                  =  0x00D801B8,
	HwPfPcieLnAsicTxovr3                  =  0x00D801BC,
	HwPfPcieLnTxbiasadjOvr                =  0x00D801C0,
	HwPfPcieLnTxcsr                       =  0x00D801C4,
	HwPfPcieLnTxtest                      =  0x00D801C8,
	HwPfPcieLnTxtestword                  =  0x00D801CC,
	HwPfPcieLnTxtestwordHigh              =  0x00D801D0,
	HwPfPcieLnTxdrive                     =  0x00D801D4,
	HwPfPcieLnMtcsLn                      =  0x00D801D8,
	HwPfPcieLnStatsumLn                   =  0x00D801DC,
	HwPfPcieLnRcbusScratch                =  0x00D801E0,
	HwPfPcieLnRcbusMinorrev               =  0x00D801F0,
	HwPfPcieLnRcbusMajorrev               =  0x00D801F4,
	HwPfPcieLnRcbusBlocktype              =  0x00D801F8,
	HwPfPcieSupPllcsr                     =  0x00D80800,
	HwPfPcieSupPlldiv                     =  0x00D80804,
	HwPfPcieSupPllcal                     =  0x00D80808,
	HwPfPcieSupPllcalsts                  =  0x00D8080C,
	HwPfPcieSupPllmeas                    =  0x00D80810,
	HwPfPcieSupPlldactrim                 =  0x00D80814,
	HwPfPcieSupPllbiastrim                =  0x00D80818,
	HwPfPcieSupPllbwtrim                  =  0x00D8081C,
	HwPfPcieSupPllcaldly                  =  0x00D80820,
	HwPfPcieSupRefclkonpclkctrl           =  0x00D80824,
	HwPfPcieSupPclkdelay                  =  0x00D80828,
	HwPfPcieSupPhyconfig                  =  0x00D8082C,
	HwPfPcieSupRcalIntf                   =  0x00D80830,
	HwPfPcieSupAuxcsr                     =  0x00D80834,
	HwPfPcieSupVref                       =  0x00D80838,
	HwPfPcieSupLinkmode                   =  0x00D8083C,
	HwPfPcieSupRrefcalctl                 =  0x00D80840,
	HwPfPcieSupRrefcal                    =  0x00D80844,
	HwPfPcieSupRrefcaldly                 =  0x00D80848,
	HwPfPcieSupTximpcalctl                =  0x00D8084C,
	HwPfPcieSupTximpcal                   =  0x00D80850,
	HwPfPcieSupTximpoffset                =  0x00D80854,
	HwPfPcieSupTximpcaldly                =  0x00D80858,
	HwPfPcieSupRximpcalctl                =  0x00D8085C,
	HwPfPcieSupRximpcal                   =  0x00D80860,
	HwPfPcieSupRximpoffset                =  0x00D80864,
	HwPfPcieSupRximpcaldly                =  0x00D80868,
	HwPfPcieSupFence                      =  0x00D8086C,
	HwPfPcieSupMtcs                       =  0x00D80870,
	HwPfPcieSupStatsum                    =  0x00D809B8,
	HwPfPcieRomVersion                    =  0x00D80B0C,
	HwPfPciePcsDpStatus0                  =  0x00D81000,
	HwPfPciePcsDpControl0                 =  0x00D81004,
	HwPfPciePcsPmaStatusLane0             =  0x00D81008,
	HwPfPciePcsPipeStatusLane0            =  0x00D8100C,
	HwPfPciePcsTxdeemph0Lane0             =  0x00D81010,
	HwPfPciePcsTxdeemph1Lane0             =  0x00D81014,
	HwPfPciePcsInternalStatusLane0        =  0x00D81018,
	HwPfPciePcsDpStatus1                  =  0x00D8101C,
	HwPfPciePcsDpControl1                 =  0x00D81020,
	HwPfPciePcsPmaStatusLane1             =  0x00D81024,
	HwPfPciePcsPipeStatusLane1            =  0x00D81028,
	HwPfPciePcsTxdeemph0Lane1             =  0x00D8102C,
	HwPfPciePcsTxdeemph1Lane1             =  0x00D81030,
	HwPfPciePcsInternalStatusLane1        =  0x00D81034,
	HwPfPciePcsDpStatus2                  =  0x00D81038,
	HwPfPciePcsDpControl2                 =  0x00D8103C,
	HwPfPciePcsPmaStatusLane2             =  0x00D81040,
	HwPfPciePcsPipeStatusLane2            =  0x00D81044,
	HwPfPciePcsTxdeemph0Lane2             =  0x00D81048,
	HwPfPciePcsTxdeemph1Lane2             =  0x00D8104C,
	HwPfPciePcsInternalStatusLane2        =  0x00D81050,
	HwPfPciePcsDpStatus3                  =  0x00D81054,
	HwPfPciePcsDpControl3                 =  0x00D81058,
	HwPfPciePcsPmaStatusLane3             =  0x00D8105C,
	HwPfPciePcsPipeStatusLane3            =  0x00D81060,
	HwPfPciePcsTxdeemph0Lane3             =  0x00D81064,
	HwPfPciePcsTxdeemph1Lane3             =  0x00D81068,
	HwPfPciePcsInternalStatusLane3        =  0x00D8106C,
	HwPfPciePcsEbStatus0                  =  0x00D81070,
	HwPfPciePcsEbStatus1                  =  0x00D81074,
	HwPfPciePcsEbStatus2                  =  0x00D81078,
	HwPfPciePcsEbStatus3                  =  0x00D8107C,
	HwPfPciePcsPllSettingPcieG1           =  0x00D81088,
	HwPfPciePcsPllSettingPcieG2           =  0x00D8108C,
	HwPfPciePcsPllSettingPcieG3           =  0x00D81090,
	HwPfPciePcsControl                    =  0x00D81094,
	HwPfPciePcsEqControl                  =  0x00D81098,
	HwPfPciePcsEqTimer                    =  0x00D8109C,
	HwPfPciePcsEqErrStatus                =  0x00D810A0,
	HwPfPciePcsEqErrCount                 =  0x00D810A4,
	HwPfPciePcsStatus                     =  0x00D810A8,
	HwPfPciePcsMiscRegister               =  0x00D810AC,
	HwPfPciePcsObsControl                 =  0x00D810B0,
	HwPfPciePcsPrbsCount0                 =  0x00D81200,
	HwPfPciePcsBistControl0               =  0x00D81204,
	HwPfPciePcsBistStaticWord00           =  0x00D81208,
	HwPfPciePcsBistStaticWord10           =  0x00D8120C,
	HwPfPciePcsBistStaticWord20           =  0x00D81210,
	HwPfPciePcsBistStaticWord30           =  0x00D81214,
	HwPfPciePcsPrbsCount1                 =  0x00D81220,
	HwPfPciePcsBistControl1               =  0x00D81224,
	HwPfPciePcsBistStaticWord01           =  0x00D81228,
	HwPfPciePcsBistStaticWord11           =  0x00D8122C,
	HwPfPciePcsBistStaticWord21           =  0x00D81230,
	HwPfPciePcsBistStaticWord31           =  0x00D81234,
	HwPfPciePcsPrbsCount2                 =  0x00D81240,
	HwPfPciePcsBistControl2               =  0x00D81244,
	HwPfPciePcsBistStaticWord02           =  0x00D81248,
	HwPfPciePcsBistStaticWord12           =  0x00D8124C,
	HwPfPciePcsBistStaticWord22           =  0x00D81250,
	HwPfPciePcsBistStaticWord32           =  0x00D81254,
	HwPfPciePcsPrbsCount3                 =  0x00D81260,
	HwPfPciePcsBistControl3               =  0x00D81264,
	HwPfPciePcsBistStaticWord03           =  0x00D81268,
	HwPfPciePcsBistStaticWord13           =  0x00D8126C,
	HwPfPciePcsBistStaticWord23           =  0x00D81270,
	HwPfPciePcsBistStaticWord33           =  0x00D81274,
	HwPfPcieGpexLtssmStateCntrl           =  0x00D90400,
	HwPfPcieGpexLtssmStateStatus          =  0x00D90404,
	HwPfPcieGpexSkipFreqTimer             =  0x00D90408,
	HwPfPcieGpexLaneSelect                =  0x00D9040C,
	HwPfPcieGpexLaneDeskew                =  0x00D90410,
	HwPfPcieGpexRxErrorStatus             =  0x00D90414,
	HwPfPcieGpexLaneNumControl            =  0x00D90418,
	HwPfPcieGpexNFstControl               =  0x00D9041C,
	HwPfPcieGpexLinkStatus                =  0x00D90420,
	HwPfPcieGpexAckReplayTimeout          =  0x00D90438,
	HwPfPcieGpexSeqNumberStatus           =  0x00D9043C,
	HwPfPcieGpexCoreClkRatio              =  0x00D90440,
	HwPfPcieGpexDllTholdControl           =  0x00D90448,
	HwPfPcieGpexPmTimer                   =  0x00D90450,
	HwPfPcieGpexPmeTimeout                =  0x00D90454,
	HwPfPcieGpexAspmL1Timer               =  0x00D90458,
	HwPfPcieGpexAspmReqTimer              =  0x00D9045C,
	HwPfPcieGpexAspmL1Dis                 =  0x00D90460,
	HwPfPcieGpexAdvisoryErrorControl      =  0x00D90468,
	HwPfPcieGpexId                        =  0x00D90470,
	HwPfPcieGpexClasscode                 =  0x00D90474,
	HwPfPcieGpexSubsystemId               =  0x00D90478,
	HwPfPcieGpexDeviceCapabilities        =  0x00D9047C,
	HwPfPcieGpexLinkCapabilities          =  0x00D90480,
	HwPfPcieGpexFunctionNumber            =  0x00D90484,
	HwPfPcieGpexPmCapabilities            =  0x00D90488,
	HwPfPcieGpexFunctionSelect            =  0x00D9048C,
	HwPfPcieGpexErrorCounter              =  0x00D904AC,
	HwPfPcieGpexConfigReady               =  0x00D904B0,
	HwPfPcieGpexFcUpdateTimeout           =  0x00D904B8,
	HwPfPcieGpexFcUpdateTimer             =  0x00D904BC,
	HwPfPcieGpexVcBufferLoad              =  0x00D904C8,
	HwPfPcieGpexVcBufferSizeThold         =  0x00D904CC,
	HwPfPcieGpexVcBufferSelect            =  0x00D904D0,
	HwPfPcieGpexBarEnable                 =  0x00D904D4,
	HwPfPcieGpexBarDwordLower             =  0x00D904D8,
	HwPfPcieGpexBarDwordUpper             =  0x00D904DC,
	HwPfPcieGpexBarSelect                 =  0x00D904E0,
	HwPfPcieGpexCreditCounterSelect       =  0x00D904E4,
	HwPfPcieGpexCreditCounterStatus       =  0x00D904E8,
	HwPfPcieGpexTlpHeaderSelect           =  0x00D904EC,
	HwPfPcieGpexTlpHeaderDword0           =  0x00D904F0,
	HwPfPcieGpexTlpHeaderDword1           =  0x00D904F4,
	HwPfPcieGpexTlpHeaderDword2           =  0x00D904F8,
	HwPfPcieGpexTlpHeaderDword3           =  0x00D904FC,
	HwPfPcieGpexRelaxOrderControl         =  0x00D90500,
	HwPfPcieGpexBarPrefetch               =  0x00D90504,
	HwPfPcieGpexFcCheckControl            =  0x00D90508,
	HwPfPcieGpexFcUpdateTimerTraffic      =  0x00D90518,
	HwPfPcieGpexPhyControl0               =  0x00D9053C,
	HwPfPcieGpexPhyControl1               =  0x00D90544,
	HwPfPcieGpexPhyControl2               =  0x00D9054C,
	HwPfPcieGpexUserControl0              =  0x00D9055C,
	HwPfPcieGpexUncorrErrorStatus         =  0x00D905F0,
	HwPfPcieGpexRxCplError                =  0x00D90620,
	HwPfPcieGpexRxCplErrorDword0          =  0x00D90624,
	HwPfPcieGpexRxCplErrorDword1          =  0x00D90628,
	HwPfPcieGpexRxCplErrorDword2          =  0x00D9062C,
	HwPfPcieGpexPabSwResetEn              =  0x00D90630,
	HwPfPcieGpexGen3Control0              =  0x00D90634,
	HwPfPcieGpexGen3Control1              =  0x00D90638,
	HwPfPcieGpexGen3Control2              =  0x00D9063C,
	HwPfPcieGpexGen2ControlCsr            =  0x00D90640,
	HwPfPcieGpexTotalVfInitialVf0         =  0x00D90644,
	HwPfPcieGpexTotalVfInitialVf1         =  0x00D90648,
	HwPfPcieGpexSriovLinkDevId0           =  0x00D90684,
	HwPfPcieGpexSriovLinkDevId1           =  0x00D90688,
	HwPfPcieGpexSriovPageSize0            =  0x00D906C4,
	HwPfPcieGpexSriovPageSize1            =  0x00D906C8,
	HwPfPcieGpexIdVersion                 =  0x00D906FC,
	HwPfPcieGpexSriovVfOffsetStride0      =  0x00D90704,
	HwPfPcieGpexSriovVfOffsetStride1      =  0x00D90708,
	HwPfPcieGpexGen3DeskewControl         =  0x00D907B4,
	HwPfPcieGpexGen3EqControl             =  0x00D907B8,
	HwPfPcieGpexBridgeVersion             =  0x00D90800,
	HwPfPcieGpexBridgeCapability          =  0x00D90804,
	HwPfPcieGpexBridgeControl             =  0x00D90808,
	HwPfPcieGpexBridgeStatus              =  0x00D9080C,
	HwPfPcieGpexEngineActivityStatus      =  0x00D9081C,
	HwPfPcieGpexEngineResetControl        =  0x00D90820,
	HwPfPcieGpexAxiPioControl             =  0x00D90840,
	HwPfPcieGpexAxiPioStatus              =  0x00D90844,
	HwPfPcieGpexAmbaSlaveCmdStatus        =  0x00D90848,
	HwPfPcieGpexPexPioControl             =  0x00D908C0,
	HwPfPcieGpexPexPioStatus              =  0x00D908C4,
	HwPfPcieGpexAmbaMasterStatus          =  0x00D908C8,
	HwPfPcieGpexCsrSlaveCmdStatus         =  0x00D90920,
	HwPfPcieGpexMailboxAxiControl         =  0x00D90A50,
	HwPfPcieGpexMailboxAxiData            =  0x00D90A54,
	HwPfPcieGpexMailboxPexControl         =  0x00D90A90,
	HwPfPcieGpexMailboxPexData            =  0x00D90A94,
	HwPfPcieGpexPexInterruptEnable        =  0x00D90AD0,
	HwPfPcieGpexPexInterruptStatus        =  0x00D90AD4,
	HwPfPcieGpexPexInterruptAxiPioVector  =  0x00D90AD8,
	HwPfPcieGpexPexInterruptPexPioVector  =  0x00D90AE0,
	HwPfPcieGpexPexInterruptMiscVector    =  0x00D90AF8,
	HwPfPcieGpexAmbaInterruptPioEnable    =  0x00D90B00,
	HwPfPcieGpexAmbaInterruptMiscEnable   =  0x00D90B0C,
	HwPfPcieGpexAmbaInterruptPioStatus    =  0x00D90B10,
	HwPfPcieGpexAmbaInterruptMiscStatus   =  0x00D90B1C,
	HwPfPcieGpexPexPmControl              =  0x00D90B80,
	HwPfPcieGpexSlotMisc                  =  0x00D90B88,
	HwPfPcieGpexAxiAddrMappingControl     =  0x00D90BA0,
	HwPfPcieGpexAxiAddrMappingWindowAxiBase     =  0x00D90BA4,
	HwPfPcieGpexAxiAddrMappingWindowPexBaseLow  =  0x00D90BA8,
	HwPfPcieGpexAxiAddrMappingWindowPexBaseHigh =  0x00D90BAC,
	HwPfPcieGpexPexBarAddrFunc0Bar0       =  0x00D91BA0,
	HwPfPcieGpexPexBarAddrFunc0Bar1       =  0x00D91BA4,
	HwPfPcieGpexAxiAddrMappingPcieHdrParam =  0x00D95BA0,
	HwPfPcieGpexExtAxiAddrMappingAxiBase  =  0x00D980A0,
	HwPfPcieGpexPexExtBarAddrFunc0Bar0    =  0x00D984A0,
	HwPfPcieGpexPexExtBarAddrFunc0Bar1    =  0x00D984A4,
	HwPfPcieGpexAmbaInterruptFlrEnable    =  0x00D9B960,
	HwPfPcieGpexAmbaInterruptFlrStatus    =  0x00D9B9A0,
	HwPfPcieGpexExtAxiAddrMappingSize     =  0x00D9BAF0,
	HwPfPcieGpexPexPioAwcacheControl      =  0x00D9C300,
	HwPfPcieGpexPexPioArcacheControl      =  0x00D9C304,
	HwPfPcieGpexPabObSizeControlVc0       =  0x00D9C310
};

/* ACC100 PF Interrupt numbers */
enum {
	ACC100_PF_INT_QMGR_AQ_OVERFLOW = 0,
	ACC100_PF_INT_DOORBELL_VF_2_PF = 1,
	ACC100_PF_INT_DMA_DL_DESC_IRQ = 2,
	ACC100_PF_INT_DMA_UL_DESC_IRQ = 3,
	ACC100_PF_INT_ILLEGAL_FORMAT = 4,
	ACC100_PF_INT_QMGR_DISABLED_ACCESS = 5,
	ACC100_PF_INT_QMGR_AQ_OVERTHRESHOLD = 6,
	ACC100_PF_INT_ARAM_ACCESS_ERR = 8,
	ACC100_PF_INT_ARAM_ECC_1BIT_ERR = 9,
	ACC100_PF_INT_PARITY_ERR = 10,
	ACC100_PF_INT_QMGR_ERR = 13,
	ACC100_PF_INT_INT_REQ_OVERFLOW = 14,
	ACC100_PF_INT_APB_TIMEOUT = 15,
	ACC100_PF_INT_FEC_DL_EXTRA_READ = 16,
	ACC100_PF_INT_FEC_DL_READ_TIMEOUT = 17,
	ACC100_PF_INT_FEC_DL_ERR = 18,
	ACC100_PF_INT_FEC_UL_EXTRA_READ = 20,
	ACC100_PF_INT_FEC_UL_READ_TIMEOUT = 21,
	ACC100_PF_INT_FEC_UL_ERR = 22,
};

#endif /* _ACC100_PF_ENUM_H_ */
