/*
 * Copyright 2009-2017 Aconex
 *
 * Licensed under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */

package io.pcp.parfait.dxm;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * {@link IdentifierSource} which logs a warning on every generation, and returns a dummy value.
 * Useful for generating a list of IDs which should later be explicity-provided.
 */
public class WarningIdentifierSource implements IdentifierSource {
    private static final Logger LOG = LoggerFactory.getLogger(WarningIdentifierSource.class);

    private final AtomicInteger nextId;

    public WarningIdentifierSource(int initialId) {
        nextId = new AtomicInteger(initialId);
    }

    @Override
    public int calculateId(String name, Set<Integer> usedIds) {
        LOG.warn("No identifier provided for value " + name + "; please specify an explicit ID");
        return nextId.getAndIncrement();
    }

}
