#
# Copyright 2014-2020 the Pacemaker project contributors
#
# The version control history for this file may have further details.
#
# This source code is licensed under the GNU General Public License version 2
# or later (GPLv2+) WITHOUT ANY WARRANTY.
#

#
# Some variables to help with silent rules
# https://www.gnu.org/software/automake/manual/html_node/Automake-silent_002drules-Option.html

V ?= $(AM_DEFAULT_VERBOSITY)

# When a make command is prefixed with one of the AM_V_* macros, it may also be
# desirable to suffix the command with this, to silence stdout.
PCMK_quiet = $(pcmk_quiet_$(V))
pcmk_quiet_0 = >/dev/null
pcmk_quiet_1 = 

# AM_V_GEN is intended to be used in custom pattern rules, and replaces echoing
# the command used with a more concise line with "GEN" and the name of the file
# being generated. Our AM_V_* macros are similar but more descriptive.
AM_V_MAN = $(am__v_MAN_$(V))
am__v_MAN_0 = @echo "  MAN      $@";
am__v_MAN_1 = 

AM_V_SCHEMA = $(am__v_SCHEMA_$(V))
am__v_SCHEMA_0 = @echo "  SCHEMA   $@";
am__v_SCHEMA_1 = 

AM_V_BOOK = $(am__v_BOOK_$(V))
am__v_BOOK_0 = @echo "  BOOK    $(@:%/_build=%): $(BOOK_FORMATS)";
am__v_BOOK_1 = 

MAINTAINERCLEANFILES	= Makefile.in

AM_CPPFLAGS		= -I$(top_builddir)/include -I$(top_srcdir)/include   \
			  -I$(top_builddir)/libltdl -I$(top_srcdir)/libltdl

#
# Man page builders
#
# We have three types of man pages:
# - man pages for the tools
# - man pages for OCF agents
# - man pages for cluster properties used by daemons
#
# "BUILD_HELP" actually means "help2man is available", so it only controls the
# tool man pages, which are generated by help2man. The other man pages are
# generated via XSL transforms.
#

if BUILD_HELP
man8_MANS		= $(sbin_PROGRAMS:%=%.8) $(sbin_SCRIPTS:%=%.8)

HELP2MAN_ARGS = -N --section 8 --name "Part of the Pacemaker cluster resource manager"

# Some of our tools' help are just shell script invocations of another tool's
# help. Putting the real tool in MAN8DEPS helps detect when the wrapped help
# needs updating.
#
# If a ".inc" file exists, the tool has been converted to use glib for
# argument parsing, otherwise it still uses the libcrmcommon functions.
#
# @TODO Drop MAN8DEPS once we've converted all tools to libpacemaker API calls
#       and all wrappers to C code.
%.8:	% $(MAN8DEPS)
	$(AM_V_at)chmod a+x $(abs_builddir)/$<
	$(AM_V_MAN)if [ -f $(top_srcdir)/tools/$@.inc ]; then			\
		PATH=$(abs_builddir):$$PATH $(HELP2MAN) $(HELP2MAN_ARGS)	\
			-h --help-all 						\
			--no-discard-stderr 					\
			-i $(top_srcdir)/tools/$@.inc $(abs_builddir)/$<		\
			| sed -f $(top_srcdir)/tools/fix-manpages > $@ ; \
	else									\
		PATH=$(abs_builddir):$$PATH $(HELP2MAN) $(HELP2MAN_ARGS)	\
			--no-discard-stderr 					\
			$(abs_builddir)/$< --output $@ ;			\
	fi
endif

# Save raw XML meta-data from daemon executables, for later conversion into man
# pages. (Note that more specific rules may override this for creating other
# types of XML files.)
%.xml:  %
	$(AM_V_at)$(abs_builddir)/$< metadata > $@

# Process the raw daemon and OCF agent meta-data output using our
# meta-data-to-docbook-XML tranform.
%.dbook: %.xml
	$(AM_V_at)$(XSLTPROC) --nonet --novalid --stringparam man.name $* \
		$(DBOOK_OPTS) $(top_srcdir)/xml/ocf-meta2man.xsl \
		$(abs_builddir)/$< > $(abs_builddir)/$@

# Generate the actual man page for an OCF resource agent from the intermediate
# docbook XML.
%.7:	%.dbook
	$(AM_V_MAN)$(XSLTPROC) $(MANPAGE_XSLT) $(abs_builddir)/$< $(PCMK_quiet)
