// Package v2 provides primitives to interact the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen DO NOT EDIT.
package v2

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
	"net/http"
	"strings"
)

// AWSEC2UploadOptions defines model for AWSEC2UploadOptions.
type AWSEC2UploadOptions struct {
	Region            string   `json:"region"`
	ShareWithAccounts []string `json:"share_with_accounts"`
	SnapshotName      *string  `json:"snapshot_name,omitempty"`
}

// AWSEC2UploadStatus defines model for AWSEC2UploadStatus.
type AWSEC2UploadStatus struct {
	Ami    string `json:"ami"`
	Region string `json:"region"`
}

// AWSS3UploadOptions defines model for AWSS3UploadOptions.
type AWSS3UploadOptions struct {
	Region string `json:"region"`
}

// AWSS3UploadStatus defines model for AWSS3UploadStatus.
type AWSS3UploadStatus struct {
	Url string `json:"url"`
}

// AzureUploadOptions defines model for AzureUploadOptions.
type AzureUploadOptions struct {

	// Name of the uploaded image. It must be unique in the given resource group.
	// If name is omitted from the request, a random one based on a UUID is
	// generated.
	ImageName *string `json:"image_name,omitempty"`

	// Location where the image should be uploaded and registered.
	// How to list all locations:
	// https://docs.microsoft.com/en-us/cli/azure/account?view=azure-cli-latest#az_account_list_locations'
	Location string `json:"location"`

	// Name of the resource group where the image should be uploaded.
	ResourceGroup string `json:"resource_group"`

	// ID of subscription where the image should be uploaded.
	SubscriptionId string `json:"subscription_id"`

	// ID of the tenant where the image should be uploaded.
	// How to find it in the Azure Portal:
	// https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-how-to-find-tenant
	TenantId string `json:"tenant_id"`
}

// AzureUploadStatus defines model for AzureUploadStatus.
type AzureUploadStatus struct {
	ImageName string `json:"image_name"`
}

// ComposeId defines model for ComposeId.
type ComposeId struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// ComposeMetadata defines model for ComposeMetadata.
type ComposeMetadata struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference
	// Embedded fields due to inline allOf schema

	// ID (hash) of the built commit
	OstreeCommit *string `json:"ostree_commit,omitempty"`

	// Package list including NEVRA
	Packages *[]PackageMetadata `json:"packages,omitempty"`
}

// ComposeRequest defines model for ComposeRequest.
type ComposeRequest struct {
	Customizations *Customizations `json:"customizations,omitempty"`
	Distribution   string          `json:"distribution"`
	ImageRequest   ImageRequest    `json:"image_request"`
}

// ComposeStatus defines model for ComposeStatus.
type ComposeStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference
	// Embedded fields due to inline allOf schema
	ImageStatus ImageStatus `json:"image_status"`
}

// Customizations defines model for Customizations.
type Customizations struct {
	Packages     *[]string     `json:"packages,omitempty"`
	Subscription *Subscription `json:"subscription,omitempty"`
	Users        *[]User       `json:"users,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference
	// Embedded fields due to inline allOf schema
	Code        string `json:"code"`
	OperationId string `json:"operation_id"`
	Reason      string `json:"reason"`
}

// ErrorList defines model for ErrorList.
type ErrorList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List
	// Embedded fields due to inline allOf schema
	Items []Error `json:"items"`
}

// GCPUploadOptions defines model for GCPUploadOptions.
type GCPUploadOptions struct {

	// Name of an existing STANDARD Storage class Bucket.
	Bucket string `json:"bucket"`

	// The name to use for the imported and shared Compute Engine image.
	// The image name must be unique within the GCP project, which is used
	// for the OS image upload and import. If not specified a random
	// 'composer-api-<uuid>' string is used as the image name.
	ImageName *string `json:"image_name,omitempty"`

	// The GCP region where the OS image will be imported to and shared from.
	// The value must be a valid GCP location. See https://cloud.google.com/storage/docs/locations.
	// If not specified, the multi-region location closest to the source
	// (source Storage Bucket location) is chosen automatically.
	Region string `json:"region"`

	// List of valid Google accounts to share the imported Compute Engine image with.
	// Each string must contain a specifier of the account type. Valid formats are:
	//   - 'user:{emailid}': An email address that represents a specific
	//     Google account. For example, 'alice@example.com'.
	//   - 'serviceAccount:{emailid}': An email address that represents a
	//     service account. For example, 'my-other-app@appspot.gserviceaccount.com'.
	//   - 'group:{emailid}': An email address that represents a Google group.
	//     For example, 'admins@example.com'.
	//   - 'domain:{domain}': The G Suite domain (primary) that represents all
	//     the users of that domain. For example, 'google.com' or 'example.com'.
	// If not specified, the imported Compute Engine image is not shared with any
	// account.
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// GCPUploadStatus defines model for GCPUploadStatus.
type GCPUploadStatus struct {
	ImageName string `json:"image_name"`
	ProjectId string `json:"project_id"`
}

// ImageRequest defines model for ImageRequest.
type ImageRequest struct {
	Architecture  string        `json:"architecture"`
	ImageType     ImageTypes    `json:"image_type"`
	Ostree        *OSTree       `json:"ostree,omitempty"`
	Repositories  []Repository  `json:"repositories"`
	UploadOptions UploadOptions `json:"upload_options"`
}

// ImageStatus defines model for ImageStatus.
type ImageStatus struct {
	Status       ImageStatusValue `json:"status"`
	UploadStatus *UploadStatus    `json:"upload_status,omitempty"`
}

// ImageStatusValue defines model for ImageStatusValue.
type ImageStatusValue string

// List of ImageStatusValue
const (
	ImageStatusValue_building    ImageStatusValue = "building"
	ImageStatusValue_failure     ImageStatusValue = "failure"
	ImageStatusValue_pending     ImageStatusValue = "pending"
	ImageStatusValue_registering ImageStatusValue = "registering"
	ImageStatusValue_success     ImageStatusValue = "success"
	ImageStatusValue_uploading   ImageStatusValue = "uploading"
)

// ImageTypes defines model for ImageTypes.
type ImageTypes string

// List of ImageTypes
const (
	ImageTypes_aws             ImageTypes = "aws"
	ImageTypes_azure           ImageTypes = "azure"
	ImageTypes_edge_commit     ImageTypes = "edge-commit"
	ImageTypes_edge_container  ImageTypes = "edge-container"
	ImageTypes_edge_installer  ImageTypes = "edge-installer"
	ImageTypes_gcp             ImageTypes = "gcp"
	ImageTypes_guest_image     ImageTypes = "guest-image"
	ImageTypes_image_installer ImageTypes = "image-installer"
	ImageTypes_vsphere         ImageTypes = "vsphere"
)

// List defines model for List.
type List struct {
	Kind  string `json:"kind"`
	Page  int    `json:"page"`
	Size  int    `json:"size"`
	Total int    `json:"total"`
}

// OSTree defines model for OSTree.
type OSTree struct {
	Ref *string `json:"ref,omitempty"`
	Url *string `json:"url,omitempty"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// PackageMetadata defines model for PackageMetadata.
type PackageMetadata struct {
	Arch      string  `json:"arch"`
	Epoch     *string `json:"epoch,omitempty"`
	Name      string  `json:"name"`
	Release   string  `json:"release"`
	Sigmd5    string  `json:"sigmd5"`
	Signature *string `json:"signature,omitempty"`
	Type      string  `json:"type"`
	Version   string  `json:"version"`
}

// Repository defines model for Repository.
type Repository struct {
	Baseurl    *string `json:"baseurl,omitempty"`
	Metalink   *string `json:"metalink,omitempty"`
	Mirrorlist *string `json:"mirrorlist,omitempty"`
	Rhsm       bool    `json:"rhsm"`
}

// Subscription defines model for Subscription.
type Subscription struct {
	ActivationKey string `json:"activation_key"`
	BaseUrl       string `json:"base_url"`
	Insights      bool   `json:"insights"`
	Organization  string `json:"organization"`
	ServerUrl     string `json:"server_url"`
}

// UploadOptions defines model for UploadOptions.
type UploadOptions interface{}

// UploadStatus defines model for UploadStatus.
type UploadStatus struct {
	Options interface{} `json:"options"`
	Status  string      `json:"status"`
	Type    UploadTypes `json:"type"`
}

// UploadTypes defines model for UploadTypes.
type UploadTypes string

// List of UploadTypes
const (
	UploadTypes_aws    UploadTypes = "aws"
	UploadTypes_aws_s3 UploadTypes = "aws.s3"
	UploadTypes_azure  UploadTypes = "azure"
	UploadTypes_gcp    UploadTypes = "gcp"
)

// User defines model for User.
type User struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference
	// Embedded fields due to inline allOf schema
	Groups *[]string `json:"groups,omitempty"`
	Key    *string   `json:"key,omitempty"`
	Name   string    `json:"name"`
}

// Page defines model for page.
type Page string

// Size defines model for size.
type Size string

// PostComposeJSONBody defines parameters for PostCompose.
type PostComposeJSONBody ComposeRequest

// GetErrorListParams defines parameters for GetErrorList.
type GetErrorListParams struct {

	// Page index
	Page *Page `json:"page,omitempty"`

	// Number of items in each page
	Size *Size `json:"size,omitempty"`
}

// PostComposeRequestBody defines body for PostCompose for application/json ContentType.
type PostComposeJSONRequestBody PostComposeJSONBody

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Create compose
	// (POST /compose)
	PostCompose(ctx echo.Context) error
	// The status of a compose
	// (GET /composes/{id})
	GetComposeStatus(ctx echo.Context, id string) error
	// Get the metadata for a compose.
	// (GET /composes/{id}/metadata)
	GetComposeMetadata(ctx echo.Context, id string) error
	// Get a list of all possible errors
	// (GET /errors)
	GetErrorList(ctx echo.Context, params GetErrorListParams) error
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// PostCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCompose(ctx echo.Context) error {
	var err error

	ctx.Set("Bearer.Scopes", []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCompose(ctx)
	return err
}

// GetComposeStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameter("simple", false, "id", ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set("Bearer.Scopes", []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeStatus(ctx, id)
	return err
}

// GetComposeMetadata converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeMetadata(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameter("simple", false, "id", ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set("Bearer.Scopes", []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeMetadata(ctx, id)
	return err
}

// GetErrorList converts echo context to params.
func (w *ServerInterfaceWrapper) GetErrorList(ctx echo.Context) error {
	var err error

	ctx.Set("Bearer.Scopes", []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetErrorListParams
	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", ctx.QueryParams(), &params.Page)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter page: %s", err))
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", ctx.QueryParams(), &params.Size)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter size: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetErrorList(ctx, params)
	return err
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameter("simple", false, "id", ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set("Bearer.Scopes", []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	ctx.Set("Bearer.Scopes", []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.POST("/compose", wrapper.PostCompose)
	router.GET("/composes/:id", wrapper.GetComposeStatus)
	router.GET("/composes/:id/metadata", wrapper.GetComposeMetadata)
	router.GET("/errors", wrapper.GetErrorList)
	router.GET("/errors/:id", wrapper.GetError)
	router.GET("/openapi", wrapper.GetOpenapi)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+xbe2/buLL/KoTOBbKLK/ntNDFQ7EnTnJ7sbZsiTndxbxMEtDS2uJVIlaTiOIW/+wUf",
	"kvWgY+dsdhcL5J/GNsmZ3wxnhjND9rsXsjRjFKgU3uS7l2GOU5DA7bcFqL8RiJCTTBJGvYn3CS8AERrB",
	"ved7cI/TLIHa9Duc5OBNvL63XvseUWu+5cBXnu9RnKoRPdP3RBhDitUSucrU70JyQhd6mSAPDt4f83QG",
	"HLE5IhJSgQhFgMMYWYJVNAWBEk2vtxWPnvsYnnUxqEmf/Do9Ox18zhKGowsNzcjPWQZcEsOfw0Jj/l6g",
	"8iYe5MEShAz6nt9k4Xsixhxul0TGtzgMWW63pFz9xesPhqPx4auj415/4N34ntaBA25JHHOOV5o2xZmI",
	"mbw1AlcxpaugGG2jWvseh2854RApAFYmN9abcjWb/QahVHyrmppKLHOHonBK6ohwSoJeeDTsvToevno1",
	"Hh+Po9HMpbEnqrghjOJb0tgCfjp83l1263MH822Ky3ni9p0qCzXJSf8h57BDOJLiBZQm0/BEnILyQxkD",
	"yjUZiJBe0EHnEqW5kGgGKKfkW67ChZ64IHdAEQfBch4CWnCWZ51rej5HigkiArGUSAkRmnOW6iVKFhDS",
	"RxhxTCOWIkYBzbCACDGKMPr8+fwtIuKaLoACxxKizjXdxAJj4RqYy4QSFmJpd7Au4Hs7gpYxcNBYNBUk",
	"YpYnkRaukBvTCKm9FBK45v9vtkSSoYQIiXCSoIKNmFzTWMpMTLrdiIWik5KQM8HmshOytAs0yEU3TEgX",
	"q+3pWt/66Y7A8rX+KQgTEiRYgpD/wA+F890qRrclk4OGApQ1Qq621u1FZjtu9XY8vtP1rdtDNc29uGJ5",
	"iOmlJfNOc3TFwnxWQrglURvU+VsFqTrtPwAzgnF0NBuEAZ4NRsFo1B8Gx71wHBz2B8PeIRz1jmHgQieB",
	"YiofwaVAmEn7obLmMic0QkQW3qJdFH1iXOJkH7spbEaSOwgiwiGUjK+685xGOAUqcSJao0HMloFkgWId",
	"GMgNJY3DVzAfzw6DfjicB6MI9wJ8OBgEvVnvsDcYHkevolc7A91GY+29bVlgxSt3RK5tkbEeuPaJBA28",
	"FQIuCKcqaRJwrg0AJ8nF3Jt8+e79F4e5N/H+0d0kVV2bNnQv9OJLmAMHGoK39lugozrY/mAI6rgP4Oh4",
	"FvQH0TDAo/FhMBocHo7Ho1Gv1+t5vjdnPMXSm3h5rpW5Q7DIIdDNRqQPIHGEJX5OwZiQHOA2ZGlKpNNl",
	"foixiH8sPGeWk0QiO93hfhkOv+KFod1MTfWIibuEhkkeEbpAH89+uTzxKvnSY/JYGqUiWtnU+jH9XZrj",
	"qm2SYS4kS8kDLs/ax0Cc1mevfS8iSgGzXLbSDR5DEhy5FGWsmG8gPcbyXE0u4DfNpsa9Sbgi/sYhn80r",
	"NCtR0t0pgoXg9mhLZ4sLtLaoDqVqd5WsPGNCLjiIJ2bklSi4S65pde7a93JhC7S9DPqzAL6PFfveGeeM",
	"P+fmhSwCpzbUJFw53B1JCRZGMY/HM82hnN4g7N5mLeV7YjxiP0n1bIdtFurfax+Mdl0bUbNTTcqN/N3p",
	"px0Z+ywPv4LcnsNhiuCeCKmi4vTq5OPbk8u3aCoZV1EzTLAQ6I0m0Wlm0PZLYDlsjTbuauEqBpPiS4Zy",
	"AWjOuM2JMsalzaB1URkhFUpyCeiMLgi1aVPnml6VKZQm1CgwVClq06Z3p59QxplSm4+WMQljVVjkAqJr",
	"WvC9mFpaJgnT7A2WDlLVCJNIZBCSOVHYbOVxTQ9CE+Z4gDMSXOe93jBUx67+BAfIKKNgh7CoJH4K9VMq",
	"k01l2ValEtGMV/LLUqYlSRKlmlK5klX1q0orq0/dGylVidV3EmnqRQbWQVMAVKSeYcLyqLNgbJGATjyF",
	"MR2dk3bL+sOWdFUl+hpimieSBBZ5MR2FCRMgpIKpJplc8Jr+YEuNwjyNYZbLflRqDmMmgCKcS5ZiSUKc",
	"JKumkiF/QrelUQOqPILNC71ouVExXeHVVOqW7DJfbZ6da3qGw7gwEq31kFGJiSpjC03xIguybJBC3kG/",
	"aAQm1xMIc5hcU4QCdKDOgsl3SDFJSLQ+mKATivQ3hKOIg1AmiCXikHEQKh5teIWKBGqI1UH/YhxZ7fno",
	"ACckhH/a72rPDzqWswB+R0I4MeueiMGwtiS28U5XAZOx9rbsnzjLRMZkZ2EXFWuqkHT98FRtWPmLZoTC",
	"1VBBlBIqnDqIWIoJnXw3fxVD7Z5omhMJyPyKfsg4STFf/dhmniSGoe6iqFPd7D6Wdm1TIxvXO0CMo4MG",
	"JrfXPW6aRJg1JjgoQ0WYrq5pod+6N33RycekZRWqrqvbw76b5/me2ba2mj3fswqu/viENGtb+9IeYq7S",
	"rjxjn6+29D17HN02SzwsQqARpjKYcUyiYNgbjvvDnUVchZy/q1StpfXt3isPYyIhlDlviHN/dHh7ONp+",
	"zpuf98jHr1YZ6ArGlIG71lxMr9QsLXHGBJGMN7Otx5ZfFotWrqTbnPa3LNurCKvnWq32cVV1Na00oLfY",
	"3hTbss3Enlzt/KLvODYC7kegZudN8YpKqY7VMFKGQvNUT8vDEIQSco5JYlSRAVVlt/YzktiPBpn5XLRK",
	"1bcbh4VV7KbCCi8VG93kUhEpWkBQ9gjsN32YAi9+IFRInCT6h0WYqX+VG5R+qv/WZt2JTOVTTlRFyVDf",
	"q6+EuiuY4jbMDhAqYWEKseJmqj0imcSJa6ixOZqpX16jmdsrs9jfWkH4nvUtxyXGvN1S6B51TQzoKl26",
	"AsHW+4c240al2EIQWwjtYONW7hatt5tdfqErzcGllGa/xxkjnSAgY1tGitPBkdQngIV7TJBFGo23DVFc",
	"xOgtZ55j4A64IPtU0TZsadibZRu4vlFCiVFFhUqkbZehWIC1jo1RlUVERDscohib3rXyWqCyGxEhu8rw",
	"jjaWp+gw0WWiW2t08sRljilInBD61c01Jar8Fp05RIxje4J2GF90i3U/qaj92owHw4Gq6QaHSu7X5Vm4",
	"E4JmkthAUQdRYlDDnRCoZELz/8lq+fVRoE5InFY4Y/Xv4cj8ovG9wQIupntg4bFIKzs/YywBTNs5kZrm",
	"8otpo0HVcIpQkjvTaPkKq/aNMoQcZKCGKkgzLMSS8cgFV231rdNm2iazh/SECrKIGzfokufgtxTie4wv",
	"MLV9vzr/QW/UGw6caZDKZIG3IVcbex2l3QrynZldDYnf1HKNaUVlFXFdO9nqGTEKezS9XK8c1v7ONc0r",
	"811LWk2tnTzaN9e6O/Z42s5+j/hFjrS/9HuuaFYbT5C9WKFE3+R7++VlPKd0W/K1T2JvENjM3p04+sWh",
	"Us16q+vamd1SdMSwTNVMoudCqBvaz9il1uVnvcTYuLMedL7XaRYXrTgoRBxANBiP+8fo5OTk5HT48QGf",
	"9pP/e3ve/3h1Nla/nX/k7/7njH/4X/LfHz58Xub/xpcnP6eX79n5w+V88O3tIHo7fui9ubrvHt67QLTr",
	"UFWf7355sqVevNEvnSDMOZGrqdKgUdEbwNwofaY//asIvz//elU8nNJB1cwr6ar4bZ5PETpn7Qbb1DaA",
	"JNO3frYRaxJy058QHc/3EhICNWmTfbF1kuEwBjTo9DybiJYn/XK57GA9rI9Xu1Z035+fnn2cngWDTq8T",
	"yzTRe0ikVtrF9I1mb6+xONKdToQzUsmHJt7A3l1QNTDxhp1ep6/zcBlrNXVtf1iHHyYcjfhTDlgCwojC",
	"EtnZPsqYSoEITpIVChkVtkPP5kjAHXBc6EKrx7as9bs30zIlHEWgltj2a/Ue5DzyJt4nJqQVzTN2AEK+",
	"YdHKXNLoBEx7VJYlxLRXu7/Z+5fNo7hHLyzr15/rur2pg9e8NMmY2gtFbdDrPzf388gwbqjcDKIYCyQk",
	"5hIitY2jXu/Z+NurnTbvc2pax3ani9dMhn//j+d/kktlJF+BIiIQMWgM9+Efz/0zxbmMGScP5hIiA67y",
	"NlQap0Ey+jOQfKVsSct9MEoY/xkm8JnCfQahhAiBmoNYGOZcuUU11upjrIiyX27WN74n8jTFqroqgkYR",
	"XNS6ItKI7ncSrfUp5rr3ewfS3KnoQ1nfACJ7+CPGNcUEFDRLTt8LaUsJkzwCgZYxyBi4mkyZoVXoUKcY",
	"EEHUjjfvQNYfBPi1l8Vf3K+mSsIGrGRooW8a9YtdFWM3D3bts6FqfKk+3332RzQ3reDVe+7gVfbhWhZU",
	"18tfFruKwPEStl7C1l5h66oReLbHL92DKbpvjwayYqKhOCeUiLgRvgDBPQ4lUhmn8mrCKOIgc04hQhGo",
	"KkggRquvi4uny+ay9ZFwVnYJXwLazoC2eUHXtq6r6lYWjzLM6/BiK1/i3Euc+3vEuVZsUgaNK4as4p0m",
	"LirxrRViNu/SWsHFJdlmSlffA21rHVXm6YuiP9T1NzK4rN28y2VzZJXx4mZ/jZsZQ//7ORkuDQgnCcqY",
	"EGSWQGlNGzfbXRRhatpMNCz/b4tBtnn2N1shfXS6HXW/DKCk+3tP/eGffIaXW/nioy8++hQfNWurpLVf",
	"lk3T7effhZ3ituo6WEtOeysiFCkd2NeRf8fM4VFx1uVlo4kz9W43zkhHLRcxsf8ZDGeka1626JY68KB4",
	"tdy9G3hNKT7YF4osykPzrNbw0vlEm5WQeAG/i+FU4gWhizabJ9LRuqbFQ0lvfbP+/wAAAP//6r7bvs0+",
	"AAA=",
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file.
func GetSwagger() (*openapi3.Swagger, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	swagger, err := openapi3.NewSwaggerLoader().LoadSwaggerFromData(buf.Bytes())
	if err != nil {
		return nil, fmt.Errorf("error loading Swagger: %s", err)
	}
	return swagger, nil
}
