// Package v2 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.8.2 DO NOT EDIT.
package v2

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

const (
	BearerScopes = "Bearer.Scopes"
)

// Defines values for ComposeStatusValue.
const (
	ComposeStatusValueFailure ComposeStatusValue = "failure"

	ComposeStatusValuePending ComposeStatusValue = "pending"

	ComposeStatusValueSuccess ComposeStatusValue = "success"
)

// Defines values for ImageStatusValue.
const (
	ImageStatusValueBuilding ImageStatusValue = "building"

	ImageStatusValueFailure ImageStatusValue = "failure"

	ImageStatusValuePending ImageStatusValue = "pending"

	ImageStatusValueRegistering ImageStatusValue = "registering"

	ImageStatusValueSuccess ImageStatusValue = "success"

	ImageStatusValueUploading ImageStatusValue = "uploading"
)

// Defines values for ImageTypes.
const (
	ImageTypesAws ImageTypes = "aws"

	ImageTypesAwsHaRhui ImageTypes = "aws-ha-rhui"

	ImageTypesAwsRhui ImageTypes = "aws-rhui"

	ImageTypesAwsSapRhui ImageTypes = "aws-sap-rhui"

	ImageTypesAzure ImageTypes = "azure"

	ImageTypesEdgeCommit ImageTypes = "edge-commit"

	ImageTypesEdgeContainer ImageTypes = "edge-container"

	ImageTypesEdgeInstaller ImageTypes = "edge-installer"

	ImageTypesGcp ImageTypes = "gcp"

	ImageTypesGuestImage ImageTypes = "guest-image"

	ImageTypesImageInstaller ImageTypes = "image-installer"

	ImageTypesVsphere ImageTypes = "vsphere"
)

// Defines values for UploadStatusValue.
const (
	UploadStatusValueFailure UploadStatusValue = "failure"

	UploadStatusValuePending UploadStatusValue = "pending"

	UploadStatusValueRunning UploadStatusValue = "running"

	UploadStatusValueSuccess UploadStatusValue = "success"
)

// Defines values for UploadTypes.
const (
	UploadTypesAws UploadTypes = "aws"

	UploadTypesAwsS3 UploadTypes = "aws.s3"

	UploadTypesAzure UploadTypes = "azure"

	UploadTypesGcp UploadTypes = "gcp"
)

// AWSEC2UploadOptions defines model for AWSEC2UploadOptions.
type AWSEC2UploadOptions struct {
	Region            string   `json:"region"`
	ShareWithAccounts []string `json:"share_with_accounts"`
	SnapshotName      *string  `json:"snapshot_name,omitempty"`
}

// AWSEC2UploadStatus defines model for AWSEC2UploadStatus.
type AWSEC2UploadStatus struct {
	Ami    string `json:"ami"`
	Region string `json:"region"`
}

// AWSS3UploadOptions defines model for AWSS3UploadOptions.
type AWSS3UploadOptions struct {
	Region string `json:"region"`
}

// AWSS3UploadStatus defines model for AWSS3UploadStatus.
type AWSS3UploadStatus struct {
	Url string `json:"url"`
}

// AzureUploadOptions defines model for AzureUploadOptions.
type AzureUploadOptions struct {
	// Name of the uploaded image. It must be unique in the given resource group.
	// If name is omitted from the request, a random one based on a UUID is
	// generated.
	ImageName *string `json:"image_name,omitempty"`

	// Location where the image should be uploaded and registered.
	// How to list all locations:
	// https://docs.microsoft.com/en-us/cli/azure/account?view=azure-cli-latest#az_account_list_locations'
	Location string `json:"location"`

	// Name of the resource group where the image should be uploaded.
	ResourceGroup string `json:"resource_group"`

	// ID of subscription where the image should be uploaded.
	SubscriptionId string `json:"subscription_id"`

	// ID of the tenant where the image should be uploaded.
	// How to find it in the Azure Portal:
	// https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-how-to-find-tenant
	TenantId string `json:"tenant_id"`
}

// AzureUploadStatus defines model for AzureUploadStatus.
type AzureUploadStatus struct {
	ImageName string `json:"image_name"`
}

// ComposeId defines model for ComposeId.
type ComposeId struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// ComposeLogs defines model for ComposeLogs.
type ComposeLogs struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageBuilds []interface{} `json:"image_builds"`
	Koji        *KojiLogs     `json:"koji,omitempty"`
}

// ComposeManifests defines model for ComposeManifests.
type ComposeManifests struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Manifests []interface{} `json:"manifests"`
}

// ComposeMetadata defines model for ComposeMetadata.
type ComposeMetadata struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// ID (hash) of the built commit
	OstreeCommit *string `json:"ostree_commit,omitempty"`

	// Package list including NEVRA
	Packages *[]PackageMetadata `json:"packages,omitempty"`
}

// ComposeRequest defines model for ComposeRequest.
type ComposeRequest struct {
	Customizations *Customizations `json:"customizations,omitempty"`
	Distribution   string          `json:"distribution"`
	ImageRequest   *ImageRequest   `json:"image_request,omitempty"`
	ImageRequests  *[]ImageRequest `json:"image_requests,omitempty"`
	Koji           *Koji           `json:"koji,omitempty"`
}

// ComposeStatus defines model for ComposeStatus.
type ComposeStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageStatus   ImageStatus        `json:"image_status"`
	ImageStatuses *[]ImageStatus     `json:"image_statuses,omitempty"`
	KojiStatus    *KojiStatus        `json:"koji_status,omitempty"`
	Status        ComposeStatusValue `json:"status"`
}

// ComposeStatusValue defines model for ComposeStatusValue.
type ComposeStatusValue string

// Customizations defines model for Customizations.
type Customizations struct {
	Packages *[]string `json:"packages,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will only be used to depsolve and retrieve packages
	// for the OS itself (they will not be available for the build root or
	// any other part of the build process). The package_sets field for these
	// repositories is ignored.
	PayloadRepositories *[]Repository `json:"payload_repositories,omitempty"`
	Subscription        *Subscription `json:"subscription,omitempty"`
	Users               *[]User       `json:"users,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Code        string `json:"code"`
	OperationId string `json:"operation_id"`
	Reason      string `json:"reason"`
}

// ErrorList defines model for ErrorList.
type ErrorList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Items []Error `json:"items"`
}

// GCPUploadOptions defines model for GCPUploadOptions.
type GCPUploadOptions struct {
	// Name of an existing STANDARD Storage class Bucket.
	Bucket string `json:"bucket"`

	// The name to use for the imported and shared Compute Engine image.
	// The image name must be unique within the GCP project, which is used
	// for the OS image upload and import. If not specified a random
	// 'composer-api-<uuid>' string is used as the image name.
	ImageName *string `json:"image_name,omitempty"`

	// The GCP region where the OS image will be imported to and shared from.
	// The value must be a valid GCP location. See https://cloud.google.com/storage/docs/locations.
	// If not specified, the multi-region location closest to the source
	// (source Storage Bucket location) is chosen automatically.
	Region string `json:"region"`

	// List of valid Google accounts to share the imported Compute Engine image with.
	// Each string must contain a specifier of the account type. Valid formats are:
	//   - 'user:{emailid}': An email address that represents a specific
	//     Google account. For example, 'alice@example.com'.
	//   - 'serviceAccount:{emailid}': An email address that represents a
	//     service account. For example, 'my-other-app@appspot.gserviceaccount.com'.
	//   - 'group:{emailid}': An email address that represents a Google group.
	//     For example, 'admins@example.com'.
	//   - 'domain:{domain}': The G Suite domain (primary) that represents all
	//     the users of that domain. For example, 'google.com' or 'example.com'.
	// If not specified, the imported Compute Engine image is not shared with any
	// account.
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// GCPUploadStatus defines model for GCPUploadStatus.
type GCPUploadStatus struct {
	ImageName string `json:"image_name"`
	ProjectId string `json:"project_id"`
}

// ImageRequest defines model for ImageRequest.
type ImageRequest struct {
	Architecture  string         `json:"architecture"`
	ImageType     ImageTypes     `json:"image_type"`
	Ostree        *OSTree        `json:"ostree,omitempty"`
	Repositories  []Repository   `json:"repositories"`
	UploadOptions *UploadOptions `json:"upload_options,omitempty"`
}

// ImageStatus defines model for ImageStatus.
type ImageStatus struct {
	Status       ImageStatusValue `json:"status"`
	UploadStatus *UploadStatus    `json:"upload_status,omitempty"`
}

// ImageStatusValue defines model for ImageStatusValue.
type ImageStatusValue string

// ImageTypes defines model for ImageTypes.
type ImageTypes string

// Koji defines model for Koji.
type Koji struct {
	Name    string `json:"name"`
	Release string `json:"release"`
	Server  string `json:"server"`
	TaskId  int    `json:"task_id"`
	Version string `json:"version"`
}

// KojiLogs defines model for KojiLogs.
type KojiLogs struct {
	Import interface{} `json:"import"`
	Init   interface{} `json:"init"`
}

// KojiStatus defines model for KojiStatus.
type KojiStatus struct {
	BuildId *int `json:"build_id,omitempty"`
}

// List defines model for List.
type List struct {
	Kind  string `json:"kind"`
	Page  int    `json:"page"`
	Size  int    `json:"size"`
	Total int    `json:"total"`
}

// OSTree defines model for OSTree.
type OSTree struct {
	Ref *string `json:"ref,omitempty"`
	Url *string `json:"url,omitempty"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// PackageMetadata defines model for PackageMetadata.
type PackageMetadata struct {
	Arch      string  `json:"arch"`
	Epoch     *string `json:"epoch,omitempty"`
	Name      string  `json:"name"`
	Release   string  `json:"release"`
	Sigmd5    string  `json:"sigmd5"`
	Signature *string `json:"signature,omitempty"`
	Type      string  `json:"type"`
	Version   string  `json:"version"`
}

// Repository defines model for Repository.
type Repository struct {
	Baseurl    *string `json:"baseurl,omitempty"`
	CheckGpg   *bool   `json:"check_gpg,omitempty"`
	GpgKey     *string `json:"gpg_key,omitempty"`
	IgnoreSsl  *bool   `json:"ignore_ssl,omitempty"`
	Metalink   *string `json:"metalink,omitempty"`
	Mirrorlist *string `json:"mirrorlist,omitempty"`

	// Naming package sets for a repository assigns it to a specific part
	// (pipeline) of the build process.
	PackageSets *[]string `json:"package_sets,omitempty"`
	Rhsm        bool      `json:"rhsm"`
}

// Subscription defines model for Subscription.
type Subscription struct {
	ActivationKey string `json:"activation_key"`
	BaseUrl       string `json:"base_url"`
	Insights      bool   `json:"insights"`
	Organization  string `json:"organization"`
	ServerUrl     string `json:"server_url"`
}

// UploadOptions defines model for UploadOptions.
type UploadOptions interface{}

// UploadStatus defines model for UploadStatus.
type UploadStatus struct {
	Options interface{}       `json:"options"`
	Status  UploadStatusValue `json:"status"`
	Type    UploadTypes       `json:"type"`
}

// UploadStatusValue defines model for UploadStatusValue.
type UploadStatusValue string

// UploadTypes defines model for UploadTypes.
type UploadTypes string

// User defines model for User.
type User struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Groups *[]string `json:"groups,omitempty"`
	Key    *string   `json:"key,omitempty"`
	Name   string    `json:"name"`
}

// Page defines model for page.
type Page string

// Size defines model for size.
type Size string

// PostComposeJSONBody defines parameters for PostCompose.
type PostComposeJSONBody ComposeRequest

// GetErrorListParams defines parameters for GetErrorList.
type GetErrorListParams struct {
	// Page index
	Page *Page `json:"page,omitempty"`

	// Number of items in each page
	Size *Size `json:"size,omitempty"`
}

// PostComposeJSONRequestBody defines body for PostCompose for application/json ContentType.
type PostComposeJSONRequestBody PostComposeJSONBody

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Create compose
	// (POST /compose)
	PostCompose(ctx echo.Context) error
	// The status of a compose
	// (GET /composes/{id})
	GetComposeStatus(ctx echo.Context, id string) error
	// Get logs for a compose.
	// (GET /composes/{id}/logs)
	GetComposeLogs(ctx echo.Context, id string) error
	// Get the manifests for a compose.
	// (GET /composes/{id}/manifests)
	GetComposeManifests(ctx echo.Context, id string) error
	// Get the metadata for a compose.
	// (GET /composes/{id}/metadata)
	GetComposeMetadata(ctx echo.Context, id string) error
	// Get a list of all possible errors
	// (GET /errors)
	GetErrorList(ctx echo.Context, params GetErrorListParams) error
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// PostCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCompose(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCompose(ctx)
	return err
}

// GetComposeStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeStatus(ctx, id)
	return err
}

// GetComposeLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeLogs(ctx, id)
	return err
}

// GetComposeManifests converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeManifests(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeManifests(ctx, id)
	return err
}

// GetComposeMetadata converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeMetadata(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeMetadata(ctx, id)
	return err
}

// GetErrorList converts echo context to params.
func (w *ServerInterfaceWrapper) GetErrorList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetErrorListParams
	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", ctx.QueryParams(), &params.Page)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter page: %s", err))
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", ctx.QueryParams(), &params.Size)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter size: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetErrorList(ctx, params)
	return err
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.POST(baseURL+"/compose", wrapper.PostCompose)
	router.GET(baseURL+"/composes/:id", wrapper.GetComposeStatus)
	router.GET(baseURL+"/composes/:id/logs", wrapper.GetComposeLogs)
	router.GET(baseURL+"/composes/:id/manifests", wrapper.GetComposeManifests)
	router.GET(baseURL+"/composes/:id/metadata", wrapper.GetComposeMetadata)
	router.GET(baseURL+"/errors", wrapper.GetErrorList)
	router.GET(baseURL+"/errors/:id", wrapper.GetError)
	router.GET(baseURL+"/openapi", wrapper.GetOpenapi)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+w8a2/buLJ/hdC5QFpcyXb8SBMDiz1pmu3JbtsUSboH9zaBQUtji41EakkqjlPkv1/w",
	"IVkP+pHd7J57DvKlsS1yZjic94z63QtZmjEKVApv/N3LMMcpSOD22xzU3whEyEkmCaPe2PuM54AIjeDe",
	"8z24x2mWQG35HU5y8Mbevvf46HtE7fktB770fI/iVD3RK31PhDGkWG2Ry0z9LiQndK63CfLgwP0pT6fA",
	"EZshIiEViFAEOIyRBVilpgBQUtPrraVHr91Ez2PxUIM+/ufl6Un/S5YwHJ1r0sz5OcuAS2Lwc5hrmr8X",
	"VHljD/JgAUIG+57fROF7IsYcJgsi4wkOQ5bbKyl3f/X2+4Ph6ODN4VFvv+/d+J7mgYPcEjjmHC81bIoz",
	"ETM5MQeu0pQug+Jpm6pH3+PwW044RIoAeyY3rTflbjb9BqFUeKucupRY5g5G4ZTUKcIpCXrh4aD35mjw",
	"5s1odDSKhlMXx57I4sZhFN4SxhriLwfPe8tufm5Bvo5xOU/culNFoRY54T/kHLYcjqR4DqXINDQRp6D0",
	"UMaAcg0GIqQ3dNCZRGkuJJoCyin5LVfmQi+ckzugiINgOQ8BzTnLs841PZshhQQRgVhKpIQIzThL9RZ1",
	"FhDSRxhxTCOWIkYBTbGACDGKMPry5ewdIuKazoECxxKizjVd2QIj4ZowlwglLMTS3mD9gB/sE7SIgYOm",
	"RUNBImZ5EunDFefGNELqLoUErvH/gy2QZCghQiKcJKhAI8bXNJYyE+NuN2Kh6KQk5EywmeyELO0CDXLR",
	"DRPSxep6ula3frwjsPhB/xSECQkSLEHIv+GHQvkmCtGkRLLXYICSRsjV1bq1yFzHRF/H5puuX90OrGne",
	"xRXLQ0wvLJj3GqPLFubTkoQJidpEnb1TJFWX/Q5ihjCKDqf9MMDT/jAYDvcHwVEvHAUH+/1B7wAOe0fQ",
	"d1EngWIqN9CliDCLdqPKisuM0AgRWWiLVlH0mXGJk13kppAZSe4giAiHUDK+7M5yGuEUqMSJaD0NYrYI",
	"JAsU6sCQ3GDSKHwDs9H0INgPB7NgGOFegA/6/aA37R30+oOj6E30ZquhW3GsfbctCaxo5RbLtc4y1g3X",
	"LpagQW8FgIuEExU0CTjTAoCT5Hzmjb9+9/6Lw8wbe3/rroKqrg0buud68wXMgAMNwXv0W0RHdWL3+wNQ",
	"7j6Aw6NpsN+PBgEejg6CYf/gYDQaDnu9Xs/zvRnjKZbe2MtzzcwtB4scB7pZHekDm4tnPZRm5DQnSVSN",
	"VMrA5JZ9095/E5Zf2Dei6XLfkgW+8VgfMSUzEPJZz5ZWgdYP1iB0tXIzlSBxhCV+TiKZkBxgErI0JdJp",
	"r17FWMSvC7OluCmRXe6wfRkOb/HcwG7mBfqJcXqEhkkeETpHn05/vTj2KsHqpvNYGCUjWqHs4yb+XZhY",
	"oW0PwlxIlpIHXAY6m4g4qa9+9L2IKAZMc9mK9XgMSXDoYpQRTr4iaRPKM7W4IL+52SjSLuxrgvm92tYS",
	"4BoDKhxfGeDnNRiihLv1uJaEkmlmKzyRaSsoLp7tSI9i3QrQbntqjPxV56pN5ltA9QNutiRVcEpeaZ5q",
	"SHkYglCgZpgkOVeOMAOq9FTBW4n1amFLrk9aulS/wKqBqOSuGRNyzkE8LW/N8FL5+QmHjAkiGScuy3N6",
	"LzlG1TVoxjgqKEEig5DMiEpQKKrbgg66ikHANa3tXpAkQYwmSx2nqVRDMhRBJlhyBzbal5zAHZRIrqlC",
	"qSzo+SUiUkAyQ69kDEsDjDKdDuE7TBI8TQAVq7X3QpwxiRi/ppguEZMxKOq5rBrlCGWcqUt5rWkuEE8E",
	"SIFmBJKogNk6DhGIzCnjRQS8k1pcFBCWzoJCJYjbBumyuvbR93Jh60s70fFFAN/FD/jeKeeMP6ctClkE",
	"TjFVi3AlN3HkVFgYxmwOxzSGcnkDsFvD9Sk/EONTdjupXu0wtQX7d7oHw13XRdRCMg3KTfn7k89bCg7T",
	"PLwFuT4FxRTBPRFSxRWXV8ef3h1fvEOXknEVd4QJFgK91SA6zQKA/RJYDGv9tbvYofRNVygkU+agVF6S",
	"ZoxLWwDQNbEIKQucS0CndE6ozfo61/SqzAA1oEZ9ZEFkbLO+9yeflaYrtvloEZMwVvqrjFDdxGhYJofU",
	"6A0tHXQ208ZmZfOKwsk13QuNd+ABzkhwnfd6g1BlDfoT7CHDjAIdwqKStyqqn1JYWRXG2qxURzTPK+lx",
	"eSZtL6cV5kpW5e+Ms9TyU5d2S1Zi9Z1EGnqRQHbQJQAqMucwYXnUmTM2T0DnzcKIjk6pu2X5xFakqkz0",
	"NYlpnkgSWMqL5ShMmAAhFZlqkUllr+krWykpxNMIZrnttWJzGDMBFOFcshRLEuIkWTaZDPkTisWNEpaK",
	"xNms4Is+NyqWK3o1lLoku8RXi2fnmp7iMC6ERHM9ZFRiQhEuOcULl2XRIEV5B/2qKTCpqkCYw/iaIhSg",
	"PeULxt8hxSQh0ePeGB1TpL8hHEUchBJBLJVv5yCUPVrhChUI1DhWB/3EOLLc89EeTkgIf7ff1Z3vdSxm",
	"AfyOhHBs9j2RBoPagliHO10G2pUHOMv+jrNMZEx25nZTsadKki5/PJUb9vxFLVXR1WBBlBIqnDyIWIoJ",
	"HX83fxVCrZ7oMicSkPkVvco4STFfvm4jTxKDUBeBlVc3t4+l3dvkyEr19hDjaK9Bk1vrNosmEWaPMQ5K",
	"UBGmy2ta8LeuTV918DFuSYXnew152PXyPN8z19Zms+d7lsHVH58Q/67rvlgn5qpMlT72+Upjvmfd0aRZ",
	"ocIiBBphKoMpxyQKBr3BaH+wtQZVAedvq7TVMtp264iHMZEQSpXK1Ei7PzyYHAzX+3nz8w6J4dUyA53O",
	"mULKtj3nl1dqlT5xPWV5hqDbePsJy3YqY9RjrVb3q8q6GlcapN8Ut7BOop6cq9sstzzPbgBqYr0mRW7Q",
	"+qT8V6kVSexHQ5n5XDR2bJLcEqiKmFRQ4YVCgxci4HFO7McYV78JnJVfHwwxEM0hKItv9pv2scCLHwgV",
	"EieJ/mEeZupfpR2l+uq/tVV3IlNhlpP6X2xJqH6nbfvwE0SM4+BEhVDBWyzWBH0JqEe1nf1ev9c76r3p",
	"9JyBDPA74PUdRbx2y76Rzkwjtjajw/hc/xzn01rtmyfORg0Wt02rNeyXCwmVMDfZ5R1w0SruDbZ3cC35",
	"K1R2pmAFccUVl30ra9sOQ63cnjf+rmcWdO22lWxRLSZ25Trw6/RWi/su3HHl2kUCWgd5S6g7Hy5GQ9qM",
	"L8Y02k8kkzhxPWpwQSP1y5kSM8phNvtr81Hfs5ba0dGftUu83cOu8ShdpYIuUVvbjG8jbtQdWhTEloS2",
	"63Izdw3X250fv+CVxuBiSrP+7vS4TiIgY2ueFLZkk7VomwUyT6PRukcUFx5/TQTleFDR8C29SuME16qx",
	"b5hQ0qicTsVvt/UMC7DS0TZxYUQ7HKIYm0auMvZAZTciQnaV4B2uJE/BYaLLRHcHyxfGEN5O5tm8ct4p",
	"YwlgXYKbZ/PJLSzdUqZLhRMhEvfeFCROCL11HyglnDMuHGa72PejCi9+MM+DQf867/X6B4qlP5RB27bT",
	"GSSJtUF1Ikoa1ONOCFQyofH/aC/wh8NAhXI4rWDG6t+DoflF06dc3PnlDrRU67DOypXKlu0iZIq1jKNK",
	"uXqJsFAyLRDRRYRVgqtrwNf0VUYySAiF1856cCvF0U89FbE+rdjOY5G6rryZhqhlLuNx2agJNyxHKMmd",
	"qW1ayavPoEHIQQbqUYXnGRZiwXjkYrzSh4lTsdp6tcM9EirIPG7M3Emeg+/QAcbnmNoeQjPaGfYG/eH6",
	"UKdNcrWW3lHcrVC+NQCpUeI3uVxDWmFZ5bium2yVaRmFHerMrrnIR3/rnuaQ3bYtrTryVhztWTddkN6c",
	"KbM/cvyyDbjz6Xfc0Uzwn3D2YsfNzs3J6r4ya9sldTYbbe68rp1pHW3B5+aNPDF74zml61K0KjmuHK0j",
	"BmUyZVIxJxQBz9pe0nWjem1gZRT0Q+eccKtB3bSmQsQBRP3RaP8IHR8fH58MPj3gk/3kf9+d7X+6Oh2p",
	"384+8fe/nPKP/0P+++PHL4v8H/ji+Of04gM7e7iY9X9714/ejR56b6/uuwf3LiLaCWIugG/Pl9YUem70",
	"hDWEOSdyeak4aFj0FjA3TJ/qTz8VRvznf14VA9vaNJt1JVzlBczYNqEz1nbLl7ZyK5n1pbqDYlJmU1gU",
	"Hc/3EhICNRGqnRQ/znAYA+rrZFZb8jLyWSwWHawf63DD7hXdD2cnp58uT4N+p9eJZZroOyRSM+388q1G",
	"b9v2HOkWBcIZqYSeY69vm45UPRh7g06vs69THhlrNnVtY0cbMSYcHbQTDlgCwojCAtnVPsqYijYJTpIl",
	"ChkVtrXGZkjAHXBc8EKzx/aa9Ly96XUQjiJQW2zfpNrAPIu8sfeZCWmP5hk5ACHfsmhpuqs61tUalWUJ",
	"MX2R7jfbOF0N4+8wPlHOvNTlTblvM+GaMWpnQvq9/efGfhYZxA2Wm4coxgIJibmESF3jsNd7Nvy2J9vG",
	"fUZNz8fedDFFbfDv//n4j3OphOQWqB4+MNQY7IM/H/sXinMZM04eTPcwA66iP1QKp6Fk+FdQckvZgpb3",
	"YJgw+itE4AuF+wxCCRECtQaxMMy5UouqrdVurLCyX28eb3xP5GmKVSJbGI3CuKh9haUR3e8ketRezNWw",
	"fw/SNEO1J9ete2QdNGJcQ0xAkWbB6YaulpQwySMQaBGDnoJhXLd3FKyChzoMgAiitr15D7I+mObX3mj6",
	"6p7WLgEbYiVDcz0ioN8UUjZ29aKQHVeu2pfqa0PPPrx70zJevec2XmVFvSVBdb78y2xXYThezNaL2drJ",
	"bF01DM96+9VNbOn99xixGaFExBUbhjaaMCJXlsvXARVOBEMpSIxUkKoMAWEU4SnLZfGyTZ7ITVZOdw5e",
	"bNxWG2ffHmgJm5IUJQLlQJd5Qa2MjwlFlOkqHAnzBHM7wYJeyZjl89gO1vx8ef7pdcdtHyXcy26WYNIg",
	"2vGC6W5WcPhcCFw6/lhVo/d6Wmle1CsLKXepUe1NiI26VK7cQZ0uQOacCv3CX7FPE6NTEDv+QatvCXaQ",
	"HlEqF4dMK5YoZrPs9UUwIxQihCWqJm9M6FzQFKsx7drvQQGuM9qgiqs3TF70cas+rpi1Rilr191SzP9M",
	"Xaurxw5KV2nSbdY5u9CoXEvPzCwl3ONQ1hwR1+oHEYogAxopPazqWvG6r5nw26QZBZ0virFdMcoXn9bo",
	"RXGVT9GLlxj9JUb//xajt2yTy95p4NWYomViVi9DtIyL62SrJV09LrKueVJZp+dJ/lTVX53BJe3mdUo2",
	"Q5YZL2r2r1EzI+j/fkqGSwHCSYIyJgSZJlBK00rNthf0MDUtEhqW/x+EoWz1rsl0ibTrdCvqbhFACfeP",
	"ev3BX+zDy6t80dEXHX2Kjpq9VdBaL8uG33r/d26XuKW6TqwFp7VV5c2KBzYj/neMHDYe57Ect3HZmY/2",
	"tRYW5aF5F6sc4623dHFGOgqPiIn9n1ZwRrpmwFrXBoAHxTt13bu+jicajWaJ54TONyEQEs/hD6LRTKTF",
	"azclmm1wbh7/LwAA//8bFLwoAU4AAA==",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
