// Package v2 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.8.2 DO NOT EDIT.
package v2

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

const (
	BearerScopes = "Bearer.Scopes"
)

// Defines values for ComposeStatusValue.
const (
	ComposeStatusValueFailure ComposeStatusValue = "failure"

	ComposeStatusValuePending ComposeStatusValue = "pending"

	ComposeStatusValueSuccess ComposeStatusValue = "success"
)

// Defines values for ImageStatusValue.
const (
	ImageStatusValueBuilding ImageStatusValue = "building"

	ImageStatusValueFailure ImageStatusValue = "failure"

	ImageStatusValuePending ImageStatusValue = "pending"

	ImageStatusValueRegistering ImageStatusValue = "registering"

	ImageStatusValueSuccess ImageStatusValue = "success"

	ImageStatusValueUploading ImageStatusValue = "uploading"
)

// Defines values for ImageTypes.
const (
	ImageTypesAws ImageTypes = "aws"

	ImageTypesAwsHaRhui ImageTypes = "aws-ha-rhui"

	ImageTypesAwsRhui ImageTypes = "aws-rhui"

	ImageTypesAwsSapRhui ImageTypes = "aws-sap-rhui"

	ImageTypesAzure ImageTypes = "azure"

	ImageTypesAzureRhui ImageTypes = "azure-rhui"

	ImageTypesEdgeCommit ImageTypes = "edge-commit"

	ImageTypesEdgeContainer ImageTypes = "edge-container"

	ImageTypesEdgeInstaller ImageTypes = "edge-installer"

	ImageTypesGcp ImageTypes = "gcp"

	ImageTypesGcpRhui ImageTypes = "gcp-rhui"

	ImageTypesGuestImage ImageTypes = "guest-image"

	ImageTypesImageInstaller ImageTypes = "image-installer"

	ImageTypesIotCommit ImageTypes = "iot-commit"

	ImageTypesIotContainer ImageTypes = "iot-container"

	ImageTypesIotInstaller ImageTypes = "iot-installer"

	ImageTypesIotRawImage ImageTypes = "iot-raw-image"

	ImageTypesVsphere ImageTypes = "vsphere"
)

// Defines values for UploadStatusValue.
const (
	UploadStatusValueFailure UploadStatusValue = "failure"

	UploadStatusValuePending UploadStatusValue = "pending"

	UploadStatusValueRunning UploadStatusValue = "running"

	UploadStatusValueSuccess UploadStatusValue = "success"
)

// Defines values for UploadTypes.
const (
	UploadTypesAws UploadTypes = "aws"

	UploadTypesAwsS3 UploadTypes = "aws.s3"

	UploadTypesAzure UploadTypes = "azure"

	UploadTypesContainer UploadTypes = "container"

	UploadTypesGcp UploadTypes = "gcp"
)

// AWSEC2CloneCompose defines model for AWSEC2CloneCompose.
type AWSEC2CloneCompose struct {
	Region            string    `json:"region"`
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// AWSEC2UploadOptions defines model for AWSEC2UploadOptions.
type AWSEC2UploadOptions struct {
	Region            string   `json:"region"`
	ShareWithAccounts []string `json:"share_with_accounts"`
	SnapshotName      *string  `json:"snapshot_name,omitempty"`
}

// AWSEC2UploadStatus defines model for AWSEC2UploadStatus.
type AWSEC2UploadStatus struct {
	Ami    string `json:"ami"`
	Region string `json:"region"`
}

// AWSS3UploadOptions defines model for AWSS3UploadOptions.
type AWSS3UploadOptions struct {
	// If set to false (the default value), a long, obfuscated URL
	// is returned. Its expiration might be sooner than for other upload
	// targets.
	//
	// If set to true, a shorter URL is returned and
	// its expiration is the same as for the other upload targets.
	Public *bool  `json:"public,omitempty"`
	Region string `json:"region"`
}

// AWSS3UploadStatus defines model for AWSS3UploadStatus.
type AWSS3UploadStatus struct {
	Url string `json:"url"`
}

// AzureUploadOptions defines model for AzureUploadOptions.
type AzureUploadOptions struct {
	// Name of the uploaded image. It must be unique in the given resource group.
	// If name is omitted from the request, a random one based on a UUID is
	// generated.
	ImageName *string `json:"image_name,omitempty"`

	// Location of the provided resource_group, where the image should be uploaded and registered.
	// How to list all locations:
	// https://docs.microsoft.com/en-us/cli/azure/account?view=azure-cli-latest#az_account_list_locations'
	// If the location is not specified, it is deducted from the provided resource_group.
	Location *string `json:"location,omitempty"`

	// Name of the resource group where the image should be uploaded.
	ResourceGroup string `json:"resource_group"`

	// ID of subscription where the image should be uploaded.
	SubscriptionId string `json:"subscription_id"`

	// ID of the tenant where the image should be uploaded.
	// How to find it in the Azure Portal:
	// https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-how-to-find-tenant
	TenantId string `json:"tenant_id"`
}

// AzureUploadStatus defines model for AzureUploadStatus.
type AzureUploadStatus struct {
	ImageName string `json:"image_name"`
}

// CloneComposeBody defines model for CloneComposeBody.
type CloneComposeBody interface{}

// CloneComposeResponse defines model for CloneComposeResponse.
type CloneComposeResponse struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// CloneStatus defines model for CloneStatus.
type CloneStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/UploadStatus)
	UploadStatus `yaml:",inline"`
}

// ComposeId defines model for ComposeId.
type ComposeId struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// ComposeLogs defines model for ComposeLogs.
type ComposeLogs struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageBuilds []interface{} `json:"image_builds"`
	Koji        *KojiLogs     `json:"koji,omitempty"`
}

// ComposeManifests defines model for ComposeManifests.
type ComposeManifests struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Manifests []interface{} `json:"manifests"`
}

// ComposeMetadata defines model for ComposeMetadata.
type ComposeMetadata struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// ID (hash) of the built commit
	OstreeCommit *string `json:"ostree_commit,omitempty"`

	// Package list including NEVRA
	Packages *[]PackageMetadata `json:"packages,omitempty"`
}

// ComposeRequest defines model for ComposeRequest.
type ComposeRequest struct {
	Customizations *Customizations `json:"customizations,omitempty"`
	Distribution   string          `json:"distribution"`
	ImageRequest   *ImageRequest   `json:"image_request,omitempty"`
	ImageRequests  *[]ImageRequest `json:"image_requests,omitempty"`
	Koji           *Koji           `json:"koji,omitempty"`
}

// ComposeStatus defines model for ComposeStatus.
type ComposeStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageStatus   ImageStatus        `json:"image_status"`
	ImageStatuses *[]ImageStatus     `json:"image_statuses,omitempty"`
	KojiStatus    *KojiStatus        `json:"koji_status,omitempty"`
	Status        ComposeStatusValue `json:"status"`
}

// ComposeStatusError defines model for ComposeStatusError.
type ComposeStatusError struct {
	Details *interface{} `json:"details,omitempty"`
	Id      int          `json:"id"`
	Reason  string       `json:"reason"`
}

// ComposeStatusValue defines model for ComposeStatusValue.
type ComposeStatusValue string

// Container defines model for Container.
type Container struct {
	// Name to use for the container from the image
	Name   *string `json:"name,omitempty"`
	Source string  `json:"source"`

	// Control TLS verifification
	TlsVerify *bool `json:"tls_verify,omitempty"`
}

// ContainerUploadOptions defines model for ContainerUploadOptions.
type ContainerUploadOptions struct {
	// Name for the created container image
	Name *string `json:"name,omitempty"`

	// Tag for the created container image
	Tag *string `json:"tag,omitempty"`
}

// ContainerUploadStatus defines model for ContainerUploadStatus.
type ContainerUploadStatus struct {
	// Digest of the manifest of the uploaded container on the registry
	Digest string `json:"digest"`

	// FQDN of the uploaded image
	Url string `json:"url"`
}

// Customizations defines model for Customizations.
type Customizations struct {
	Containers *[]Container  `json:"containers,omitempty"`
	Filesystem *[]Filesystem `json:"filesystem,omitempty"`
	Packages   *[]string     `json:"packages,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will only be used to depsolve and retrieve packages
	// for the OS itself (they will not be available for the build root or
	// any other part of the build process). The package_sets field for these
	// repositories is ignored.
	PayloadRepositories *[]Repository `json:"payload_repositories,omitempty"`
	Services            *struct {
		// List of services to disable by default
		Disabled *[]string `json:"disabled,omitempty"`

		// List of services to enable by default
		Enabled *[]string `json:"enabled,omitempty"`
	} `json:"services,omitempty"`
	Subscription *Subscription `json:"subscription,omitempty"`
	Users        *[]User       `json:"users,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Code        string       `json:"code"`
	Details     *interface{} `json:"details,omitempty"`
	OperationId string       `json:"operation_id"`
	Reason      string       `json:"reason"`
}

// ErrorList defines model for ErrorList.
type ErrorList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Items []Error `json:"items"`
}

// Filesystem defines model for Filesystem.
type Filesystem struct {
	MinSize    uint64 `json:"min_size"`
	Mountpoint string `json:"mountpoint"`
}

// GCPUploadOptions defines model for GCPUploadOptions.
type GCPUploadOptions struct {
	// Name of an existing STANDARD Storage class Bucket.
	Bucket *string `json:"bucket,omitempty"`

	// The name to use for the imported and shared Compute Engine image.
	// The image name must be unique within the GCP project, which is used
	// for the OS image upload and import. If not specified a random
	// 'composer-api-<uuid>' string is used as the image name.
	ImageName *string `json:"image_name,omitempty"`

	// The GCP region where the OS image will be imported to and shared from.
	// The value must be a valid GCP location. See https://cloud.google.com/storage/docs/locations.
	// If not specified, the multi-region location closest to the source
	// (source Storage Bucket location) is chosen automatically.
	Region string `json:"region"`

	// List of valid Google accounts to share the imported Compute Engine image with.
	// Each string must contain a specifier of the account type. Valid formats are:
	//   - 'user:{emailid}': An email address that represents a specific
	//     Google account. For example, 'alice@example.com'.
	//   - 'serviceAccount:{emailid}': An email address that represents a
	//     service account. For example, 'my-other-app@appspot.gserviceaccount.com'.
	//   - 'group:{emailid}': An email address that represents a Google group.
	//     For example, 'admins@example.com'.
	//   - 'domain:{domain}': The G Suite domain (primary) that represents all
	//     the users of that domain. For example, 'google.com' or 'example.com'.
	// If not specified, the imported Compute Engine image is not shared with any
	// account.
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// GCPUploadStatus defines model for GCPUploadStatus.
type GCPUploadStatus struct {
	ImageName string `json:"image_name"`
	ProjectId string `json:"project_id"`
}

// ImageRequest defines model for ImageRequest.
type ImageRequest struct {
	Architecture string       `json:"architecture"`
	ImageType    ImageTypes   `json:"image_type"`
	Ostree       *OSTree      `json:"ostree,omitempty"`
	Repositories []Repository `json:"repositories"`

	// This should really be oneOf but AWSS3UploadOptions is a subset of
	// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
	// are also valid AWSS3UploadOptionas objects which violates the oneOf
	// rules. Therefore, we have to use anyOf here but be aware that it isn't
	// possible to mix and match more schemas together.
	UploadOptions *UploadOptions `json:"upload_options,omitempty"`
}

// ImageStatus defines model for ImageStatus.
type ImageStatus struct {
	Error        *ComposeStatusError `json:"error,omitempty"`
	Status       ImageStatusValue    `json:"status"`
	UploadStatus *UploadStatus       `json:"upload_status,omitempty"`
}

// ImageStatusValue defines model for ImageStatusValue.
type ImageStatusValue string

// ImageTypes defines model for ImageTypes.
type ImageTypes string

// Koji defines model for Koji.
type Koji struct {
	Name    string `json:"name"`
	Release string `json:"release"`
	Server  string `json:"server"`
	TaskId  int    `json:"task_id"`
	Version string `json:"version"`
}

// KojiLogs defines model for KojiLogs.
type KojiLogs struct {
	Import interface{} `json:"import"`
	Init   interface{} `json:"init"`
}

// KojiStatus defines model for KojiStatus.
type KojiStatus struct {
	BuildId *int `json:"build_id,omitempty"`
}

// List defines model for List.
type List struct {
	Kind  string `json:"kind"`
	Page  int    `json:"page"`
	Size  int    `json:"size"`
	Total int    `json:"total"`
}

// OSTree defines model for OSTree.
type OSTree struct {
	// A URL which, if set, is used for fetching content. Implies that `url` is set as well,
	// which will be used for metadata only.
	Contenturl *string `json:"contenturl,omitempty"`

	// Can be either a commit (example: 02604b2da6e954bd34b8b82a835e5a77d2b60ffa), or a branch-like reference (example: rhel/8/x86_64/edge)
	Parent *string `json:"parent,omitempty"`
	Ref    *string `json:"ref,omitempty"`

	// Determines whether a valid subscription manager (candlepin) identity is required to
	// access this repository. Consumer certificates will be used as client certificates when
	// fetching metadata and content.
	Rhsm *bool   `json:"rhsm,omitempty"`
	Url  *string `json:"url,omitempty"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// PackageMetadata defines model for PackageMetadata.
type PackageMetadata struct {
	Arch      string  `json:"arch"`
	Epoch     *string `json:"epoch,omitempty"`
	Name      string  `json:"name"`
	Release   string  `json:"release"`
	Sigmd5    string  `json:"sigmd5"`
	Signature *string `json:"signature,omitempty"`
	Type      string  `json:"type"`
	Version   string  `json:"version"`
}

// Repository defines model for Repository.
type Repository struct {
	Baseurl  *string `json:"baseurl,omitempty"`
	CheckGpg *bool   `json:"check_gpg,omitempty"`

	// GPG key used to sign packages in this repository.
	Gpgkey     *string `json:"gpgkey,omitempty"`
	IgnoreSsl  *bool   `json:"ignore_ssl,omitempty"`
	Metalink   *string `json:"metalink,omitempty"`
	Mirrorlist *string `json:"mirrorlist,omitempty"`

	// Naming package sets for a repository assigns it to a specific part
	// (pipeline) of the build process.
	PackageSets *[]string `json:"package_sets,omitempty"`

	// Determines whether a valid subscription is required to access this repository.
	Rhsm *bool `json:"rhsm,omitempty"`
}

// Subscription defines model for Subscription.
type Subscription struct {
	ActivationKey string `json:"activation_key"`
	BaseUrl       string `json:"base_url"`
	Insights      bool   `json:"insights"`
	Organization  string `json:"organization"`
	ServerUrl     string `json:"server_url"`
}

// This should really be oneOf but AWSS3UploadOptions is a subset of
// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
// are also valid AWSS3UploadOptionas objects which violates the oneOf
// rules. Therefore, we have to use anyOf here but be aware that it isn't
// possible to mix and match more schemas together.
type UploadOptions interface{}

// UploadStatus defines model for UploadStatus.
type UploadStatus struct {
	Options interface{}       `json:"options"`
	Status  UploadStatusValue `json:"status"`
	Type    UploadTypes       `json:"type"`
}

// UploadStatusValue defines model for UploadStatusValue.
type UploadStatusValue string

// UploadTypes defines model for UploadTypes.
type UploadTypes string

// User defines model for User.
type User struct {
	Groups *[]string `json:"groups,omitempty"`
	Key    *string   `json:"key,omitempty"`
	Name   string    `json:"name"`
}

// Page defines model for page.
type Page string

// Size defines model for size.
type Size string

// PostComposeJSONBody defines parameters for PostCompose.
type PostComposeJSONBody ComposeRequest

// PostCloneComposeJSONBody defines parameters for PostCloneCompose.
type PostCloneComposeJSONBody CloneComposeBody

// GetErrorListParams defines parameters for GetErrorList.
type GetErrorListParams struct {
	// Page index
	Page *Page `json:"page,omitempty"`

	// Number of items in each page
	Size *Size `json:"size,omitempty"`
}

// PostComposeJSONRequestBody defines body for PostCompose for application/json ContentType.
type PostComposeJSONRequestBody PostComposeJSONBody

// PostCloneComposeJSONRequestBody defines body for PostCloneCompose for application/json ContentType.
type PostCloneComposeJSONRequestBody PostCloneComposeJSONBody

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// The status of a cloned compose
	// (GET /clones/{id})
	GetCloneStatus(ctx echo.Context, id string) error
	// Create compose
	// (POST /compose)
	PostCompose(ctx echo.Context) error
	// The status of a compose
	// (GET /composes/{id})
	GetComposeStatus(ctx echo.Context, id string) error
	// Clone an existing compose
	// (POST /composes/{id}/clone)
	PostCloneCompose(ctx echo.Context, id string) error
	// Get logs for a compose.
	// (GET /composes/{id}/logs)
	GetComposeLogs(ctx echo.Context, id string) error
	// Get the manifests for a compose.
	// (GET /composes/{id}/manifests)
	GetComposeManifests(ctx echo.Context, id string) error
	// Get the metadata for a compose.
	// (GET /composes/{id}/metadata)
	GetComposeMetadata(ctx echo.Context, id string) error
	// Get a list of all possible errors
	// (GET /errors)
	GetErrorList(ctx echo.Context, params GetErrorListParams) error
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetCloneStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetCloneStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetCloneStatus(ctx, id)
	return err
}

// PostCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCompose(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCompose(ctx)
	return err
}

// GetComposeStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeStatus(ctx, id)
	return err
}

// PostCloneCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCloneCompose(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCloneCompose(ctx, id)
	return err
}

// GetComposeLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeLogs(ctx, id)
	return err
}

// GetComposeManifests converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeManifests(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeManifests(ctx, id)
	return err
}

// GetComposeMetadata converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeMetadata(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeMetadata(ctx, id)
	return err
}

// GetErrorList converts echo context to params.
func (w *ServerInterfaceWrapper) GetErrorList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetErrorListParams
	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", ctx.QueryParams(), &params.Page)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter page: %s", err))
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", ctx.QueryParams(), &params.Size)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter size: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetErrorList(ctx, params)
	return err
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/clones/:id", wrapper.GetCloneStatus)
	router.POST(baseURL+"/compose", wrapper.PostCompose)
	router.GET(baseURL+"/composes/:id", wrapper.GetComposeStatus)
	router.POST(baseURL+"/composes/:id/clone", wrapper.PostCloneCompose)
	router.GET(baseURL+"/composes/:id/logs", wrapper.GetComposeLogs)
	router.GET(baseURL+"/composes/:id/manifests", wrapper.GetComposeManifests)
	router.GET(baseURL+"/composes/:id/metadata", wrapper.GetComposeMetadata)
	router.GET(baseURL+"/errors", wrapper.GetErrorList)
	router.GET(baseURL+"/errors/:id", wrapper.GetError)
	router.GET(baseURL+"/openapi", wrapper.GetOpenapi)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9eXPiurL4V1HxflUzU2FfAknVqfuAkIQAWYCsh6k8Ycu2wJYcSWbJqfnuv5K8YMAE",
	"cs+c8+69b+4fZ4Jtdbda3a3epPtHSqOOSwkigqdO/0i5kEEHCcSCXyaS/+qIawy7AlOSOk3dQhMBTHS0",
	"SKVTaAEd10Zrn8+g7aHUaaqQ+vEjncJyzJuH2DKVThHoyDfqy3SKaxZyoBwilq58zgXDxFTDOH5PwH3t",
	"OWPEADUAFsjhABOAoGaBAGCcmhBARE0+v5Me9e1H9PwIXyrQ9cdBq1ls2pSgpmQfV4hcRl3EBPbRM2Qq",
	"krdgpVPcggy9zrGwXqGmUS/gfUB86vT3VKFYKleOq7WTfKGY+p5OqckmwgoeQMbgUk2PoTcPM6RLMAEN",
	"36PP6HiCNCHH+VO4d20K9RvFXf7RHCLaUsjLzBEXmUIq/XfOLJ3iBLrcouLVX7M4Tc4yE77dpiqZJ8m0",
	"7uPUQEDhJTAKOnidIujgTF6rlfLVk1K1WqmcVPTyOIljn2TxxmQk3vSeZR6U9qyy641trPm6ZkDPFqlT",
	"A9ocpTd0r20AjgQQFKjX4KuwEAiGAKVl39IAApsSMw3o2PC4BgXSwX2/OyKYA4aExwjSs6AtOEALFzMo",
	"QQMHm5YAYwQ4pQQxICxIgEEZoMJCDHiK/BERkJlI8OyIjMiKFsE8JNFyizKBmMQGYsgAJPqI4HWEmANJ",
	"O4cOApArVPJ3HB1YYVutwphSG0Hy59ftsBXbJW0es5NtZhyF/CgR/rvH0B6JwA40UaRnGxZYMo0aimE+",
	"q5AO1AC5rsDxuFpKj+A3T24T6kMTzxABDHHqMQ0Bk1HPzapVlEjkelAHCyksBqOOGiLngriQS8sg0akD",
	"KEFgDDnSASUAgvv79hnAfERMRBCTkuav1ZpZUIQl6Z1NNSiCFVyfYDd4E07SZXSG5SRD8l8V+WkwtxBD",
	"6hOFRUqgZ+tq8iFfIJHDTMwFYoq+SzqXQmtjLgC0bRCSwU9HxBLC5ae5nE41nnWwxiinhshq1MkhkvF4",
	"TrNxDsrlywUG6x8zjOa/qUcZzcYZGwrExX/B99CivUpErxGSL4rlkuLwkWQ9oQJwF2nYwEhPAyzkQx3p",
	"nra2IDv4sMl0qQHIk+KUbO7iYz+WrnVxOYDdm6QMqadB0g/AXCiMSZuWN45IeMX6NlHtM0lS/LN/gpgy",
	"qui1cVHLwHGxnCmXC6XMSV6rZI4LxVL+GNXyJ6iYRJ1ABBLxAV2SCP+jw6gKRNDARFdr7WuoMgvgljIB",
	"7UNkMZRDgWcoo2OGNEHZMmd4RIcOIgLafOttxqLzjKAZiTrjk7zBpIpWRUZlfJwpaCUjU9ZhPgOPi8VM",
	"fpw/zhdLJ3pVr+41riuOba/tlgTuMZG7TPC6hTzE5GwQGQOQRELct2xQfSmxUIJujNTp73+k/h9DRuo0",
	"9V+5lfOeC9zTXIJv+uP7BsQ+4i4lvtcKbfsAqDeKsj4yEENEQ6kf6S2O6OucKBRLSHp6GVQ7GWcKRb2U",
	"geXKcaZcPD6uVMrlfD6fT6VTBmUOFKnTlOep5dnDNT2BW9HsVov1z0/qo+/XRMJH6/Ozrf8HcdKfUpea",
	"/KdOSsn72MO27v/e8PsDEtKpRcakmeAhJgIxA2rojx9JEcGUTpTb/RFlHTrBai7JChgQ9CErepBgA3Hx",
	"U/nhxIH+eWZsTG4F/eOZIQF1KODPnBjlgiH0qlHHwSJxz/pqQW59C7cuuQICBJ8n7H8u1KbQ9GFv5iHU",
	"G9+ZwkSzPR0TE1y3Hvr1VCyy/Gg+AYyIEUmM3c2/vu+jbm8PmscFdfA7jBzsj4horn/9I53SsWTA2BNb",
	"MQazkJ2pJTHKF2i2IukjlG35cUj+5uB1mfwMmH9WQ7cEeI0BMY7/DBOfZJh4BHfvdEP7n14bij7JtBWU",
	"JJ4dSI9k3QrQYWPWGPmgcmObzA8ArU/wY0vig2sxRtm2NuhIQGzLPyXT9JihkzbNRMyPDCBPzJdtb1zR",
	"x1sE+PORCkM8R03F0zTE5VwMiG2PScfMRUQaCjmhlV6tPtxSrCYlAmKCEmb2QYgsKPA4inILWghkFVDt",
	"jE19BzWAuwIbSbFKe6zBFBQgZ4z0NWfaDzzZMhs8Ut67QnoqoJkYa9j8dYYYNpbbk5JcYNQGw+4AqG+w",
	"gYMQOoZUZWO20iWb8uXPL9HvDae0laGAuo7lD2jfxpYgSFQdvCrRcjCkclMrFirGbIQjlCv/IJFV0NxG",
	"MYTmJzH4EXuit7aPNzFTeDhrdGwGu8M65Wfqebgnh+7DVp5nNRlKghjdl7F4lmzFpCBRtY7q/O7sOjmB",
	"tMGbNw8us5jmnGWQzcgF63H6Adc2U2DpcMqJ0ra1TW9s4+F0DzfuK2ORYNoNbCO+5AI5B8M7Xw1JABh3",
	"jmJJdpdyYTLEP5dgd+FSrsYrQy7lWFCGk7yu1kIwCOLfKJEPKVllkgAmYN0PyoKhhTgakbXRc2zbgBJ7",
	"qfIUHOnSmunI5dSeoSCDJhhGMxQhGZFQy24GAAuObENlo5c+MEJVChLOILbh2F5pvZIewCgVgLIRgWQZ",
	"5HxdyETcIdWBy6jcD74pmkPErxwJDgyMbD2EuTUdzAE2CWVhBuigVe6HEJaJlQ/EZlhDn9d1LmefkDjq",
	"Yl+3Q8CK4/7XYLwMc/px4ldaaWCG5tBOtooOJm1/SGF7Goh8ghz/473UEEPI7/gniUkyr/FU0b71GsS/",
	"lYaOf8ZG3PMk85BEU+RQ/SxvV6M6SjQGaz6aHAFj6dCENO5hzppCF32+ATjZoVRTlhJx+LTV1wmefbgW",
	"By2Kz+p9gbUPKpny8zXrvhHuY/IaFqQj6S3ki+X1GN/DRByXlfDKDc+lmIh1gc/NINu78cUGp1eok3bA",
	"i+btnlrQ2NOmSOzO1EMC0AJzIUPvwbB+fVbvn4GBoEyG5poNOQcNBSK7WZsJfmQCDDtD2mR3TpplkuBo",
	"Y8elTAS1F1Xj1YGMETyBQIuYmASOd3ZEhlGiXAHaKF3NsbCC5PhF81ZuCJJpaTC3sGZJMy/3qvWdSMEK",
	"6ocSvU9LFrSN9SJLVNMakS+aH7+wDHRxZuTl8yXN87Cu/kJfgM+MEB2APJbel1R/pua1qllus1JO0X8f",
	"qyJEc1Lb6jjGXEHj/JUhTcBPVQeOWAnlb6wr6GHJKQsGCIGwwKDZ1NOzJqVmEKBwX3RU5SEXVa6CYuF6",
	"pUq5qp4tcCagPKpqaTbl0n8NAiU/4BiRr0FBKRRPXzCjYd8kmzWLckQA9AR1oMAatO3lJpOR94nmh+S9",
	"LuCLmjcIP5f0Kijrkpwkvko8syPSgpoVConieuCzAhhxioWeTYAGSMqz4EFR4GeNOYAMnY4IABnwRW5m",
	"p38gB2Ib6z++nII6AeoXgLrOEJciCIV0ARni0oaucGkSBNiYVhacUwYC7qXBF2hjDf13LCj9kg0wBw5A",
	"3R/3SRp81AGIXbidZUZ5fBnouv8NXZe7VGTNYFA4Jk6SqhJ9lhvB/MP6qKRrgwW6gwlP5IFOHYjJ6R/+",
	"vxKhUk8w8LBAwH8KvroMO5Atv20jt20foQqvpFvirz4UwdhNjqxU7wugDHzZoClZ6z4WzbCm7BsHKagA",
	"kuWIhPxd16bflfd0uiUVqcjxDeXh0MVLpVP+sm2zWcaDPoPjD/+SDqtoa/15NUTl4Uv4r5s1Isg1RHRI",
	"RGbMINYzpXypUijtdRRi4NL7SpJrud7tDiimWVggTXhsYzqL2vHrcXn39u4/PiBlOly6SCU6/RLDvjE3",
	"g6H8Ss14PaD9CSGZv8m/UvegBP+6i7XVxBVn3RpXNkj/Hq7CLolCYbhwcAI48no/nQAPUscRKw4DsF5C",
	"Tc47b0zzUznddEqF7/6fPmX+32EXTpD43ZLFmITFUMG5RAPnPGPBDLM8HPyK/cmhG/1894nxG3KCh0g3",
	"USYqbwW/whxR8AATLqBtqwem5vr/DQGYUuEii6D+XRuAqVjB93+swMvfmx8zOI/Azbgrvb1ElnSC4k1y",
	"cnWl4OdIpwxmmtKTyzQg3+F72gjyjZHFfDGfP8lXs/lEfwqxmZ90X40I3cYpneCsoRAHNixLmakeW954",
	"rRrOcHL+lk83rWi5mE4oTMwQ41tluNL+Hr+A/BWqoNt4BXHFlSR7G1WuEzYOufsG5RSiqqxbcSrxxcH/",
	"chf4XXZE6dAh3EnKWYSx+zrIKSbJqYSwaXyb8WG8vP1GUAHtpFcbXFBI01G3ud/k7Q9O7wzl06lg50hM",
	"ByMiErPaddV4qmLDNMCqOzUdRW0yRjSQ0CzppQdQsqDtuDZGgf/4Px6z/0cO4EjIKG+ObDs9In6wGYZf",
	"ETAnqFervGk2OfnuQoZIQuDehETCQlhlPmFQegdfg4U+Bfnicb48LurwGJ1UymO9VB7XxrUirJUqqAKr",
	"Vb04Ps4bBvyWlg4jBGMGiWZlbDxFgEU1qhU8ZiE7V8v5fkBOGrxvG/HU9hfJJsTYroUfMMzizv7m5jMk",
	"EHMwQVzGvwFr/CBtrfHPgQSaiIGvGiS6jVwso0YdEYHF0u879sUPCKocXj9AUC9CfyILmpRwz0EMaFK4",
	"VB0tTISHqww50GyMiNj4xkJkRCJZiuRABuOhYO3oWN7ZNbwt/xtpxC1FsIKl2PboknV8h/InVXYDlVUY",
	"knRzs2Ej0RFNJAK5dMebcEv7aNPa3p2w6eiVXa8IDB3hHfFEwovYRrOnwdH3DXfuJmmfCRGN0qGKubPb",
	"5h5yFEjH9k6r6STLkG5Bv/szELKcjrnISQWsrTRQwqE8R3nugA1Ys5A2fTVdMzbfmLSarjlFCWXoi9sL",
	"MEXLqFAkeb0qPql83bqyrRmajPxfo3XRvga3F7fg9r7RbTdBp/UMGt2bZke9HpERce7a142LujbQaKNV",
	"P+satefLKXq/Ooa63XueV+HFRdu+graoXU2Ki1yj2Dmy2kbbW1wI92FSRSPS7Ztn99XjCRxW3IezinPe",
	"uyq5U0RQP6cNnbe3u+n18o5bT0V69zRvvd8PxoXmda9pNC/M6VPtrjgi7y9T1taa7Dx/V5yzztiGnm7d",
	"H+EHSOpn3CnUnltvfFyp35equrhnvdLds/5onvSPnvCt8VDrj0inMRnmS7OHxo3eG/Dn0kkXNslx2y3c",
	"zNxau0VzbdR6eC68Oc2b2zrs5MdXlyXPMMtND0350XAwIvO7xyFqdhfeS/f4pvdEb24781nvzliMzcLT",
	"WW3mveQ7YpLTri+LC+jlFw6veyeXVy6azm5u+wt7RJZvYrJ8MRh9wOh86c5fzNndXBDSq+XMQcvLXT0M",
	"2XO+UnRa98NqUxtXy1Pt8nx4bvSmNple5EYkb9yX631YyZcvS4tJfirGqDTraLdP9PbG6zQe+OVgls/f",
	"XzzXl7fIWx7Vqtp97rll9arT0uChMxmRY9R+MZe4d5Of24Xni7N+R/Ps+ZSf1I88e2oW6HBc5qV352V2",
	"m69e0OHisVycwE7lcXB0bb0gNCK14/wTfbDGWqHjDo4mxgudcNYSL7Xb8f3L0fPsvNZ3mf5YZ5PL8dW0",
	"eOX2O/XF0FrwuzpvWBeFEcl3vUXxEfYaebPYrtxqPf0qp71NaL6maWzSePLw4pHhCvZOek9u7W2YMwbv",
	"1w7X2yap5d5eOiOCa3eebXjVqvdmPebmojgWBAuzz98m1qLnTZ7vyy/jsjUV5zWrc597eqqWi29Wt9KZ",
	"1/v1u3pjRMTZ+cXLY3+mOS2zc9YrdAb12ovzMB2XrqzusFfoPjWW8LFgacSuh8+1y6sZdB4merMyGxHN",
	"0Y7w3dVNo9FrNOv18jlutdDlscOs88uq98Dvur1eMf9c0V4ssniundcdpUPNi3ntvDmftkekMW9fnN/R",
	"q2adNxuN52Z93mpemq3mebleb5rTu9Xoo+vneq7aeHZNezmovzxfWpNlxxqR3JFx/H5rPMzGl8V86600",
	"bVdvzhvXedJ9OmrcFxxvNjh6G3qD0mOXNUpO6cKzhdvpt646XeFUWmcjUmAX7091Oiws3ZPndq1bP9N7",
	"zebNclKfcPp4X6s+33vNo9yYTNgQ9Yvd/k3TWN42q8ePJ7UKvnkYEacyOBrzu7N5tVnsMluv98q9M48u",
	"XwoDLC7gS7lz130QR8MWLJQxfx5cNCfvtHr7XHsoXd1MK/kRMd8ezVrxOjd2iq33QXVYKz22zsYFezYp",
	"t+3Zwmy/dZBZKLw/PS8c9jx4ubpqGrN348i+Hhx7C/NyRCaL3FV+ab8Uu3h8wY4v6vXlzcn9I6u/DOaD",
	"Xr6lTYa1eatJFtPBmbd8cx7nD7PrxpPXaj/UblDpeUR6+L5gXF3XuF49c/n5otI7etJJj9wNji7ZZHjb",
	"OSs5j8yu66Q1tPTnh9rkZeo+WmdLXsqdnKCbEbGmedYly/zkej6FnpHD97Ub7fhp1ptOuv3elVm5P3no",
	"LK+8x0fxPn8ik9515bF/3njrlPkLdXq9ETHEeHhZOKosx/3HXL00a4zhov9YFNX79+uJ9o6mg5cWht3r",
	"k27uUrtqtvuFu/Paca14ptft1vmJPiLTonmHnwd3dQiv8ldX9ffLWX/av+p2zU7x+e4ZX14/LIuidLU8",
	"NziDTmU+aD7eGNYtai+7jeHL1YjMmHtt346RwYcnlerQKDau2575/sKalYfF2aAzfTH7VuHhYjZo35Hm",
	"8n16tzxu3Rffbl38WDmRNsq6bT+9sA7VOqVOd3CSw+9Xd8O+LSa9+m8j8tutMayOiNpdWtdnH209iWky",
	"1U7wyrmdvFVKJ9DGZJq8fzuYMcp4QrAcjvuH3C1/899nSsWRl88Xj6UH8VuUutu3mftI7CDyWyciokG+",
	"zmqICMoV/n8E/spvtQwXDEEnhhnK/x6X/SeKvgbk6GZwAC3xXo3EsqV0nIOPgN/QocKYlc8AIJduBQdY",
	"VZBW1Q3VJzIiX13sIhsT9C2xZ2Qrvx02kdFPNuT83MhlPTgBO2KTVGL33pYbPtholtjwwTWBZ36dP3Di",
	"1s/qIo0hkZGvYsvpQs7nlCX2lUjP8jXRRd32UA8QEUw4Nq2Ns8nJrYvpFGUmJEEL02b6qpwvFcu7c1fb",
	"JMdXJCvXN0b5XsI3woA1wtKbTF+jIcbB2OyT4qvtvkuyPPjU0UaeO713zObZ5H1DttoV9uLYPu26b8iO",
	"FtQf39NbZXPMwyN2DEHb72BTp7TA2BNge35SB6HSSiQANUYkgW1ZoOA6CJIgNQRtGyR8CPxF4yMCGQLQ",
	"5jTQ+i28MPo2aF6YYapaKP1Tz5LgEWGejfwOPYYMylAazBGw4CxqsFCCAFRvgJzdGAE490vVUPiHRskX",
	"MSIu5RyPbTXMwQuVmXCg0CzgUIZAwGUgqKlslTSWkdjtykfGyiyfOQS3Xmw4XBoPHLFZ4PuELB44Irnj",
	"VzUbfb7cEhVsDim4+QODituu4wFBHiJcne8b6/jJwg3zCNlVnYmTk1SeyfJSVDoJqzCrMkgiRJ7Uz6/K",
	"xus1wpXtVi8Tr73YOsKxuelxbmWQXqxUCiegXq/Xm6Xrd9gs2C9n7cL1sFWRz9rX7KLTYr1nfNTr3c+9",
	"S9ivXzn9Lm2/943i21lRP6u85xvDRe54kUTEdmHG44jtr1PsKPiqTUzzGBbLgRQKn0ENBJnPuLH66zzc",
	"sK4eh+EFKmr/9L+LoMqt2r9GBRODbrtlg6BtQ9DAl1LtU37hyu8q4NI1sbGGgnOrwc0tdRdqFgJFVUJS",
	"223k+c7n8yxUr5W7GYzluW672boetDLFbD5rCcdWK4iFYtnNoKHQB0VSBlR/EoAujmXaTlPFlN8lSeSL",
	"01Qpm88WVKFBWIpNOc2mBPHcH1j/oeQqqYPuAgm/O0lpi+qlA4ESAMqA1EobibA53j83otL1kjLVboV5",
	"cO4t5vtRppovVl1i6iCCdACV+iEd6dl4J2Zb90mJn6BNr90D9HvyufPgiLlPvKDAVD186nYdyYfV5TrB",
	"iZ1Q4nw/a3XVzk8/6PpdHfJWB5zVYhTz+Vj1Rvk0rmsHh1dyk6CRdUXQhxY5xiUlzuucifNEikj5J6IO",
	"SvXbSNvE3/cDyQBY91EX/nrUdU9YQNApUuEF9gnxsZf+euz3BHrCogy/+yGNi5iUDRDJtk9J+e+gZEro",
	"nGwsQeXvWP17ghYuUld1qPYPQDXNY1LT4iZcaXFovH//LnWEe44D2TLo/4wbIWW8InlScHJa7J4rmnSC",
	"qKnOOwEICJqHQ9PApXLqWDnHGiU8aBRWzf4zxGBo3JW9Dzpn1YVefucmZkBHckjQBbpluG4pF+E1B76R",
	"QVyEFyb8HI1fP+r7Y337lMbsx5a9Kfxs7G09aemDl8CCXK4fE0j/XzM6bHUI+Jfl+WV5DrQ8gdFIsjQ/",
	"y3n6hL8U8nCPo7R2Ev0gVykC/H/MWVrjVIIErfPll8P0y2z9mzpMO+2XHwjGvaYE/yV+V9NB9iRmrP6F",
	"rMhf4Htt3oL1d3tfSXdmJYiUOouG5qvjD2OkOv38KwCS7ZpAC5FzbYg36Em4efYw61X+WQiSdPPH2q4t",
	"2bJ28O8DBbCDFtZ/Zhc3MMHcim3i4MM9HIvV1p1WEYXKijtIQICJL8OYEgDH1BPhFYOeLT7a5lUH7q9N",
	"fu8mH9yxlagaUgSi85n+VaBRgIgJIFTVVbHm2ZAFB9LAV2FRz7SCksbV4Ob6W/Y/TpEu1OFDM6xAh1Ke",
	"pEZr94V9qEvRlweoU1/dksvV1arRpR+SGBWDB+aMxO9jzQJ14jD6WKNKsXh41DJYPh0ZWN2+K0A8HRtc",
	"4OG3H0ASXuiRCcFlKx+o4uoetl/6uFcfV8zaoZRry72lmP+ZurauHgcoXazL+GOdi/rxpcpt6Zl/NBot",
	"oCbWNqLokmoduYjofHWrjtK1KPWvDux+pBkhnb8UY79iRFf97dCLcCk/oxe/gtRfQeq/WpC6ZZuS7J0C",
	"HvcptkzM6j6WLeOSNLPVJzl17GpXi0PsO3Uu6y9V/dUckqTdv0CUGiBgxi81+99RM1/Q//2UDEYCBG0b",
	"RP1PoTSt1Gx/RhsSv+mBaNEt+D5lq6tjxkugts5kRT08f4SCz//Url/6m/fwnUupXoD4s19a/EuLP6PF",
	"aFuCpOZGTT67d8ib4JNkuV8nNgCn9FlG1pIHQcz87+hbfDidH1EfdJIl6gX32FDd0/zLl6ID8+ttXNDF",
	"WYmHWzj4f6CALvbvsc2o7AFimfASrdysqDyOjeYyAU1MzI8QcAFN9CfRKCaS8J6dCM0+ON9//P8AAAD/",
	"/3HxqRyFbQAA",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
