package osbuild1

const v1ResultSuccess = `
{
    "success": true,
    "build": {
        "success": true,
        "stages": [
            {
                "name": "org.osbuild.rpm",
                "id": "6efecc9910457689fa56b362cfed5f0c9af2c9f1ebfe35bd5d54558b1fcbda06",
                "options": {
                    "gpgkeys": [
                        "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBErgSTsBEACh2A4b0O9t+vzC9VrVtL1AKvUWi9OPCjkvR7Xd8DtJxeeMZ5eF\n0HtzIG58qDRybwUe89FZprB1ffuUKzdE+HcL3FbNWSSOXVjZIersdXyH3NvnLLLF\n0DNRB2ix3bXG9Rh/RXpFsNxDp2CEMdUvbYCzE79K1EnUTVh1L0Of023FtPSZXX0c\nu7Pb5DI5lX5YeoXO6RoodrIGYJsVBQWnrWw4xNTconUfNPk0EGZtEnzvH2zyPoJh\nXGF+Ncu9XwbalnYde10OCvSWAZ5zTCpoLMTvQjWpbCdWXJzCm6G+/hx9upke546H\n5IjtYm4dTIVTnc3wvDiODgBKRzOl9rEOCIgOuGtDxRxcQkjrC+xvg5Vkqn7vBUyW\n9pHedOU+PoF3DGOM+dqv+eNKBvh9YF9ugFAQBkcG7viZgvGEMGGUpzNgN7XnS1gj\n/DPo9mZESOYnKceve2tIC87p2hqjrxOHuI7fkZYeNIcAoa83rBltFXaBDYhWAKS1\nPcXS1/7JzP0ky7d0L6Xbu/If5kqWQpKwUInXtySRkuraVfuK3Bpa+X1XecWi24JY\nHVtlNX025xx1ewVzGNCTlWn1skQN2OOoQTV4C8/qFpTW6DTWYurd4+fE0OJFJZQF\nbuhfXYwmRlVOgN5i77NTIJZJQfYFj38c/Iv5vZBPokO6mffrOTv3MHWVgQARAQAB\ntDNSZWQgSGF0LCBJbmMuIChyZWxlYXNlIGtleSAyKSA8c2VjdXJpdHlAcmVkaGF0\nLmNvbT6JAjYEEwECACAFAkrgSTsCGwMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAAK\nCRAZni+R/UMdUWzpD/9s5SFR/ZF3yjY5VLUFLMXIKUztNN3oc45fyLdTI3+UClKC\n2tEruzYjqNHhqAEXa2sN1fMrsuKec61Ll2NfvJjkLKDvgVIh7kM7aslNYVOP6BTf\nC/JJ7/ufz3UZmyViH/WDl+AYdgk3JqCIO5w5ryrC9IyBzYv2m0HqYbWfphY3uHw5\nun3ndLJcu8+BGP5F+ONQEGl+DRH58Il9Jp3HwbRa7dvkPgEhfFR+1hI+Btta2C7E\n0/2NKzCxZw7Lx3PBRcU92YKyaEihfy/aQKZCAuyfKiMvsmzs+4poIX7I9NQCJpyE\nIGfINoZ7VxqHwRn/d5mw2MZTJjbzSf+Um9YJyA0iEEyD6qjriWQRbuxpQXmlAJbh\n8okZ4gbVFv1F8MzK+4R8VvWJ0XxgtikSo72fHjwha7MAjqFnOq6eo6fEC/75g3NL\nGht5VdpGuHk0vbdENHMC8wS99e5qXGNDued3hlTavDMlEAHl34q2H9nakTGRF5Ki\nJUfNh3DVRGhg8cMIti21njiRh7gyFI2OccATY7bBSr79JhuNwelHuxLrCFpY7V25\nOFktl15jZJaMxuQBqYdBgSay2G0U6D1+7VsWufpzd/Abx1/c3oi9ZaJvW22kAggq\ndzdA27UUYjWvx42w9menJwh/0jeQcTecIUd0d0rFcw/c1pvgMMl/Q73yzKgKYw==\n=zbHE\n-----END PGP PUBLIC KEY BLOCK-----\n-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nvt61kpkXoRGxjTlc6h+69aidSg==\n=ls8J\n-----END PGP PUBLIC KEY BLOCK-----\n",
                        "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBErgSTsBEACh2A4b0O9t+vzC9VrVtL1AKvUWi9OPCjkvR7Xd8DtJxeeMZ5eF\n0HtzIG58qDRybwUe89FZprB1ffuUKzdE+HcL3FbNWSSOXVjZIersdXyH3NvnLLLF\n0DNRB2ix3bXG9Rh/RXpFsNxDp2CEMdUvbYCzE79K1EnUTVh1L0Of023FtPSZXX0c\nu7Pb5DI5lX5YeoXO6RoodrIGYJsVBQWnrWw4xNTconUfNPk0EGZtEnzvH2zyPoJh\nXGF+Ncu9XwbalnYde10OCvSWAZ5zTCpoLMTvQjWpbCdWXJzCm6G+/hx9upke546H\n5IjtYm4dTIVTnc3wvDiODgBKRzOl9rEOCIgOuGtDxRxcQkjrC+xvg5Vkqn7vBUyW\n9pHedOU+PoF3DGOM+dqv+eNKBvh9YF9ugFAQBkcG7viZgvGEMGGUpzNgN7XnS1gj\n/DPo9mZESOYnKceve2tIC87p2hqjrxOHuI7fkZYeNIcAoa83rBltFXaBDYhWAKS1\nPcXS1/7JzP0ky7d0L6Xbu/If5kqWQpKwUInXtySRkuraVfuK3Bpa+X1XecWi24JY\nHVtlNX025xx1ewVzGNCTlWn1skQN2OOoQTV4C8/qFpTW6DTWYurd4+fE0OJFJZQF\nbuhfXYwmRlVOgN5i77NTIJZJQfYFj38c/Iv5vZBPokO6mffrOTv3MHWVgQARAQAB\ntDNSZWQgSGF0LCBJbmMuIChyZWxlYXNlIGtleSAyKSA8c2VjdXJpdHlAcmVkaGF0\nLmNvbT6JAjYEEwECACAFAkrgSTsCGwMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAAK\nCRAZni+R/UMdUWzpD/9s5SFR/ZF3yjY5VLUFLMXIKUztNN3oc45fyLdTI3+UClKC\n2tEruzYjqNHhqAEXa2sN1fMrsuKec61Ll2NfvJjkLKDvgVIh7kM7aslNYVOP6BTf\nC/JJ7/ufz3UZmyViH/WDl+AYdgk3JqCIO5w5ryrC9IyBzYv2m0HqYbWfphY3uHw5\nun3ndLJcu8+BGP5F+ONQEGl+DRH58Il9Jp3HwbRa7dvkPgEhfFR+1hI+Btta2C7E\n0/2NKzCxZw7Lx3PBRcU92YKyaEihfy/aQKZCAuyfKiMvsmzs+4poIX7I9NQCJpyE\nIGfINoZ7VxqHwRn/d5mw2MZTJjbzSf+Um9YJyA0iEEyD6qjriWQRbuxpQXmlAJbh\n8okZ4gbVFv1F8MzK+4R8VvWJ0XxgtikSo72fHjwha7MAjqFnOq6eo6fEC/75g3NL\nGht5VdpGuHk0vbdENHMC8wS99e5qXGNDued3hlTavDMlEAHl34q2H9nakTGRF5Ki\nJUfNh3DVRGhg8cMIti21njiRh7gyFI2OccATY7bBSr79JhuNwelHuxLrCFpY7V25\nOFktl15jZJaMxuQBqYdBgSay2G0U6D1+7VsWufpzd/Abx1/c3oi9ZaJvW22kAggq\ndzdA27UUYjWvx42w9menJwh/0jeQcTecIUd0d0rFcw/c1pvgMMl/Q73yzKgKYw==\n=zbHE\n-----END PGP PUBLIC KEY BLOCK-----\n-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nvt61kpkXoRGxjTlc6h+69aidSg==\n=ls8J\n-----END PGP PUBLIC KEY BLOCK-----\n",
                        "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBErgSTsBEACh2A4b0O9t+vzC9VrVtL1AKvUWi9OPCjkvR7Xd8DtJxeeMZ5eF\n0HtzIG58qDRybwUe89FZprB1ffuUKzdE+HcL3FbNWSSOXVjZIersdXyH3NvnLLLF\n0DNRB2ix3bXG9Rh/RXpFsNxDp2CEMdUvbYCzE79K1EnUTVh1L0Of023FtPSZXX0c\nu7Pb5DI5lX5YeoXO6RoodrIGYJsVBQWnrWw4xNTconUfNPk0EGZtEnzvH2zyPoJh\nXGF+Ncu9XwbalnYde10OCvSWAZ5zTCpoLMTvQjWpbCdWXJzCm6G+/hx9upke546H\n5IjtYm4dTIVTnc3wvDiODgBKRzOl9rEOCIgOuGtDxRxcQkjrC+xvg5Vkqn7vBUyW\n9pHedOU+PoF3DGOM+dqv+eNKBvh9YF9ugFAQBkcG7viZgvGEMGGUpzNgN7XnS1gj\n/DPo9mZESOYnKceve2tIC87p2hqjrxOHuI7fkZYeNIcAoa83rBltFXaBDYhWAKS1\nPcXS1/7JzP0ky7d0L6Xbu/If5kqWQpKwUInXtySRkuraVfuK3Bpa+X1XecWi24JY\nHVtlNX025xx1ewVzGNCTlWn1skQN2OOoQTV4C8/qFpTW6DTWYurd4+fE0OJFJZQF\nbuhfXYwmRlVOgN5i77NTIJZJQfYFj38c/Iv5vZBPokO6mffrOTv3MHWVgQARAQAB\ntDNSZWQgSGF0LCBJbmMuIChyZWxlYXNlIGtleSAyKSA8c2VjdXJpdHlAcmVkaGF0\nLmNvbT6JAjYEEwECACAFAkrgSTsCGwMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAAK\nCRAZni+R/UMdUWzpD/9s5SFR/ZF3yjY5VLUFLMXIKUztNN3oc45fyLdTI3+UClKC\n2tEruzYjqNHhqAEXa2sN1fMrsuKec61Ll2NfvJjkLKDvgVIh7kM7aslNYVOP6BTf\nC/JJ7/ufz3UZmyViH/WDl+AYdgk3JqCIO5w5ryrC9IyBzYv2m0HqYbWfphY3uHw5\nun3ndLJcu8+BGP5F+ONQEGl+DRH58Il9Jp3HwbRa7dvkPgEhfFR+1hI+Btta2C7E\n0/2NKzCxZw7Lx3PBRcU92YKyaEihfy/aQKZCAuyfKiMvsmzs+4poIX7I9NQCJpyE\nIGfINoZ7VxqHwRn/d5mw2MZTJjbzSf+Um9YJyA0iEEyD6qjriWQRbuxpQXmlAJbh\n8okZ4gbVFv1F8MzK+4R8VvWJ0XxgtikSo72fHjwha7MAjqFnOq6eo6fEC/75g3NL\nGht5VdpGuHk0vbdENHMC8wS99e5qXGNDued3hlTavDMlEAHl34q2H9nakTGRF5Ki\nJUfNh3DVRGhg8cMIti21njiRh7gyFI2OccATY7bBSr79JhuNwelHuxLrCFpY7V25\nOFktl15jZJaMxuQBqYdBgSay2G0U6D1+7VsWufpzd/Abx1/c3oi9ZaJvW22kAggq\ndzdA27UUYjWvx42w9menJwh/0jeQcTecIUd0d0rFcw/c1pvgMMl/Q73yzKgKYw==\n=zbHE\n-----END PGP PUBLIC KEY BLOCK-----\n-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nvt61kpkXoRGxjTlc6h+69aidSg==\n=ls8J\n-----END PGP PUBLIC KEY BLOCK-----\n"
                    ],
                    "packages": [
                        {
                            "checksum": "sha256:ce7e129103cab9de8081b9752a9990a632b5930e371988892e671bb47d42d14e"
                        }
                    ]
                },
                "success": true,
                "output": "/usr/lib/tmpfiles.d/abrt.conf:2: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/abrt.conf:9: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/colord.conf:1: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:2: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:3: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/cups.conf:4: Failed to resolve user 'lp': No such process\n/usr/lib/tmpfiles.d/gluster.conf:2: Failed to resolve user 'gluster': No such process\n/usr/lib/tmpfiles.d/httpd.conf:1: Failed to resolve group 'apache'.\n/usr/lib/tmpfiles.d/httpd.conf:2: Failed to resolve user 'apache': No such process\n/usr/lib/tmpfiles.d/journal-nocow.conf:26: Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\n/usr/lib/tmpfiles.d/lockdev.conf:3: Failed to resolve group 'lock'.\n/usr/lib/tmpfiles.d/openvpn.conf:1: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/openvpn.conf:2: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/radvd.conf:1: Failed to resolve user 'radvd': No such process\n/usr/lib/tmpfiles.d/rpcbind.conf:2: Failed to resolve user 'rpc': No such process\nFailed to open file \"/sys/fs/selinux/checkreqprot\": Read-only file system\nPreparing packages...\nlibgcc-8.4.1-1.el8.x86_64\npython3-setuptools-wheel-39.2.0-6.el8.noarch\npython3-pip-wheel-9.0.3-19.el8.noarch\nxkeyboard-config-2.28-1.el8.noarch\ntzdata-2020f-1.el8.noarch\nredhat-release-eula-8.4-0.5.el8.x86_64\nredhat-release-8.4-0.5.el8.x86_64\nsetup-2.12.2-6.el8.noarch\nfilesystem-3.8-3.el8.x86_64\nbasesystem-11-5.el8.noarch\npublicsuffix-list-dafsa-20180723-1.el8.noarch\nncurses-base-6.1-7.20180224.el8.noarch\npcre2-10.32-2.el8.x86_64\nlibselinux-2.9-5.el8.x86_64\nncurses-libs-6.1-7.20180224.el8.x86_64\nglibc-all-langpacks-2.28-145.el8.x86_64\nglibc-common-2.28-145.el8.x86_64\nglibc-2.28-145.el8.x86_64\nbash-4.4.19-14.el8.x86_64\nlibsepol-2.9-2.el8.x86_64\nzlib-1.2.11-17.el8.x86_64\nxz-libs-5.2.4-3.el8.x86_64\nbzip2-libs-1.0.6-26.el8.x86_64\nlibgpg-error-1.31-1.el8.x86_64\ninfo-6.5-6.el8.x86_64\nlibcap-2.26-4.el8.x86_64\nlibxml2-2.9.7-9.el8.x86_64\nelfutils-libelf-0.182-3.el8.x86_64\nlibcom_err-1.45.6-1.el8.x86_64\nlibzstd-1.4.4-1.el8.x86_64\nlibuuid-2.32.1-26.el8.x86_64\npopt-1.18-1.el8.x86_64\nreadline-7.0-10.el8.x86_64\nlibgcrypt-1.8.5-4.el8.x86_64\nexpat-2.2.5-4.el8.x86_64\nlibxcrypt-4.1.1-4.el8.x86_64\nlua-libs-5.3.4-11.el8.x86_64\nchkconfig-1.13-2.el8.x86_64\nlibunistring-0.9.9-3.el8.x86_64\nsqlite-libs-3.26.0-13.el8.x86_64\ngrub2-common-1:2.02-93.el8.noarch\ngmp-1:6.1.2-10.el8.x86_64\nlibstdc++-8.4.1-1.el8.x86_64\nlibidn2-2.2.0-1.el8.x86_64\nlibassuan-2.5.1-3.el8.x86_64\nfile-libs-5.33-16.el8.x86_64\njson-c-0.13.1-0.3.el8.x86_64\nlibattr-2.4.48-3.el8.x86_64\nlibacl-2.2.53-1.el8.x86_64\nsed-4.5-2.el8.x86_64\nlibcap-ng-0.7.9-5.el8.x86_64\naudit-libs-3.0-0.17.20191104git1c2f876.el8.x86_64\nlibsmartcols-2.32.1-26.el8.x86_64\nfile-5.33-16.el8.x86_64\nlibffi-3.1-22.el8.x86_64\np11-kit-0.23.22-1.el8.x86_64\nlz4-libs-1.8.3-2.el8.x86_64\nwhich-2.21-12.el8.x86_64\nlibsemanage-2.9-4.el8.x86_64\ndiffutils-3.6-6.el8.x86_64\nfindutils-1:4.6.0-20.el8.x86_64\nlibgomp-8.4.1-1.el8.x86_64\nlibksba-1.3.5-7.el8.x86_64\ngdbm-libs-1:1.18-1.el8.x86_64\nkeyutils-libs-1.5.10-6.el8.x86_64\nlibtasn1-4.13-3.el8.x86_64\np11-kit-trust-0.23.22-1.el8.x86_64\npcre-8.42-4.el8.x86_64\ngrep-3.1-6.el8.x86_64\nxz-5.2.4-3.el8.x86_64\ngdbm-1:1.18-1.el8.x86_64\nacl-2.2.53-1.el8.x86_64\nlibpsl-0.20.2-6.el8.x86_64\nmpfr-3.1.6-1.el8.x86_64\nnettle-3.4.1-2.el8.x86_64\ngrub2-pc-modules-1:2.02-93.el8.noarch\nlibcomps-0.1.11-4.el8.x86_64\nlibmetalink-0.1.3-7.el8.x86_64\ne2fsprogs-libs-1.45.6-1.el8.x86_64\nlibss-1.45.6-1.el8.x86_64\ncoreutils-common-8.30-8.el8.x86_64\nlibpng-2:1.6.34-5.el8.x86_64\nfreetype-2.9.1-4.el8_3.1.x86_64\npigz-2.4-4.el8.x86_64\nlibselinux-utils-2.9-5.el8.x86_64\nbrotli-1.0.6-3.el8.x86_64\ncpio-2.12-9.el8.x86_64\nfuse-libs-2.9.7-12.el8.x86_64\nhardlink-1:1.3-6.el8.x86_64\nlibaio-0.3.112-1.el8.x86_64\nlibnghttp2-1.33.0-3.el8_2.1.x86_64\nlibpcap-14:1.9.1-4.el8.x86_64\niptables-libs-1.8.4-16.el8.x86_64\nlibseccomp-2.4.3-1.el8.x86_64\nlibsigsegv-2.11-5.el8.x86_64\ngawk-4.2.1-2.el8.x86_64\nlibverto-0.3.0-5.el8.x86_64\nlibyaml-0.1.7-5.el8.x86_64\nmemstrack-0.1.11-1.el8.x86_64\nncurses-6.1-7.20180224.el8.x86_64\nnpth-1.5-4.el8.x86_64\nlibxkbcommon-0.9.1-1.el8.x86_64\nlibssh-config-0.9.4-2.el8.noarch\nlibreport-filesystem-2.9.5-15.el8.x86_64\ndnf-data-4.4.2-3.el8.noarch\nkbd-misc-2.0.4-10.el8.noarch\nkbd-legacy-2.0.4-10.el8.noarch\ndbus-common-1:1.12.8-12.el8.noarch\ncyrus-sasl-lib-2.1.27-5.el8.x86_64\nplatform-python-pip-9.0.3-19.el8.noarch\nplatform-python-setuptools-39.2.0-6.el8.noarch\npython3-libs-3.6.8-34.el8.x86_64\ngrub2-tools-minimal-1:2.02-93.el8.x86_64\nlibssh-0.9.4-2.el8.x86_64\nopenldap-2.4.46-16.el8.x86_64\nplatform-python-3.6.8-34.el8.x86_64\ngrubby-8.40-41.el8.x86_64\nlibkcapi-1.2.0-2.el8.x86_64\nlibkcapi-hmaccalc-1.2.0-2.el8.x86_64\nlibarchive-3.3.3-1.el8.x86_64\nlibdb-utils-5.3.28-40.el8.x86_64\ncurl-7.61.1-17.el8.x86_64\nlibcurl-7.61.1-17.el8.x86_64\nopenssl-1:1.1.1g-12.el8_3.x86_64\ncrypto-policies-scripts-20200713-1.git51d1222.el8.noarch\ncrypto-policies-20200713-1.git51d1222.el8.noarch\nelfutils-default-yama-scope-0.182-3.el8.noarch\ngzip-1.9-12.el8.x86_64\ncracklib-2.9.6-15.el8.x86_64\ncracklib-dicts-2.9.6-15.el8.x86_64\nprocps-ng-3.3.15-5.el8.x86_64\nkrb5-libs-1.18.2-8.el8.x86_64\nlibtirpc-1.1.4-4.el8.x86_64\nlibnsl2-1.2.0-2.20180605git4a062cf.el8.x86_64\nkpartx-0.8.4-7.el8.x86_64\ndevice-mapper-8:1.02.175-1.el8.x86_64\nelfutils-debuginfod-client-0.182-3.el8.x86_64\nelfutils-libs-0.182-3.el8.x86_64\nopenssl-pkcs11-0.4.10-2.el8.x86_64\nrpm-4.14.3-4.el8.x86_64\ngettext-libs-0.19.8.1-17.el8.x86_64\nlibcroco-0.6.12-4.el8_2.1.x86_64\nlibfdisk-2.32.1-26.el8.x86_64\nlibmount-2.32.1-26.el8.x86_64\ndbus-libs-1:1.12.8-12.el8.x86_64\ndbus-tools-1:1.12.8-12.el8.x86_64\ncoreutils-8.30-8.el8.x86_64\nlibblkid-2.32.1-26.el8.x86_64\nsystemd-libs-239-43.el8.x86_64\ndevice-mapper-libs-8:1.02.175-1.el8.x86_64\nshadow-utils-2:4.6-12.el8.x86_64\nca-certificates-2020.2.41-80.0.el8_2.noarch\nopenssl-libs-1:1.1.1g-12.el8_3.x86_64\nlibdb-5.3.28-40.el8.x86_64\nrpm-libs-4.14.3-4.el8.x86_64\nkmod-25-17.el8.x86_64\nkmod-libs-25-17.el8.x86_64\ncryptsetup-libs-2.3.3-2.el8.x86_64\ntrousers-lib-0.3.15-1.el8.x86_64\ndbus-daemon-1:1.12.8-12.el8.x86_64\nlibutempter-1.1.6-14.el8.x86_64\nkbd-2.0.4-10.el8.x86_64\nlibpwquality-1.4.4-1.el8.x86_64\npam-1.3.1-14.el8.x86_64\nutil-linux-2.32.1-26.el8.x86_64\nsystemd-pam-239-43.el8.x86_64\ndracut-049-133.git20210112.el8.x86_64\nos-prober-1.74-6.el8.x86_64\ngettext-0.19.8.1-17.el8.x86_64\ngrub2-tools-1:2.02-93.el8.x86_64\nglib2-2.56.4-9.el8.x86_64\nshared-mime-info-1.9-3.el8.x86_64\ngnutls-3.6.14-7.el8_3.x86_64\ndbus-1:1.12.8-12.el8.x86_64\nsystemd-239-43.el8.x86_64\nsystemd-udev-239-43.el8.x86_64\ntrousers-0.3.15-1.el8.x86_64\njson-glib-1.4.4-1.el8.x86_64\nlibmodulemd-2.9.4-2.el8.x86_64\nlibrhsm-0.0.3-4.el8.x86_64\nlibsolv-0.7.16-1.el8.x86_64\npolicycoreutils-2.9-9.el8.x86_64\nima-evm-utils-1.1-5.el8.x86_64\nlibevent-2.1.8-5.el8.x86_64\nunbound-libs-1.7.3-15.el8.x86_64\npython3-unbound-1.7.3-15.el8.x86_64\nrpm-plugin-selinux-4.14.3-4.el8.x86_64\nselinux-policy-3.14.3-60.el8.noarch\nselinux-policy-targeted-3.14.3-60.el8.noarch\nlibsecret-0.18.6-1.el8.x86_64\npinentry-1.1.0-2.el8.x86_64\ngrub2-tools-extra-1:2.02-93.el8.x86_64\nrpm-plugin-systemd-inhibit-4.14.3-4.el8.x86_64\nlibusbx-1.0.23-4.el8.x86_64\ngnupg2-smime-2.2.20-2.el8.x86_64\ngnupg2-2.2.20-2.el8.x86_64\ngpgme-1.13.1-7.el8.x86_64\nlibrepo-1.12.0-3.el8.x86_64\nlibdnf-0.55.0-1.el8.x86_64\npython3-libdnf-0.55.0-1.el8.x86_64\npython3-hawkey-0.55.0-1.el8.x86_64\npython3-gpg-1.13.1-7.el8.x86_64\nrpm-build-libs-4.14.3-4.el8.x86_64\npython3-rpm-4.14.3-4.el8.x86_64\npython3-libcomps-0.1.11-4.el8.x86_64\npython3-dnf-4.4.2-3.el8.noarch\npython3-setuptools-39.2.0-6.el8.noarch\npython3-pip-9.0.3-19.el8.noarch\npython36-3.6.8-2.module+el8.1.0+3334+5cb623d7.x86_64\npython3-six-1.11.0-8.el8.noarch\npython3-iniparse-0.4-31.el8.noarch\ndnf-4.4.2-3.el8.noarch\ngrub2-pc-1:2.02-93.el8.x86_64\nqemu-img-15:4.2.0-41.module+el8.4.0+9504+ab2393e6.x86_64\nxfsprogs-5.0.0-8.el8.x86_64\ne2fsprogs-1.45.6-1.el8.x86_64\ntar-2:1.30-5.el8.x86_64\ndosfstools-4.1-6.el8.x86_64\nimported gpg key\nimported gpg key\nimported gpg key\ncreating a fake machine id\ndeleting the fake machine id\n",
                "metadata": {
                    "packages": [
                        {
                            "name": "gpg-pubkey",
                            "version": "fd431d51",
                            "release": "4ae0493b",
                            "epoch": null,
                            "arch": null,
                            "sigmd5": null,
                            "sigpgp": null,
                            "siggpg": null
                        }
                    ]
                },
                "error": null
            },
            {
                "name": "org.osbuild.selinux",
                "id": "abc451d81c7c03be83af647efdf9217954d06332f41fac5f709b695697a6dd6a",
                "options": {
                    "file_contexts": "etc/selinux/targeted/contexts/files/file_contexts"
                },
                "success": true,
                "output": "/usr/lib/tmpfiles.d/abrt.conf:2: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/abrt.conf:9: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/colord.conf:1: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:2: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:3: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/cups.conf:4: Failed to resolve user 'lp': No such process\n/usr/lib/tmpfiles.d/gluster.conf:2: Failed to resolve user 'gluster': No such process\n/usr/lib/tmpfiles.d/httpd.conf:1: Failed to resolve group 'apache'.\n/usr/lib/tmpfiles.d/httpd.conf:2: Failed to resolve user 'apache': No such process\n/usr/lib/tmpfiles.d/journal-nocow.conf:26: Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\n/usr/lib/tmpfiles.d/lockdev.conf:3: Failed to resolve group 'lock'.\n/usr/lib/tmpfiles.d/openvpn.conf:1: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/openvpn.conf:2: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/radvd.conf:1: Failed to resolve user 'radvd': No such process\n/usr/lib/tmpfiles.d/rpcbind.conf:2: Failed to resolve user 'rpc': No such process\nFailed to open file \"/sys/fs/selinux/checkreqprot\": Read-only file system\n",
                "metadata": {},
                "error": null
            }
        ]
    },
    "stages": [
        {
            "name": "org.osbuild.rpm",
            "id": "dcf25b0b73304c9ea2e02fe1c835c5234242697061d37849b23a2bd44de764ff",
            "options": {
                "gpgkeys": [
                    "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBErgSTsBEACh2A4b0O9t+vzC9VrVtL1AKvUWi9OPCjkvR7Xd8DtJxeeMZ5eF\n0HtzIG58qDRybwUe89FZprB1ffuUKzdE+HcL3FbNWSSOXVjZIersdXyH3NvnLLLF\n0DNRB2ix3bXG9Rh/RXpFsNxDp2CEMdUvbYCzE79K1EnUTVh1L0Of023FtPSZXX0c\nu7Pb5DI5lX5YeoXO6RoodrIGYJsVBQWnrWw4xNTconUfNPk0EGZtEnzvH2zyPoJh\nXGF+Ncu9XwbalnYde10OCvSWAZ5zTCpoLMTvQjWpbCdWXJzCm6G+/hx9upke546H\n5IjtYm4dTIVTnc3wvDiODgBKRzOl9rEOCIgOuGtDxRxcQkjrC+xvg5Vkqn7vBUyW\n9pHedOU+PoF3DGOM+dqv+eNKBvh9YF9ugFAQBkcG7viZgvGEMGGUpzNgN7XnS1gj\n/DPo9mZESOYnKceve2tIC87p2hqjrxOHuI7fkZYeNIcAoa83rBltFXaBDYhWAKS1\nPcXS1/7JzP0ky7d0L6Xbu/If5kqWQpKwUInXtySRkuraVfuK3Bpa+X1XecWi24JY\nHVtlNX025xx1ewVzGNCTlWn1skQN2OOoQTV4C8/qFpTW6DTWYurd4+fE0OJFJZQF\nbuhfXYwmRlVOgN5i77NTIJZJQfYFj38c/Iv5vZBPokO6mffrOTv3MHWVgQARAQAB\ntDNSZWQgSGF0LCBJbmMuIChyZWxlYXNlIGtleSAyKSA8c2VjdXJpdHlAcmVkaGF0\nLmNvbT6JAjYEEwECACAFAkrgSTsCGwMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAAK\nCRAZni+R/UMdUWzpD/9s5SFR/ZF3yjY5VLUFLMXIKUztNN3oc45fyLdTI3+UClKC\n2tEruzYjqNHhqAEXa2sN1fMrsuKec61Ll2NfvJjkLKDvgVIh7kM7aslNYVOP6BTf\nC/JJ7/ufz3UZmyViH/WDl+AYdgk3JqCIO5w5ryrC9IyBzYv2m0HqYbWfphY3uHw5\nun3ndLJcu8+BGP5F+ONQEGl+DRH58Il9Jp3HwbRa7dvkPgEhfFR+1hI+Btta2C7E\n0/2NKzCxZw7Lx3PBRcU92YKyaEihfy/aQKZCAuyfKiMvsmzs+4poIX7I9NQCJpyE\nIGfINoZ7VxqHwRn/d5mw2MZTJjbzSf+Um9YJyA0iEEyD6qjriWQRbuxpQXmlAJbh\n8okZ4gbVFv1F8MzK+4R8VvWJ0XxgtikSo72fHjwha7MAjqFnOq6eo6fEC/75g3NL\nGht5VdpGuHk0vbdENHMC8wS99e5qXGNDued3hlTavDMlEAHl34q2H9nakTGRF5Ki\nJUfNh3DVRGhg8cMIti21njiRh7gyFI2OccATY7bBSr79JhuNwelHuxLrCFpY7V25\nOFktl15jZJaMxuQBqYdBgSay2G0U6D1+7VsWufpzd/Abx1/c3oi9ZaJvW22kAggq\ndzdA27UUYjWvx42w9menJwh/0jeQcTecIUd0d0rFcw/c1pvgMMl/Q73yzKgKYw==\n=zbHE\n-----END PGP PUBLIC KEY BLOCK-----\n-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nvt61kpkXoRGxjTlc6h+69aidSg==\n=ls8J\n-----END PGP PUBLIC KEY BLOCK-----\n",
                    "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBErgSTsBEACh2A4b0O9t+vzC9VrVtL1AKvUWi9OPCjkvR7Xd8DtJxeeMZ5eF\n0HtzIG58qDRybwUe89FZprB1ffuUKzdE+HcL3FbNWSSOXVjZIersdXyH3NvnLLLF\n0DNRB2ix3bXG9Rh/RXpFsNxDp2CEMdUvbYCzE79K1EnUTVh1L0Of023FtPSZXX0c\nu7Pb5DI5lX5YeoXO6RoodrIGYJsVBQWnrWw4xNTconUfNPk0EGZtEnzvH2zyPoJh\nXGF+Ncu9XwbalnYde10OCvSWAZ5zTCpoLMTvQjWpbCdWXJzCm6G+/hx9upke546H\n5IjtYm4dTIVTnc3wvDiODgBKRzOl9rEOCIgOuGtDxRxcQkjrC+xvg5Vkqn7vBUyW\n9pHedOU+PoF3DGOM+dqv+eNKBvh9YF9ugFAQBkcG7viZgvGEMGGUpzNgN7XnS1gj\n/DPo9mZESOYnKceve2tIC87p2hqjrxOHuI7fkZYeNIcAoa83rBltFXaBDYhWAKS1\nPcXS1/7JzP0ky7d0L6Xbu/If5kqWQpKwUInXtySRkuraVfuK3Bpa+X1XecWi24JY\nHVtlNX025xx1ewVzGNCTlWn1skQN2OOoQTV4C8/qFpTW6DTWYurd4+fE0OJFJZQF\nbuhfXYwmRlVOgN5i77NTIJZJQfYFj38c/Iv5vZBPokO6mffrOTv3MHWVgQARAQAB\ntDNSZWQgSGF0LCBJbmMuIChyZWxlYXNlIGtleSAyKSA8c2VjdXJpdHlAcmVkaGF0\nLmNvbT6JAjYEEwECACAFAkrgSTsCGwMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAAK\nCRAZni+R/UMdUWzpD/9s5SFR/ZF3yjY5VLUFLMXIKUztNN3oc45fyLdTI3+UClKC\n2tEruzYjqNHhqAEXa2sN1fMrsuKec61Ll2NfvJjkLKDvgVIh7kM7aslNYVOP6BTf\nC/JJ7/ufz3UZmyViH/WDl+AYdgk3JqCIO5w5ryrC9IyBzYv2m0HqYbWfphY3uHw5\nun3ndLJcu8+BGP5F+ONQEGl+DRH58Il9Jp3HwbRa7dvkPgEhfFR+1hI+Btta2C7E\n0/2NKzCxZw7Lx3PBRcU92YKyaEihfy/aQKZCAuyfKiMvsmzs+4poIX7I9NQCJpyE\nIGfINoZ7VxqHwRn/d5mw2MZTJjbzSf+Um9YJyA0iEEyD6qjriWQRbuxpQXmlAJbh\n8okZ4gbVFv1F8MzK+4R8VvWJ0XxgtikSo72fHjwha7MAjqFnOq6eo6fEC/75g3NL\nGht5VdpGuHk0vbdENHMC8wS99e5qXGNDued3hlTavDMlEAHl34q2H9nakTGRF5Ki\nJUfNh3DVRGhg8cMIti21njiRh7gyFI2OccATY7bBSr79JhuNwelHuxLrCFpY7V25\nOFktl15jZJaMxuQBqYdBgSay2G0U6D1+7VsWufpzd/Abx1/c3oi9ZaJvW22kAggq\ndzdA27UUYjWvx42w9menJwh/0jeQcTecIUd0d0rFcw/c1pvgMMl/Q73yzKgKYw==\n=zbHE\n-----END PGP PUBLIC KEY BLOCK-----\n-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nvt61kpkXoRGxjTlc6h+69aidSg==\n=ls8J\n-----END PGP PUBLIC KEY BLOCK-----\n",
                    "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBErgSTsBEACh2A4b0O9t+vzC9VrVtL1AKvUWi9OPCjkvR7Xd8DtJxeeMZ5eF\n0HtzIG58qDRybwUe89FZprB1ffuUKzdE+HcL3FbNWSSOXVjZIersdXyH3NvnLLLF\n0DNRB2ix3bXG9Rh/RXpFsNxDp2CEMdUvbYCzE79K1EnUTVh1L0Of023FtPSZXX0c\nu7Pb5DI5lX5YeoXO6RoodrIGYJsVBQWnrWw4xNTconUfNPk0EGZtEnzvH2zyPoJh\nXGF+Ncu9XwbalnYde10OCvSWAZ5zTCpoLMTvQjWpbCdWXJzCm6G+/hx9upke546H\n5IjtYm4dTIVTnc3wvDiODgBKRzOl9rEOCIgOuGtDxRxcQkjrC+xvg5Vkqn7vBUyW\n9pHedOU+PoF3DGOM+dqv+eNKBvh9YF9ugFAQBkcG7viZgvGEMGGUpzNgN7XnS1gj\n/DPo9mZESOYnKceve2tIC87p2hqjrxOHuI7fkZYeNIcAoa83rBltFXaBDYhWAKS1\nPcXS1/7JzP0ky7d0L6Xbu/If5kqWQpKwUInXtySRkuraVfuK3Bpa+X1XecWi24JY\nHVtlNX025xx1ewVzGNCTlWn1skQN2OOoQTV4C8/qFpTW6DTWYurd4+fE0OJFJZQF\nbuhfXYwmRlVOgN5i77NTIJZJQfYFj38c/Iv5vZBPokO6mffrOTv3MHWVgQARAQAB\ntDNSZWQgSGF0LCBJbmMuIChyZWxlYXNlIGtleSAyKSA8c2VjdXJpdHlAcmVkaGF0\nLmNvbT6JAjYEEwECACAFAkrgSTsCGwMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAAK\nCRAZni+R/UMdUWzpD/9s5SFR/ZF3yjY5VLUFLMXIKUztNN3oc45fyLdTI3+UClKC\n2tEruzYjqNHhqAEXa2sN1fMrsuKec61Ll2NfvJjkLKDvgVIh7kM7aslNYVOP6BTf\nC/JJ7/ufz3UZmyViH/WDl+AYdgk3JqCIO5w5ryrC9IyBzYv2m0HqYbWfphY3uHw5\nun3ndLJcu8+BGP5F+ONQEGl+DRH58Il9Jp3HwbRa7dvkPgEhfFR+1hI+Btta2C7E\n0/2NKzCxZw7Lx3PBRcU92YKyaEihfy/aQKZCAuyfKiMvsmzs+4poIX7I9NQCJpyE\nIGfINoZ7VxqHwRn/d5mw2MZTJjbzSf+Um9YJyA0iEEyD6qjriWQRbuxpQXmlAJbh\n8okZ4gbVFv1F8MzK+4R8VvWJ0XxgtikSo72fHjwha7MAjqFnOq6eo6fEC/75g3NL\nGht5VdpGuHk0vbdENHMC8wS99e5qXGNDued3hlTavDMlEAHl34q2H9nakTGRF5Ki\nJUfNh3DVRGhg8cMIti21njiRh7gyFI2OccATY7bBSr79JhuNwelHuxLrCFpY7V25\nOFktl15jZJaMxuQBqYdBgSay2G0U6D1+7VsWufpzd/Abx1/c3oi9ZaJvW22kAggq\ndzdA27UUYjWvx42w9menJwh/0jeQcTecIUd0d0rFcw/c1pvgMMl/Q73yzKgKYw==\n=zbHE\n-----END PGP PUBLIC KEY BLOCK-----\n-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nvt61kpkXoRGxjTlc6h+69aidSg==\n=ls8J\n-----END PGP PUBLIC KEY BLOCK-----\n"
                ],
                "packages": [
                    {
                        "checksum": "sha256:7043ce24e7d3c8f8760c2697d524f049c425f64df85b79e7e40ef0b92288798d"
                    }
                ]
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\nPreparing packages...\nlibgcc-8.4.1-1.el8.x86_64\ntzdata-2020f-1.el8.noarch\nfontpackages-filesystem-1.44-22.el8.noarch\ngeolite2-country-20180605-1.el8.noarch\ngeolite2-city-20180605-1.el8.noarch\npython3-setuptools-wheel-39.2.0-6.el8.noarch\npython3-pip-wheel-9.0.3-19.el8.noarch\nhwdata-0.314-8.7.el8.noarch\ndejavu-fonts-common-2.35-7.el8.noarch\ndejavu-sans-mono-fonts-2.35-7.el8.noarch\nabattis-cantarell-fonts-0.0.25-6.el8.noarch\nxkeyboard-config-2.28-1.el8.noarch\nlibX11-common-1.6.8-4.el8.noarch\nsubscription-manager-rhsm-certificates-1.28.9-1.el8.x86_64\nrhsm-icons-1.28.9-1.el8.noarch\nredhat-release-eula-8.4-0.5.el8.x86_64\nredhat-release-8.4-0.5.el8.x86_64\nsetup-2.12.2-6.el8.noarch\nfilesystem-3.8-3.el8.x86_64\nefi-filesystem-3-3.el8.noarch\nbasesystem-11-5.el8.noarch\nquota-nls-1:4.04-12.el8.noarch\npublicsuffix-list-dafsa-20180723-1.el8.noarch\nncurses-base-6.1-7.20180224.el8.noarch\npcre2-10.32-2.el8.x86_64\nlibselinux-2.9-5.el8.x86_64\nncurses-libs-6.1-7.20180224.el8.x86_64\nglibc-all-langpacks-2.28-145.el8.x86_64\nglibc-common-2.28-145.el8.x86_64\nglibc-2.28-145.el8.x86_64\nbash-4.4.19-14.el8.x86_64\nlibsepol-2.9-2.el8.x86_64\nzlib-1.2.11-17.el8.x86_64\nxz-libs-5.2.4-3.el8.x86_64\npopt-1.18-1.el8.x86_64\nlibcom_err-1.45.6-1.el8.x86_64\nlibcap-2.26-4.el8.x86_64\nbzip2-libs-1.0.6-26.el8.x86_64\nlibxml2-2.9.7-9.el8.x86_64\nlibuuid-2.32.1-26.el8.x86_64\ninfo-6.5-6.el8.x86_64\nlibgpg-error-1.31-1.el8.x86_64\nlibstdc++-8.4.1-1.el8.x86_64\nlibxcrypt-4.1.1-4.el8.x86_64\nelfutils-libelf-0.182-3.el8.x86_64\nsqlite-libs-3.26.0-13.el8.x86_64\nexpat-2.2.5-4.el8.x86_64\nreadline-7.0-10.el8.x86_64\nlibcap-ng-0.7.9-5.el8.x86_64\naudit-libs-3.0-0.17.20191104git1c2f876.el8.x86_64\nlibzstd-1.4.4-1.el8.x86_64\nchkconfig-1.13-2.el8.x86_64\ngrub2-common-1:2.02-93.el8.noarch\nkeyutils-libs-1.5.10-6.el8.x86_64\nlibffi-3.1-22.el8.x86_64\np11-kit-0.23.22-1.el8.x86_64\nlibtalloc-2.3.1-2.el8.x86_64\nlua-libs-5.3.4-11.el8.x86_64\nlibgcrypt-1.8.5-4.el8.x86_64\nlibunistring-0.9.9-3.el8.x86_64\nlibidn2-2.2.0-1.el8.x86_64\ngmp-1:6.1.2-10.el8.x86_64\njson-c-0.13.1-0.3.el8.x86_64\nlibattr-2.4.48-3.el8.x86_64\nlibacl-2.2.53-1.el8.x86_64\nsed-4.5-2.el8.x86_64\nlibnl3-3.5.0-1.el8.x86_64\nlibsemanage-2.9-4.el8.x86_64\nlibassuan-2.5.1-3.el8.x86_64\nfindutils-1:4.6.0-20.el8.x86_64\nfile-libs-5.33-16.el8.x86_64\nfile-5.33-16.el8.x86_64\nlibpng-2:1.6.34-5.el8.x86_64\nfreetype-2.9.1-4.el8_3.1.x86_64\nlibbasicobjects-0.1.1-39.el8.x86_64\nlibcollection-0.7.0-39.el8.x86_64\nlibref_array-0.1.5-39.el8.x86_64\nlibsmartcols-2.32.1-26.el8.x86_64\nlz4-libs-1.8.3-2.el8.x86_64\npcre-8.42-4.el8.x86_64\ngrep-3.1-6.el8.x86_64\nwhich-2.21-12.el8.x86_64\nlibtevent-0.10.2-2.el8.x86_64\nefivar-libs-37-4.el8.x86_64\ngdbm-libs-1:1.18-1.el8.x86_64\njansson-2.11-3.el8.x86_64\nlibtdb-1.4.3-1.el8.x86_64\nlibverto-0.3.0-5.el8.x86_64\nxz-5.2.4-3.el8.x86_64\nlibnl3-cli-3.5.0-1.el8.x86_64\nnettle-3.4.1-2.el8.x86_64\nlibksba-1.3.5-7.el8.x86_64\ndiffutils-3.6-6.el8.x86_64\nlibgomp-8.4.1-1.el8.x86_64\ne2fsprogs-libs-1.45.6-1.el8.x86_64\ndmidecode-1:3.2-8.el8.x86_64\nlibdhash-0.5.0-39.el8.x86_64\nlibedit-3.1-23.20170329cvs.el8.x86_64\nlibmnl-1.0.4-6.el8.x86_64\nethtool-2:5.8-5.el8.x86_64\nlibpath_utils-0.2.1-39.el8.x86_64\nlibini_config-1.3.1-39.el8.x86_64\nlibpcap-14:1.9.1-4.el8.x86_64\nlibseccomp-2.4.3-1.el8.x86_64\nlibsss_idmap-2.4.0-5.el8.x86_64\nlibtasn1-4.13-3.el8.x86_64\np11-kit-trust-0.23.22-1.el8.x86_64\nlibyaml-0.1.7-5.el8.x86_64\nlzo-2.08-14.el8.x86_64\nnumactl-libs-2.0.12-11.el8.x86_64\npciutils-libs-3.7.0-1.el8.x86_64\npsmisc-23.1-5.el8.x86_64\npixman-0.38.4-1.el8.x86_64\nsquashfs-tools-4.3-19.el8.x86_64\niptables-libs-1.8.4-16.el8.x86_64\nlibteam-1.31-2.el8.x86_64\ngdbm-1:1.18-1.el8.x86_64\nefivar-37-4.el8.x86_64\ngroff-base-1.22.3-18.el8.x86_64\nacl-2.2.53-1.el8.x86_64\ntar-2:1.30-5.el8.x86_64\nvim-minimal-2:8.0.1763-15.el8.x86_64\nmpfr-3.1.6-1.el8.x86_64\nlibpsl-0.20.2-6.el8.x86_64\nkeyutils-1.5.10-6.el8.x86_64\ngrub2-pc-modules-1:2.02-93.el8.noarch\nlibcomps-0.1.11-4.el8.x86_64\nlibmetalink-0.1.3-7.el8.x86_64\nlibmodman-2.0.1-17.el8.x86_64\nlibproxy-0.4.15-5.2.el8.x86_64\nmozjs60-60.9.0-4.el8.x86_64\nsnappy-1.1.8-3.el8.x86_64\ncoreutils-common-8.30-8.el8.x86_64\nbzip2-1.0.6-26.el8.x86_64\nlibss-1.45.6-1.el8.x86_64\npigz-2.4-4.el8.x86_64\nlibselinux-utils-2.9-5.el8.x86_64\nkernel-tools-libs-4.18.0-275.el8.x86_64\nless-530-1.el8.x86_64\nbrotli-1.0.6-3.el8.x86_64\nc-ares-1.13.0-5.el8.x86_64\ncheckpolicy-2.9-1.el8.x86_64\ncpio-2.12-9.el8.x86_64\nfuse-libs-2.9.7-12.el8.x86_64\nhardlink-1:1.3-6.el8.x86_64\nhdparm-9.54-3.el8.x86_64\nlibdaemon-0.14-15.el8.x86_64\nlibndp-1.7-3.el8.x86_64\nlibnghttp2-1.33.0-3.el8_2.1.x86_64\nlibpipeline-1.5.0-2.el8.x86_64\nlibsigsegv-2.11-5.el8.x86_64\ngawk-4.2.1-2.el8.x86_64\nlibsss_autofs-2.4.0-5.el8.x86_64\nlibsss_nss_idmap-2.4.0-5.el8.x86_64\nlibsss_sudo-2.4.0-5.el8.x86_64\nlibstemmer-0-10.585svn.el8.x86_64\nlmdb-libs-0.9.24-1.el8.x86_64\nmemstrack-0.1.11-1.el8.x86_64\nncurses-6.1-7.20180224.el8.x86_64\nnpth-1.5-4.el8.x86_64\nsg3_utils-libs-1.44-5.el8.x86_64\nslang-2.3.2-3.el8.x86_64\nnewt-0.52.20-11.el8.x86_64\nlibXau-1.0.9-3.el8.x86_64\nlibxcb-1.13.1-1.el8.x86_64\nlibX11-1.6.8-4.el8.x86_64\nlibXext-1.3.4-1.el8.x86_64\nlibXrender-0.9.10-7.el8.x86_64\nlibestr-0.1.10-1.el8.x86_64\nlibfastjson-0.99.8-2.el8.x86_64\nlibmaxminddb-1.2.0-10.el8.x86_64\nipcalc-0.2.4-4.el8.x86_64\nlibxkbcommon-0.9.1-1.el8.x86_64\nlinux-firmware-20201118-101.git7455a360.el8.noarch\nlibssh-config-0.9.4-2.el8.noarch\nlibreport-filesystem-2.9.5-15.el8.x86_64\ndnf-data-4.4.2-3.el8.noarch\nkbd-misc-2.0.4-10.el8.noarch\nkbd-legacy-2.0.4-10.el8.noarch\ndhcp-common-12:4.3.6-44.el8.noarch\ndbus-common-1:1.12.8-12.el8.noarch\ncyrus-sasl-lib-2.1.27-5.el8.x86_64\nplatform-python-pip-9.0.3-19.el8.noarch\nplatform-python-setuptools-39.2.0-6.el8.noarch\npython3-libs-3.6.8-34.el8.x86_64\ngrub2-tools-minimal-1:2.02-93.el8.x86_64\nlibssh-0.9.4-2.el8.x86_64\nopenldap-2.4.46-16.el8.x86_64\nplatform-python-3.6.8-34.el8.x86_64\ngrubby-8.40-41.el8.x86_64\nlibkcapi-1.2.0-2.el8.x86_64\nlibkcapi-hmaccalc-1.2.0-2.el8.x86_64\nlibarchive-3.3.3-1.el8.x86_64\nlibdb-utils-5.3.28-40.el8.x86_64\ncurl-7.61.1-17.el8.x86_64\nlibcurl-7.61.1-17.el8.x86_64\nopenssl-1:1.1.1g-12.el8_3.x86_64\ncrypto-policies-scripts-20200713-1.git51d1222.el8.noarch\ncrypto-policies-20200713-1.git51d1222.el8.noarch\nelfutils-default-yama-scope-0.182-3.el8.noarch\ngzip-1.9-12.el8.x86_64\ncracklib-2.9.6-15.el8.x86_64\ncracklib-dicts-2.9.6-15.el8.x86_64\nprocps-ng-3.3.15-5.el8.x86_64\nkrb5-libs-1.18.2-8.el8.x86_64\nlibtirpc-1.1.4-4.el8.x86_64\nlibnsl2-1.2.0-2.20180605git4a062cf.el8.x86_64\nkpartx-0.8.4-7.el8.x86_64\ndevice-mapper-8:1.02.175-1.el8.x86_64\nelfutils-debuginfod-client-0.182-3.el8.x86_64\nelfutils-libs-0.182-3.el8.x86_64\nopenssl-pkcs11-0.4.10-2.el8.x86_64\nrpm-4.14.3-4.el8.x86_64\ngettext-libs-0.19.8.1-17.el8.x86_64\nlibcroco-0.6.12-4.el8_2.1.x86_64\nlibfdisk-2.32.1-26.el8.x86_64\nlibmount-2.32.1-26.el8.x86_64\ndbus-libs-1:1.12.8-12.el8.x86_64\ndbus-tools-1:1.12.8-12.el8.x86_64\ncoreutils-8.30-8.el8.x86_64\nsystemd-libs-239-43.el8.x86_64\nshadow-utils-2:4.6-12.el8.x86_64\nlibblkid-2.32.1-26.el8.x86_64\ndevice-mapper-libs-8:1.02.175-1.el8.x86_64\nca-certificates-2020.2.41-80.0.el8_2.noarch\nopenssl-libs-1:1.1.1g-12.el8_3.x86_64\nlibdb-5.3.28-40.el8.x86_64\nrpm-libs-4.14.3-4.el8.x86_64\nkmod-25-17.el8.x86_64\nkmod-libs-25-17.el8.x86_64\ncryptsetup-libs-2.3.3-2.el8.x86_64\ntrousers-lib-0.3.15-1.el8.x86_64\ndbus-daemon-1:1.12.8-12.el8.x86_64\nlibutempter-1.1.6-14.el8.x86_64\nkbd-2.0.4-10.el8.x86_64\nlibpwquality-1.4.4-1.el8.x86_64\npam-1.3.1-14.el8.x86_64\nutil-linux-2.32.1-26.el8.x86_64\nsystemd-pam-239-43.el8.x86_64\ndracut-049-133.git20210112.el8.x86_64\nos-prober-1.74-6.el8.x86_64\ngettext-0.19.8.1-17.el8.x86_64\ngrub2-tools-1:2.02-93.el8.x86_64\nglib2-2.56.4-9.el8.x86_64\nshared-mime-info-1.9-3.el8.x86_64\ngnutls-3.6.14-7.el8_3.x86_64\ndbus-1:1.12.8-12.el8.x86_64\nsystemd-239-43.el8.x86_64\nsystemd-udev-239-43.el8.x86_64\ntrousers-0.3.15-1.el8.x86_64\npython3-six-1.11.0-8.el8.noarch\njson-glib-1.4.4-1.el8.x86_64\npython3-libselinux-2.9-5.el8.x86_64\nlibmodulemd-2.9.4-2.el8.x86_64\npolkit-libs-0.115-11.el8.x86_64\npolkit-0.115-11.el8.x86_64\npolkit-pkla-compat-0.1-12.el8.x86_64\npolicycoreutils-2.9-9.el8.x86_64\nlibevent-2.1.8-5.el8.x86_64\nlibrhsm-0.0.3-4.el8.x86_64\npython3-dateutil-1:2.6.1-6.el8.noarch\ngobject-introspection-1.56.1-1.el8.x86_64\npython3-gobject-base-3.28.3-2.el8.x86_64\nlibsolv-0.7.16-1.el8.x86_64\niproute-5.9.0-1.el8.x86_64\npython3-decorator-4.2.1-2.el8.noarch\npython3-libxml2-2.9.7-9.el8.x86_64\npython3-pyyaml-3.12-12.el8.x86_64\npython3-configobj-5.0.6-11.el8.noarch\npython3-iniparse-0.4-31.el8.noarch\nkernel-core-4.18.0-275.el8.x86_64\ncrontabs-1.11-17.20190603git.el8.noarch\ncronie-1.5.2-4.el8.x86_64\ncronie-anacron-1.5.2-4.el8.x86_64\ninitscripts-10.00.12-1.el8.x86_64\niputils-20180629-6.el8.x86_64\nNetworkManager-libnm-1:1.30.0-0.6.el8.x86_64\nNetworkManager-1:1.30.0-0.6.el8.x86_64\ngdk-pixbuf2-2.36.12-5.el8.x86_64\nlibuser-0.62-23.el8.x86_64\ngrub2-tools-extra-1:2.02-93.el8.x86_64\nopenssh-8.0p1-5.el8.x86_64\nvirt-what-1.18-6.el8.x86_64\nima-evm-utils-1.1-5.el8.x86_64\nfontconfig-2.13.1-3.el8.x86_64\ncairo-1.15.12-3.el8.x86_64\nlibnfsidmap-1:2.3.3-40.el8.x86_64\npython3-audit-3.0-0.17.20191104git1c2f876.el8.x86_64\npython3-syspurpose-1.28.9-1.el8.x86_64\nlibldb-2.2.0-1.el8.x86_64\nsssd-nfs-idmap-2.4.0-5.el8.x86_64\ncairo-gobject-1.15.12-3.el8.x86_64\npython3-cairo-1.16.3-6.el8.x86_64\npython3-gobject-3.28.3-2.el8.x86_64\npasswd-0.80-3.el8.x86_64\nusermode-1.113-1.el8.x86_64\naudit-3.0-0.17.20191104git1c2f876.el8.x86_64\nkernel-modules-4.18.0-275.el8.x86_64\npython3-dmidecode-3.12.2-15.el8.x86_64\npython3-pydbus-0.6.0-5.el8.noarch\nPackageKit-glib-1.1.12-6.el8.x86_64\nlibverto-libevent-0.3.0-5.el8.x86_64\ngssproxy-0.8.0-19.el8.x86_64\nunbound-libs-1.7.3-15.el8.x86_64\npython3-unbound-1.7.3-15.el8.x86_64\nrpcbind-1.2.5-8.el8.x86_64\nrpm-plugin-selinux-4.14.3-4.el8.x86_64\nselinux-policy-3.14.3-60.el8.noarch\nselinux-policy-targeted-3.14.3-60.el8.noarch\ntimedatex-0.5-3.el8.x86_64\npython3-libsemanage-2.9-4.el8.x86_64\npython3-setools-4.3.0-2.el8.x86_64\npython3-policycoreutils-2.9-9.el8.noarch\npolicycoreutils-python-utils-2.9-9.el8.noarch\npython3-slip-0.6.4-11.el8.noarch\npython3-linux-procfs-0.6.3-1.el8.noarch\npython3-pyudev-0.21.0-7.el8.noarch\nauthselect-libs-1.2.2-1.el8.x86_64\ndbxtool-8-5.el8.x86_64\noddjob-0.34.7-1.el8.x86_64\ndbus-daemon: no process found\noddjob-mkhomedir-0.34.7-1.el8.x86_64\ndbus-daemon: no process found\nauthselect-1.2.2-1.el8.x86_64\ndbus-glib-0.110-2.el8.x86_64\npython3-dbus-1.2.4-15.el8.x86_64\npython3-slip-dbus-0.6.4-11.el8.noarch\ngsettings-desktop-schemas-3.32.0-5.el8.x86_64\nglib-networking-2.56.1-1.1.el8.x86_64\ncockpit-bridge-235-1.el8.x86_64\nlibsoup-2.62.3-2.el8.x86_64\nlibappstream-glib-0.7.14-3.el8.x86_64\nlibsecret-0.18.6-1.el8.x86_64\npinentry-1.1.0-2.el8.x86_64\ndracut-squash-049-133.git20210112.el8.x86_64\nsssd-client-2.4.0-5.el8.x86_64\nsudo-1.8.29-6.el8.x86_64\npciutils-3.7.0-1.el8.x86_64\nrpm-plugin-systemd-inhibit-4.14.3-4.el8.x86_64\nbind-export-libs-32:9.11.26-1.el8.x86_64\nlibsss_certmap-2.4.0-5.el8.x86_64\nsssd-common-2.4.0-5.el8.x86_64\nmokutil-1:0.3.0-11.el8.x86_64\nsscg-2.3.3-14.el8.x86_64\nxfsprogs-5.0.0-8.el8.x86_64\ne2fsprogs-1.45.6-1.el8.x86_64\ndhcp-libs-12:4.3.6-44.el8.x86_64\ndhcp-client-12:4.3.6-44.el8.x86_64\ndracut-network-049-133.git20210112.el8.x86_64\nkexec-tools-2.0.20-43.el8.x86_64\nlibusbx-1.0.23-4.el8.x86_64\ngnupg2-smime-2.2.20-2.el8.x86_64\ngnupg2-2.2.20-2.el8.x86_64\ngpgme-1.13.1-7.el8.x86_64\nlibrepo-1.12.0-3.el8.x86_64\nlibdnf-0.55.0-1.el8.x86_64\npython3-libdnf-0.55.0-1.el8.x86_64\npython3-hawkey-0.55.0-1.el8.x86_64\nPackageKit-1.1.12-6.el8.x86_64\npython3-librepo-1.12.0-3.el8.x86_64\npython3-gpg-1.13.1-7.el8.x86_64\nrpm-build-libs-4.14.3-4.el8.x86_64\npython3-rpm-4.14.3-4.el8.x86_64\npython3-subscription-manager-rhsm-1.28.9-1.el8.x86_64\npython3-systemd-234-8.el8.x86_64\nsetroubleshoot-plugins-3.3.13-1.el8.noarch\n(2021-03-19 13:01:50:454548): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:01:50:454733): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:01:50:497854): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:01:50:498038): [sss_cache] [init_domains] (0x0020): Could not initialize domains\nsetroubleshoot-server-3.3.24-1.el8.x86_64\nlogrotate-3.14.0-4.el8.x86_64\nredhat-logos-82.2-1.el8.x86_64\n(2021-03-19 13:01:51:389335): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:01:51:389568): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:01:51:442524): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:01:51:442687): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:01:51:527330): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:01:51:527502): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:01:51:570011): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:01:51:570185): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:01:51:648251): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:01:51:648392): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:01:51:684878): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:01:51:685029): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:01:51:863484): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:01:51:863625): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:01:51:903413): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:01:51:903596): [sss_cache] [init_domains] (0x0020): Could not initialize domains\ncockpit-ws-235-1.el8.x86_64\nteamd-1.31-2.el8.x86_64\nNetworkManager-team-1:1.30.0-0.6.el8.x86_64\nquota-1:4.04-12.el8.x86_64\nkernel-tools-4.18.0-275.el8.x86_64\npython3-chardet-3.0.4-7.el8.noarch\npython3-ethtool-0.14-3.el8.x86_64\npython3-idna-2.5-5.el8.noarch\npython3-inotify-0.9.6-13.el8.noarch\npython3-libcomps-0.1.11-4.el8.x86_64\npython3-dnf-4.4.2-3.el8.noarch\ndnf-4.4.2-3.el8.noarch\npython3-dnf-plugins-core-4.0.18-2.el8.noarch\ndnf-plugin-subscription-manager-1.28.9-1.el8.x86_64\nsubscription-manager-1.28.9-1.el8.x86_64\nchmod: cannot access '/etc/pki/entitlement/*.pem': No such file or directory\ndnf-plugins-core-4.0.18-2.el8.noarch\npython3-magic-5.33-16.el8.noarch\npython3-perf-4.18.0-275.el8.x86_64\npython3-ply-3.9-9.el8.noarch\npython3-pycparser-2.14-14.el8.noarch\npython3-cffi-1.11.5-5.el8.x86_64\npython3-cryptography-3.2.1-3.el8.x86_64\npython3-jwt-1.6.1-2.el8.noarch\npython3-oauthlib-2.1.0-1.el8.noarch\npython3-pysocks-1.6.8-3.el8.noarch\npython3-urllib3-1.24.2-5.el8.noarch\npython3-requests-2.20.0-2.1.el8_1.noarch\npython3-schedutils-0.6-6.el8.x86_64\npython3-jsonpointer-1.10-11.el8.noarch\npython3-jsonpatch-1.21-2.el8.noarch\npython3-jsonschema-2.6.0-4.el8.noarch\npython3-markupsafe-0.23-19.el8.x86_64\npython3-prettytable-0.7.2-14.el8.noarch\npython3-ptyprocess-0.5.2-4.el8.noarch\npython3-pexpect-4.3.1-3.el8.noarch\nsos-4.0-5.el8.noarch\ncockpit-system-235-1.el8.noarch\npython3-pyserial-3.1.1-8.el8.noarch\npython3-pytz-2017.2-9.el8.noarch\npython3-babel-2.5.1-5.el8.noarch\npython3-jinja2-2.10.1-2.el8_0.noarch\ncloud-init-20.3-7.el8.noarch\nsubscription-manager-cockpit-1.28.9-1.el8.noarch\ntuned-2.15.0-1.el8.noarch\ninsights-client-0:3.1.1-1.el8_3.noarch\nyum-utils-4.0.18-2.el8.noarch\nyum-4.4.2-3.el8.noarch\nnfs-utils-1:2.3.3-40.el8.x86_64\nRunning in chroot, ignoring request: try-restart\nRunning in chroot, ignoring request: try-restart\nrsyslog-8.1911.0-7.el8.x86_64\nshim-x64-15-16.el8.x86_64\nsssd-kcm-2.4.0-5.el8.x86_64\nauthselect-compat-1.2.2-1.el8.x86_64\n(2021-03-19 13:02:03:593920): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:02:03:594030): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:02:03:625537): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:02:03:625635): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:02:03:677501): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:02:03:677579): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:02:03:696243): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:02:03:696342): [sss_cache] [init_domains] (0x0020): Could not initialize domains\nchrony-3.5-1.el8.x86_64\nRunning in chroot, ignoring request: daemon-reload\nkernel-4.18.0-275.el8.x86_64\nopenssh-clients-8.0p1-5.el8.x86_64\n(2021-03-19 13:02:04:518758): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:02:04:518856): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:02:04:547205): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:02:04:547392): [sss_cache] [init_domains] (0x0020): Could not initialize domains\nopenssh-server-8.0p1-5.el8.x86_64\ngrub2-efi-x64-1:2.02-93.el8.x86_64\ngrub2-pc-1:2.02-93.el8.x86_64\nNetworkManager-tui-1:1.30.0-0.6.el8.x86_64\nmicrocode_ctl-4:20201112-1.el8.x86_64\nnet-tools-2.0-0.52.20160912git.el8.x86_64\nqemu-guest-agent-15:4.2.0-41.module+el8.4.0+9504+ab2393e6.x86_64\nirqbalance-2:1.4.0-5.el8.x86_64\ndracut-config-generic-049-133.git20210112.el8.x86_64\ncloud-utils-growpart-0.31-1.el8.noarch\ntcpdump-14:4.9.3-1.el8.x86_64\nparted-3.2-38.el8.x86_64\nprefixdevname-0.1.0-6.el8.x86_64\nman-db-2.7.6.1-17.el8.x86_64\nsg3_utils-1.44-5.el8.x86_64\nrsync-3.1.3-12.el8.x86_64\nlshw-B.02.19.2-4.el8.x86_64\nhostname-3.20-6.el8.x86_64\ndosfstools-4.1-6.el8.x86_64\nlibsysfs-2.1.0-24.el8.x86_64\nlsscsi-0.32-2.el8.x86_64\nrootfiles-8.1-22.el8.noarch\ndracut: No '/dev/log' or 'logger' included for syslog logging\nsort: fflush failed: 'standard output': Broken pipe\nsort: write error\n\ngzip: stdout: Broken pipe\n\ngzip: stdout: Broken pipe\nsort: write failed: 'standard output': Broken pipe\nsort: write error\nimported gpg key\nimported gpg key\nimported gpg key\ncreating a fake machine id\ndeleting the fake machine id\n",
            "metadata": {
                "packages": [
                    {
                        "name": "polkit-pkla-compat",
                        "version": "0.1",
                        "release": "12.el8",
                        "epoch": null,
                        "arch": "x86_64",
                        "sigmd5": "10c5806679d48d041309fa2aa0e6444f",
                        "sigpgp": "8902150305005c144def199e2f91fd431d510108a5a10fff59ded2755aee521df20b65506c9e0bd5fb947a6bb67ad2b4a8a61b6e4785b071ce6a03249a3cecd89f38b65aada8deba04f5ff01db38857f9900ff2a51064f8ac6fd8262a4f70c55280800b887df66459f13b977b37fab7c24519d13013c025d06acb353511a66f805f13070d6daca5b32410742fcc0420c92f84c182e4745560e1b3aceb770664a7639b835fe3b45bd61d92efe417d75248a7d827a10747ee7de242ff900a7a517ab20b4fdee6e70c0bd80017c9ed7ea82a2c3edc50a146ba3b1f94b04ad344c9389fa4e9241d5a735f89d7d6f29024f328d83826cad7220de2ce4ef40147a0b5141efd139fe7bdede484238ea37f614465493058cfd57b89a97fa6b4d1de68138e51282ba0405b20d3484122839fee6aaaa0406b19fb630e0b074e243a9fb851dfb6620b4603a59209784d87a2e7f9a37586f9c082b232a94edf674e3888eab8fd511f84e0ed84bd17182f72a0d17b894be7eadcafe2383c367082a414d3a8335a0f1ee976dc3d475d14beaf64f750c3dc7008e53c4245ca4bdb15597bb21ec093b3516a2b6b209ea081863bee863bb85d3fd0529b06793e0c78ec9a693a9b4270e84db2683c6a279bef0aa323137559c7373adebb13ff1c2c5f8fa6c45f4589173cc1caf03c50f53bdf11d417797a148ee97becf3c995edc872d0773d941f1eb69f9e827f53580e9bae94501f2b0eac65280126b4afffdca",
                        "siggpg": null
                    }
                ]
            },
            "error": null
        },
        {
            "name": "org.osbuild.fix-bls",
            "id": "1832d911c6babd937f0027b6179415ea8aa2694b4a8b60ba99fb6953ddf83583",
            "options": {},
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.fstab",
            "id": "797558984d6fd812e1b17a8414e0948852f91aed4ba37f0a23793d2bd2ad5c1b",
            "options": {
                "filesystems": [
                    {
                        "uuid": "0194fdc2-fa2f-4cc0-81d3-ff12045b73c8",
                        "vfs_type": "xfs",
                        "path": "/",
                        "options": "defaults"
                    },
                    {
                        "uuid": "7B77-95E7",
                        "vfs_type": "vfat",
                        "path": "/boot/efi",
                        "options": "defaults,uid=0,gid=0,umask=077,shortname=winnt",
                        "passno": 2
                    }
                ]
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.grub2",
            "id": "70db1ca256b92f88f592488ce53aa04ea03b04d3b1d692297c7db63dc6592990",
            "options": {
                "root_fs_uuid": "0194fdc2-fa2f-4cc0-81d3-ff12045b73c8",
                "kernel_opts": "console=tty0 console=ttyS0,115200n8 no_timer_check net.ifnames=0 crashkernel=auto",
                "legacy": "i386-pc",
                "uefi": {
                    "vendor": "redhat"
                },
                "saved_entry": "ffffffffffffffffffffffffffffffff-4.18.0-275.el8.x86_64"
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n# GRUB Environment Block\nkernelopts=root=UUID=0194fdc2-fa2f-4cc0-81d3-ff12045b73c8 console=tty0 console=ttyS0,115200n8 no_timer_check net.ifnames=0 crashkernel=auto\nsaved_entry=ffffffffffffffffffffffffffffffff-4.18.0-275.el8.x86_64\n########################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################\nhybrid boot support enabled. Writing alias grub config\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.locale",
            "id": "afad29a4a677da2c8a6d81027a108490d93a25f5db51fde015bcea83bd026ade",
            "options": {
                "language": "en_US.UTF-8"
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n/run/osbuild/tree/etc/locale.conf written.\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.timezone",
            "id": "081e2b48a56b144a81602c6446502c84ea92f42607e28dd151ea27643db70752",
            "options": {
                "zone": "America/New_York"
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n/run/osbuild/tree/etc/localtime written\n/etc/localtime already exists. Replacing.\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.users",
            "id": "69789b06dcf62312ed5056c52176660df74a014f38518acb5875247cac341146",
            "options": {
                "users": {
                    "redhat": {
                        "key": "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC61wMCjOSHwbVb4VfVyl5sn497qW4PsdQ7Ty7aD6wDNZ/QjjULkDV/yW5WjDlDQ7UqFH0Sr7vywjqDizUAqK7zM5FsUKsUXWHWwg/ehKg8j9xKcMv11AkFoUoujtfAujnKODkk58XSA9whPr7qcw3vPrmog680pnMSzf9LC7J6kXfs6lkoKfBh9VnlxusCrw2yg0qI1fHAZBLPx7mW6+me71QZsS6sVz8v8KXyrXsKTdnF50FjzHcK9HXDBtSJS5wA3fkcRYymJe0o6WMWNdgSRVpoSiWaHHmFgdMUJaYoCfhXzyl7LtNb3Q+Sveg+tJK7JaRXBLMUllOlJ6ll5Hod root@localhost"
                    }
                }
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n(2021-03-19  9:02:59:069980): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19  9:02:59:070119): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19  9:02:59:101554): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19  9:02:59:101656): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.systemd",
            "id": "2bbe6089331c21741e0756b0282cd5b1ca97816fdf409b2fb7a9512db183fa10",
            "options": {
                "default_target": "multi-user.target"
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\nCreated symlink /run/osbuild/tree/etc/systemd/system/default.target → /usr/lib/systemd/system/multi-user.target.\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.selinux",
            "id": "cb87bb17c89e2c1ffa8f41d7753ecc72a28cc9635efc9d1ccc221708704f50c5",
            "options": {
                "file_contexts": "etc/selinux/targeted/contexts/files/file_contexts"
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.sysconfig",
            "id": "506487cc33281bb765d77f77ae61b407af4eb46d46880729129248c3b3453c01",
            "options": {
                "kernel": {
                    "update_default": true,
                    "default_kernel": "kernel"
                },
                "network": {
                    "networking": true,
                    "no_zero_conf": true
                }
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.rhsm",
            "id": "f66320355b4a71305ceb8be42c760f4932e2369e47df0be335cecfe436c5096f",
            "options": {
                "dnf-plugins": {
                    "product-id": {
                        "enabled": false
                    },
                    "subscription-manager": {
                        "enabled": false
                    }
                }
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n",
            "metadata": {},
            "error": null
        }
    ],
    "assembler": {
        "name": "org.osbuild.qemu",
        "id": "18e1d0944ef51a67165353c63934a5efd6f5a87903f455b5a9eb4dd664c93c91",
        "options": {
            "bootloader": {
                "type": "grub2"
            },
            "format": "qcow2",
            "filename": "disk.qcow2",
            "size": 10737418240,
            "ptuuid": "D209C89E-EA5E-4FBD-B161-B461CCE297E0",
            "pttype": "gpt",
            "partitions": [
                {
                    "start": 2048,
                    "size": 2048,
                    "type": "21686148-6449-6E6F-744E-656564454649",
                    "bootable": true,
                    "uuid": "FAC7F1FB-3E8D-4137-A512-961DE09A5549"
                },
                {
                    "start": 4096,
                    "size": 204800,
                    "type": "C12A7328-F81F-11D2-BA4B-00A0C93EC93B",
                    "uuid": "68B2905B-DF3E-4FB3-80FA-49D1E773AA33",
                    "filesystem": {
                        "type": "vfat",
                        "uuid": "7B77-95E7",
                        "mountpoint": "/boot/efi"
                    }
                },
                {
                    "start": 208896,
                    "type": "0FC63DAF-8483-4772-8E79-3D69D8477DE4",
                    "uuid": "6264D520-3FB9-423F-8AB8-7A0A8E3D3562",
                    "filesystem": {
                        "type": "xfs",
                        "uuid": "0194fdc2-fa2f-4cc0-81d3-ff12045b73c8",
                        "label": "root",
                        "mountpoint": "/"
                    }
                }
            ]
        },
        "success": true,
        "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\ngrub2-mkimage: info: the total module size is 0x6000.\ngrub2-mkimage: info: reading /usr/lib/grub/i386-pc/kernel.img.\ngrub2-mkimage: info: locating the section .text at 0x0.\ngrub2-mkimage: info: locating the section .rodata at 0xa100.\ngrub2-mkimage: info: locating the section .data at 0xba40.\ngrub2-mkimage: info: locating the section .module_license at 0xc2ec.\ngrub2-mkimage: info: locating the section .bss at 0xc300.\ngrub2-mkimage: info: reading /usr/lib/grub/i386-pc/biosdisk.mod.\ngrub2-mkimage: info: reading /usr/lib/grub/i386-pc/part_gpt.mod.\ngrub2-mkimage: info: reading /usr/lib/grub/i386-pc/fshelp.mod.\ngrub2-mkimage: info: reading /usr/lib/grub/i386-pc/xfs.mod.\ngrub2-mkimage: info: kernel_img=0x559b728e0a60, kernel_size=0xc2fb.\ngrub2-mkimage: info: the core size is 0x6f0b.\ngrub2-mkimage: info: reading /usr/lib/grub/i386-pc/lzma_decompress.img.\ngrub2-mkimage: info: reading /usr/lib/grub/i386-pc/diskboot.img.\ngrub2-mkimage: info: writing 0x200 bytes.\ngrub2-mkimage: info: writing 0x7a3b bytes.\nmeta-data=/dev/loop1             isize=512    agcount=4, agsize=648831 blks\n         =                       sectsz=512   attr=2, projid32bit=1\n         =                       crc=1        finobt=1, sparse=1, rmapbt=0\n         =                       reflink=1\ndata     =                       bsize=4096   blocks=2595323, imaxpct=25\n         =                       sunit=0      swidth=0 blks\nnaming   =version 2              bsize=4096   ascii-ci=0, ftype=1\nlog      =internal log           bsize=4096   blocks=2560, version=2\n         =                       sectsz=512   sunit=0 blks, lazy-count=1\nrealtime =none                   extsz=4096   blocks=0, rtextents=0\nDiscarding blocks...Done.\nmkfs.fat 4.1 (2017-01-24)\ngrub2 prefix gpt3\n",
        "metadata": {},
        "error": null
    }
}
`

const v1ResultFailure = `
{
    "success": false,
    "build": {
        "success": true,
        "stages": [
            {
                "name": "org.osbuild.rpm",
                "id": "6efecc9910457689fa56b362cfed5f0c9af2c9f1ebfe35bd5d54558b1fcbda06",
                "options": {
                    "gpgkeys": [
                        "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBErgSTsBEACh2A4b0O9t+vzC9VrVtL1AKvUWi9OPCjkvR7Xd8DtJxeeMZ5eF\n0HtzIG58qDRybwUe89FZprB1ffuUKzdE+HcL3FbNWSSOXVjZIersdXyH3NvnLLLF\n0DNRB2ix3bXG9Rh/RXpFsNxDp2CEMdUvbYCzE79K1EnUTVh1L0Of023FtPSZXX0c\nu7Pb5DI5lX5YeoXO6RoodrIGYJsVBQWnrWw4xNTconUfNPk0EGZtEnzvH2zyPoJh\nXGF+Ncu9XwbalnYde10OCvSWAZ5zTCpoLMTvQjWpbCdWXJzCm6G+/hx9upke546H\n5IjtYm4dTIVTnc3wvDiODgBKRzOl9rEOCIgOuGtDxRxcQkjrC+xvg5Vkqn7vBUyW\n9pHedOU+PoF3DGOM+dqv+eNKBvh9YF9ugFAQBkcG7viZgvGEMGGUpzNgN7XnS1gj\n/DPo9mZESOYnKceve2tIC87p2hqjrxOHuI7fkZYeNIcAoa83rBltFXaBDYhWAKS1\nPcXS1/7JzP0ky7d0L6Xbu/If5kqWQpKwUInXtySRkuraVfuK3Bpa+X1XecWi24JY\nHVtlNX025xx1ewVzGNCTlWn1skQN2OOoQTV4C8/qFpTW6DTWYurd4+fE0OJFJZQF\nbuhfXYwmRlVOgN5i77NTIJZJQfYFj38c/Iv5vZBPokO6mffrOTv3MHWVgQARAQAB\ntDNSZWQgSGF0LCBJbmMuIChyZWxlYXNlIGtleSAyKSA8c2VjdXJpdHlAcmVkaGF0\nLmNvbT6JAjYEEwECACAFAkrgSTsCGwMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAAK\nCRAZni+R/UMdUWzpD/9s5SFR/ZF3yjY5VLUFLMXIKUztNN3oc45fyLdTI3+UClKC\n2tEruzYjqNHhqAEXa2sN1fMrsuKec61Ll2NfvJjkLKDvgVIh7kM7aslNYVOP6BTf\nC/JJ7/ufz3UZmyViH/WDl+AYdgk3JqCIO5w5ryrC9IyBzYv2m0HqYbWfphY3uHw5\nun3ndLJcu8+BGP5F+ONQEGl+DRH58Il9Jp3HwbRa7dvkPgEhfFR+1hI+Btta2C7E\n0/2NKzCxZw7Lx3PBRcU92YKyaEihfy/aQKZCAuyfKiMvsmzs+4poIX7I9NQCJpyE\nIGfINoZ7VxqHwRn/d5mw2MZTJjbzSf+Um9YJyA0iEEyD6qjriWQRbuxpQXmlAJbh\n8okZ4gbVFv1F8MzK+4R8VvWJ0XxgtikSo72fHjwha7MAjqFnOq6eo6fEC/75g3NL\nGht5VdpGuHk0vbdENHMC8wS99e5qXGNDued3hlTavDMlEAHl34q2H9nakTGRF5Ki\nJUfNh3DVRGhg8cMIti21njiRh7gyFI2OccATY7bBSr79JhuNwelHuxLrCFpY7V25\nOFktl15jZJaMxuQBqYdBgSay2G0U6D1+7VsWufpzd/Abx1/c3oi9ZaJvW22kAggq\ndzdA27UUYjWvx42w9menJwh/0jeQcTecIUd0d0rFcw/c1pvgMMl/Q73yzKgKYw==\n=zbHE\n-----END PGP PUBLIC KEY BLOCK-----\n-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nvt61kpkXoRGxjTlc6h+69aidSg==\n=ls8J\n-----END PGP PUBLIC KEY BLOCK-----\n",
                        "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBErgSTsBEACh2A4b0O9t+vzC9VrVtL1AKvUWi9OPCjkvR7Xd8DtJxeeMZ5eF\n0HtzIG58qDRybwUe89FZprB1ffuUKzdE+HcL3FbNWSSOXVjZIersdXyH3NvnLLLF\n0DNRB2ix3bXG9Rh/RXpFsNxDp2CEMdUvbYCzE79K1EnUTVh1L0Of023FtPSZXX0c\nu7Pb5DI5lX5YeoXO6RoodrIGYJsVBQWnrWw4xNTconUfNPk0EGZtEnzvH2zyPoJh\nXGF+Ncu9XwbalnYde10OCvSWAZ5zTCpoLMTvQjWpbCdWXJzCm6G+/hx9upke546H\n5IjtYm4dTIVTnc3wvDiODgBKRzOl9rEOCIgOuGtDxRxcQkjrC+xvg5Vkqn7vBUyW\n9pHedOU+PoF3DGOM+dqv+eNKBvh9YF9ugFAQBkcG7viZgvGEMGGUpzNgN7XnS1gj\n/DPo9mZESOYnKceve2tIC87p2hqjrxOHuI7fkZYeNIcAoa83rBltFXaBDYhWAKS1\nPcXS1/7JzP0ky7d0L6Xbu/If5kqWQpKwUInXtySRkuraVfuK3Bpa+X1XecWi24JY\nHVtlNX025xx1ewVzGNCTlWn1skQN2OOoQTV4C8/qFpTW6DTWYurd4+fE0OJFJZQF\nbuhfXYwmRlVOgN5i77NTIJZJQfYFj38c/Iv5vZBPokO6mffrOTv3MHWVgQARAQAB\ntDNSZWQgSGF0LCBJbmMuIChyZWxlYXNlIGtleSAyKSA8c2VjdXJpdHlAcmVkaGF0\nLmNvbT6JAjYEEwECACAFAkrgSTsCGwMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAAK\nCRAZni+R/UMdUWzpD/9s5SFR/ZF3yjY5VLUFLMXIKUztNN3oc45fyLdTI3+UClKC\n2tEruzYjqNHhqAEXa2sN1fMrsuKec61Ll2NfvJjkLKDvgVIh7kM7aslNYVOP6BTf\nC/JJ7/ufz3UZmyViH/WDl+AYdgk3JqCIO5w5ryrC9IyBzYv2m0HqYbWfphY3uHw5\nun3ndLJcu8+BGP5F+ONQEGl+DRH58Il9Jp3HwbRa7dvkPgEhfFR+1hI+Btta2C7E\n0/2NKzCxZw7Lx3PBRcU92YKyaEihfy/aQKZCAuyfKiMvsmzs+4poIX7I9NQCJpyE\nIGfINoZ7VxqHwRn/d5mw2MZTJjbzSf+Um9YJyA0iEEyD6qjriWQRbuxpQXmlAJbh\n8okZ4gbVFv1F8MzK+4R8VvWJ0XxgtikSo72fHjwha7MAjqFnOq6eo6fEC/75g3NL\nGht5VdpGuHk0vbdENHMC8wS99e5qXGNDued3hlTavDMlEAHl34q2H9nakTGRF5Ki\nJUfNh3DVRGhg8cMIti21njiRh7gyFI2OccATY7bBSr79JhuNwelHuxLrCFpY7V25\nOFktl15jZJaMxuQBqYdBgSay2G0U6D1+7VsWufpzd/Abx1/c3oi9ZaJvW22kAggq\ndzdA27UUYjWvx42w9menJwh/0jeQcTecIUd0d0rFcw/c1pvgMMl/Q73yzKgKYw==\n=zbHE\n-----END PGP PUBLIC KEY BLOCK-----\n-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nvt61kpkXoRGxjTlc6h+69aidSg==\n=ls8J\n-----END PGP PUBLIC KEY BLOCK-----\n",
                        "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBErgSTsBEACh2A4b0O9t+vzC9VrVtL1AKvUWi9OPCjkvR7Xd8DtJxeeMZ5eF\n0HtzIG58qDRybwUe89FZprB1ffuUKzdE+HcL3FbNWSSOXVjZIersdXyH3NvnLLLF\n0DNRB2ix3bXG9Rh/RXpFsNxDp2CEMdUvbYCzE79K1EnUTVh1L0Of023FtPSZXX0c\nu7Pb5DI5lX5YeoXO6RoodrIGYJsVBQWnrWw4xNTconUfNPk0EGZtEnzvH2zyPoJh\nXGF+Ncu9XwbalnYde10OCvSWAZ5zTCpoLMTvQjWpbCdWXJzCm6G+/hx9upke546H\n5IjtYm4dTIVTnc3wvDiODgBKRzOl9rEOCIgOuGtDxRxcQkjrC+xvg5Vkqn7vBUyW\n9pHedOU+PoF3DGOM+dqv+eNKBvh9YF9ugFAQBkcG7viZgvGEMGGUpzNgN7XnS1gj\n/DPo9mZESOYnKceve2tIC87p2hqjrxOHuI7fkZYeNIcAoa83rBltFXaBDYhWAKS1\nPcXS1/7JzP0ky7d0L6Xbu/If5kqWQpKwUInXtySRkuraVfuK3Bpa+X1XecWi24JY\nHVtlNX025xx1ewVzGNCTlWn1skQN2OOoQTV4C8/qFpTW6DTWYurd4+fE0OJFJZQF\nbuhfXYwmRlVOgN5i77NTIJZJQfYFj38c/Iv5vZBPokO6mffrOTv3MHWVgQARAQAB\ntDNSZWQgSGF0LCBJbmMuIChyZWxlYXNlIGtleSAyKSA8c2VjdXJpdHlAcmVkaGF0\nLmNvbT6JAjYEEwECACAFAkrgSTsCGwMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAAK\nCRAZni+R/UMdUWzpD/9s5SFR/ZF3yjY5VLUFLMXIKUztNN3oc45fyLdTI3+UClKC\n2tEruzYjqNHhqAEXa2sN1fMrsuKec61Ll2NfvJjkLKDvgVIh7kM7aslNYVOP6BTf\nC/JJ7/ufz3UZmyViH/WDl+AYdgk3JqCIO5w5ryrC9IyBzYv2m0HqYbWfphY3uHw5\nun3ndLJcu8+BGP5F+ONQEGl+DRH58Il9Jp3HwbRa7dvkPgEhfFR+1hI+Btta2C7E\n0/2NKzCxZw7Lx3PBRcU92YKyaEihfy/aQKZCAuyfKiMvsmzs+4poIX7I9NQCJpyE\nIGfINoZ7VxqHwRn/d5mw2MZTJjbzSf+Um9YJyA0iEEyD6qjriWQRbuxpQXmlAJbh\n8okZ4gbVFv1F8MzK+4R8VvWJ0XxgtikSo72fHjwha7MAjqFnOq6eo6fEC/75g3NL\nGht5VdpGuHk0vbdENHMC8wS99e5qXGNDued3hlTavDMlEAHl34q2H9nakTGRF5Ki\nJUfNh3DVRGhg8cMIti21njiRh7gyFI2OccATY7bBSr79JhuNwelHuxLrCFpY7V25\nOFktl15jZJaMxuQBqYdBgSay2G0U6D1+7VsWufpzd/Abx1/c3oi9ZaJvW22kAggq\ndzdA27UUYjWvx42w9menJwh/0jeQcTecIUd0d0rFcw/c1pvgMMl/Q73yzKgKYw==\n=zbHE\n-----END PGP PUBLIC KEY BLOCK-----\n-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nvt61kpkXoRGxjTlc6h+69aidSg==\n=ls8J\n-----END PGP PUBLIC KEY BLOCK-----\n"
                    ],
                    "packages": [
                        {
                            "checksum": "sha256:ce7e129103cab9de8081b9752a9990a632b5930e371988892e671bb47d42d14e"
                        }
                    ]
                },
                "success": true,
                "output": "/usr/lib/tmpfiles.d/abrt.conf:2: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/abrt.conf:9: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/colord.conf:1: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:2: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:3: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/cups.conf:4: Failed to resolve user 'lp': No such process\n/usr/lib/tmpfiles.d/gluster.conf:2: Failed to resolve user 'gluster': No such process\n/usr/lib/tmpfiles.d/httpd.conf:1: Failed to resolve group 'apache'.\n/usr/lib/tmpfiles.d/httpd.conf:2: Failed to resolve user 'apache': No such process\n/usr/lib/tmpfiles.d/journal-nocow.conf:26: Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\n/usr/lib/tmpfiles.d/lockdev.conf:3: Failed to resolve group 'lock'.\n/usr/lib/tmpfiles.d/openvpn.conf:1: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/openvpn.conf:2: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/radvd.conf:1: Failed to resolve user 'radvd': No such process\n/usr/lib/tmpfiles.d/rpcbind.conf:2: Failed to resolve user 'rpc': No such process\nFailed to open file \"/sys/fs/selinux/checkreqprot\": Read-only file system\nPreparing packages...\nlibgcc-8.4.1-1.el8.x86_64\npython3-setuptools-wheel-39.2.0-6.el8.noarch\npython3-pip-wheel-9.0.3-19.el8.noarch\nxkeyboard-config-2.28-1.el8.noarch\ntzdata-2020f-1.el8.noarch\nredhat-release-eula-8.4-0.5.el8.x86_64\nredhat-release-8.4-0.5.el8.x86_64\nsetup-2.12.2-6.el8.noarch\nfilesystem-3.8-3.el8.x86_64\nbasesystem-11-5.el8.noarch\npublicsuffix-list-dafsa-20180723-1.el8.noarch\nncurses-base-6.1-7.20180224.el8.noarch\npcre2-10.32-2.el8.x86_64\nlibselinux-2.9-5.el8.x86_64\nncurses-libs-6.1-7.20180224.el8.x86_64\nglibc-all-langpacks-2.28-145.el8.x86_64\nglibc-common-2.28-145.el8.x86_64\nglibc-2.28-145.el8.x86_64\nbash-4.4.19-14.el8.x86_64\nlibsepol-2.9-2.el8.x86_64\nzlib-1.2.11-17.el8.x86_64\nxz-libs-5.2.4-3.el8.x86_64\nbzip2-libs-1.0.6-26.el8.x86_64\nlibgpg-error-1.31-1.el8.x86_64\ninfo-6.5-6.el8.x86_64\nlibcap-2.26-4.el8.x86_64\nlibxml2-2.9.7-9.el8.x86_64\nelfutils-libelf-0.182-3.el8.x86_64\nlibcom_err-1.45.6-1.el8.x86_64\nlibzstd-1.4.4-1.el8.x86_64\nlibuuid-2.32.1-26.el8.x86_64\npopt-1.18-1.el8.x86_64\nreadline-7.0-10.el8.x86_64\nlibgcrypt-1.8.5-4.el8.x86_64\nexpat-2.2.5-4.el8.x86_64\nlibxcrypt-4.1.1-4.el8.x86_64\nlua-libs-5.3.4-11.el8.x86_64\nchkconfig-1.13-2.el8.x86_64\nlibunistring-0.9.9-3.el8.x86_64\nsqlite-libs-3.26.0-13.el8.x86_64\ngrub2-common-1:2.02-93.el8.noarch\ngmp-1:6.1.2-10.el8.x86_64\nlibstdc++-8.4.1-1.el8.x86_64\nlibidn2-2.2.0-1.el8.x86_64\nlibassuan-2.5.1-3.el8.x86_64\nfile-libs-5.33-16.el8.x86_64\njson-c-0.13.1-0.3.el8.x86_64\nlibattr-2.4.48-3.el8.x86_64\nlibacl-2.2.53-1.el8.x86_64\nsed-4.5-2.el8.x86_64\nlibcap-ng-0.7.9-5.el8.x86_64\naudit-libs-3.0-0.17.20191104git1c2f876.el8.x86_64\nlibsmartcols-2.32.1-26.el8.x86_64\nfile-5.33-16.el8.x86_64\nlibffi-3.1-22.el8.x86_64\np11-kit-0.23.22-1.el8.x86_64\nlz4-libs-1.8.3-2.el8.x86_64\nwhich-2.21-12.el8.x86_64\nlibsemanage-2.9-4.el8.x86_64\ndiffutils-3.6-6.el8.x86_64\nfindutils-1:4.6.0-20.el8.x86_64\nlibgomp-8.4.1-1.el8.x86_64\nlibksba-1.3.5-7.el8.x86_64\ngdbm-libs-1:1.18-1.el8.x86_64\nkeyutils-libs-1.5.10-6.el8.x86_64\nlibtasn1-4.13-3.el8.x86_64\np11-kit-trust-0.23.22-1.el8.x86_64\npcre-8.42-4.el8.x86_64\ngrep-3.1-6.el8.x86_64\nxz-5.2.4-3.el8.x86_64\ngdbm-1:1.18-1.el8.x86_64\nacl-2.2.53-1.el8.x86_64\nlibpsl-0.20.2-6.el8.x86_64\nmpfr-3.1.6-1.el8.x86_64\nnettle-3.4.1-2.el8.x86_64\ngrub2-pc-modules-1:2.02-93.el8.noarch\nlibcomps-0.1.11-4.el8.x86_64\nlibmetalink-0.1.3-7.el8.x86_64\ne2fsprogs-libs-1.45.6-1.el8.x86_64\nlibss-1.45.6-1.el8.x86_64\ncoreutils-common-8.30-8.el8.x86_64\nlibpng-2:1.6.34-5.el8.x86_64\nfreetype-2.9.1-4.el8_3.1.x86_64\npigz-2.4-4.el8.x86_64\nlibselinux-utils-2.9-5.el8.x86_64\nbrotli-1.0.6-3.el8.x86_64\ncpio-2.12-9.el8.x86_64\nfuse-libs-2.9.7-12.el8.x86_64\nhardlink-1:1.3-6.el8.x86_64\nlibaio-0.3.112-1.el8.x86_64\nlibnghttp2-1.33.0-3.el8_2.1.x86_64\nlibpcap-14:1.9.1-4.el8.x86_64\niptables-libs-1.8.4-16.el8.x86_64\nlibseccomp-2.4.3-1.el8.x86_64\nlibsigsegv-2.11-5.el8.x86_64\ngawk-4.2.1-2.el8.x86_64\nlibverto-0.3.0-5.el8.x86_64\nlibyaml-0.1.7-5.el8.x86_64\nmemstrack-0.1.11-1.el8.x86_64\nncurses-6.1-7.20180224.el8.x86_64\nnpth-1.5-4.el8.x86_64\nlibxkbcommon-0.9.1-1.el8.x86_64\nlibssh-config-0.9.4-2.el8.noarch\nlibreport-filesystem-2.9.5-15.el8.x86_64\ndnf-data-4.4.2-3.el8.noarch\nkbd-misc-2.0.4-10.el8.noarch\nkbd-legacy-2.0.4-10.el8.noarch\ndbus-common-1:1.12.8-12.el8.noarch\ncyrus-sasl-lib-2.1.27-5.el8.x86_64\nplatform-python-pip-9.0.3-19.el8.noarch\nplatform-python-setuptools-39.2.0-6.el8.noarch\npython3-libs-3.6.8-34.el8.x86_64\ngrub2-tools-minimal-1:2.02-93.el8.x86_64\nlibssh-0.9.4-2.el8.x86_64\nopenldap-2.4.46-16.el8.x86_64\nplatform-python-3.6.8-34.el8.x86_64\ngrubby-8.40-41.el8.x86_64\nlibkcapi-1.2.0-2.el8.x86_64\nlibkcapi-hmaccalc-1.2.0-2.el8.x86_64\nlibarchive-3.3.3-1.el8.x86_64\nlibdb-utils-5.3.28-40.el8.x86_64\ncurl-7.61.1-17.el8.x86_64\nlibcurl-7.61.1-17.el8.x86_64\nopenssl-1:1.1.1g-12.el8_3.x86_64\ncrypto-policies-scripts-20200713-1.git51d1222.el8.noarch\ncrypto-policies-20200713-1.git51d1222.el8.noarch\nelfutils-default-yama-scope-0.182-3.el8.noarch\ngzip-1.9-12.el8.x86_64\ncracklib-2.9.6-15.el8.x86_64\ncracklib-dicts-2.9.6-15.el8.x86_64\nprocps-ng-3.3.15-5.el8.x86_64\nkrb5-libs-1.18.2-8.el8.x86_64\nlibtirpc-1.1.4-4.el8.x86_64\nlibnsl2-1.2.0-2.20180605git4a062cf.el8.x86_64\nkpartx-0.8.4-7.el8.x86_64\ndevice-mapper-8:1.02.175-1.el8.x86_64\nelfutils-debuginfod-client-0.182-3.el8.x86_64\nelfutils-libs-0.182-3.el8.x86_64\nopenssl-pkcs11-0.4.10-2.el8.x86_64\nrpm-4.14.3-4.el8.x86_64\ngettext-libs-0.19.8.1-17.el8.x86_64\nlibcroco-0.6.12-4.el8_2.1.x86_64\nlibfdisk-2.32.1-26.el8.x86_64\nlibmount-2.32.1-26.el8.x86_64\ndbus-libs-1:1.12.8-12.el8.x86_64\ndbus-tools-1:1.12.8-12.el8.x86_64\ncoreutils-8.30-8.el8.x86_64\nlibblkid-2.32.1-26.el8.x86_64\nsystemd-libs-239-43.el8.x86_64\ndevice-mapper-libs-8:1.02.175-1.el8.x86_64\nshadow-utils-2:4.6-12.el8.x86_64\nca-certificates-2020.2.41-80.0.el8_2.noarch\nopenssl-libs-1:1.1.1g-12.el8_3.x86_64\nlibdb-5.3.28-40.el8.x86_64\nrpm-libs-4.14.3-4.el8.x86_64\nkmod-25-17.el8.x86_64\nkmod-libs-25-17.el8.x86_64\ncryptsetup-libs-2.3.3-2.el8.x86_64\ntrousers-lib-0.3.15-1.el8.x86_64\ndbus-daemon-1:1.12.8-12.el8.x86_64\nlibutempter-1.1.6-14.el8.x86_64\nkbd-2.0.4-10.el8.x86_64\nlibpwquality-1.4.4-1.el8.x86_64\npam-1.3.1-14.el8.x86_64\nutil-linux-2.32.1-26.el8.x86_64\nsystemd-pam-239-43.el8.x86_64\ndracut-049-133.git20210112.el8.x86_64\nos-prober-1.74-6.el8.x86_64\ngettext-0.19.8.1-17.el8.x86_64\ngrub2-tools-1:2.02-93.el8.x86_64\nglib2-2.56.4-9.el8.x86_64\nshared-mime-info-1.9-3.el8.x86_64\ngnutls-3.6.14-7.el8_3.x86_64\ndbus-1:1.12.8-12.el8.x86_64\nsystemd-239-43.el8.x86_64\nsystemd-udev-239-43.el8.x86_64\ntrousers-0.3.15-1.el8.x86_64\njson-glib-1.4.4-1.el8.x86_64\nlibmodulemd-2.9.4-2.el8.x86_64\nlibrhsm-0.0.3-4.el8.x86_64\nlibsolv-0.7.16-1.el8.x86_64\npolicycoreutils-2.9-9.el8.x86_64\nima-evm-utils-1.1-5.el8.x86_64\nlibevent-2.1.8-5.el8.x86_64\nunbound-libs-1.7.3-15.el8.x86_64\npython3-unbound-1.7.3-15.el8.x86_64\nrpm-plugin-selinux-4.14.3-4.el8.x86_64\nselinux-policy-3.14.3-60.el8.noarch\nselinux-policy-targeted-3.14.3-60.el8.noarch\nlibsecret-0.18.6-1.el8.x86_64\npinentry-1.1.0-2.el8.x86_64\ngrub2-tools-extra-1:2.02-93.el8.x86_64\nrpm-plugin-systemd-inhibit-4.14.3-4.el8.x86_64\nlibusbx-1.0.23-4.el8.x86_64\ngnupg2-smime-2.2.20-2.el8.x86_64\ngnupg2-2.2.20-2.el8.x86_64\ngpgme-1.13.1-7.el8.x86_64\nlibrepo-1.12.0-3.el8.x86_64\nlibdnf-0.55.0-1.el8.x86_64\npython3-libdnf-0.55.0-1.el8.x86_64\npython3-hawkey-0.55.0-1.el8.x86_64\npython3-gpg-1.13.1-7.el8.x86_64\nrpm-build-libs-4.14.3-4.el8.x86_64\npython3-rpm-4.14.3-4.el8.x86_64\npython3-libcomps-0.1.11-4.el8.x86_64\npython3-dnf-4.4.2-3.el8.noarch\npython3-setuptools-39.2.0-6.el8.noarch\npython3-pip-9.0.3-19.el8.noarch\npython36-3.6.8-2.module+el8.1.0+3334+5cb623d7.x86_64\npython3-six-1.11.0-8.el8.noarch\npython3-iniparse-0.4-31.el8.noarch\ndnf-4.4.2-3.el8.noarch\ngrub2-pc-1:2.02-93.el8.x86_64\nqemu-img-15:4.2.0-41.module+el8.4.0+9504+ab2393e6.x86_64\nxfsprogs-5.0.0-8.el8.x86_64\ne2fsprogs-1.45.6-1.el8.x86_64\ntar-2:1.30-5.el8.x86_64\ndosfstools-4.1-6.el8.x86_64\nimported gpg key\nimported gpg key\nimported gpg key\ncreating a fake machine id\ndeleting the fake machine id\n",
                "metadata": {
                    "packages": [
                        {
                            "name": "gpg-pubkey",
                            "version": "fd431d51",
                            "release": "4ae0493b",
                            "epoch": null,
                            "arch": null,
                            "sigmd5": null,
                            "sigpgp": null,
                            "siggpg": null
                        }
                    ]
                },
                "error": null
            },
            {
                "name": "org.osbuild.selinux",
                "id": "abc451d81c7c03be83af647efdf9217954d06332f41fac5f709b695697a6dd6a",
                "options": {
                    "file_contexts": "etc/selinux/targeted/contexts/files/file_contexts"
                },
                "success": true,
                "output": "/usr/lib/tmpfiles.d/abrt.conf:2: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/abrt.conf:9: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/colord.conf:1: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:2: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:3: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/cups.conf:4: Failed to resolve user 'lp': No such process\n/usr/lib/tmpfiles.d/gluster.conf:2: Failed to resolve user 'gluster': No such process\n/usr/lib/tmpfiles.d/httpd.conf:1: Failed to resolve group 'apache'.\n/usr/lib/tmpfiles.d/httpd.conf:2: Failed to resolve user 'apache': No such process\n/usr/lib/tmpfiles.d/journal-nocow.conf:26: Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\n/usr/lib/tmpfiles.d/lockdev.conf:3: Failed to resolve group 'lock'.\n/usr/lib/tmpfiles.d/openvpn.conf:1: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/openvpn.conf:2: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/radvd.conf:1: Failed to resolve user 'radvd': No such process\n/usr/lib/tmpfiles.d/rpcbind.conf:2: Failed to resolve user 'rpc': No such process\nFailed to open file \"/sys/fs/selinux/checkreqprot\": Read-only file system\n",
                "metadata": {},
                "error": null
            }
        ]
    },
    "stages": [
        {
            "name": "org.osbuild.rpm",
            "id": "dcf25b0b73304c9ea2e02fe1c835c5234242697061d37849b23a2bd44de764ff",
            "options": {
                "gpgkeys": [
                    "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBErgSTsBEACh2A4b0O9t+vzC9VrVtL1AKvUWi9OPCjkvR7Xd8DtJxeeMZ5eF\n0HtzIG58qDRybwUe89FZprB1ffuUKzdE+HcL3FbNWSSOXVjZIersdXyH3NvnLLLF\n0DNRB2ix3bXG9Rh/RXpFsNxDp2CEMdUvbYCzE79K1EnUTVh1L0Of023FtPSZXX0c\nu7Pb5DI5lX5YeoXO6RoodrIGYJsVBQWnrWw4xNTconUfNPk0EGZtEnzvH2zyPoJh\nXGF+Ncu9XwbalnYde10OCvSWAZ5zTCpoLMTvQjWpbCdWXJzCm6G+/hx9upke546H\n5IjtYm4dTIVTnc3wvDiODgBKRzOl9rEOCIgOuGtDxRxcQkjrC+xvg5Vkqn7vBUyW\n9pHedOU+PoF3DGOM+dqv+eNKBvh9YF9ugFAQBkcG7viZgvGEMGGUpzNgN7XnS1gj\n/DPo9mZESOYnKceve2tIC87p2hqjrxOHuI7fkZYeNIcAoa83rBltFXaBDYhWAKS1\nPcXS1/7JzP0ky7d0L6Xbu/If5kqWQpKwUInXtySRkuraVfuK3Bpa+X1XecWi24JY\nHVtlNX025xx1ewVzGNCTlWn1skQN2OOoQTV4C8/qFpTW6DTWYurd4+fE0OJFJZQF\nbuhfXYwmRlVOgN5i77NTIJZJQfYFj38c/Iv5vZBPokO6mffrOTv3MHWVgQARAQAB\ntDNSZWQgSGF0LCBJbmMuIChyZWxlYXNlIGtleSAyKSA8c2VjdXJpdHlAcmVkaGF0\nLmNvbT6JAjYEEwECACAFAkrgSTsCGwMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAAK\nCRAZni+R/UMdUWzpD/9s5SFR/ZF3yjY5VLUFLMXIKUztNN3oc45fyLdTI3+UClKC\n2tEruzYjqNHhqAEXa2sN1fMrsuKec61Ll2NfvJjkLKDvgVIh7kM7aslNYVOP6BTf\nC/JJ7/ufz3UZmyViH/WDl+AYdgk3JqCIO5w5ryrC9IyBzYv2m0HqYbWfphY3uHw5\nun3ndLJcu8+BGP5F+ONQEGl+DRH58Il9Jp3HwbRa7dvkPgEhfFR+1hI+Btta2C7E\n0/2NKzCxZw7Lx3PBRcU92YKyaEihfy/aQKZCAuyfKiMvsmzs+4poIX7I9NQCJpyE\nIGfINoZ7VxqHwRn/d5mw2MZTJjbzSf+Um9YJyA0iEEyD6qjriWQRbuxpQXmlAJbh\n8okZ4gbVFv1F8MzK+4R8VvWJ0XxgtikSo72fHjwha7MAjqFnOq6eo6fEC/75g3NL\nGht5VdpGuHk0vbdENHMC8wS99e5qXGNDued3hlTavDMlEAHl34q2H9nakTGRF5Ki\nJUfNh3DVRGhg8cMIti21njiRh7gyFI2OccATY7bBSr79JhuNwelHuxLrCFpY7V25\nOFktl15jZJaMxuQBqYdBgSay2G0U6D1+7VsWufpzd/Abx1/c3oi9ZaJvW22kAggq\ndzdA27UUYjWvx42w9menJwh/0jeQcTecIUd0d0rFcw/c1pvgMMl/Q73yzKgKYw==\n=zbHE\n-----END PGP PUBLIC KEY BLOCK-----\n-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nvt61kpkXoRGxjTlc6h+69aidSg==\n=ls8J\n-----END PGP PUBLIC KEY BLOCK-----\n",
                    "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBErgSTsBEACh2A4b0O9t+vzC9VrVtL1AKvUWi9OPCjkvR7Xd8DtJxeeMZ5eF\n0HtzIG58qDRybwUe89FZprB1ffuUKzdE+HcL3FbNWSSOXVjZIersdXyH3NvnLLLF\n0DNRB2ix3bXG9Rh/RXpFsNxDp2CEMdUvbYCzE79K1EnUTVh1L0Of023FtPSZXX0c\nu7Pb5DI5lX5YeoXO6RoodrIGYJsVBQWnrWw4xNTconUfNPk0EGZtEnzvH2zyPoJh\nXGF+Ncu9XwbalnYde10OCvSWAZ5zTCpoLMTvQjWpbCdWXJzCm6G+/hx9upke546H\n5IjtYm4dTIVTnc3wvDiODgBKRzOl9rEOCIgOuGtDxRxcQkjrC+xvg5Vkqn7vBUyW\n9pHedOU+PoF3DGOM+dqv+eNKBvh9YF9ugFAQBkcG7viZgvGEMGGUpzNgN7XnS1gj\n/DPo9mZESOYnKceve2tIC87p2hqjrxOHuI7fkZYeNIcAoa83rBltFXaBDYhWAKS1\nPcXS1/7JzP0ky7d0L6Xbu/If5kqWQpKwUInXtySRkuraVfuK3Bpa+X1XecWi24JY\nHVtlNX025xx1ewVzGNCTlWn1skQN2OOoQTV4C8/qFpTW6DTWYurd4+fE0OJFJZQF\nbuhfXYwmRlVOgN5i77NTIJZJQfYFj38c/Iv5vZBPokO6mffrOTv3MHWVgQARAQAB\ntDNSZWQgSGF0LCBJbmMuIChyZWxlYXNlIGtleSAyKSA8c2VjdXJpdHlAcmVkaGF0\nLmNvbT6JAjYEEwECACAFAkrgSTsCGwMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAAK\nCRAZni+R/UMdUWzpD/9s5SFR/ZF3yjY5VLUFLMXIKUztNN3oc45fyLdTI3+UClKC\n2tEruzYjqNHhqAEXa2sN1fMrsuKec61Ll2NfvJjkLKDvgVIh7kM7aslNYVOP6BTf\nC/JJ7/ufz3UZmyViH/WDl+AYdgk3JqCIO5w5ryrC9IyBzYv2m0HqYbWfphY3uHw5\nun3ndLJcu8+BGP5F+ONQEGl+DRH58Il9Jp3HwbRa7dvkPgEhfFR+1hI+Btta2C7E\n0/2NKzCxZw7Lx3PBRcU92YKyaEihfy/aQKZCAuyfKiMvsmzs+4poIX7I9NQCJpyE\nIGfINoZ7VxqHwRn/d5mw2MZTJjbzSf+Um9YJyA0iEEyD6qjriWQRbuxpQXmlAJbh\n8okZ4gbVFv1F8MzK+4R8VvWJ0XxgtikSo72fHjwha7MAjqFnOq6eo6fEC/75g3NL\nGht5VdpGuHk0vbdENHMC8wS99e5qXGNDued3hlTavDMlEAHl34q2H9nakTGRF5Ki\nJUfNh3DVRGhg8cMIti21njiRh7gyFI2OccATY7bBSr79JhuNwelHuxLrCFpY7V25\nOFktl15jZJaMxuQBqYdBgSay2G0U6D1+7VsWufpzd/Abx1/c3oi9ZaJvW22kAggq\ndzdA27UUYjWvx42w9menJwh/0jeQcTecIUd0d0rFcw/c1pvgMMl/Q73yzKgKYw==\n=zbHE\n-----END PGP PUBLIC KEY BLOCK-----\n-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nvt61kpkXoRGxjTlc6h+69aidSg==\n=ls8J\n-----END PGP PUBLIC KEY BLOCK-----\n",
                    "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBErgSTsBEACh2A4b0O9t+vzC9VrVtL1AKvUWi9OPCjkvR7Xd8DtJxeeMZ5eF\n0HtzIG58qDRybwUe89FZprB1ffuUKzdE+HcL3FbNWSSOXVjZIersdXyH3NvnLLLF\n0DNRB2ix3bXG9Rh/RXpFsNxDp2CEMdUvbYCzE79K1EnUTVh1L0Of023FtPSZXX0c\nu7Pb5DI5lX5YeoXO6RoodrIGYJsVBQWnrWw4xNTconUfNPk0EGZtEnzvH2zyPoJh\nXGF+Ncu9XwbalnYde10OCvSWAZ5zTCpoLMTvQjWpbCdWXJzCm6G+/hx9upke546H\n5IjtYm4dTIVTnc3wvDiODgBKRzOl9rEOCIgOuGtDxRxcQkjrC+xvg5Vkqn7vBUyW\n9pHedOU+PoF3DGOM+dqv+eNKBvh9YF9ugFAQBkcG7viZgvGEMGGUpzNgN7XnS1gj\n/DPo9mZESOYnKceve2tIC87p2hqjrxOHuI7fkZYeNIcAoa83rBltFXaBDYhWAKS1\nPcXS1/7JzP0ky7d0L6Xbu/If5kqWQpKwUInXtySRkuraVfuK3Bpa+X1XecWi24JY\nHVtlNX025xx1ewVzGNCTlWn1skQN2OOoQTV4C8/qFpTW6DTWYurd4+fE0OJFJZQF\nbuhfXYwmRlVOgN5i77NTIJZJQfYFj38c/Iv5vZBPokO6mffrOTv3MHWVgQARAQAB\ntDNSZWQgSGF0LCBJbmMuIChyZWxlYXNlIGtleSAyKSA8c2VjdXJpdHlAcmVkaGF0\nLmNvbT6JAjYEEwECACAFAkrgSTsCGwMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAAK\nCRAZni+R/UMdUWzpD/9s5SFR/ZF3yjY5VLUFLMXIKUztNN3oc45fyLdTI3+UClKC\n2tEruzYjqNHhqAEXa2sN1fMrsuKec61Ll2NfvJjkLKDvgVIh7kM7aslNYVOP6BTf\nC/JJ7/ufz3UZmyViH/WDl+AYdgk3JqCIO5w5ryrC9IyBzYv2m0HqYbWfphY3uHw5\nun3ndLJcu8+BGP5F+ONQEGl+DRH58Il9Jp3HwbRa7dvkPgEhfFR+1hI+Btta2C7E\n0/2NKzCxZw7Lx3PBRcU92YKyaEihfy/aQKZCAuyfKiMvsmzs+4poIX7I9NQCJpyE\nIGfINoZ7VxqHwRn/d5mw2MZTJjbzSf+Um9YJyA0iEEyD6qjriWQRbuxpQXmlAJbh\n8okZ4gbVFv1F8MzK+4R8VvWJ0XxgtikSo72fHjwha7MAjqFnOq6eo6fEC/75g3NL\nGht5VdpGuHk0vbdENHMC8wS99e5qXGNDued3hlTavDMlEAHl34q2H9nakTGRF5Ki\nJUfNh3DVRGhg8cMIti21njiRh7gyFI2OccATY7bBSr79JhuNwelHuxLrCFpY7V25\nOFktl15jZJaMxuQBqYdBgSay2G0U6D1+7VsWufpzd/Abx1/c3oi9ZaJvW22kAggq\ndzdA27UUYjWvx42w9menJwh/0jeQcTecIUd0d0rFcw/c1pvgMMl/Q73yzKgKYw==\n=zbHE\n-----END PGP PUBLIC KEY BLOCK-----\n-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nvt61kpkXoRGxjTlc6h+69aidSg==\n=ls8J\n-----END PGP PUBLIC KEY BLOCK-----\n"
                ],
                "packages": [
                    {
                        "checksum": "sha256:7043ce24e7d3c8f8760c2697d524f049c425f64df85b79e7e40ef0b92288798d"
                    }
                ]
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\nPreparing packages...\nlibgcc-8.4.1-1.el8.x86_64\ntzdata-2020f-1.el8.noarch\nfontpackages-filesystem-1.44-22.el8.noarch\ngeolite2-country-20180605-1.el8.noarch\ngeolite2-city-20180605-1.el8.noarch\npython3-setuptools-wheel-39.2.0-6.el8.noarch\npython3-pip-wheel-9.0.3-19.el8.noarch\nhwdata-0.314-8.7.el8.noarch\ndejavu-fonts-common-2.35-7.el8.noarch\ndejavu-sans-mono-fonts-2.35-7.el8.noarch\nabattis-cantarell-fonts-0.0.25-6.el8.noarch\nxkeyboard-config-2.28-1.el8.noarch\nlibX11-common-1.6.8-4.el8.noarch\nsubscription-manager-rhsm-certificates-1.28.9-1.el8.x86_64\nrhsm-icons-1.28.9-1.el8.noarch\nredhat-release-eula-8.4-0.5.el8.x86_64\nredhat-release-8.4-0.5.el8.x86_64\nsetup-2.12.2-6.el8.noarch\nfilesystem-3.8-3.el8.x86_64\nefi-filesystem-3-3.el8.noarch\nbasesystem-11-5.el8.noarch\nquota-nls-1:4.04-12.el8.noarch\npublicsuffix-list-dafsa-20180723-1.el8.noarch\nncurses-base-6.1-7.20180224.el8.noarch\npcre2-10.32-2.el8.x86_64\nlibselinux-2.9-5.el8.x86_64\nncurses-libs-6.1-7.20180224.el8.x86_64\nglibc-all-langpacks-2.28-145.el8.x86_64\nglibc-common-2.28-145.el8.x86_64\nglibc-2.28-145.el8.x86_64\nbash-4.4.19-14.el8.x86_64\nlibsepol-2.9-2.el8.x86_64\nzlib-1.2.11-17.el8.x86_64\nxz-libs-5.2.4-3.el8.x86_64\npopt-1.18-1.el8.x86_64\nlibcom_err-1.45.6-1.el8.x86_64\nlibcap-2.26-4.el8.x86_64\nbzip2-libs-1.0.6-26.el8.x86_64\nlibxml2-2.9.7-9.el8.x86_64\nlibuuid-2.32.1-26.el8.x86_64\ninfo-6.5-6.el8.x86_64\nlibgpg-error-1.31-1.el8.x86_64\nlibstdc++-8.4.1-1.el8.x86_64\nlibxcrypt-4.1.1-4.el8.x86_64\nelfutils-libelf-0.182-3.el8.x86_64\nsqlite-libs-3.26.0-13.el8.x86_64\nexpat-2.2.5-4.el8.x86_64\nreadline-7.0-10.el8.x86_64\nlibcap-ng-0.7.9-5.el8.x86_64\naudit-libs-3.0-0.17.20191104git1c2f876.el8.x86_64\nlibzstd-1.4.4-1.el8.x86_64\nchkconfig-1.13-2.el8.x86_64\ngrub2-common-1:2.02-93.el8.noarch\nkeyutils-libs-1.5.10-6.el8.x86_64\nlibffi-3.1-22.el8.x86_64\np11-kit-0.23.22-1.el8.x86_64\nlibtalloc-2.3.1-2.el8.x86_64\nlua-libs-5.3.4-11.el8.x86_64\nlibgcrypt-1.8.5-4.el8.x86_64\nlibunistring-0.9.9-3.el8.x86_64\nlibidn2-2.2.0-1.el8.x86_64\ngmp-1:6.1.2-10.el8.x86_64\njson-c-0.13.1-0.3.el8.x86_64\nlibattr-2.4.48-3.el8.x86_64\nlibacl-2.2.53-1.el8.x86_64\nsed-4.5-2.el8.x86_64\nlibnl3-3.5.0-1.el8.x86_64\nlibsemanage-2.9-4.el8.x86_64\nlibassuan-2.5.1-3.el8.x86_64\nfindutils-1:4.6.0-20.el8.x86_64\nfile-libs-5.33-16.el8.x86_64\nfile-5.33-16.el8.x86_64\nlibpng-2:1.6.34-5.el8.x86_64\nfreetype-2.9.1-4.el8_3.1.x86_64\nlibbasicobjects-0.1.1-39.el8.x86_64\nlibcollection-0.7.0-39.el8.x86_64\nlibref_array-0.1.5-39.el8.x86_64\nlibsmartcols-2.32.1-26.el8.x86_64\nlz4-libs-1.8.3-2.el8.x86_64\npcre-8.42-4.el8.x86_64\ngrep-3.1-6.el8.x86_64\nwhich-2.21-12.el8.x86_64\nlibtevent-0.10.2-2.el8.x86_64\nefivar-libs-37-4.el8.x86_64\ngdbm-libs-1:1.18-1.el8.x86_64\njansson-2.11-3.el8.x86_64\nlibtdb-1.4.3-1.el8.x86_64\nlibverto-0.3.0-5.el8.x86_64\nxz-5.2.4-3.el8.x86_64\nlibnl3-cli-3.5.0-1.el8.x86_64\nnettle-3.4.1-2.el8.x86_64\nlibksba-1.3.5-7.el8.x86_64\ndiffutils-3.6-6.el8.x86_64\nlibgomp-8.4.1-1.el8.x86_64\ne2fsprogs-libs-1.45.6-1.el8.x86_64\ndmidecode-1:3.2-8.el8.x86_64\nlibdhash-0.5.0-39.el8.x86_64\nlibedit-3.1-23.20170329cvs.el8.x86_64\nlibmnl-1.0.4-6.el8.x86_64\nethtool-2:5.8-5.el8.x86_64\nlibpath_utils-0.2.1-39.el8.x86_64\nlibini_config-1.3.1-39.el8.x86_64\nlibpcap-14:1.9.1-4.el8.x86_64\nlibseccomp-2.4.3-1.el8.x86_64\nlibsss_idmap-2.4.0-5.el8.x86_64\nlibtasn1-4.13-3.el8.x86_64\np11-kit-trust-0.23.22-1.el8.x86_64\nlibyaml-0.1.7-5.el8.x86_64\nlzo-2.08-14.el8.x86_64\nnumactl-libs-2.0.12-11.el8.x86_64\npciutils-libs-3.7.0-1.el8.x86_64\npsmisc-23.1-5.el8.x86_64\npixman-0.38.4-1.el8.x86_64\nsquashfs-tools-4.3-19.el8.x86_64\niptables-libs-1.8.4-16.el8.x86_64\nlibteam-1.31-2.el8.x86_64\ngdbm-1:1.18-1.el8.x86_64\nefivar-37-4.el8.x86_64\ngroff-base-1.22.3-18.el8.x86_64\nacl-2.2.53-1.el8.x86_64\ntar-2:1.30-5.el8.x86_64\nvim-minimal-2:8.0.1763-15.el8.x86_64\nmpfr-3.1.6-1.el8.x86_64\nlibpsl-0.20.2-6.el8.x86_64\nkeyutils-1.5.10-6.el8.x86_64\ngrub2-pc-modules-1:2.02-93.el8.noarch\nlibcomps-0.1.11-4.el8.x86_64\nlibmetalink-0.1.3-7.el8.x86_64\nlibmodman-2.0.1-17.el8.x86_64\nlibproxy-0.4.15-5.2.el8.x86_64\nmozjs60-60.9.0-4.el8.x86_64\nsnappy-1.1.8-3.el8.x86_64\ncoreutils-common-8.30-8.el8.x86_64\nbzip2-1.0.6-26.el8.x86_64\nlibss-1.45.6-1.el8.x86_64\npigz-2.4-4.el8.x86_64\nlibselinux-utils-2.9-5.el8.x86_64\nkernel-tools-libs-4.18.0-275.el8.x86_64\nless-530-1.el8.x86_64\nbrotli-1.0.6-3.el8.x86_64\nc-ares-1.13.0-5.el8.x86_64\ncheckpolicy-2.9-1.el8.x86_64\ncpio-2.12-9.el8.x86_64\nfuse-libs-2.9.7-12.el8.x86_64\nhardlink-1:1.3-6.el8.x86_64\nhdparm-9.54-3.el8.x86_64\nlibdaemon-0.14-15.el8.x86_64\nlibndp-1.7-3.el8.x86_64\nlibnghttp2-1.33.0-3.el8_2.1.x86_64\nlibpipeline-1.5.0-2.el8.x86_64\nlibsigsegv-2.11-5.el8.x86_64\ngawk-4.2.1-2.el8.x86_64\nlibsss_autofs-2.4.0-5.el8.x86_64\nlibsss_nss_idmap-2.4.0-5.el8.x86_64\nlibsss_sudo-2.4.0-5.el8.x86_64\nlibstemmer-0-10.585svn.el8.x86_64\nlmdb-libs-0.9.24-1.el8.x86_64\nmemstrack-0.1.11-1.el8.x86_64\nncurses-6.1-7.20180224.el8.x86_64\nnpth-1.5-4.el8.x86_64\nsg3_utils-libs-1.44-5.el8.x86_64\nslang-2.3.2-3.el8.x86_64\nnewt-0.52.20-11.el8.x86_64\nlibXau-1.0.9-3.el8.x86_64\nlibxcb-1.13.1-1.el8.x86_64\nlibX11-1.6.8-4.el8.x86_64\nlibXext-1.3.4-1.el8.x86_64\nlibXrender-0.9.10-7.el8.x86_64\nlibestr-0.1.10-1.el8.x86_64\nlibfastjson-0.99.8-2.el8.x86_64\nlibmaxminddb-1.2.0-10.el8.x86_64\nipcalc-0.2.4-4.el8.x86_64\nlibxkbcommon-0.9.1-1.el8.x86_64\nlinux-firmware-20201118-101.git7455a360.el8.noarch\nlibssh-config-0.9.4-2.el8.noarch\nlibreport-filesystem-2.9.5-15.el8.x86_64\ndnf-data-4.4.2-3.el8.noarch\nkbd-misc-2.0.4-10.el8.noarch\nkbd-legacy-2.0.4-10.el8.noarch\ndhcp-common-12:4.3.6-44.el8.noarch\ndbus-common-1:1.12.8-12.el8.noarch\ncyrus-sasl-lib-2.1.27-5.el8.x86_64\nplatform-python-pip-9.0.3-19.el8.noarch\nplatform-python-setuptools-39.2.0-6.el8.noarch\npython3-libs-3.6.8-34.el8.x86_64\ngrub2-tools-minimal-1:2.02-93.el8.x86_64\nlibssh-0.9.4-2.el8.x86_64\nopenldap-2.4.46-16.el8.x86_64\nplatform-python-3.6.8-34.el8.x86_64\ngrubby-8.40-41.el8.x86_64\nlibkcapi-1.2.0-2.el8.x86_64\nlibkcapi-hmaccalc-1.2.0-2.el8.x86_64\nlibarchive-3.3.3-1.el8.x86_64\nlibdb-utils-5.3.28-40.el8.x86_64\ncurl-7.61.1-17.el8.x86_64\nlibcurl-7.61.1-17.el8.x86_64\nopenssl-1:1.1.1g-12.el8_3.x86_64\ncrypto-policies-scripts-20200713-1.git51d1222.el8.noarch\ncrypto-policies-20200713-1.git51d1222.el8.noarch\nelfutils-default-yama-scope-0.182-3.el8.noarch\ngzip-1.9-12.el8.x86_64\ncracklib-2.9.6-15.el8.x86_64\ncracklib-dicts-2.9.6-15.el8.x86_64\nprocps-ng-3.3.15-5.el8.x86_64\nkrb5-libs-1.18.2-8.el8.x86_64\nlibtirpc-1.1.4-4.el8.x86_64\nlibnsl2-1.2.0-2.20180605git4a062cf.el8.x86_64\nkpartx-0.8.4-7.el8.x86_64\ndevice-mapper-8:1.02.175-1.el8.x86_64\nelfutils-debuginfod-client-0.182-3.el8.x86_64\nelfutils-libs-0.182-3.el8.x86_64\nopenssl-pkcs11-0.4.10-2.el8.x86_64\nrpm-4.14.3-4.el8.x86_64\ngettext-libs-0.19.8.1-17.el8.x86_64\nlibcroco-0.6.12-4.el8_2.1.x86_64\nlibfdisk-2.32.1-26.el8.x86_64\nlibmount-2.32.1-26.el8.x86_64\ndbus-libs-1:1.12.8-12.el8.x86_64\ndbus-tools-1:1.12.8-12.el8.x86_64\ncoreutils-8.30-8.el8.x86_64\nsystemd-libs-239-43.el8.x86_64\nshadow-utils-2:4.6-12.el8.x86_64\nlibblkid-2.32.1-26.el8.x86_64\ndevice-mapper-libs-8:1.02.175-1.el8.x86_64\nca-certificates-2020.2.41-80.0.el8_2.noarch\nopenssl-libs-1:1.1.1g-12.el8_3.x86_64\nlibdb-5.3.28-40.el8.x86_64\nrpm-libs-4.14.3-4.el8.x86_64\nkmod-25-17.el8.x86_64\nkmod-libs-25-17.el8.x86_64\ncryptsetup-libs-2.3.3-2.el8.x86_64\ntrousers-lib-0.3.15-1.el8.x86_64\ndbus-daemon-1:1.12.8-12.el8.x86_64\nlibutempter-1.1.6-14.el8.x86_64\nkbd-2.0.4-10.el8.x86_64\nlibpwquality-1.4.4-1.el8.x86_64\npam-1.3.1-14.el8.x86_64\nutil-linux-2.32.1-26.el8.x86_64\nsystemd-pam-239-43.el8.x86_64\ndracut-049-133.git20210112.el8.x86_64\nos-prober-1.74-6.el8.x86_64\ngettext-0.19.8.1-17.el8.x86_64\ngrub2-tools-1:2.02-93.el8.x86_64\nglib2-2.56.4-9.el8.x86_64\nshared-mime-info-1.9-3.el8.x86_64\ngnutls-3.6.14-7.el8_3.x86_64\ndbus-1:1.12.8-12.el8.x86_64\nsystemd-239-43.el8.x86_64\nsystemd-udev-239-43.el8.x86_64\ntrousers-0.3.15-1.el8.x86_64\npython3-six-1.11.0-8.el8.noarch\njson-glib-1.4.4-1.el8.x86_64\npython3-libselinux-2.9-5.el8.x86_64\nlibmodulemd-2.9.4-2.el8.x86_64\npolkit-libs-0.115-11.el8.x86_64\npolkit-0.115-11.el8.x86_64\npolkit-pkla-compat-0.1-12.el8.x86_64\npolicycoreutils-2.9-9.el8.x86_64\nlibevent-2.1.8-5.el8.x86_64\nlibrhsm-0.0.3-4.el8.x86_64\npython3-dateutil-1:2.6.1-6.el8.noarch\ngobject-introspection-1.56.1-1.el8.x86_64\npython3-gobject-base-3.28.3-2.el8.x86_64\nlibsolv-0.7.16-1.el8.x86_64\niproute-5.9.0-1.el8.x86_64\npython3-decorator-4.2.1-2.el8.noarch\npython3-libxml2-2.9.7-9.el8.x86_64\npython3-pyyaml-3.12-12.el8.x86_64\npython3-configobj-5.0.6-11.el8.noarch\npython3-iniparse-0.4-31.el8.noarch\nkernel-core-4.18.0-275.el8.x86_64\ncrontabs-1.11-17.20190603git.el8.noarch\ncronie-1.5.2-4.el8.x86_64\ncronie-anacron-1.5.2-4.el8.x86_64\ninitscripts-10.00.12-1.el8.x86_64\niputils-20180629-6.el8.x86_64\nNetworkManager-libnm-1:1.30.0-0.6.el8.x86_64\nNetworkManager-1:1.30.0-0.6.el8.x86_64\ngdk-pixbuf2-2.36.12-5.el8.x86_64\nlibuser-0.62-23.el8.x86_64\ngrub2-tools-extra-1:2.02-93.el8.x86_64\nopenssh-8.0p1-5.el8.x86_64\nvirt-what-1.18-6.el8.x86_64\nima-evm-utils-1.1-5.el8.x86_64\nfontconfig-2.13.1-3.el8.x86_64\ncairo-1.15.12-3.el8.x86_64\nlibnfsidmap-1:2.3.3-40.el8.x86_64\npython3-audit-3.0-0.17.20191104git1c2f876.el8.x86_64\npython3-syspurpose-1.28.9-1.el8.x86_64\nlibldb-2.2.0-1.el8.x86_64\nsssd-nfs-idmap-2.4.0-5.el8.x86_64\ncairo-gobject-1.15.12-3.el8.x86_64\npython3-cairo-1.16.3-6.el8.x86_64\npython3-gobject-3.28.3-2.el8.x86_64\npasswd-0.80-3.el8.x86_64\nusermode-1.113-1.el8.x86_64\naudit-3.0-0.17.20191104git1c2f876.el8.x86_64\nkernel-modules-4.18.0-275.el8.x86_64\npython3-dmidecode-3.12.2-15.el8.x86_64\npython3-pydbus-0.6.0-5.el8.noarch\nPackageKit-glib-1.1.12-6.el8.x86_64\nlibverto-libevent-0.3.0-5.el8.x86_64\ngssproxy-0.8.0-19.el8.x86_64\nunbound-libs-1.7.3-15.el8.x86_64\npython3-unbound-1.7.3-15.el8.x86_64\nrpcbind-1.2.5-8.el8.x86_64\nrpm-plugin-selinux-4.14.3-4.el8.x86_64\nselinux-policy-3.14.3-60.el8.noarch\nselinux-policy-targeted-3.14.3-60.el8.noarch\ntimedatex-0.5-3.el8.x86_64\npython3-libsemanage-2.9-4.el8.x86_64\npython3-setools-4.3.0-2.el8.x86_64\npython3-policycoreutils-2.9-9.el8.noarch\npolicycoreutils-python-utils-2.9-9.el8.noarch\npython3-slip-0.6.4-11.el8.noarch\npython3-linux-procfs-0.6.3-1.el8.noarch\npython3-pyudev-0.21.0-7.el8.noarch\nauthselect-libs-1.2.2-1.el8.x86_64\ndbxtool-8-5.el8.x86_64\noddjob-0.34.7-1.el8.x86_64\ndbus-daemon: no process found\noddjob-mkhomedir-0.34.7-1.el8.x86_64\ndbus-daemon: no process found\nauthselect-1.2.2-1.el8.x86_64\ndbus-glib-0.110-2.el8.x86_64\npython3-dbus-1.2.4-15.el8.x86_64\npython3-slip-dbus-0.6.4-11.el8.noarch\ngsettings-desktop-schemas-3.32.0-5.el8.x86_64\nglib-networking-2.56.1-1.1.el8.x86_64\ncockpit-bridge-235-1.el8.x86_64\nlibsoup-2.62.3-2.el8.x86_64\nlibappstream-glib-0.7.14-3.el8.x86_64\nlibsecret-0.18.6-1.el8.x86_64\npinentry-1.1.0-2.el8.x86_64\ndracut-squash-049-133.git20210112.el8.x86_64\nsssd-client-2.4.0-5.el8.x86_64\nsudo-1.8.29-6.el8.x86_64\npciutils-3.7.0-1.el8.x86_64\nrpm-plugin-systemd-inhibit-4.14.3-4.el8.x86_64\nbind-export-libs-32:9.11.26-1.el8.x86_64\nlibsss_certmap-2.4.0-5.el8.x86_64\nsssd-common-2.4.0-5.el8.x86_64\nmokutil-1:0.3.0-11.el8.x86_64\nsscg-2.3.3-14.el8.x86_64\nxfsprogs-5.0.0-8.el8.x86_64\ne2fsprogs-1.45.6-1.el8.x86_64\ndhcp-libs-12:4.3.6-44.el8.x86_64\ndhcp-client-12:4.3.6-44.el8.x86_64\ndracut-network-049-133.git20210112.el8.x86_64\nkexec-tools-2.0.20-43.el8.x86_64\nlibusbx-1.0.23-4.el8.x86_64\ngnupg2-smime-2.2.20-2.el8.x86_64\ngnupg2-2.2.20-2.el8.x86_64\ngpgme-1.13.1-7.el8.x86_64\nlibrepo-1.12.0-3.el8.x86_64\nlibdnf-0.55.0-1.el8.x86_64\npython3-libdnf-0.55.0-1.el8.x86_64\npython3-hawkey-0.55.0-1.el8.x86_64\nPackageKit-1.1.12-6.el8.x86_64\npython3-librepo-1.12.0-3.el8.x86_64\npython3-gpg-1.13.1-7.el8.x86_64\nrpm-build-libs-4.14.3-4.el8.x86_64\npython3-rpm-4.14.3-4.el8.x86_64\npython3-subscription-manager-rhsm-1.28.9-1.el8.x86_64\npython3-systemd-234-8.el8.x86_64\nsetroubleshoot-plugins-3.3.13-1.el8.noarch\n(2021-03-19 13:24:52:891263): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:24:52:891337): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:24:52:904612): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:24:52:904657): [sss_cache] [init_domains] (0x0020): Could not initialize domains\nsetroubleshoot-server-3.3.24-1.el8.x86_64\nlogrotate-3.14.0-4.el8.x86_64\nredhat-logos-82.2-1.el8.x86_64\n(2021-03-19 13:24:53:507926): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:24:53:508002): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:24:53:523385): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:24:53:523467): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:24:53:560315): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:24:53:560375): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:24:53:571432): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:24:53:571511): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:24:53:629312): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:24:53:629392): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:24:53:644170): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:24:53:644222): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:24:53:735552): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:24:53:735653): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:24:53:754754): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:24:53:754828): [sss_cache] [init_domains] (0x0020): Could not initialize domains\ncockpit-ws-235-1.el8.x86_64\nteamd-1.31-2.el8.x86_64\nNetworkManager-team-1:1.30.0-0.6.el8.x86_64\nquota-1:4.04-12.el8.x86_64\nkernel-tools-4.18.0-275.el8.x86_64\npython3-chardet-3.0.4-7.el8.noarch\npython3-ethtool-0.14-3.el8.x86_64\npython3-idna-2.5-5.el8.noarch\npython3-inotify-0.9.6-13.el8.noarch\npython3-libcomps-0.1.11-4.el8.x86_64\npython3-dnf-4.4.2-3.el8.noarch\ndnf-4.4.2-3.el8.noarch\npython3-dnf-plugins-core-4.0.18-2.el8.noarch\ndnf-plugin-subscription-manager-1.28.9-1.el8.x86_64\nsubscription-manager-1.28.9-1.el8.x86_64\nchmod: cannot access '/etc/pki/entitlement/*.pem': No such file or directory\ndnf-plugins-core-4.0.18-2.el8.noarch\npython3-magic-5.33-16.el8.noarch\npython3-perf-4.18.0-275.el8.x86_64\npython3-ply-3.9-9.el8.noarch\npython3-pycparser-2.14-14.el8.noarch\npython3-cffi-1.11.5-5.el8.x86_64\npython3-cryptography-3.2.1-3.el8.x86_64\npython3-jwt-1.6.1-2.el8.noarch\npython3-oauthlib-2.1.0-1.el8.noarch\npython3-pysocks-1.6.8-3.el8.noarch\npython3-urllib3-1.24.2-5.el8.noarch\npython3-requests-2.20.0-2.1.el8_1.noarch\npython3-schedutils-0.6-6.el8.x86_64\npython3-jsonpointer-1.10-11.el8.noarch\npython3-jsonpatch-1.21-2.el8.noarch\npython3-jsonschema-2.6.0-4.el8.noarch\npython3-markupsafe-0.23-19.el8.x86_64\npython3-prettytable-0.7.2-14.el8.noarch\npython3-ptyprocess-0.5.2-4.el8.noarch\npython3-pexpect-4.3.1-3.el8.noarch\nsos-4.0-5.el8.noarch\ncockpit-system-235-1.el8.noarch\npython3-pyserial-3.1.1-8.el8.noarch\npython3-pytz-2017.2-9.el8.noarch\npython3-babel-2.5.1-5.el8.noarch\npython3-jinja2-2.10.1-2.el8_0.noarch\ncloud-init-20.3-7.el8.noarch\nsubscription-manager-cockpit-1.28.9-1.el8.noarch\ntuned-2.15.0-1.el8.noarch\ninsights-client-0:3.1.1-1.el8_3.noarch\nyum-utils-4.0.18-2.el8.noarch\nyum-4.4.2-3.el8.noarch\nnfs-utils-1:2.3.3-40.el8.x86_64\nRunning in chroot, ignoring request: try-restart\nRunning in chroot, ignoring request: try-restart\nrsyslog-8.1911.0-7.el8.x86_64\nshim-x64-15-16.el8.x86_64\nsssd-kcm-2.4.0-5.el8.x86_64\nauthselect-compat-1.2.2-1.el8.x86_64\n(2021-03-19 13:25:01:766858): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:25:01:766951): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:25:01:784750): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:25:01:784823): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:25:01:851058): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:25:01:851172): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:25:01:867677): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:25:01:867716): [sss_cache] [init_domains] (0x0020): Could not initialize domains\nchrony-3.5-1.el8.x86_64\nRunning in chroot, ignoring request: daemon-reload\nkernel-4.18.0-275.el8.x86_64\nopenssh-clients-8.0p1-5.el8.x86_64\n(2021-03-19 13:25:02:417917): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:25:02:417988): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19 13:25:02:433118): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19 13:25:02:433175): [sss_cache] [init_domains] (0x0020): Could not initialize domains\nopenssh-server-8.0p1-5.el8.x86_64\ngrub2-efi-x64-1:2.02-93.el8.x86_64\ngrub2-pc-1:2.02-93.el8.x86_64\nNetworkManager-tui-1:1.30.0-0.6.el8.x86_64\nmicrocode_ctl-4:20201112-1.el8.x86_64\nnet-tools-2.0-0.52.20160912git.el8.x86_64\nqemu-guest-agent-15:4.2.0-41.module+el8.4.0+9504+ab2393e6.x86_64\nirqbalance-2:1.4.0-5.el8.x86_64\ndracut-config-generic-049-133.git20210112.el8.x86_64\ncloud-utils-growpart-0.31-1.el8.noarch\ntcpdump-14:4.9.3-1.el8.x86_64\nparted-3.2-38.el8.x86_64\nprefixdevname-0.1.0-6.el8.x86_64\nman-db-2.7.6.1-17.el8.x86_64\nsg3_utils-1.44-5.el8.x86_64\nrsync-3.1.3-12.el8.x86_64\nlshw-B.02.19.2-4.el8.x86_64\nhostname-3.20-6.el8.x86_64\ndosfstools-4.1-6.el8.x86_64\nlibsysfs-2.1.0-24.el8.x86_64\nlsscsi-0.32-2.el8.x86_64\nrootfiles-8.1-22.el8.noarch\ndracut: No '/dev/log' or 'logger' included for syslog logging\nsort: fflush failed: 'standard output': Broken pipe\nsort: write error\n\ngzip: stdout: Broken pipe\n\ngzip: stdout: Broken pipe\nsort: write failed: 'standard output': Broken pipe\nsort: write error\nimported gpg key\nimported gpg key\nimported gpg key\ncreating a fake machine id\ndeleting the fake machine id\n",
            "metadata": {
                "packages": [
                    {
                        "name": "polkit-pkla-compat",
                        "version": "0.1",
                        "release": "12.el8",
                        "epoch": null,
                        "arch": "x86_64",
                        "sigmd5": "10c5806679d48d041309fa2aa0e6444f",
                        "sigpgp": "8902150305005c144def199e2f91fd431d510108a5a10fff59ded2755aee521df20b65506c9e0bd5fb947a6bb67ad2b4a8a61b6e4785b071ce6a03249a3cecd89f38b65aada8deba04f5ff01db38857f9900ff2a51064f8ac6fd8262a4f70c55280800b887df66459f13b977b37fab7c24519d13013c025d06acb353511a66f805f13070d6daca5b32410742fcc0420c92f84c182e4745560e1b3aceb770664a7639b835fe3b45bd61d92efe417d75248a7d827a10747ee7de242ff900a7a517ab20b4fdee6e70c0bd80017c9ed7ea82a2c3edc50a146ba3b1f94b04ad344c9389fa4e9241d5a735f89d7d6f29024f328d83826cad7220de2ce4ef40147a0b5141efd139fe7bdede484238ea37f614465493058cfd57b89a97fa6b4d1de68138e51282ba0405b20d3484122839fee6aaaa0406b19fb630e0b074e243a9fb851dfb6620b4603a59209784d87a2e7f9a37586f9c082b232a94edf674e3888eab8fd511f84e0ed84bd17182f72a0d17b894be7eadcafe2383c367082a414d3a8335a0f1ee976dc3d475d14beaf64f750c3dc7008e53c4245ca4bdb15597bb21ec093b3516a2b6b209ea081863bee863bb85d3fd0529b06793e0c78ec9a693a9b4270e84db2683c6a279bef0aa323137559c7373adebb13ff1c2c5f8fa6c45f4589173cc1caf03c50f53bdf11d417797a148ee97becf3c995edc872d0773d941f1eb69f9e827f53580e9bae94501f2b0eac65280126b4afffdca",
                        "siggpg": null
                    }
                ]
            },
            "error": null
        },
        {
            "name": "org.osbuild.fix-bls",
            "id": "1832d911c6babd937f0027b6179415ea8aa2694b4a8b60ba99fb6953ddf83583",
            "options": {},
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.fstab",
            "id": "797558984d6fd812e1b17a8414e0948852f91aed4ba37f0a23793d2bd2ad5c1b",
            "options": {
                "filesystems": [
                    {
                        "uuid": "0194fdc2-fa2f-4cc0-81d3-ff12045b73c8",
                        "vfs_type": "xfs",
                        "path": "/",
                        "options": "defaults"
                    },
                    {
                        "uuid": "7B77-95E7",
                        "vfs_type": "vfat",
                        "path": "/boot/efi",
                        "options": "defaults,uid=0,gid=0,umask=077,shortname=winnt",
                        "passno": 2
                    }
                ]
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.grub2",
            "id": "70db1ca256b92f88f592488ce53aa04ea03b04d3b1d692297c7db63dc6592990",
            "options": {
                "root_fs_uuid": "0194fdc2-fa2f-4cc0-81d3-ff12045b73c8",
                "kernel_opts": "console=tty0 console=ttyS0,115200n8 no_timer_check net.ifnames=0 crashkernel=auto",
                "legacy": "i386-pc",
                "uefi": {
                    "vendor": "redhat"
                },
                "saved_entry": "ffffffffffffffffffffffffffffffff-4.18.0-275.el8.x86_64"
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n# GRUB Environment Block\nkernelopts=root=UUID=0194fdc2-fa2f-4cc0-81d3-ff12045b73c8 console=tty0 console=ttyS0,115200n8 no_timer_check net.ifnames=0 crashkernel=auto\nsaved_entry=ffffffffffffffffffffffffffffffff-4.18.0-275.el8.x86_64\n########################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################\nhybrid boot support enabled. Writing alias grub config\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.locale",
            "id": "afad29a4a677da2c8a6d81027a108490d93a25f5db51fde015bcea83bd026ade",
            "options": {
                "language": "en_US.UTF-8"
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n/run/osbuild/tree/etc/locale.conf written.\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.timezone",
            "id": "081e2b48a56b144a81602c6446502c84ea92f42607e28dd151ea27643db70752",
            "options": {
                "zone": "America/New_York"
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n/run/osbuild/tree/etc/localtime written\n/etc/localtime already exists. Replacing.\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.users",
            "id": "69789b06dcf62312ed5056c52176660df74a014f38518acb5875247cac341146",
            "options": {
                "users": {
                    "redhat": {
                        "key": "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC61wMCjOSHwbVb4VfVyl5sn497qW4PsdQ7Ty7aD6wDNZ/QjjULkDV/yW5WjDlDQ7UqFH0Sr7vywjqDizUAqK7zM5FsUKsUXWHWwg/ehKg8j9xKcMv11AkFoUoujtfAujnKODkk58XSA9whPr7qcw3vPrmog680pnMSzf9LC7J6kXfs6lkoKfBh9VnlxusCrw2yg0qI1fHAZBLPx7mW6+me71QZsS6sVz8v8KXyrXsKTdnF50FjzHcK9HXDBtSJS5wA3fkcRYymJe0o6WMWNdgSRVpoSiWaHHmFgdMUJaYoCfhXzyl7LtNb3Q+Sveg+tJK7JaRXBLMUllOlJ6ll5Hod root@localhost"
                    }
                }
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n(2021-03-19  9:25:34:900218): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19  9:25:34:900250): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n(2021-03-19  9:25:34:908671): [sss_cache] [confdb_get_enabled_domain_list] (0x0040): Failed to get [domains] from [sssd], error [2] (No such file or directory)\n(2021-03-19  9:25:34:908699): [sss_cache] [init_domains] (0x0020): Could not initialize domains\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.systemd",
            "id": "2bbe6089331c21741e0756b0282cd5b1ca97816fdf409b2fb7a9512db183fa10",
            "options": {
                "default_target": "multi-user.target"
            },
            "success": true,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\nCreated symlink /run/osbuild/tree/etc/systemd/system/default.target → /usr/lib/systemd/system/multi-user.target.\n",
            "metadata": {},
            "error": null
        },
        {
            "name": "org.osbuild.selinux",
            "id": "85ae8750c2cca6fb8074f1ff2ffa314e554ec2bc45b9f7d3fe8c61b25bc3b7d1",
            "options": {
                "file_contexts": "etc/selinux/targeted/contexts/files/file_context"
            },
            "success": false,
            "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n/run/osbuild/tree/etc/selinux/targeted/contexts/files/file_context: No such file or directory\nTraceback (most recent call last):\n  File \"/run/osbuild/bin/org.osbuild.selinux\", line 62, in <module>\n    r = main(args[\"tree\"], args[\"options\"])\n  File \"/run/osbuild/bin/org.osbuild.selinux\", line 53, in main\n    subprocess.run([\"setfiles\", \"-F\", \"-r\", f\"{tree}\", f\"{file_contexts}\", f\"{tree}\"], check=True)\n  File \"/usr/lib64/python3.6/subprocess.py\", line 438, in run\n    output=stdout, stderr=stderr)\nsubprocess.CalledProcessError: Command '['setfiles', '-F', '-r', '/run/osbuild/tree', '/run/osbuild/tree/etc/selinux/targeted/contexts/files/file_context', '/run/osbuild/tree']' returned non-zero exit status 255.\n",
            "metadata": {},
            "error": null
        }
    ]
}
`

const v2ResultSuccess = `
{
    "type": "result",
    "success": true,
    "metadata": {
        "build": {
            "org.osbuild.rpm": {
                "packages": [
                    {
                        "name": "gpg-pubkey",
                        "version": "fd431d51",
                        "release": "4ae0493b",
                        "epoch": null,
                        "arch": null,
                        "sigmd5": null,
                        "sigpgp": null,
                        "siggpg": null
                    }
                ]
            }
        },
        "ostree-tree": {
            "org.osbuild.rpm": {
                "packages": [
                    {
                        "name": "libgusb",
                        "version": "0.3.0",
                        "release": "1.el8",
                        "epoch": null,
                        "arch": "x86_64",
                        "sigmd5": "a58dbee62e2e39fe0b3292b4a9b3cd65",
                        "sigpgp": "8902150305005c143a39199e2f91fd431d510108bb9a0ffc0aeb0d04ff4dd5f9b2ff0301a31f2388fec68e8109d869f867116094becf42c91c798215e1f287d1aeb7dc48f672a9ed66e05b448ebf64a0005dda3835db0208b9dc3a93502e0b99a4cdb2d758dc765ee24c32cac48b549c09c64f64885c7cba945c980862a13798da3554c0d52cd82c90e70fa66da3efd688f797633d29813d54a90476d34edcb4b42776acb4d270c8b7ef678fec8538c70647e2970454ca04380bfd436c235a4f762fcb83bb8d6e9e685a28d53b40385188d94e01f6e1581baa94ff044c1de583066474678215923d8434bac800c79b6244901e29ed8417dc3419fa491095b621573abb980057309fb91c2455e79dabaaa6c2b5d101b9bea2ca2fb1563015b96f7e378c803ee36307215a069f49fc1e2b2c009e811f76a034037b2d58214bdfd6ae9aa757a34cc2090fea4c6c892a3bf2efb43a3c8ed3f35d0c605b12c43ef91f33404297165c9d741e543522e43566c79d6672e2aa2ea1c1053df169e0ff92868d59aedee91005fff80f05212d288eb84459a418cc7abe298644e24791be32a4fc244e3cc40550914c6dd72a26e70bc7de78b3e094b118765ca82cd1f1acccbff1293221191325e9bd999485f3a944a48d452ef646f7475e022a0005f3e55ac29c21091f620a8a5113c11245b94c3ce252e661c5e34e91dda5c10a2522437b65caadd101a9228b1554920e3779d287b4f627126816ea6863",
                        "siggpg": null
                    }
                ]
            }
        },
        "ostree-commit": {
            "org.osbuild.ostree.commit": {
                "compose": {
                    "ref": "rhel/8/x86_64/edge",
                    "ostree-n-metadata-total": 9495,
                    "ostree-n-metadata-written": 3361,
                    "ostree-n-content-total": 26016,
                    "ostree-n-content-written": 21965,
                    "ostree-n-cache-hits": 0,
                    "ostree-content-bytes-written": 1485885441,
                    "ostree-commit": "f2b16f20de69edf932866662efbd00754c2d0decd878c60b4914372e34b5e629",
                    "ostree-content-checksum": "55c372e6c176214f8cbdc2daa8cbbcded0a50cea8b401a2d522528f398bfa9a8",
                    "ostree-version": "8.4",
                    "ostree-timestamp": "2021-03-19T13:35:02Z",
                    "rpm-ostree-inputhash": "ca4759f532fa83a6532be33ec4122dd8c45516fb5f4f9decc424f6edf145df3c"
                }
            }
        },
        "container-tree": {
            "org.osbuild.rpm": {
                "packages": [
                    {
                        "name": "gpg-pubkey",
                        "version": "d4082792",
                        "release": "5b32db75",
                        "epoch": null,
                        "arch": null,
                        "sigmd5": null,
                        "sigpgp": null,
                        "siggpg": null
                    }
                ]            }
        }
    },
    "log": {
        "build": [
            {
                "id": "56a93713050f49c966eda0391dce1340d16f168bcbfd542d9d90be668ecc8268",
                "type": "org.osbuild.rpm",
                "output": "/usr/lib/tmpfiles.d/abrt.conf:2: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/abrt.conf:9: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/colord.conf:1: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:2: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:3: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/cups.conf:4: Failed to resolve user 'lp': No such process\n/usr/lib/tmpfiles.d/gluster.conf:2: Failed to resolve user 'gluster': No such process\n/usr/lib/tmpfiles.d/httpd.conf:1: Failed to resolve group 'apache'.\n/usr/lib/tmpfiles.d/httpd.conf:2: Failed to resolve user 'apache': No such process\n/usr/lib/tmpfiles.d/journal-nocow.conf:26: Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\n/usr/lib/tmpfiles.d/lockdev.conf:3: Failed to resolve group 'lock'.\n/usr/lib/tmpfiles.d/openvpn.conf:1: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/openvpn.conf:2: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/radvd.conf:1: Failed to resolve user 'radvd': No such process\n/usr/lib/tmpfiles.d/rpcbind.conf:2: Failed to resolve user 'rpc': No such process\nFailed to open file \"/sys/fs/selinux/checkreqprot\": Read-only file system\nPreparing packages...\nlibgcc-8.4.1-1.el8.x86_64\npython3-setuptools-wheel-39.2.0-6.el8.noarch\npython3-pip-wheel-9.0.3-19.el8.noarch\nxkeyboard-config-2.28-1.el8.noarch\ntzdata-2020f-1.el8.noarch\nredhat-release-eula-8.4-0.5.el8.x86_64\nredhat-release-8.4-0.5.el8.x86_64\nsetup-2.12.2-6.el8.noarch\nfilesystem-3.8-3.el8.x86_64\nbasesystem-11-5.el8.noarch\npublicsuffix-list-dafsa-20180723-1.el8.noarch\nncurses-base-6.1-7.20180224.el8.noarch\npcre2-10.32-2.el8.x86_64\nlibselinux-2.9-5.el8.x86_64\nncurses-libs-6.1-7.20180224.el8.x86_64\nglibc-all-langpacks-2.28-145.el8.x86_64\nglibc-common-2.28-145.el8.x86_64\nglibc-2.28-145.el8.x86_64\nbash-4.4.19-14.el8.x86_64\nlibsepol-2.9-2.el8.x86_64\nzlib-1.2.11-17.el8.x86_64\nxz-libs-5.2.4-3.el8.x86_64\nlibgpg-error-1.31-1.el8.x86_64\nbzip2-libs-1.0.6-26.el8.x86_64\ninfo-6.5-6.el8.x86_64\nlibcap-2.26-4.el8.x86_64\nlibxml2-2.9.7-9.el8.x86_64\nelfutils-libelf-0.182-3.el8.x86_64\nlibcom_err-1.45.6-1.el8.x86_64\nlibzstd-1.4.4-1.el8.x86_64\nexpat-2.2.5-4.el8.x86_64\nlibuuid-2.32.1-26.el8.x86_64\npopt-1.18-1.el8.x86_64\nreadline-7.0-10.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/history.info\ninstall-info: No such file or directory for /usr/share/info/rluserman.info\nlibgcrypt-1.8.5-4.el8.x86_64\nsqlite-libs-3.26.0-13.el8.x86_64\nlibstdc++-8.4.1-1.el8.x86_64\nlibxcrypt-4.1.1-4.el8.x86_64\nlua-libs-5.3.4-11.el8.x86_64\nchkconfig-1.13-2.el8.x86_64\nlibunistring-0.9.9-3.el8.x86_64\ngrub2-common-1:2.02-93.el8.noarch\ngmp-1:6.1.2-10.el8.x86_64\njson-c-0.13.1-0.3.el8.x86_64\nlibsmartcols-2.32.1-26.el8.x86_64\nlibidn2-2.2.0-1.el8.x86_64\nlibassuan-2.5.1-3.el8.x86_64\nfile-libs-5.33-16.el8.x86_64\nlibattr-2.4.48-3.el8.x86_64\nlibacl-2.2.53-1.el8.x86_64\nsed-4.5-2.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/sed.info.gz\nlibcap-ng-0.7.9-5.el8.x86_64\naudit-libs-3.0-0.17.20191104git1c2f876.el8.x86_64\nwhich-2.21-12.el8.x86_64\nfile-5.33-16.el8.x86_64\nlibffi-3.1-22.el8.x86_64\np11-kit-0.23.22-1.el8.x86_64\nlz4-libs-1.8.3-2.el8.x86_64\nlibsemanage-2.9-4.el8.x86_64\ndiffutils-3.6-6.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/diffutils.info\nfindutils-1:4.6.0-20.el8.x86_64\nlibgomp-8.4.1-1.el8.x86_64\nlibksba-1.3.5-7.el8.x86_64\nfuse-libs-2.9.7-12.el8.x86_64\ngdbm-libs-1:1.18-1.el8.x86_64\nkeyutils-libs-1.5.10-6.el8.x86_64\nlibtasn1-4.13-3.el8.x86_64\np11-kit-trust-0.23.22-1.el8.x86_64\npcre-8.42-4.el8.x86_64\ngrep-3.1-6.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/grep.info.gz\nxz-5.2.4-3.el8.x86_64\ngdbm-1:1.18-1.el8.x86_64\nacl-2.2.53-1.el8.x86_64\nlibpsl-0.20.2-6.el8.x86_64\nmpfr-3.1.6-1.el8.x86_64\nnettle-3.4.1-2.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/nettle.info\ngrub2-pc-modules-1:2.02-93.el8.noarch\nlibcomps-0.1.11-4.el8.x86_64\nlibmetalink-0.1.3-7.el8.x86_64\ne2fsprogs-libs-1.45.6-1.el8.x86_64\nlibss-1.45.6-1.el8.x86_64\nbubblewrap-0.4.0-1.el8.x86_64\ncoreutils-common-8.30-8.el8.x86_64\nlibpng-2:1.6.34-5.el8.x86_64\nfreetype-2.9.1-4.el8_3.1.x86_64\npigz-2.4-4.el8.x86_64\nlibselinux-utils-2.9-5.el8.x86_64\nbrotli-1.0.6-3.el8.x86_64\ncpio-2.12-9.el8.x86_64\nhardlink-1:1.3-6.el8.x86_64\nlibaio-0.3.112-1.el8.x86_64\nlibnghttp2-1.33.0-3.el8_2.1.x86_64\nlibpcap-14:1.9.1-4.el8.x86_64\niptables-libs-1.8.4-16.el8.x86_64\nlibseccomp-2.4.3-1.el8.x86_64\nlibsigsegv-2.11-5.el8.x86_64\ngawk-4.2.1-2.el8.x86_64\nlibverto-0.3.0-5.el8.x86_64\nlibyaml-0.1.7-5.el8.x86_64\nmemstrack-0.1.11-1.el8.x86_64\nncurses-6.1-7.20180224.el8.x86_64\nnpth-1.5-4.el8.x86_64\nlibxkbcommon-0.9.1-1.el8.x86_64\nlibssh-config-0.9.4-2.el8.noarch\nlibreport-filesystem-2.9.5-15.el8.x86_64\ndnf-data-4.4.2-3.el8.noarch\nkbd-misc-2.0.4-10.el8.noarch\nkbd-legacy-2.0.4-10.el8.noarch\nfuse-common-3.2.1-12.el8.x86_64\nfuse-2.9.7-12.el8.x86_64\ndbus-common-1:1.12.8-12.el8.noarch\ncyrus-sasl-lib-2.1.27-5.el8.x86_64\nplatform-python-pip-9.0.3-19.el8.noarch\nplatform-python-setuptools-39.2.0-6.el8.noarch\npython3-libs-3.6.8-34.el8.x86_64\ngrub2-tools-minimal-1:2.02-93.el8.x86_64\nlibssh-0.9.4-2.el8.x86_64\nopenldap-2.4.46-16.el8.x86_64\nplatform-python-3.6.8-34.el8.x86_64\ngrubby-8.40-41.el8.x86_64\nlibkcapi-1.2.0-2.el8.x86_64\nlibkcapi-hmaccalc-1.2.0-2.el8.x86_64\nlibarchive-3.3.3-1.el8.x86_64\nlibdb-utils-5.3.28-40.el8.x86_64\ncurl-7.61.1-17.el8.x86_64\nlibcurl-7.61.1-17.el8.x86_64\nopenssl-1:1.1.1g-12.el8_3.x86_64\ncrypto-policies-scripts-20200713-1.git51d1222.el8.noarch\ncrypto-policies-20200713-1.git51d1222.el8.noarch\nelfutils-default-yama-scope-0.182-3.el8.noarch\ngzip-1.9-12.el8.x86_64\ncracklib-2.9.6-15.el8.x86_64\ncracklib-dicts-2.9.6-15.el8.x86_64\nprocps-ng-3.3.15-5.el8.x86_64\nkrb5-libs-1.18.2-8.el8.x86_64\nlibtirpc-1.1.4-4.el8.x86_64\nlibnsl2-1.2.0-2.20180605git4a062cf.el8.x86_64\nkpartx-0.8.4-7.el8.x86_64\ndevice-mapper-8:1.02.175-1.el8.x86_64\nelfutils-debuginfod-client-0.182-3.el8.x86_64\nelfutils-libs-0.182-3.el8.x86_64\nopenssl-pkcs11-0.4.10-2.el8.x86_64\nrpm-4.14.3-4.el8.x86_64\ngettext-libs-0.19.8.1-17.el8.x86_64\nlibcroco-0.6.12-4.el8_2.1.x86_64\nlibfdisk-2.32.1-26.el8.x86_64\nlibmount-2.32.1-26.el8.x86_64\ndbus-libs-1:1.12.8-12.el8.x86_64\ndbus-tools-1:1.12.8-12.el8.x86_64\ncoreutils-8.30-8.el8.x86_64\nsystemd-libs-239-43.el8.x86_64\nlibblkid-2.32.1-26.el8.x86_64\ndevice-mapper-libs-8:1.02.175-1.el8.x86_64\nshadow-utils-2:4.6-12.el8.x86_64\nca-certificates-2020.2.41-80.0.el8_2.noarch\nopenssl-libs-1:1.1.1g-12.el8_3.x86_64\nlibdb-5.3.28-40.el8.x86_64\nrpm-libs-4.14.3-4.el8.x86_64\nkmod-25-17.el8.x86_64\nkmod-libs-25-17.el8.x86_64\ncryptsetup-libs-2.3.3-2.el8.x86_64\ntrousers-lib-0.3.15-1.el8.x86_64\ndbus-daemon-1:1.12.8-12.el8.x86_64\nlibutempter-1.1.6-14.el8.x86_64\nkbd-2.0.4-10.el8.x86_64\nlibpwquality-1.4.4-1.el8.x86_64\npam-1.3.1-14.el8.x86_64\nutil-linux-2.32.1-26.el8.x86_64\nsystemd-pam-239-43.el8.x86_64\ndracut-049-133.git20210112.el8.x86_64\nos-prober-1.74-6.el8.x86_64\ngettext-0.19.8.1-17.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/gettext.info.gz\ngrub2-tools-1:2.02-93.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/grub2.info.gz\ninstall-info: No such file or directory for /usr/share/info/grub2-dev.info.gz\nglib2-2.56.4-9.el8.x86_64\nshared-mime-info-1.9-3.el8.x86_64\ngnutls-3.6.14-7.el8_3.x86_64\ndbus-1:1.12.8-12.el8.x86_64\nsystemd-239-43.el8.x86_64\nsystemd-udev-239-43.el8.x86_64\ntrousers-0.3.15-1.el8.x86_64\njson-glib-1.4.4-1.el8.x86_64\nlibmodulemd-2.9.4-2.el8.x86_64\nlibsolv-0.7.16-1.el8.x86_64\nlibrhsm-0.0.3-4.el8.x86_64\npolkit-libs-0.115-11.el8.x86_64\npolicycoreutils-2.9-9.el8.x86_64\nima-evm-utils-1.1-5.el8.x86_64\nlibevent-2.1.8-5.el8.x86_64\nunbound-libs-1.7.3-15.el8.x86_64\npython3-unbound-1.7.3-15.el8.x86_64\nrpm-plugin-selinux-4.14.3-4.el8.x86_64\nselinux-policy-3.14.3-60.el8.noarch\nselinux-policy-targeted-3.14.3-60.el8.noarch\nlibsecret-0.18.6-1.el8.x86_64\npinentry-1.1.0-2.el8.x86_64\ngrub2-tools-extra-1:2.02-93.el8.x86_64\nrpm-plugin-systemd-inhibit-4.14.3-4.el8.x86_64\nlibusbx-1.0.23-4.el8.x86_64\ngnupg2-smime-2.2.20-2.el8.x86_64\ngnupg2-2.2.20-2.el8.x86_64\ngpgme-1.13.1-7.el8.x86_64\nlibrepo-1.12.0-3.el8.x86_64\nostree-libs-2020.7-1.el8.x86_64\nlibdnf-0.55.0-1.el8.x86_64\npython3-libdnf-0.55.0-1.el8.x86_64\npython3-hawkey-0.55.0-1.el8.x86_64\nostree-2020.7-1.el8.x86_64\nrpm-ostree-libs-2020.7-1.el8.x86_64\npython3-gpg-1.13.1-7.el8.x86_64\nrpm-build-libs-4.14.3-4.el8.x86_64\npython3-rpm-4.14.3-4.el8.x86_64\npython3-libcomps-0.1.11-4.el8.x86_64\npython3-dnf-4.4.2-3.el8.noarch\npython3-setuptools-39.2.0-6.el8.noarch\npython3-pip-9.0.3-19.el8.noarch\npython36-3.6.8-2.module+el8.1.0+3334+5cb623d7.x86_64\npython3-six-1.11.0-8.el8.noarch\npython3-iniparse-0.4-31.el8.noarch\ndnf-4.4.2-3.el8.noarch\nrpm-ostree-2020.7-1.el8.x86_64\ngrub2-pc-1:2.02-93.el8.x86_64\nqemu-img-15:4.2.0-41.module+el8.4.0+9504+ab2393e6.x86_64\nxfsprogs-5.0.0-8.el8.x86_64\ne2fsprogs-1.45.6-1.el8.x86_64\ntar-2:1.30-5.el8.x86_64\ndosfstools-4.1-6.el8.x86_64\nimported gpg key\nimported gpg key\nimported gpg key\ncreating a fake machine id\ndeleting the fake machine id\n"
            },
            {
                "id": "cac48f998b87f9c9007037f48202bea9ef7966eacdaaf35f8e9da4b543cfa7fb",
                "type": "org.osbuild.selinux",
                "output": "/usr/lib/tmpfiles.d/abrt.conf:2: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/abrt.conf:9: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/colord.conf:1: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:2: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:3: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/cups.conf:4: Failed to resolve user 'lp': No such process\n/usr/lib/tmpfiles.d/gluster.conf:2: Failed to resolve user 'gluster': No such process\n/usr/lib/tmpfiles.d/httpd.conf:1: Failed to resolve group 'apache'.\n/usr/lib/tmpfiles.d/httpd.conf:2: Failed to resolve user 'apache': No such process\n/usr/lib/tmpfiles.d/journal-nocow.conf:26: Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\n/usr/lib/tmpfiles.d/lockdev.conf:3: Failed to resolve group 'lock'.\n/usr/lib/tmpfiles.d/openvpn.conf:1: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/openvpn.conf:2: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/radvd.conf:1: Failed to resolve user 'radvd': No such process\n/usr/lib/tmpfiles.d/rpcbind.conf:2: Failed to resolve user 'rpc': No such process\nFailed to open file \"/sys/fs/selinux/checkreqprot\": Read-only file system\n"
            }
        ],
        "ostree-tree": [
            {
                "id": "52f9740ad68953831b503edbcdf2c54eb3eab87efa7dacedabe3ab83b2db708a",
                "type": "org.osbuild.rpm",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\nPreparing packages...\nlibgcc-8.4.1-1.el8.x86_64\ngeolite2-country-20180605-1.el8.noarch\ngeolite2-city-20180605-1.el8.noarch\npython3-setuptools-wheel-39.2.0-6.el8.noarch\npython3-pip-wheel-9.0.3-19.el8.noarch\nfuse-common-3.2.1-12.el8.x86_64\nxkeyboard-config-2.28-1.el8.noarch\ntzdata-2020f-1.el8.noarch\nredhat-release-eula-8.4-0.5.el8.x86_64\nredhat-release-8.4-0.5.el8.x86_64\nsetup-2.12.2-6.el8.noarch\nfilesystem-3.8-3.el8.x86_64\nefi-filesystem-3-3.el8.noarch\nbasesystem-11-5.el8.noarch\npublicsuffix-list-dafsa-20180723-1.el8.noarch\npkgconf-m4-1.4.2-1.el8.noarch\nncurses-base-6.1-7.20180224.el8.noarch\npcre2-10.32-2.el8.x86_64\nlibselinux-2.9-5.el8.x86_64\nncurses-libs-6.1-7.20180224.el8.x86_64\nglibc-minimal-langpack-2.28-145.el8.x86_64\nglibc-common-2.28-145.el8.x86_64\nglibc-2.28-145.el8.x86_64\nbash-4.4.19-14.el8.x86_64\nlibsepol-2.9-2.el8.x86_64\nzlib-1.2.11-17.el8.x86_64\nxz-libs-5.2.4-3.el8.x86_64\nlibgpg-error-1.31-1.el8.x86_64\ninfo-6.5-6.el8.x86_64\nlibcap-2.26-4.el8.x86_64\nlibuuid-2.32.1-26.el8.x86_64\nlibcom_err-1.45.6-1.el8.x86_64\nbzip2-libs-1.0.6-26.el8.x86_64\nlibxcrypt-4.1.1-4.el8.x86_64\npopt-1.18-1.el8.x86_64\nreadline-7.0-10.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/history.info\ninstall-info: No such file or directory for /usr/share/info/rluserman.info\nelfutils-libelf-0.182-3.el8.x86_64\ngmp-1:6.1.2-10.el8.x86_64\nlibstdc++-8.4.1-1.el8.x86_64\nlibxml2-2.9.7-9.el8.x86_64\nexpat-2.2.5-4.el8.x86_64\nnspr-4.25.0-2.el8_2.x86_64\nnss-util-3.53.1-17.el8_3.x86_64\nchkconfig-1.13-2.el8.x86_64\nlibassuan-2.5.1-3.el8.x86_64\nlibgcrypt-1.8.5-4.el8.x86_64\ngrub2-common-1:2.02-93.el8.noarch\nlibattr-2.4.48-3.el8.x86_64\nlibacl-2.2.53-1.el8.x86_64\nsed-4.5-2.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/sed.info.gz\nlibcap-ng-0.7.9-5.el8.x86_64\naudit-libs-3.0-0.17.20191104git1c2f876.el8.x86_64\nlibmnl-1.0.4-6.el8.x86_64\nlibunistring-0.9.9-3.el8.x86_64\nlibidn2-2.2.0-1.el8.x86_64\nsqlite-libs-3.26.0-13.el8.x86_64\nlibffi-3.1-22.el8.x86_64\nlibseccomp-2.4.3-1.el8.x86_64\nlibzstd-1.4.4-1.el8.x86_64\np11-kit-0.23.22-1.el8.x86_64\njansson-2.11-3.el8.x86_64\nwhich-2.21-12.el8.x86_64\nlibsemanage-2.9-4.el8.x86_64\nnettle-3.4.1-2.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/nettle.info\nfindutils-1:4.6.0-20.el8.x86_64\nlibselinux-utils-2.9-5.el8.x86_64\nefivar-libs-37-4.el8.x86_64\nkeyutils-libs-1.5.10-6.el8.x86_64\nlibaio-0.3.112-1.el8.x86_64\nlibpcap-14:1.9.1-4.el8.x86_64\niptables-libs-1.8.4-16.el8.x86_64\nlua-libs-5.3.4-11.el8.x86_64\nlz4-libs-1.8.3-2.el8.x86_64\npcre-8.42-4.el8.x86_64\ngrep-3.1-6.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/grep.info.gz\nlibnftnl-1.1.5-4.el8.x86_64\nnftables-1:0.9.3-16.el8.x86_64\ngdisk-1.0.3-6.el8.x86_64\nmpfr-3.1.6-1.el8.x86_64\nbubblewrap-0.4.0-1.el8.x86_64\ndiffutils-3.6-6.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/diffutils.info\nlibgomp-8.4.1-1.el8.x86_64\nlibksba-1.3.5-7.el8.x86_64\nfile-libs-5.33-16.el8.x86_64\nfile-5.33-16.el8.x86_64\nfuse-libs-2.9.7-12.el8.x86_64\ngdbm-libs-1:1.18-1.el8.x86_64\njson-c-0.13.1-0.3.el8.x86_64\nlibedit-3.1-23.20170329cvs.el8.x86_64\nlibnfnetlink-1.0.1-13.el8.x86_64\nlibnl3-3.5.0-1.el8.x86_64\nlibsmartcols-2.32.1-26.el8.x86_64\nlibtasn1-4.13-3.el8.x86_64\np11-kit-trust-0.23.22-1.el8.x86_64\nlibnetfilter_conntrack-1.0.6-5.el8.x86_64\niptables-1.8.4-16.el8.x86_64\niptables-ebtables-1.8.4-16.el8.x86_64\ngdbm-1:1.18-1.el8.x86_64\nlibbytesize-1.4-3.el8.x86_64\nxz-5.2.4-3.el8.x86_64\ndevice-mapper-persistent-data-0.8.5-4.el8.x86_64\nfuse-2.9.7-12.el8.x86_64\nlibpsl-0.20.2-6.el8.x86_64\nipset-libs-7.1-1.el8.x86_64\nipset-7.1-1.el8.x86_64\nacl-2.2.53-1.el8.x86_64\ntar-2:1.30-5.el8.x86_64\nvim-minimal-2:8.0.1763-15.el8.x86_64\ngrub2-pc-modules-1:2.02-93.el8.noarch\nnss-softokn-freebl-3.53.1-17.el8_3.x86_64\nnss-softokn-3.53.1-17.el8_3.x86_64\nlibmetalink-0.1.3-7.el8.x86_64\nmozjs60-60.9.0-4.el8.x86_64\nprotobuf-3.5.0-13.el8.x86_64\ne2fsprogs-libs-1.45.6-1.el8.x86_64\nlibss-1.45.6-1.el8.x86_64\ncoreutils-common-8.30-8.el8.x86_64\nlibpng-2:1.6.34-5.el8.x86_64\nfreetype-2.9.1-4.el8_3.1.x86_64\npigz-2.4-4.el8.x86_64\nbrotli-1.0.6-3.el8.x86_64\ncheckpolicy-2.9-1.el8.x86_64\ncpio-2.12-9.el8.x86_64\ndosfstools-4.1-6.el8.x86_64\nfuse3-3.2.1-12.el8.x86_64\nfuse3-libs-3.2.1-12.el8.x86_64\nhardlink-1:1.3-6.el8.x86_64\nlibndp-1.7-3.el8.x86_64\nlibnghttp2-1.33.0-3.el8_2.1.x86_64\nlibpkgconf-1.4.2-1.el8.x86_64\npkgconf-1.4.2-1.el8.x86_64\npkgconf-pkg-config-1.4.2-1.el8.x86_64\nlibqb-1.0.3-12.el8.x86_64\nlibsigsegv-2.11-5.el8.x86_64\ngawk-4.2.1-2.el8.x86_64\nlibsmbios-2.4.1-2.el8.x86_64\nlibverto-0.3.0-5.el8.x86_64\nlibyaml-0.1.7-5.el8.x86_64\nmemstrack-0.1.11-1.el8.x86_64\nncurses-6.1-7.20180224.el8.x86_64\nnpth-1.5-4.el8.x86_64\ncontainernetworking-plugins-0.9.0-1.module+el8.4.0+9425+98db097b.x86_64\nlibmaxminddb-1.2.0-10.el8.x86_64\nipcalc-0.2.4-4.el8.x86_64\nlibnet-1.1.6-15.el8.x86_64\nlibxkbcommon-0.9.1-1.el8.x86_64\noniguruma-6.8.2-2.el8.x86_64\njq-1.5-12.el8.x86_64\nprotobuf-c-1.3.0-4.el8.x86_64\ncriu-3.15-1.module+el8.4.0+9425+98db097b.x86_64\nrunc-1.0.0-69.rc92.module+el8.4.0+9425+98db097b.x86_64\nlinux-firmware-20201118-101.git7455a360.el8.noarch\nlibssh-config-0.9.4-2.el8.noarch\nlibreport-filesystem-2.9.5-15.el8.x86_64\nkbd-misc-2.0.4-10.el8.noarch\nkbd-legacy-2.0.4-10.el8.noarch\nfirewalld-filesystem-0.8.2-3.el8.noarch\ndhcp-common-12:4.3.6-44.el8.noarch\ndbus-common-1:1.12.8-12.el8.noarch\ncyrus-sasl-lib-2.1.27-5.el8.x86_64\nplatform-python-pip-9.0.3-19.el8.noarch\nplatform-python-setuptools-39.2.0-6.el8.noarch\npython3-libs-3.6.8-34.el8.x86_64\ngrub2-tools-minimal-1:2.02-93.el8.x86_64\nlibssh-0.9.4-2.el8.x86_64\nopenldap-2.4.46-16.el8.x86_64\nplatform-python-3.6.8-34.el8.x86_64\ngrubby-8.40-41.el8.x86_64\nlibkcapi-1.2.0-2.el8.x86_64\nlibkcapi-hmaccalc-1.2.0-2.el8.x86_64\nlibarchive-3.3.3-1.el8.x86_64\nlibdb-utils-5.3.28-40.el8.x86_64\ncurl-7.61.1-17.el8.x86_64\nlibcurl-7.61.1-17.el8.x86_64\nopenssl-1:1.1.1g-12.el8_3.x86_64\ncrypto-policies-scripts-20200713-1.git51d1222.el8.noarch\ncrypto-policies-20200713-1.git51d1222.el8.noarch\nelfutils-default-yama-scope-0.182-3.el8.noarch\ngzip-1.9-12.el8.x86_64\ncracklib-2.9.6-15.el8.x86_64\ncracklib-dicts-2.9.6-15.el8.x86_64\nprocps-ng-3.3.15-5.el8.x86_64\nkrb5-libs-1.18.2-8.el8.x86_64\nlibtirpc-1.1.4-4.el8.x86_64\nlibnsl2-1.2.0-2.20180605git4a062cf.el8.x86_64\nkpartx-0.8.4-7.el8.x86_64\ndevice-mapper-8:1.02.175-1.el8.x86_64\nelfutils-debuginfod-client-0.182-3.el8.x86_64\nelfutils-libs-0.182-3.el8.x86_64\nopenssl-pkcs11-0.4.10-2.el8.x86_64\nrpm-4.14.3-4.el8.x86_64\ngettext-libs-0.19.8.1-17.el8.x86_64\nlibcroco-0.6.12-4.el8_2.1.x86_64\nlibfdisk-2.32.1-26.el8.x86_64\nlibmount-2.32.1-26.el8.x86_64\ndbus-libs-1:1.12.8-12.el8.x86_64\ndbus-tools-1:1.12.8-12.el8.x86_64\ncoreutils-8.30-8.el8.x86_64\nsystemd-libs-239-43.el8.x86_64\nlibblkid-2.32.1-26.el8.x86_64\ndevice-mapper-libs-8:1.02.175-1.el8.x86_64\nshadow-utils-2:4.6-12.el8.x86_64\nca-certificates-2020.2.41-80.0.el8_2.noarch\nopenssl-libs-1:1.1.1g-12.el8_3.x86_64\nkmod-libs-25-17.el8.x86_64\ncryptsetup-libs-2.3.3-2.el8.x86_64\nlibdb-5.3.28-40.el8.x86_64\nrpm-libs-4.14.3-4.el8.x86_64\nkmod-25-17.el8.x86_64\ntrousers-lib-0.3.15-1.el8.x86_64\ndbus-daemon-1:1.12.8-12.el8.x86_64\nlibutempter-1.1.6-14.el8.x86_64\nkbd-2.0.4-10.el8.x86_64\nlibpwquality-1.4.4-1.el8.x86_64\npam-1.3.1-14.el8.x86_64\nutil-linux-2.32.1-26.el8.x86_64\nsystemd-pam-239-43.el8.x86_64\ndracut-049-133.git20210112.el8.x86_64\nos-prober-1.74-6.el8.x86_64\ngettext-0.19.8.1-17.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/gettext.info.gz\ngrub2-tools-1:2.02-93.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/grub2.info.gz\ninstall-info: No such file or directory for /usr/share/info/grub2-dev.info.gz\nglib2-2.56.4-9.el8.x86_64\nshared-mime-info-1.9-3.el8.x86_64\ngnutls-3.6.14-7.el8_3.x86_64\ndbus-1:1.12.8-12.el8.x86_64\nsystemd-239-43.el8.x86_64\nsystemd-udev-239-43.el8.x86_64\ntrousers-0.3.15-1.el8.x86_64\nlibgudev-232-4.el8.x86_64\npolkit-libs-0.115-11.el8.x86_64\npolicycoreutils-2.9-9.el8.x86_64\nlibmbim-1.20.2-1.el8.x86_64\ngreenboot-0.11-1.el8.x86_64\npython3-libselinux-2.9-5.el8.x86_64\nlibqmi-1.24.0-1.el8.x86_64\nrpm-plugin-selinux-4.14.3-4.el8.x86_64\nselinux-policy-3.14.3-60.el8.noarch\nselinux-policy-targeted-3.14.3-60.el8.noarch\nModemManager-glib-1.10.8-2.el8.x86_64\njson-glib-1.4.4-1.el8.x86_64\nopenssh-8.0p1-5.el8.x86_64\ndevice-mapper-event-libs-8:1.02.175-1.el8.x86_64\nparted-3.2-38.el8.x86_64\nlibblockdev-utils-2.24-5.el8.x86_64\npython3-setools-4.3.0-2.el8.x86_64\npolkit-0.115-11.el8.x86_64\npolkit-pkla-compat-0.1-12.el8.x86_64\nkernel-core-4.18.0-275.el8.x86_64\niputils-20180629-6.el8.x86_64\ngrub2-tools-extra-1:2.02-93.el8.x86_64\nfuse-overlayfs-1.3.0-1.module+el8.4.0+9425+98db097b.x86_64\nlibsolv-0.7.16-1.el8.x86_64\niproute-5.9.0-1.el8.x86_64\nlibjose-10-2.el8.x86_64\nlibusbx-1.0.23-4.el8.x86_64\npython3-decorator-4.2.1-2.el8.noarch\nlibgusb-0.3.0-1.el8.x86_64\njose-10-2.el8.x86_64\nkernel-modules-4.18.0-275.el8.x86_64\ntimedatex-0.5-3.el8.x86_64\nlibblockdev-2.24-5.el8.x86_64\nlibblockdev-fs-2.24-5.el8.x86_64\nlibblockdev-loop-2.24-5.el8.x86_64\nlibblockdev-part-2.24-5.el8.x86_64\nlibblockdev-swap-2.24-5.el8.x86_64\ndevice-mapper-event-8:1.02.175-1.el8.x86_64\nlvm2-libs-8:2.03.11-1.el8.x86_64\nlibqmi-utils-1.24.0-1.el8.x86_64\npython3-libsemanage-2.9-4.el8.x86_64\npython3-slip-0.6.4-11.el8.noarch\ngreenboot-grub2-0.11-1.el8.x86_64\nlibmbim-utils-1.20.2-1.el8.x86_64\nModemManager-1.10.8-2.el8.x86_64\ninitscripts-10.00.12-1.el8.x86_64\nmdadm-4.1-15.el8.x86_64\nlibblockdev-mdraid-2.24-5.el8.x86_64\nwpa_supplicant-1:2.9-3.el8.x86_64\nNetworkManager-libnm-1:1.30.0-0.6.el8.x86_64\nNetworkManager-1:1.30.0-0.6.el8.x86_64\nlibxmlb-0.1.15-1.el8.x86_64\ndbus-glib-0.110-2.el8.x86_64\npython3-dbus-1.2.4-15.el8.x86_64\ngobject-introspection-1.56.1-1.el8.x86_64\npython3-gobject-base-3.28.3-2.el8.x86_64\nlibgcab1-1.1-1.el8.x86_64\nlibmodulemd-2.9.4-2.el8.x86_64\nlibsecret-0.18.6-1.el8.x86_64\npinentry-1.1.0-2.el8.x86_64\ngnupg2-smime-2.2.20-2.el8.x86_64\ngnupg2-2.2.20-2.el8.x86_64\ngpgme-1.13.1-7.el8.x86_64\nostree-libs-2020.7-1.el8.x86_64\nlibrepo-1.12.0-3.el8.x86_64\nrpm-ostree-libs-2020.7-1.el8.x86_64\nostree-2020.7-1.el8.x86_64\nrpm-ostree-2020.7-1.el8.x86_64\nlibuser-0.62-23.el8.x86_64\nconmon-2:2.0.22-3.module+el8.4.0+9425+98db097b.x86_64\nlibslirp-4.3.1-1.module+el8.4.0+9425+98db097b.x86_64\nslirp4netns-1.1.8-1.module+el8.4.0+9425+98db097b.x86_64\ncontainers-common-1:1.2.1-3.module+el8.4.0+9425+98db097b.x86_64\nlibudisks2-2.9.0-5.el8.x86_64\ncryptsetup-2.3.3-2.el8.x86_64\nlibluksmeta-9-4.el8.x86_64\nluksmeta-9-4.el8.x86_64\nbind-export-libs-32:9.11.26-1.el8.x86_64\nlibevent-2.1.8-5.el8.x86_64\nmokutil-1:0.3.0-11.el8.x86_64\ntpm2-tss-2.3.2-3.el8.x86_64\ntpm2-tools-4.1.1-2.el8.x86_64\nclevis-15-1.el8.x86_64\nclevis-luks-15-1.el8.x86_64\nnmap-ncat-2:7.70-5.el8.x86_64\nclevis-systemd-15-1.el8.x86_64\nxfsprogs-5.0.0-8.el8.x86_64\ne2fsprogs-1.45.6-1.el8.x86_64\ndhcp-libs-12:4.3.6-44.el8.x86_64\ndhcp-client-12:4.3.6-44.el8.x86_64\ndracut-network-049-133.git20210112.el8.x86_64\nlibatasmart-0.19-14.el8.x86_64\nnss-sysinit-3.53.1-17.el8_3.x86_64\nnss-3.53.1-17.el8_3.x86_64\nvolume_key-libs-0.3.11-5.el8.x86_64\nlibblockdev-crypto-2.24-5.el8.x86_64\nudisks2-2.9.0-5.el8.x86_64\nfwupd-1.5.5-1.el8.x86_64\npython3-audit-3.0-0.17.20191104git1c2f876.el8.x86_64\npython3-policycoreutils-2.9-9.el8.noarch\npolicycoreutils-python-utils-2.9-9.el8.noarch\ncontainer-selinux-2:2.155.0-1.module+el8.4.0+9425+98db097b.noarch\npodman-catatonit-3.0.0-0.21.module+el8.4.0+9425+98db097b.x86_64\npodman-3.0.0-0.21.module+el8.4.0+9425+98db097b.x86_64\nusbguard-selinux-0.7.8-7.el8.noarch\nusbguard-0.7.8-7.el8.x86_64\npython3-nftables-1:0.9.3-16.el8.x86_64\npython3-six-1.11.0-8.el8.noarch\npython3-slip-dbus-0.6.4-11.el8.noarch\npython3-firewall-0.8.2-3.el8.noarch\nfirewalld-0.8.2-3.el8.noarch\nshim-x64-15-16.el8.x86_64\nclevis-dracut-15-1.el8.x86_64\ntmux-2.7-1.el8.x86_64\nskopeo-1:1.2.1-3.module+el8.4.0+9425+98db097b.x86_64\npasswd-0.80-3.el8.x86_64\ngreenboot-rpm-ostree-grub2-0.11-1.el8.x86_64\nNetworkManager-wifi-1:1.30.0-0.6.el8.x86_64\nNetworkManager-wwan-1:1.30.0-0.6.el8.x86_64\naudit-3.0-0.17.20191104git1c2f876.el8.x86_64\nlvm2-8:2.03.11-1.el8.x86_64\nchrony-3.5-1.el8.x86_64\nRunning in chroot, ignoring request: daemon-reload\nkernel-4.18.0-275.el8.x86_64\ngrub2-efi-x64-1:2.02-93.el8.x86_64\ngrub2-pc-1:2.02-93.el8.x86_64\nsetools-console-4.3.0-2.el8.x86_64\nopenssh-clients-8.0p1-5.el8.x86_64\nopenssh-server-8.0p1-5.el8.x86_64\ngreenboot-status-0.11-1.el8.x86_64\ngreenboot-reboot-0.11-1.el8.x86_64\nmicrocode_ctl-4:20201112-1.el8.x86_64\ndnsmasq-2.79-14.el8.x86_64\ndracut-config-generic-049-133.git20210112.el8.x86_64\nsudo-1.8.29-6.el8.x86_64\nima-evm-utils-1.1-5.el8.x86_64\nbash-completion-1:2.7-5.el8.noarch\nkeyutils-1.5.10-6.el8.x86_64\nefibootmgr-16-1.el8.x86_64\nrsync-3.1.3-12.el8.x86_64\nattr-2.4.48-3.el8.x86_64\nhostname-3.20-6.el8.x86_64\nless-530-1.el8.x86_64\ntraceroute-3:2.1.0-6.el8.x86_64\nnss-altfiles-2.18.1-12.el8.x86_64\nrootfiles-8.1-22.el8.noarch\niwl7260-firmware-1:25.30.13.0-101.el8.1.noarch\niwl6050-firmware-41.28.5.1-101.el8.1.noarch\niwl6000-firmware-9.221.4.1-101.el8.1.noarch\niwl5150-firmware-8.24.2.2-101.el8.1.noarch\niwl5000-firmware-8.83.5.1_1-101.el8.1.noarch\niwl3160-firmware-1:25.30.13.0-101.el8.1.noarch\niwl2030-firmware-18.168.6.1-101.el8.1.noarch\niwl2000-firmware-18.168.6.1-101.el8.1.noarch\niwl135-firmware-18.168.6.1-101.el8.1.noarch\niwl105-firmware-18.168.6.1-101.el8.1.noarch\niwl1000-firmware-1:39.31.5.1-101.el8.1.noarch\niwl100-firmware-39.31.5.1-101.el8.1.noarch\ndracut: No '/dev/log' or 'logger' included for syslog logging\nimported gpg key\nimported gpg key\nimported gpg key\ncreating a fake machine id\ndeleting the fake machine id\n"
            },
            {
                "id": "fb5e7b93a3eba924a02a89043554641b022abcdaf07eb933da24813277a93636",
                "type": "org.osbuild.locale",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n/run/osbuild/tree/etc/locale.conf written.\n"
            },
            {
                "id": "52bb78797b3fc3c05d4d538f1b1362648f232b149cf7bf73edda582754167a7f",
                "type": "org.osbuild.timezone",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n/run/osbuild/tree/etc/localtime written\n/etc/localtime already exists. Replacing.\n"
            },
            {
                "id": "b63e0b7baa7b0acd794ee3d2f92728f6ef45bde203fbffba3364b17499aab63f",
                "type": "org.osbuild.systemd",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\nCreated symlink /run/osbuild/tree/etc/systemd/system/ostree-finalize-staged.service.requires/greenboot-grub2-set-counter.service → /usr/lib/systemd/system/greenboot-grub2-set-counter.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/multi-user.target.requires/greenboot-grub2-set-success.service → /usr/lib/systemd/system/greenboot-grub2-set-success.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/multi-user.target.wants/greenboot-healthcheck.service → /usr/lib/systemd/system/greenboot-healthcheck.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/boot-complete.target.requires/greenboot-healthcheck.service → /usr/lib/systemd/system/greenboot-healthcheck.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/greenboot-healthcheck.service.requires/greenboot-rpm-ostree-grub2-check-fallback.service → /usr/lib/systemd/system/greenboot-rpm-ostree-grub2-check-fallback.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/multi-user.target.wants/greenboot-status.service → /usr/lib/systemd/system/greenboot-status.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/multi-user.target.wants/greenboot-task-runner.service → /usr/lib/systemd/system/greenboot-task-runner.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/redboot.target.wants/redboot-auto-reboot.service → /usr/lib/systemd/system/redboot-auto-reboot.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/redboot.target.requires/redboot-task-runner.service → /usr/lib/systemd/system/redboot-task-runner.service.\n"
            },
            {
                "id": "8408aa9001f16dc620ec55be98f4ae39fc53821f030ac7a317ffa5ab23d0004c",
                "type": "org.osbuild.selinux",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n"
            },
            {
                "id": "3eee7dcec04f605eadfb8bea2288ae80d5486498f8eeafa29fc011982cf5ca19",
                "type": "org.osbuild.sysconfig",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n"
            },
            {
                "id": "fb1abba7db9c429bda336994831ed884b352fedd86b874c6c4d90980869fcc3f",
                "type": "org.osbuild.ostree.preptree",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\nRecompiling policy\nMigrating /usr/etc/passwd to /usr/lib/\nMigrating /usr/etc/group to /usr/lib/\nSELinux policy in /var, enabling workaround\nIgnoring non-directory/non-symlink '/var/lib/alternatives/libnssckbi.so.x86_64'\nIgnoring non-directory/non-symlink '/var/lib/alternatives/python'\nIgnoring non-directory/non-symlink '/var/lib/alternatives/ifup'\nIgnoring non-directory/non-symlink '/var/lib/alternatives/nmap'\nIgnoring non-directory/non-symlink '/var/lib/fwupd/builder/README.md'\nIgnoring non-directory/non-symlink '/var/log/lastlog'\nIgnoring non-directory/non-symlink '/var/cache/ldconfig/aux-cache'\nAdding rpm-ostree-0-integration.conf\nPreparing kernel\nRemoving RPM-generated 'usr/lib/ostree-boot/initramfs-4.18.0-275.el8.x86_64.img'\nCreating empty machine-id\ndracut: No '/dev/log' or 'logger' included for syslog logging\ndracut: Executing: /usr/bin/dracut --reproducible --gzip -v --add ostree --tmpdir=/tmp/dracut -f /tmp/initramfs.img --kver 4.18.0-275.el8.x86_64\ndracut: dracut module 'busybox' will not be installed, because command 'busybox' could not be found!\ndracut: dracut module 'rngd' will not be installed, because command 'rngd' could not be found!\ndracut: dracut module 'btrfs' will not be installed, because command 'btrfs' could not be found!\ndracut: dracut module 'dmraid' will not be installed, because command 'dmraid' could not be found!\ndracut: dracut module 'multipath' will not be installed, because command 'multipath' could not be found!\ndracut: dracut module 'stratis' will not be installed, because command 'stratisd-init' could not be found!\ndracut: dracut module 'cifs' will not be installed, because command 'mount.cifs' could not be found!\ndracut: dracut module 'fcoe' will not be installed, because command 'dcbtool' could not be found!\ndracut: dracut module 'fcoe' will not be installed, because command 'fipvlan' could not be found!\ndracut: dracut module 'fcoe' will not be installed, because command 'lldpad' could not be found!\ndracut: dracut module 'fcoe' will not be installed, because command 'fcoemon' could not be found!\ndracut: dracut module 'fcoe' will not be installed, because command 'fcoeadm' could not be found!\ndracut: dracut module 'fcoe-uefi' will not be installed, because command 'dcbtool' could not be found!\ndracut: dracut module 'fcoe-uefi' will not be installed, because command 'fipvlan' could not be found!\ndracut: dracut module 'fcoe-uefi' will not be installed, because command 'lldpad' could not be found!\ndracut: dracut module 'iscsi' will not be installed, because command 'iscsi-iname' could not be found!\ndracut: dracut module 'iscsi' will not be installed, because command 'iscsiadm' could not be found!\ndracut: dracut module 'iscsi' will not be installed, because command 'iscsid' could not be found!\ndracut: dracut module 'nbd' will not be installed, because command 'nbd-client' could not be found!\ndracut: 95nfs: Could not find any command of 'rpcbind portmap'!\ndracut: dracut module 'nvmf' will not be installed, because command 'nvme' could not be found!\ndracut: dracut module 'biosdevname' will not be installed, because command 'biosdevname' could not be found!\ndracut: memstrack is available\nmknod: /tmp/dracut/dracut.BD4N5p/initramfs/dev/null: Operation not permitted\nmknod: /tmp/dracut/dracut.BD4N5p/initramfs/dev/kmsg: Operation not permitted\nmknod: /tmp/dracut/dracut.BD4N5p/initramfs/dev/console: Operation not permitted\nmknod: /tmp/dracut/dracut.BD4N5p/initramfs/dev/random: Operation not permitted\nmknod: /tmp/dracut/dracut.BD4N5p/initramfs/dev/urandom: Operation not permitted\ndracut: *** Including module: bash ***\ndracut: *** Including module: systemd ***\ndracut: *** Including module: systemd-initrd ***\ndracut: *** Including module: modsign ***\ndracut: *** Including module: nss-softokn ***\ndracut: *** Including module: i18n ***\ndracut: *** Including module: network-manager ***\ndracut: *** Including module: network ***\ndracut: *** Including module: ifcfg ***\ndracut: *** Including module: clevis ***\ndracut: *** Including module: clevis-pin-sss ***\ndracut: *** Including module: clevis-pin-tang ***\ndracut: *** Including module: clevis-pin-tpm2 ***\ndracut: *** Including module: crypt ***\ndracut: *** Including module: dm ***\ndracut: Skipping udev rule: 64-device-mapper.rules\ndracut: Skipping udev rule: 60-persistent-storage-dm.rules\ndracut: Skipping udev rule: 55-dm.rules\ndracut: *** Including module: kernel-modules ***\ndracut: *** Including module: kernel-modules-extra ***\ndracut: *** Including module: kernel-network-modules ***\ndracut: *** Including module: lvm ***\ndracut: Skipping udev rule: 64-device-mapper.rules\ndracut: Skipping udev rule: 56-lvm.rules\ndracut: Skipping udev rule: 60-persistent-storage-lvm.rules\ndracut: *** Including module: mdraid ***\ndracut: Skipping udev rule: 64-md-raid.rules\ndracut: *** Including module: qemu ***\ndracut: *** Including module: qemu-net ***\ndracut: *** Including module: lunmask ***\ndracut: *** Including module: resume ***\ndracut: *** Including module: rootfs-block ***\ndracut: *** Including module: terminfo ***\ndracut: *** Including module: udev-rules ***\ndracut: Skipping udev rule: 91-permissions.rules\ndracut: Skipping udev rule: 80-drivers-modprobe.rules\ndracut: *** Including module: dracut-systemd ***\ndracut: *** Including module: ostree ***\ndracut: *** Including module: usrmount ***\ndracut: *** Including module: base ***\ndracut: *** Including module: fs-lib ***\ndracut: *** Including module: memstrack ***\ndracut: *** Including module: microcode_ctl-fw_dir_override ***\ndracut:   microcode_ctl module: mangling fw_dir\ndracut:     microcode_ctl: reset fw_dir to \"/lib/firmware/updates /lib/firmware\"\ndracut:     microcode_ctl: processing data directory  \"/usr/share/microcode_ctl/ucode_with_caveats/intel\"...\nintel: model '', path ' intel-ucode/*', kvers ''\nintel: blacklist ''\ndracut:       microcode_ctl: intel: caveats check for kernel version \"4.18.0-275.el8.x86_64\" passed, adding \"/usr/share/microcode_ctl/ucode_with_caveats/intel\" to fw_dir variable\ndracut:     microcode_ctl: processing data directory  \"/usr/share/microcode_ctl/ucode_with_caveats/intel-06-2d-07\"...\nintel-06-2d-07: model 'GenuineIntel 06-2d-07', path ' intel-ucode/06-2d-07', kvers ''\nintel-06-2d-07: blacklist ''\ndracut:       microcode_ctl: intel-06-2d-07: caveats check for kernel version \"4.18.0-275.el8.x86_64\" passed, adding \"/usr/share/microcode_ctl/ucode_with_caveats/intel-06-2d-07\" to fw_dir variable\ndracut:     microcode_ctl: processing data directory  \"/usr/share/microcode_ctl/ucode_with_caveats/intel-06-4e-03\"...\nintel-06-4e-03: model 'GenuineIntel 06-4e-03', path ' intel-ucode/06-4e-03', kvers ''\nintel-06-4e-03: blacklist ''\nintel-06-4e-03: caveat is disabled in configuration\ndracut:     microcode_ctl: kernel version \"4.18.0-275.el8.x86_64\" failed early load check for \"intel-06-4e-03\", skipping\ndracut:     microcode_ctl: processing data directory  \"/usr/share/microcode_ctl/ucode_with_caveats/intel-06-4f-01\"...\nintel-06-4f-01: model 'GenuineIntel 06-4f-01', path ' intel-ucode/06-4f-01', kvers ' 4.17.0 3.10.0-894 3.10.0-862.6.1 3.10.0-693.35.1 3.10.0-514.52.1 3.10.0-327.70.1 2.6.32-754.1.1 2.6.32-573.58.1 2.6.32-504.71.1 2.6.32-431.90.1 2.6.32-358.90.1'\nintel-06-4f-01: blacklist ''\nintel-06-4f-01: caveat is disabled in configuration\ndracut:     microcode_ctl: kernel version \"4.18.0-275.el8.x86_64\" failed early load check for \"intel-06-4f-01\", skipping\ndracut:     microcode_ctl: processing data directory  \"/usr/share/microcode_ctl/ucode_with_caveats/intel-06-55-04\"...\nintel-06-55-04: model 'GenuineIntel 06-55-04', path ' intel-ucode/06-55-04', kvers ''\nintel-06-55-04: blacklist ''\ndracut:       microcode_ctl: intel-06-55-04: caveats check for kernel version \"4.18.0-275.el8.x86_64\" passed, adding \"/usr/share/microcode_ctl/ucode_with_caveats/intel-06-55-04\" to fw_dir variable\ndracut:     microcode_ctl: processing data directory  \"/usr/share/microcode_ctl/ucode_with_caveats/intel-06-5e-03\"...\nintel-06-5e-03: model 'GenuineIntel 06-5e-03', path ' intel-ucode/06-5e-03', kvers ''\nintel-06-5e-03: blacklist ''\nintel-06-5e-03: caveat is disabled in configuration\ndracut:     microcode_ctl: kernel version \"4.18.0-275.el8.x86_64\" failed early load check for \"intel-06-5e-03\", skipping\ndracut:     microcode_ctl: processing data directory  \"/usr/share/microcode_ctl/ucode_with_caveats/intel-06-8c-01\"...\nintel-06-8c-01: model 'GenuineIntel 06-8c-01', path ' intel-ucode/06-8c-01', kvers ''\nintel-06-8c-01: blacklist ''\nintel-06-8c-01: caveat is disabled in configuration\ndracut:     microcode_ctl: kernel version \"4.18.0-275.el8.x86_64\" failed early load check for \"intel-06-8c-01\", skipping\ndracut:     microcode_ctl: processing data directory  \"/usr/share/microcode_ctl/ucode_with_caveats/intel-06-8e-9e-0x-0xca\"...\nintel-06-8e-9e-0x-0xca: model '', path ' intel-ucode/*', kvers ''\nintel-06-8e-9e-0x-0xca: blacklist ''\nintel-06-8e-9e-0x-0xca: caveat is disabled in configuration\ndracut:     microcode_ctl: kernel version \"4.18.0-275.el8.x86_64\" failed early load check for \"intel-06-8e-9e-0x-0xca\", skipping\ndracut:     microcode_ctl: processing data directory  \"/usr/share/microcode_ctl/ucode_with_caveats/intel-06-8e-9e-0x-dell\"...\nintel-06-8e-9e-0x-dell: model '', path ' intel-ucode/*', kvers ''\nintel-06-8e-9e-0x-dell: blacklist ''\ndracut:       microcode_ctl: intel-06-8e-9e-0x-dell: caveats check for kernel version \"4.18.0-275.el8.x86_64\" passed, adding \"/usr/share/microcode_ctl/ucode_with_caveats/intel-06-8e-9e-0x-dell\" to fw_dir variable\ndracut:     microcode_ctl: final fw_dir: \"/usr/share/microcode_ctl/ucode_with_caveats/intel-06-8e-9e-0x-dell /usr/share/microcode_ctl/ucode_with_caveats/intel-06-55-04 /usr/share/microcode_ctl/ucode_with_caveats/intel-06-2d-07 /usr/share/microcode_ctl/ucode_with_caveats/intel /lib/firmware/updates /lib/firmware\"\ndracut: *** Including module: shutdown ***\ndracut: *** Including modules done ***\ndracut: *** Installing kernel module dependencies ***\ndracut: *** Installing kernel module dependencies done ***\ndracut: *** Resolving executable dependencies ***\ndracut: *** Resolving executable dependencies done***\ndracut: *** Hardlinking files ***\ndracut: *** Hardlinking files done ***\ndracut: Could not find 'strip'. Not stripping the initramfs.\ndracut: *** Generating early-microcode cpio image ***\ndracut: *** Constructing AuthenticAMD.bin ****\ndracut: *** Constructing GenuineIntel.bin ****\ndracut: *** Constructing GenuineIntel.bin ****\ndracut: *** Constructing GenuineIntel.bin ****\ndracut: *** Constructing GenuineIntel.bin ****\ndracut: *** Constructing GenuineIntel.bin ****\ndracut: *** Store current command line parameters ***\ndracut: *** Creating image file '/tmp/initramfs.img' ***\ndracut: *** Creating initramfs image file '/tmp/initramfs.img' done ***\nostree: machineid-compat: True\nMoving tree to temporary root\nInitializing new root filesystem\nMoving data back from temporary root\n"
            }
        ],
        "ostree-commit": [
            {
                "id": "a1f15e842f50da89bac06ccef211f8a3d3b0858fcc5f0fe949a9e7a9e230a81e",
                "type": "org.osbuild.ostree.init",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n"
            },
            {
                "id": "ca4759f532fa83a6532be33ec4122dd8c45516fb5f4f9decc424f6edf145df3c",
                "type": "org.osbuild.ostree.commit",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\nwarning: boot-location: \"new\" is deprecated, use boot-location: modules\nCommitting...done\nrhel/8/x86_64/edge => f2b16f20de69edf932866662efbd00754c2d0decd878c60b4914372e34b5e629\nMetadata Total: 9495\nMetadata Written: 3361\nContent Total: 26016\nContent Written: 21965\nContent Cache Hits: 0\nContent Bytes Written: 1485885441\n"
            }
        ],
        "container-tree": [
            {
                "id": "44b48fb20d6c1ac865171d8355d3c9e2d644461600bb05e22eec50708413b58e",
                "type": "org.osbuild.rpm",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\nPreparing packages...\nlibgcc-8.4.1-1.el8.x86_64\npython3-setuptools-wheel-39.2.0-6.el8.noarch\npython3-pip-wheel-9.0.3-19.el8.noarch\nxkeyboard-config-2.28-1.el8.noarch\ntzdata-2020f-1.el8.noarch\nredhat-release-eula-8.4-0.5.el8.x86_64\nredhat-release-8.4-0.5.el8.x86_64\nsetup-2.12.2-6.el8.noarch\nfilesystem-3.8-3.el8.x86_64\nbasesystem-11-5.el8.noarch\nredhat-logos-httpd-82.2-1.el8.noarch\npublicsuffix-list-dafsa-20180723-1.el8.noarch\nncurses-base-6.1-7.20180224.el8.noarch\npcre2-10.32-2.el8.x86_64\nlibselinux-2.9-5.el8.x86_64\nncurses-libs-6.1-7.20180224.el8.x86_64\nglibc-all-langpacks-2.28-145.el8.x86_64\nglibc-common-2.28-145.el8.x86_64\nglibc-2.28-145.el8.x86_64\nbash-4.4.19-14.el8.x86_64\nlibsepol-2.9-2.el8.x86_64\nzlib-1.2.11-17.el8.x86_64\nxz-libs-5.2.4-3.el8.x86_64\ninfo-6.5-6.el8.x86_64\nlibxcrypt-4.1.1-4.el8.x86_64\nbzip2-libs-1.0.6-26.el8.x86_64\nlibuuid-2.32.1-26.el8.x86_64\nexpat-2.2.5-4.el8.x86_64\nlibcap-2.26-4.el8.x86_64\nlibunistring-0.9.9-3.el8.x86_64\nlibxml2-2.9.7-9.el8.x86_64\nelfutils-libelf-0.182-3.el8.x86_64\ngmp-1:6.1.2-10.el8.x86_64\nlibcom_err-1.45.6-1.el8.x86_64\nlibidn2-2.2.0-1.el8.x86_64\nlibattr-2.4.48-3.el8.x86_64\nlibacl-2.2.53-1.el8.x86_64\nsed-4.5-2.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/sed.info.gz\nlibzstd-1.4.4-1.el8.x86_64\napr-1.6.3-11.el8.x86_64\nreadline-7.0-10.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/history.info\ninstall-info: No such file or directory for /usr/share/info/rluserman.info\nlibcap-ng-0.7.9-5.el8.x86_64\naudit-libs-3.0-0.17.20191104git1c2f876.el8.x86_64\nlibffi-3.1-22.el8.x86_64\np11-kit-0.23.22-1.el8.x86_64\nlua-libs-5.3.4-11.el8.x86_64\nlz4-libs-1.8.3-2.el8.x86_64\npcre-8.42-4.el8.x86_64\ngrep-3.1-6.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/grep.info.gz\npopt-1.18-1.el8.x86_64\nchkconfig-1.13-2.el8.x86_64\nfindutils-1:4.6.0-20.el8.x86_64\nlibgomp-8.4.1-1.el8.x86_64\ngrub2-common-1:2.02-93.el8.noarch\nbrotli-1.0.6-3.el8.x86_64\ngdbm-libs-1:1.18-1.el8.x86_64\nlibgpg-error-1.31-1.el8.x86_64\nlibgcrypt-1.8.5-4.el8.x86_64\nlibnghttp2-1.33.0-3.el8_2.1.x86_64\nlibtasn1-4.13-3.el8.x86_64\np11-kit-trust-0.23.22-1.el8.x86_64\ngdbm-1:1.18-1.el8.x86_64\nxz-5.2.4-3.el8.x86_64\nlibsemanage-2.9-4.el8.x86_64\nacl-2.2.53-1.el8.x86_64\nlibpsl-0.20.2-6.el8.x86_64\nmpfr-3.1.6-1.el8.x86_64\nnettle-3.4.1-2.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/nettle.info\nlibmetalink-0.1.3-7.el8.x86_64\ncoreutils-common-8.30-8.el8.x86_64\ndiffutils-3.6-6.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/diffutils.info\nfile-libs-5.33-16.el8.x86_64\nfile-5.33-16.el8.x86_64\npigz-2.4-4.el8.x86_64\nsqlite-libs-3.26.0-13.el8.x86_64\ncpio-2.12-9.el8.x86_64\nhardlink-1:1.3-6.el8.x86_64\njson-c-0.13.1-0.3.el8.x86_64\nkeyutils-libs-1.5.10-6.el8.x86_64\nlibpcap-14:1.9.1-4.el8.x86_64\niptables-libs-1.8.4-16.el8.x86_64\nlibseccomp-2.4.3-1.el8.x86_64\nlibsigsegv-2.11-5.el8.x86_64\ngawk-4.2.1-2.el8.x86_64\nlibsmartcols-2.32.1-26.el8.x86_64\nlibstdc++-8.4.1-1.el8.x86_64\nlibverto-0.3.0-5.el8.x86_64\nmemstrack-0.1.11-1.el8.x86_64\nncurses-6.1-7.20180224.el8.x86_64\nwhich-2.21-12.el8.x86_64\nlibxkbcommon-0.9.1-1.el8.x86_64\nmailcap-2.1.48-3.el8.noarch\nlibssh-config-0.9.4-2.el8.noarch\nkbd-misc-2.0.4-10.el8.noarch\nkbd-legacy-2.0.4-10.el8.noarch\ndbus-common-1:1.12.8-12.el8.noarch\ncyrus-sasl-lib-2.1.27-5.el8.x86_64\nplatform-python-pip-9.0.3-19.el8.noarch\nplatform-python-setuptools-39.2.0-6.el8.noarch\npython3-libs-3.6.8-34.el8.x86_64\ngrub2-tools-minimal-1:2.02-93.el8.x86_64\nlibssh-0.9.4-2.el8.x86_64\nopenldap-2.4.46-16.el8.x86_64\nplatform-python-3.6.8-34.el8.x86_64\ngrubby-8.40-41.el8.x86_64\nlibkcapi-1.2.0-2.el8.x86_64\nlibkcapi-hmaccalc-1.2.0-2.el8.x86_64\nlibarchive-3.3.3-1.el8.x86_64\nlibdb-utils-5.3.28-40.el8.x86_64\ncurl-7.61.1-17.el8.x86_64\nlibcurl-7.61.1-17.el8.x86_64\nopenssl-1:1.1.1g-12.el8_3.x86_64\ncrypto-policies-scripts-20200713-1.git51d1222.el8.noarch\ncrypto-policies-20200713-1.git51d1222.el8.noarch\nelfutils-default-yama-scope-0.182-3.el8.noarch\ngzip-1.9-12.el8.x86_64\ncracklib-2.9.6-15.el8.x86_64\ncracklib-dicts-2.9.6-15.el8.x86_64\nprocps-ng-3.3.15-5.el8.x86_64\nkrb5-libs-1.18.2-8.el8.x86_64\nlibtirpc-1.1.4-4.el8.x86_64\nlibnsl2-1.2.0-2.20180605git4a062cf.el8.x86_64\nkpartx-0.8.4-7.el8.x86_64\ndevice-mapper-8:1.02.175-1.el8.x86_64\nelfutils-debuginfod-client-0.182-3.el8.x86_64\nelfutils-libs-0.182-3.el8.x86_64\nopenssl-pkcs11-0.4.10-2.el8.x86_64\nrpm-4.14.3-4.el8.x86_64\ngettext-libs-0.19.8.1-17.el8.x86_64\nlibcroco-0.6.12-4.el8_2.1.x86_64\nlibfdisk-2.32.1-26.el8.x86_64\nlibmount-2.32.1-26.el8.x86_64\ndbus-libs-1:1.12.8-12.el8.x86_64\ndbus-tools-1:1.12.8-12.el8.x86_64\ncoreutils-8.30-8.el8.x86_64\nsystemd-libs-239-43.el8.x86_64\nlibblkid-2.32.1-26.el8.x86_64\ndevice-mapper-libs-8:1.02.175-1.el8.x86_64\nshadow-utils-2:4.6-12.el8.x86_64\nca-certificates-2020.2.41-80.0.el8_2.noarch\nopenssl-libs-1:1.1.1g-12.el8_3.x86_64\nlibdb-5.3.28-40.el8.x86_64\nrpm-libs-4.14.3-4.el8.x86_64\nkmod-25-17.el8.x86_64\nkmod-libs-25-17.el8.x86_64\ncryptsetup-libs-2.3.3-2.el8.x86_64\ntrousers-lib-0.3.15-1.el8.x86_64\ndbus-daemon-1:1.12.8-12.el8.x86_64\nlibutempter-1.1.6-14.el8.x86_64\nkbd-2.0.4-10.el8.x86_64\nlibpwquality-1.4.4-1.el8.x86_64\npam-1.3.1-14.el8.x86_64\nutil-linux-2.32.1-26.el8.x86_64\nsystemd-pam-239-43.el8.x86_64\ndracut-049-133.git20210112.el8.x86_64\nos-prober-1.74-6.el8.x86_64\ngettext-0.19.8.1-17.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/gettext.info.gz\ngrub2-tools-1:2.02-93.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/grub2.info.gz\ninstall-info: No such file or directory for /usr/share/info/grub2-dev.info.gz\nglib2-2.56.4-9.el8.x86_64\nshared-mime-info-1.9-3.el8.x86_64\ngnutls-3.6.14-7.el8_3.x86_64\ndbus-1:1.12.8-12.el8.x86_64\nsystemd-239-43.el8.x86_64\nsystemd-udev-239-43.el8.x86_64\ntrousers-0.3.15-1.el8.x86_64\napr-util-bdb-1.6.1-6.el8.x86_64\napr-util-1.6.1-6.el8.x86_64\napr-util-openssl-1.6.1-6.el8.x86_64\nhttpd-tools-2.4.37-37.module+el8.4.0+9120+2819a868.x86_64\nhttpd-filesystem-2.4.37-37.module+el8.4.0+9120+2819a868.noarch\nmod_http2-1.15.7-3.module+el8.4.0+8625+d397f3da.x86_64\nhttpd-2.4.37-37.module+el8.4.0+9120+2819a868.x86_64\nimported gpg key\nimported gpg key\nimported gpg key\ncreating a fake machine id\ndeleting the fake machine id\n"
            },
            {
                "id": "8b16be7b18a76a9807de410d1b3a894b57343e3433dfc469c00419891344add9",
                "type": "org.osbuild.locale",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n/run/osbuild/tree/etc/locale.conf written.\n"
            },
            {
                "id": "d2222e418a9fcb4712778d3ccaeb5d6ccbdaf51000f335c90f534e032ad76754",
                "type": "org.osbuild.ostree.init",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n"
            },
            {
                "id": "1c40859d6d74d43d984fd6f364194735279d35bf4e21d74e1f12298f2b3bd4b6",
                "type": "org.osbuild.ostree.pull",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n3361 metadata, 21965 content objects imported; 0 bytes content written\nostree pull-local /run/osbuild/inputs/commits rhel/8/x86_64/edge --repo=/run/osbuild/tree/var/www/html/repo\n"
            }
        ],
        "assembler": [
            {
                "id": "621c966c005c56d311d6ac39117d738780406b594523a933222c8af51ba98541",
                "type": "org.osbuild.oci-archive",
                "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n{'Env': ['PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin'], 'Cmd': ['httpd', '-D', 'FOREGROUND'], 'ExposedPorts': {'80': {}}}\ncreating layer\ncompressing layer\nblobs: +layer (806485052, d0acb4a72ec9e8a8525b17db6b8052ad6ed2b790820162a1f5ae9d5954a7a569)\nblobs: +config (358, 1b43c364d3fecffaa028e82470e07144cff032923f5a9c1d63208f715edf8be4)\nblobs: +manifest (365, a8adcd857cbf0165551e6227e928c8aba7ac663c6fee20139f5e34e4a6543daf)\nwriting index\ncreating final archive\n"
            }
        ]
    }
}
`

const v2ResultFailure = `
{
  "type": "error",
  "success": false,
  "error": {
    "type": "org.osbuild.error.stage",
    "details": {
      "stage": {
        "id": "147fe506d915edb9e0eb8fdb88adb43c8603125f455f47d0228bca935bb997f6",
        "type": "org.osbuild.selinux",
        "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n/run/osbuild/tree/etc/selinux/targeted/contexts/files/file_context: No such file or directory\nTraceback (most recent call last):\n  File \"/run/osbuild/bin/org.osbuild.selinux\", line 62, in <module>\n    r = main(args[\"tree\"], args[\"options\"])\n  File \"/run/osbuild/bin/org.osbuild.selinux\", line 53, in main\n    subprocess.run([\"setfiles\", \"-F\", \"-r\", f\"{tree}\", f\"{file_contexts}\", f\"{tree}\"], check=True)\n  File \"/usr/lib64/python3.6/subprocess.py\", line 438, in run\n    output=stdout, stderr=stderr)\nsubprocess.CalledProcessError: Command '['setfiles', '-F', '-r', '/run/osbuild/tree', '/run/osbuild/tree/etc/selinux/targeted/contexts/files/file_context', '/run/osbuild/tree']' returned non-zero exit status 255.\n",
        "error": null
      }
    }
  },
  "log": {
    "build": [
      {
        "id": "56a93713050f49c966eda0391dce1340d16f168bcbfd542d9d90be668ecc8268",
        "type": "org.osbuild.rpm",
        "output": "/usr/lib/tmpfiles.d/abrt.conf:2: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/abrt.conf:9: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/colord.conf:1: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:2: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:3: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/cups.conf:4: Failed to resolve user 'lp': No such process\n/usr/lib/tmpfiles.d/gluster.conf:2: Failed to resolve user 'gluster': No such process\n/usr/lib/tmpfiles.d/httpd.conf:1: Failed to resolve group 'apache'.\n/usr/lib/tmpfiles.d/httpd.conf:2: Failed to resolve user 'apache': No such process\n/usr/lib/tmpfiles.d/journal-nocow.conf:26: Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\n/usr/lib/tmpfiles.d/lockdev.conf:3: Failed to resolve group 'lock'.\n/usr/lib/tmpfiles.d/openvpn.conf:1: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/openvpn.conf:2: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/radvd.conf:1: Failed to resolve user 'radvd': No such process\n/usr/lib/tmpfiles.d/rpcbind.conf:2: Failed to resolve user 'rpc': No such process\nFailed to open file \"/sys/fs/selinux/checkreqprot\": Read-only file system\nPreparing packages...\nlibgcc-8.4.1-1.el8.x86_64\npython3-setuptools-wheel-39.2.0-6.el8.noarch\npython3-pip-wheel-9.0.3-19.el8.noarch\nxkeyboard-config-2.28-1.el8.noarch\ntzdata-2020f-1.el8.noarch\nredhat-release-eula-8.4-0.5.el8.x86_64\nredhat-release-8.4-0.5.el8.x86_64\nsetup-2.12.2-6.el8.noarch\nfilesystem-3.8-3.el8.x86_64\nbasesystem-11-5.el8.noarch\npublicsuffix-list-dafsa-20180723-1.el8.noarch\nncurses-base-6.1-7.20180224.el8.noarch\npcre2-10.32-2.el8.x86_64\nlibselinux-2.9-5.el8.x86_64\nncurses-libs-6.1-7.20180224.el8.x86_64\nglibc-all-langpacks-2.28-145.el8.x86_64\nglibc-common-2.28-145.el8.x86_64\nglibc-2.28-145.el8.x86_64\nbash-4.4.19-14.el8.x86_64\nlibsepol-2.9-2.el8.x86_64\nzlib-1.2.11-17.el8.x86_64\nxz-libs-5.2.4-3.el8.x86_64\nlibgpg-error-1.31-1.el8.x86_64\nbzip2-libs-1.0.6-26.el8.x86_64\ninfo-6.5-6.el8.x86_64\nlibcap-2.26-4.el8.x86_64\nlibxml2-2.9.7-9.el8.x86_64\nelfutils-libelf-0.182-3.el8.x86_64\nlibcom_err-1.45.6-1.el8.x86_64\nlibzstd-1.4.4-1.el8.x86_64\nexpat-2.2.5-4.el8.x86_64\nlibuuid-2.32.1-26.el8.x86_64\npopt-1.18-1.el8.x86_64\nreadline-7.0-10.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/history.info\ninstall-info: No such file or directory for /usr/share/info/rluserman.info\nlibgcrypt-1.8.5-4.el8.x86_64\nsqlite-libs-3.26.0-13.el8.x86_64\nlibstdc++-8.4.1-1.el8.x86_64\nlibxcrypt-4.1.1-4.el8.x86_64\nlua-libs-5.3.4-11.el8.x86_64\nchkconfig-1.13-2.el8.x86_64\nlibunistring-0.9.9-3.el8.x86_64\ngrub2-common-1:2.02-93.el8.noarch\ngmp-1:6.1.2-10.el8.x86_64\njson-c-0.13.1-0.3.el8.x86_64\nlibsmartcols-2.32.1-26.el8.x86_64\nlibidn2-2.2.0-1.el8.x86_64\nlibassuan-2.5.1-3.el8.x86_64\nfile-libs-5.33-16.el8.x86_64\nlibattr-2.4.48-3.el8.x86_64\nlibacl-2.2.53-1.el8.x86_64\nsed-4.5-2.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/sed.info.gz\nlibcap-ng-0.7.9-5.el8.x86_64\naudit-libs-3.0-0.17.20191104git1c2f876.el8.x86_64\nwhich-2.21-12.el8.x86_64\nfile-5.33-16.el8.x86_64\nlibffi-3.1-22.el8.x86_64\np11-kit-0.23.22-1.el8.x86_64\nlz4-libs-1.8.3-2.el8.x86_64\nlibsemanage-2.9-4.el8.x86_64\ndiffutils-3.6-6.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/diffutils.info\nfindutils-1:4.6.0-20.el8.x86_64\nlibgomp-8.4.1-1.el8.x86_64\nlibksba-1.3.5-7.el8.x86_64\nfuse-libs-2.9.7-12.el8.x86_64\ngdbm-libs-1:1.18-1.el8.x86_64\nkeyutils-libs-1.5.10-6.el8.x86_64\nlibtasn1-4.13-3.el8.x86_64\np11-kit-trust-0.23.22-1.el8.x86_64\npcre-8.42-4.el8.x86_64\ngrep-3.1-6.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/grep.info.gz\nxz-5.2.4-3.el8.x86_64\ngdbm-1:1.18-1.el8.x86_64\nacl-2.2.53-1.el8.x86_64\nlibpsl-0.20.2-6.el8.x86_64\nmpfr-3.1.6-1.el8.x86_64\nnettle-3.4.1-2.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/nettle.info\ngrub2-pc-modules-1:2.02-93.el8.noarch\nlibcomps-0.1.11-4.el8.x86_64\nlibmetalink-0.1.3-7.el8.x86_64\ne2fsprogs-libs-1.45.6-1.el8.x86_64\nlibss-1.45.6-1.el8.x86_64\nbubblewrap-0.4.0-1.el8.x86_64\ncoreutils-common-8.30-8.el8.x86_64\nlibpng-2:1.6.34-5.el8.x86_64\nfreetype-2.9.1-4.el8_3.1.x86_64\npigz-2.4-4.el8.x86_64\nlibselinux-utils-2.9-5.el8.x86_64\nbrotli-1.0.6-3.el8.x86_64\ncpio-2.12-9.el8.x86_64\nhardlink-1:1.3-6.el8.x86_64\nlibaio-0.3.112-1.el8.x86_64\nlibnghttp2-1.33.0-3.el8_2.1.x86_64\nlibpcap-14:1.9.1-4.el8.x86_64\niptables-libs-1.8.4-16.el8.x86_64\nlibseccomp-2.4.3-1.el8.x86_64\nlibsigsegv-2.11-5.el8.x86_64\ngawk-4.2.1-2.el8.x86_64\nlibverto-0.3.0-5.el8.x86_64\nlibyaml-0.1.7-5.el8.x86_64\nmemstrack-0.1.11-1.el8.x86_64\nncurses-6.1-7.20180224.el8.x86_64\nnpth-1.5-4.el8.x86_64\nlibxkbcommon-0.9.1-1.el8.x86_64\nlibssh-config-0.9.4-2.el8.noarch\nlibreport-filesystem-2.9.5-15.el8.x86_64\ndnf-data-4.4.2-3.el8.noarch\nkbd-misc-2.0.4-10.el8.noarch\nkbd-legacy-2.0.4-10.el8.noarch\nfuse-common-3.2.1-12.el8.x86_64\nfuse-2.9.7-12.el8.x86_64\ndbus-common-1:1.12.8-12.el8.noarch\ncyrus-sasl-lib-2.1.27-5.el8.x86_64\nplatform-python-pip-9.0.3-19.el8.noarch\nplatform-python-setuptools-39.2.0-6.el8.noarch\npython3-libs-3.6.8-34.el8.x86_64\ngrub2-tools-minimal-1:2.02-93.el8.x86_64\nlibssh-0.9.4-2.el8.x86_64\nopenldap-2.4.46-16.el8.x86_64\nplatform-python-3.6.8-34.el8.x86_64\ngrubby-8.40-41.el8.x86_64\nlibkcapi-1.2.0-2.el8.x86_64\nlibkcapi-hmaccalc-1.2.0-2.el8.x86_64\nlibarchive-3.3.3-1.el8.x86_64\nlibdb-utils-5.3.28-40.el8.x86_64\ncurl-7.61.1-17.el8.x86_64\nlibcurl-7.61.1-17.el8.x86_64\nopenssl-1:1.1.1g-12.el8_3.x86_64\ncrypto-policies-scripts-20200713-1.git51d1222.el8.noarch\ncrypto-policies-20200713-1.git51d1222.el8.noarch\nelfutils-default-yama-scope-0.182-3.el8.noarch\ngzip-1.9-12.el8.x86_64\ncracklib-2.9.6-15.el8.x86_64\ncracklib-dicts-2.9.6-15.el8.x86_64\nprocps-ng-3.3.15-5.el8.x86_64\nkrb5-libs-1.18.2-8.el8.x86_64\nlibtirpc-1.1.4-4.el8.x86_64\nlibnsl2-1.2.0-2.20180605git4a062cf.el8.x86_64\nkpartx-0.8.4-7.el8.x86_64\ndevice-mapper-8:1.02.175-1.el8.x86_64\nelfutils-debuginfod-client-0.182-3.el8.x86_64\nelfutils-libs-0.182-3.el8.x86_64\nopenssl-pkcs11-0.4.10-2.el8.x86_64\nrpm-4.14.3-4.el8.x86_64\ngettext-libs-0.19.8.1-17.el8.x86_64\nlibcroco-0.6.12-4.el8_2.1.x86_64\nlibfdisk-2.32.1-26.el8.x86_64\nlibmount-2.32.1-26.el8.x86_64\ndbus-libs-1:1.12.8-12.el8.x86_64\ndbus-tools-1:1.12.8-12.el8.x86_64\ncoreutils-8.30-8.el8.x86_64\nsystemd-libs-239-43.el8.x86_64\nlibblkid-2.32.1-26.el8.x86_64\ndevice-mapper-libs-8:1.02.175-1.el8.x86_64\nshadow-utils-2:4.6-12.el8.x86_64\nca-certificates-2020.2.41-80.0.el8_2.noarch\nopenssl-libs-1:1.1.1g-12.el8_3.x86_64\nlibdb-5.3.28-40.el8.x86_64\nrpm-libs-4.14.3-4.el8.x86_64\nkmod-25-17.el8.x86_64\nkmod-libs-25-17.el8.x86_64\ncryptsetup-libs-2.3.3-2.el8.x86_64\ntrousers-lib-0.3.15-1.el8.x86_64\ndbus-daemon-1:1.12.8-12.el8.x86_64\nlibutempter-1.1.6-14.el8.x86_64\nkbd-2.0.4-10.el8.x86_64\nlibpwquality-1.4.4-1.el8.x86_64\npam-1.3.1-14.el8.x86_64\nutil-linux-2.32.1-26.el8.x86_64\nsystemd-pam-239-43.el8.x86_64\ndracut-049-133.git20210112.el8.x86_64\nos-prober-1.74-6.el8.x86_64\ngettext-0.19.8.1-17.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/gettext.info.gz\ngrub2-tools-1:2.02-93.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/grub2.info.gz\ninstall-info: No such file or directory for /usr/share/info/grub2-dev.info.gz\nglib2-2.56.4-9.el8.x86_64\nshared-mime-info-1.9-3.el8.x86_64\ngnutls-3.6.14-7.el8_3.x86_64\ndbus-1:1.12.8-12.el8.x86_64\nsystemd-239-43.el8.x86_64\nsystemd-udev-239-43.el8.x86_64\ntrousers-0.3.15-1.el8.x86_64\njson-glib-1.4.4-1.el8.x86_64\nlibmodulemd-2.9.4-2.el8.x86_64\nlibsolv-0.7.16-1.el8.x86_64\nlibrhsm-0.0.3-4.el8.x86_64\npolkit-libs-0.115-11.el8.x86_64\npolicycoreutils-2.9-9.el8.x86_64\nima-evm-utils-1.1-5.el8.x86_64\nlibevent-2.1.8-5.el8.x86_64\nunbound-libs-1.7.3-15.el8.x86_64\npython3-unbound-1.7.3-15.el8.x86_64\nrpm-plugin-selinux-4.14.3-4.el8.x86_64\nselinux-policy-3.14.3-60.el8.noarch\nselinux-policy-targeted-3.14.3-60.el8.noarch\nlibsecret-0.18.6-1.el8.x86_64\npinentry-1.1.0-2.el8.x86_64\ngrub2-tools-extra-1:2.02-93.el8.x86_64\nrpm-plugin-systemd-inhibit-4.14.3-4.el8.x86_64\nlibusbx-1.0.23-4.el8.x86_64\ngnupg2-smime-2.2.20-2.el8.x86_64\ngnupg2-2.2.20-2.el8.x86_64\ngpgme-1.13.1-7.el8.x86_64\nlibrepo-1.12.0-3.el8.x86_64\nostree-libs-2020.7-1.el8.x86_64\nlibdnf-0.55.0-1.el8.x86_64\npython3-libdnf-0.55.0-1.el8.x86_64\npython3-hawkey-0.55.0-1.el8.x86_64\nostree-2020.7-1.el8.x86_64\nrpm-ostree-libs-2020.7-1.el8.x86_64\npython3-gpg-1.13.1-7.el8.x86_64\nrpm-build-libs-4.14.3-4.el8.x86_64\npython3-rpm-4.14.3-4.el8.x86_64\npython3-libcomps-0.1.11-4.el8.x86_64\npython3-dnf-4.4.2-3.el8.noarch\npython3-setuptools-39.2.0-6.el8.noarch\npython3-pip-9.0.3-19.el8.noarch\npython36-3.6.8-2.module+el8.1.0+3334+5cb623d7.x86_64\npython3-six-1.11.0-8.el8.noarch\npython3-iniparse-0.4-31.el8.noarch\ndnf-4.4.2-3.el8.noarch\nrpm-ostree-2020.7-1.el8.x86_64\ngrub2-pc-1:2.02-93.el8.x86_64\nqemu-img-15:4.2.0-41.module+el8.4.0+9504+ab2393e6.x86_64\nxfsprogs-5.0.0-8.el8.x86_64\ne2fsprogs-1.45.6-1.el8.x86_64\ntar-2:1.30-5.el8.x86_64\ndosfstools-4.1-6.el8.x86_64\nimported gpg key\nimported gpg key\nimported gpg key\ncreating a fake machine id\ndeleting the fake machine id\n"
      },
      {
        "id": "cac48f998b87f9c9007037f48202bea9ef7966eacdaaf35f8e9da4b543cfa7fb",
        "type": "org.osbuild.selinux",
        "output": "/usr/lib/tmpfiles.d/abrt.conf:2: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/abrt.conf:9: Failed to resolve user 'abrt': No such process\n/usr/lib/tmpfiles.d/colord.conf:1: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:2: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/colord.conf:3: Failed to resolve user 'colord': No such process\n/usr/lib/tmpfiles.d/cups.conf:4: Failed to resolve user 'lp': No such process\n/usr/lib/tmpfiles.d/gluster.conf:2: Failed to resolve user 'gluster': No such process\n/usr/lib/tmpfiles.d/httpd.conf:1: Failed to resolve group 'apache'.\n/usr/lib/tmpfiles.d/httpd.conf:2: Failed to resolve user 'apache': No such process\n/usr/lib/tmpfiles.d/journal-nocow.conf:26: Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\n/usr/lib/tmpfiles.d/lockdev.conf:3: Failed to resolve group 'lock'.\n/usr/lib/tmpfiles.d/openvpn.conf:1: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/openvpn.conf:2: Failed to resolve group 'openvpn'.\n/usr/lib/tmpfiles.d/radvd.conf:1: Failed to resolve user 'radvd': No such process\n/usr/lib/tmpfiles.d/rpcbind.conf:2: Failed to resolve user 'rpc': No such process\nFailed to open file \"/sys/fs/selinux/checkreqprot\": Read-only file system\n"
      }
    ],
    "ostree-tree": [
      {
        "id": "52f9740ad68953831b503edbcdf2c54eb3eab87efa7dacedabe3ab83b2db708a",
        "type": "org.osbuild.rpm",
        "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\nPreparing packages...\nlibgcc-8.4.1-1.el8.x86_64\ngeolite2-country-20180605-1.el8.noarch\ngeolite2-city-20180605-1.el8.noarch\npython3-setuptools-wheel-39.2.0-6.el8.noarch\npython3-pip-wheel-9.0.3-19.el8.noarch\nfuse-common-3.2.1-12.el8.x86_64\nxkeyboard-config-2.28-1.el8.noarch\ntzdata-2020f-1.el8.noarch\nredhat-release-eula-8.4-0.5.el8.x86_64\nredhat-release-8.4-0.5.el8.x86_64\nsetup-2.12.2-6.el8.noarch\nfilesystem-3.8-3.el8.x86_64\nefi-filesystem-3-3.el8.noarch\nbasesystem-11-5.el8.noarch\npublicsuffix-list-dafsa-20180723-1.el8.noarch\npkgconf-m4-1.4.2-1.el8.noarch\nncurses-base-6.1-7.20180224.el8.noarch\npcre2-10.32-2.el8.x86_64\nlibselinux-2.9-5.el8.x86_64\nncurses-libs-6.1-7.20180224.el8.x86_64\nglibc-minimal-langpack-2.28-145.el8.x86_64\nglibc-common-2.28-145.el8.x86_64\nglibc-2.28-145.el8.x86_64\nbash-4.4.19-14.el8.x86_64\nlibsepol-2.9-2.el8.x86_64\nzlib-1.2.11-17.el8.x86_64\nxz-libs-5.2.4-3.el8.x86_64\nlibgpg-error-1.31-1.el8.x86_64\ninfo-6.5-6.el8.x86_64\nlibcap-2.26-4.el8.x86_64\nlibuuid-2.32.1-26.el8.x86_64\nlibcom_err-1.45.6-1.el8.x86_64\nbzip2-libs-1.0.6-26.el8.x86_64\nlibxcrypt-4.1.1-4.el8.x86_64\npopt-1.18-1.el8.x86_64\nreadline-7.0-10.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/history.info\ninstall-info: No such file or directory for /usr/share/info/rluserman.info\nelfutils-libelf-0.182-3.el8.x86_64\ngmp-1:6.1.2-10.el8.x86_64\nlibstdc++-8.4.1-1.el8.x86_64\nlibxml2-2.9.7-9.el8.x86_64\nexpat-2.2.5-4.el8.x86_64\nnspr-4.25.0-2.el8_2.x86_64\nnss-util-3.53.1-17.el8_3.x86_64\nchkconfig-1.13-2.el8.x86_64\nlibassuan-2.5.1-3.el8.x86_64\nlibgcrypt-1.8.5-4.el8.x86_64\ngrub2-common-1:2.02-93.el8.noarch\nlibattr-2.4.48-3.el8.x86_64\nlibacl-2.2.53-1.el8.x86_64\nsed-4.5-2.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/sed.info.gz\nlibcap-ng-0.7.9-5.el8.x86_64\naudit-libs-3.0-0.17.20191104git1c2f876.el8.x86_64\nlibmnl-1.0.4-6.el8.x86_64\nlibunistring-0.9.9-3.el8.x86_64\nlibidn2-2.2.0-1.el8.x86_64\nsqlite-libs-3.26.0-13.el8.x86_64\nlibffi-3.1-22.el8.x86_64\nlibseccomp-2.4.3-1.el8.x86_64\nlibzstd-1.4.4-1.el8.x86_64\np11-kit-0.23.22-1.el8.x86_64\njansson-2.11-3.el8.x86_64\nwhich-2.21-12.el8.x86_64\nlibsemanage-2.9-4.el8.x86_64\nnettle-3.4.1-2.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/nettle.info\nfindutils-1:4.6.0-20.el8.x86_64\nlibselinux-utils-2.9-5.el8.x86_64\nefivar-libs-37-4.el8.x86_64\nkeyutils-libs-1.5.10-6.el8.x86_64\nlibaio-0.3.112-1.el8.x86_64\nlibpcap-14:1.9.1-4.el8.x86_64\niptables-libs-1.8.4-16.el8.x86_64\nlua-libs-5.3.4-11.el8.x86_64\nlz4-libs-1.8.3-2.el8.x86_64\npcre-8.42-4.el8.x86_64\ngrep-3.1-6.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/grep.info.gz\nlibnftnl-1.1.5-4.el8.x86_64\nnftables-1:0.9.3-16.el8.x86_64\ngdisk-1.0.3-6.el8.x86_64\nmpfr-3.1.6-1.el8.x86_64\nbubblewrap-0.4.0-1.el8.x86_64\ndiffutils-3.6-6.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/diffutils.info\nlibgomp-8.4.1-1.el8.x86_64\nlibksba-1.3.5-7.el8.x86_64\nfile-libs-5.33-16.el8.x86_64\nfile-5.33-16.el8.x86_64\nfuse-libs-2.9.7-12.el8.x86_64\ngdbm-libs-1:1.18-1.el8.x86_64\njson-c-0.13.1-0.3.el8.x86_64\nlibedit-3.1-23.20170329cvs.el8.x86_64\nlibnfnetlink-1.0.1-13.el8.x86_64\nlibnl3-3.5.0-1.el8.x86_64\nlibsmartcols-2.32.1-26.el8.x86_64\nlibtasn1-4.13-3.el8.x86_64\np11-kit-trust-0.23.22-1.el8.x86_64\nlibnetfilter_conntrack-1.0.6-5.el8.x86_64\niptables-1.8.4-16.el8.x86_64\niptables-ebtables-1.8.4-16.el8.x86_64\ngdbm-1:1.18-1.el8.x86_64\nlibbytesize-1.4-3.el8.x86_64\nxz-5.2.4-3.el8.x86_64\ndevice-mapper-persistent-data-0.8.5-4.el8.x86_64\nfuse-2.9.7-12.el8.x86_64\nlibpsl-0.20.2-6.el8.x86_64\nipset-libs-7.1-1.el8.x86_64\nipset-7.1-1.el8.x86_64\nacl-2.2.53-1.el8.x86_64\ntar-2:1.30-5.el8.x86_64\nvim-minimal-2:8.0.1763-15.el8.x86_64\ngrub2-pc-modules-1:2.02-93.el8.noarch\nnss-softokn-freebl-3.53.1-17.el8_3.x86_64\nnss-softokn-3.53.1-17.el8_3.x86_64\nlibmetalink-0.1.3-7.el8.x86_64\nmozjs60-60.9.0-4.el8.x86_64\nprotobuf-3.5.0-13.el8.x86_64\ne2fsprogs-libs-1.45.6-1.el8.x86_64\nlibss-1.45.6-1.el8.x86_64\ncoreutils-common-8.30-8.el8.x86_64\nlibpng-2:1.6.34-5.el8.x86_64\nfreetype-2.9.1-4.el8_3.1.x86_64\npigz-2.4-4.el8.x86_64\nbrotli-1.0.6-3.el8.x86_64\ncheckpolicy-2.9-1.el8.x86_64\ncpio-2.12-9.el8.x86_64\ndosfstools-4.1-6.el8.x86_64\nfuse3-3.2.1-12.el8.x86_64\nfuse3-libs-3.2.1-12.el8.x86_64\nhardlink-1:1.3-6.el8.x86_64\nlibndp-1.7-3.el8.x86_64\nlibnghttp2-1.33.0-3.el8_2.1.x86_64\nlibpkgconf-1.4.2-1.el8.x86_64\npkgconf-1.4.2-1.el8.x86_64\npkgconf-pkg-config-1.4.2-1.el8.x86_64\nlibqb-1.0.3-12.el8.x86_64\nlibsigsegv-2.11-5.el8.x86_64\ngawk-4.2.1-2.el8.x86_64\nlibsmbios-2.4.1-2.el8.x86_64\nlibverto-0.3.0-5.el8.x86_64\nlibyaml-0.1.7-5.el8.x86_64\nmemstrack-0.1.11-1.el8.x86_64\nncurses-6.1-7.20180224.el8.x86_64\nnpth-1.5-4.el8.x86_64\ncontainernetworking-plugins-0.9.0-1.module+el8.4.0+9425+98db097b.x86_64\nlibmaxminddb-1.2.0-10.el8.x86_64\nipcalc-0.2.4-4.el8.x86_64\nlibnet-1.1.6-15.el8.x86_64\nlibxkbcommon-0.9.1-1.el8.x86_64\noniguruma-6.8.2-2.el8.x86_64\njq-1.5-12.el8.x86_64\nprotobuf-c-1.3.0-4.el8.x86_64\ncriu-3.15-1.module+el8.4.0+9425+98db097b.x86_64\nrunc-1.0.0-69.rc92.module+el8.4.0+9425+98db097b.x86_64\nlinux-firmware-20201118-101.git7455a360.el8.noarch\nlibssh-config-0.9.4-2.el8.noarch\nlibreport-filesystem-2.9.5-15.el8.x86_64\nkbd-misc-2.0.4-10.el8.noarch\nkbd-legacy-2.0.4-10.el8.noarch\nfirewalld-filesystem-0.8.2-3.el8.noarch\ndhcp-common-12:4.3.6-44.el8.noarch\ndbus-common-1:1.12.8-12.el8.noarch\ncyrus-sasl-lib-2.1.27-5.el8.x86_64\nplatform-python-pip-9.0.3-19.el8.noarch\nplatform-python-setuptools-39.2.0-6.el8.noarch\npython3-libs-3.6.8-34.el8.x86_64\ngrub2-tools-minimal-1:2.02-93.el8.x86_64\nlibssh-0.9.4-2.el8.x86_64\nopenldap-2.4.46-16.el8.x86_64\nplatform-python-3.6.8-34.el8.x86_64\ngrubby-8.40-41.el8.x86_64\nlibkcapi-1.2.0-2.el8.x86_64\nlibkcapi-hmaccalc-1.2.0-2.el8.x86_64\nlibarchive-3.3.3-1.el8.x86_64\nlibdb-utils-5.3.28-40.el8.x86_64\ncurl-7.61.1-17.el8.x86_64\nlibcurl-7.61.1-17.el8.x86_64\nopenssl-1:1.1.1g-12.el8_3.x86_64\ncrypto-policies-scripts-20200713-1.git51d1222.el8.noarch\ncrypto-policies-20200713-1.git51d1222.el8.noarch\nelfutils-default-yama-scope-0.182-3.el8.noarch\ngzip-1.9-12.el8.x86_64\ncracklib-2.9.6-15.el8.x86_64\ncracklib-dicts-2.9.6-15.el8.x86_64\nprocps-ng-3.3.15-5.el8.x86_64\nkrb5-libs-1.18.2-8.el8.x86_64\nlibtirpc-1.1.4-4.el8.x86_64\nlibnsl2-1.2.0-2.20180605git4a062cf.el8.x86_64\nkpartx-0.8.4-7.el8.x86_64\ndevice-mapper-8:1.02.175-1.el8.x86_64\nelfutils-debuginfod-client-0.182-3.el8.x86_64\nelfutils-libs-0.182-3.el8.x86_64\nopenssl-pkcs11-0.4.10-2.el8.x86_64\nrpm-4.14.3-4.el8.x86_64\ngettext-libs-0.19.8.1-17.el8.x86_64\nlibcroco-0.6.12-4.el8_2.1.x86_64\nlibfdisk-2.32.1-26.el8.x86_64\nlibmount-2.32.1-26.el8.x86_64\ndbus-libs-1:1.12.8-12.el8.x86_64\ndbus-tools-1:1.12.8-12.el8.x86_64\ncoreutils-8.30-8.el8.x86_64\nsystemd-libs-239-43.el8.x86_64\nlibblkid-2.32.1-26.el8.x86_64\ndevice-mapper-libs-8:1.02.175-1.el8.x86_64\nshadow-utils-2:4.6-12.el8.x86_64\nca-certificates-2020.2.41-80.0.el8_2.noarch\nopenssl-libs-1:1.1.1g-12.el8_3.x86_64\nkmod-libs-25-17.el8.x86_64\ncryptsetup-libs-2.3.3-2.el8.x86_64\nlibdb-5.3.28-40.el8.x86_64\nrpm-libs-4.14.3-4.el8.x86_64\nkmod-25-17.el8.x86_64\ntrousers-lib-0.3.15-1.el8.x86_64\ndbus-daemon-1:1.12.8-12.el8.x86_64\nlibutempter-1.1.6-14.el8.x86_64\nkbd-2.0.4-10.el8.x86_64\nlibpwquality-1.4.4-1.el8.x86_64\npam-1.3.1-14.el8.x86_64\nutil-linux-2.32.1-26.el8.x86_64\nsystemd-pam-239-43.el8.x86_64\ndracut-049-133.git20210112.el8.x86_64\nos-prober-1.74-6.el8.x86_64\ngettext-0.19.8.1-17.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/gettext.info.gz\ngrub2-tools-1:2.02-93.el8.x86_64\ninstall-info: No such file or directory for /usr/share/info/grub2.info.gz\ninstall-info: No such file or directory for /usr/share/info/grub2-dev.info.gz\nglib2-2.56.4-9.el8.x86_64\nshared-mime-info-1.9-3.el8.x86_64\ngnutls-3.6.14-7.el8_3.x86_64\ndbus-1:1.12.8-12.el8.x86_64\nsystemd-239-43.el8.x86_64\nsystemd-udev-239-43.el8.x86_64\ntrousers-0.3.15-1.el8.x86_64\nlibgudev-232-4.el8.x86_64\npolkit-libs-0.115-11.el8.x86_64\npolicycoreutils-2.9-9.el8.x86_64\nlibmbim-1.20.2-1.el8.x86_64\ngreenboot-0.11-1.el8.x86_64\npython3-libselinux-2.9-5.el8.x86_64\nlibqmi-1.24.0-1.el8.x86_64\nrpm-plugin-selinux-4.14.3-4.el8.x86_64\nselinux-policy-3.14.3-60.el8.noarch\nselinux-policy-targeted-3.14.3-60.el8.noarch\nModemManager-glib-1.10.8-2.el8.x86_64\njson-glib-1.4.4-1.el8.x86_64\nopenssh-8.0p1-5.el8.x86_64\ndevice-mapper-event-libs-8:1.02.175-1.el8.x86_64\nparted-3.2-38.el8.x86_64\nlibblockdev-utils-2.24-5.el8.x86_64\npython3-setools-4.3.0-2.el8.x86_64\npolkit-0.115-11.el8.x86_64\npolkit-pkla-compat-0.1-12.el8.x86_64\nkernel-core-4.18.0-275.el8.x86_64\niputils-20180629-6.el8.x86_64\ngrub2-tools-extra-1:2.02-93.el8.x86_64\nfuse-overlayfs-1.3.0-1.module+el8.4.0+9425+98db097b.x86_64\nlibsolv-0.7.16-1.el8.x86_64\niproute-5.9.0-1.el8.x86_64\nlibjose-10-2.el8.x86_64\nlibusbx-1.0.23-4.el8.x86_64\npython3-decorator-4.2.1-2.el8.noarch\nlibgusb-0.3.0-1.el8.x86_64\njose-10-2.el8.x86_64\nkernel-modules-4.18.0-275.el8.x86_64\ntimedatex-0.5-3.el8.x86_64\nlibblockdev-2.24-5.el8.x86_64\nlibblockdev-fs-2.24-5.el8.x86_64\nlibblockdev-loop-2.24-5.el8.x86_64\nlibblockdev-part-2.24-5.el8.x86_64\nlibblockdev-swap-2.24-5.el8.x86_64\ndevice-mapper-event-8:1.02.175-1.el8.x86_64\nlvm2-libs-8:2.03.11-1.el8.x86_64\nlibqmi-utils-1.24.0-1.el8.x86_64\npython3-libsemanage-2.9-4.el8.x86_64\npython3-slip-0.6.4-11.el8.noarch\ngreenboot-grub2-0.11-1.el8.x86_64\nlibmbim-utils-1.20.2-1.el8.x86_64\nModemManager-1.10.8-2.el8.x86_64\ninitscripts-10.00.12-1.el8.x86_64\nmdadm-4.1-15.el8.x86_64\nlibblockdev-mdraid-2.24-5.el8.x86_64\nwpa_supplicant-1:2.9-3.el8.x86_64\nNetworkManager-libnm-1:1.30.0-0.6.el8.x86_64\nNetworkManager-1:1.30.0-0.6.el8.x86_64\nlibxmlb-0.1.15-1.el8.x86_64\ndbus-glib-0.110-2.el8.x86_64\npython3-dbus-1.2.4-15.el8.x86_64\ngobject-introspection-1.56.1-1.el8.x86_64\npython3-gobject-base-3.28.3-2.el8.x86_64\nlibgcab1-1.1-1.el8.x86_64\nlibmodulemd-2.9.4-2.el8.x86_64\nlibsecret-0.18.6-1.el8.x86_64\npinentry-1.1.0-2.el8.x86_64\ngnupg2-smime-2.2.20-2.el8.x86_64\ngnupg2-2.2.20-2.el8.x86_64\ngpgme-1.13.1-7.el8.x86_64\nostree-libs-2020.7-1.el8.x86_64\nlibrepo-1.12.0-3.el8.x86_64\nrpm-ostree-libs-2020.7-1.el8.x86_64\nostree-2020.7-1.el8.x86_64\nrpm-ostree-2020.7-1.el8.x86_64\nlibuser-0.62-23.el8.x86_64\nconmon-2:2.0.22-3.module+el8.4.0+9425+98db097b.x86_64\nlibslirp-4.3.1-1.module+el8.4.0+9425+98db097b.x86_64\nslirp4netns-1.1.8-1.module+el8.4.0+9425+98db097b.x86_64\ncontainers-common-1:1.2.1-3.module+el8.4.0+9425+98db097b.x86_64\nlibudisks2-2.9.0-5.el8.x86_64\ncryptsetup-2.3.3-2.el8.x86_64\nlibluksmeta-9-4.el8.x86_64\nluksmeta-9-4.el8.x86_64\nbind-export-libs-32:9.11.26-1.el8.x86_64\nlibevent-2.1.8-5.el8.x86_64\nmokutil-1:0.3.0-11.el8.x86_64\ntpm2-tss-2.3.2-3.el8.x86_64\ntpm2-tools-4.1.1-2.el8.x86_64\nclevis-15-1.el8.x86_64\nclevis-luks-15-1.el8.x86_64\nnmap-ncat-2:7.70-5.el8.x86_64\nclevis-systemd-15-1.el8.x86_64\nxfsprogs-5.0.0-8.el8.x86_64\ne2fsprogs-1.45.6-1.el8.x86_64\ndhcp-libs-12:4.3.6-44.el8.x86_64\ndhcp-client-12:4.3.6-44.el8.x86_64\ndracut-network-049-133.git20210112.el8.x86_64\nlibatasmart-0.19-14.el8.x86_64\nnss-sysinit-3.53.1-17.el8_3.x86_64\nnss-3.53.1-17.el8_3.x86_64\nvolume_key-libs-0.3.11-5.el8.x86_64\nlibblockdev-crypto-2.24-5.el8.x86_64\nudisks2-2.9.0-5.el8.x86_64\nfwupd-1.5.5-1.el8.x86_64\npython3-audit-3.0-0.17.20191104git1c2f876.el8.x86_64\npython3-policycoreutils-2.9-9.el8.noarch\npolicycoreutils-python-utils-2.9-9.el8.noarch\ncontainer-selinux-2:2.155.0-1.module+el8.4.0+9425+98db097b.noarch\npodman-catatonit-3.0.0-0.21.module+el8.4.0+9425+98db097b.x86_64\npodman-3.0.0-0.21.module+el8.4.0+9425+98db097b.x86_64\nusbguard-selinux-0.7.8-7.el8.noarch\nusbguard-0.7.8-7.el8.x86_64\npython3-nftables-1:0.9.3-16.el8.x86_64\npython3-six-1.11.0-8.el8.noarch\npython3-slip-dbus-0.6.4-11.el8.noarch\npython3-firewall-0.8.2-3.el8.noarch\nfirewalld-0.8.2-3.el8.noarch\nshim-x64-15-16.el8.x86_64\nclevis-dracut-15-1.el8.x86_64\ntmux-2.7-1.el8.x86_64\nskopeo-1:1.2.1-3.module+el8.4.0+9425+98db097b.x86_64\npasswd-0.80-3.el8.x86_64\ngreenboot-rpm-ostree-grub2-0.11-1.el8.x86_64\nNetworkManager-wifi-1:1.30.0-0.6.el8.x86_64\nNetworkManager-wwan-1:1.30.0-0.6.el8.x86_64\naudit-3.0-0.17.20191104git1c2f876.el8.x86_64\nlvm2-8:2.03.11-1.el8.x86_64\nchrony-3.5-1.el8.x86_64\nRunning in chroot, ignoring request: daemon-reload\nkernel-4.18.0-275.el8.x86_64\ngrub2-efi-x64-1:2.02-93.el8.x86_64\ngrub2-pc-1:2.02-93.el8.x86_64\nsetools-console-4.3.0-2.el8.x86_64\nopenssh-clients-8.0p1-5.el8.x86_64\nopenssh-server-8.0p1-5.el8.x86_64\ngreenboot-status-0.11-1.el8.x86_64\ngreenboot-reboot-0.11-1.el8.x86_64\nmicrocode_ctl-4:20201112-1.el8.x86_64\ndnsmasq-2.79-14.el8.x86_64\ndracut-config-generic-049-133.git20210112.el8.x86_64\nsudo-1.8.29-6.el8.x86_64\nima-evm-utils-1.1-5.el8.x86_64\nbash-completion-1:2.7-5.el8.noarch\nkeyutils-1.5.10-6.el8.x86_64\nefibootmgr-16-1.el8.x86_64\nrsync-3.1.3-12.el8.x86_64\nattr-2.4.48-3.el8.x86_64\nhostname-3.20-6.el8.x86_64\nless-530-1.el8.x86_64\ntraceroute-3:2.1.0-6.el8.x86_64\nnss-altfiles-2.18.1-12.el8.x86_64\nrootfiles-8.1-22.el8.noarch\niwl7260-firmware-1:25.30.13.0-101.el8.1.noarch\niwl6050-firmware-41.28.5.1-101.el8.1.noarch\niwl6000-firmware-9.221.4.1-101.el8.1.noarch\niwl5150-firmware-8.24.2.2-101.el8.1.noarch\niwl5000-firmware-8.83.5.1_1-101.el8.1.noarch\niwl3160-firmware-1:25.30.13.0-101.el8.1.noarch\niwl2030-firmware-18.168.6.1-101.el8.1.noarch\niwl2000-firmware-18.168.6.1-101.el8.1.noarch\niwl135-firmware-18.168.6.1-101.el8.1.noarch\niwl105-firmware-18.168.6.1-101.el8.1.noarch\niwl1000-firmware-1:39.31.5.1-101.el8.1.noarch\niwl100-firmware-39.31.5.1-101.el8.1.noarch\ndracut: No '/dev/log' or 'logger' included for syslog logging\nimported gpg key\nimported gpg key\nimported gpg key\ncreating a fake machine id\ndeleting the fake machine id\n"
      },
      {
        "id": "fb5e7b93a3eba924a02a89043554641b022abcdaf07eb933da24813277a93636",
        "type": "org.osbuild.locale",
        "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n/run/osbuild/tree/etc/locale.conf written.\n"
      },
      {
        "id": "52bb78797b3fc3c05d4d538f1b1362648f232b149cf7bf73edda582754167a7f",
        "type": "org.osbuild.timezone",
        "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n/run/osbuild/tree/etc/localtime written\n/etc/localtime already exists. Replacing.\n"
      },
      {
        "id": "b63e0b7baa7b0acd794ee3d2f92728f6ef45bde203fbffba3364b17499aab63f",
        "type": "org.osbuild.systemd",
        "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\nCreated symlink /run/osbuild/tree/etc/systemd/system/ostree-finalize-staged.service.requires/greenboot-grub2-set-counter.service → /usr/lib/systemd/system/greenboot-grub2-set-counter.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/multi-user.target.requires/greenboot-grub2-set-success.service → /usr/lib/systemd/system/greenboot-grub2-set-success.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/multi-user.target.wants/greenboot-healthcheck.service → /usr/lib/systemd/system/greenboot-healthcheck.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/boot-complete.target.requires/greenboot-healthcheck.service → /usr/lib/systemd/system/greenboot-healthcheck.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/greenboot-healthcheck.service.requires/greenboot-rpm-ostree-grub2-check-fallback.service → /usr/lib/systemd/system/greenboot-rpm-ostree-grub2-check-fallback.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/multi-user.target.wants/greenboot-status.service → /usr/lib/systemd/system/greenboot-status.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/multi-user.target.wants/greenboot-task-runner.service → /usr/lib/systemd/system/greenboot-task-runner.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/redboot.target.wants/redboot-auto-reboot.service → /usr/lib/systemd/system/redboot-auto-reboot.service.\nCreated symlink /run/osbuild/tree/etc/systemd/system/redboot.target.requires/redboot-task-runner.service → /usr/lib/systemd/system/redboot-task-runner.service.\n"
      },
      {
        "id": "147fe506d915edb9e0eb8fdb88adb43c8603125f455f47d0228bca935bb997f6",
        "type": "org.osbuild.selinux",
        "output": "[/usr/lib/tmpfiles.d/journal-nocow.conf:26] Failed to resolve specifier: uninitialized /etc detected, skipping\nAll rules containing unresolvable specifiers will be skipped.\nFailed to create file /sys/fs/selinux/checkreqprot: Read-only file system\n/run/osbuild/tree/etc/selinux/targeted/contexts/files/file_context: No such file or directory\nTraceback (most recent call last):\n  File \"/run/osbuild/bin/org.osbuild.selinux\", line 62, in <module>\n    r = main(args[\"tree\"], args[\"options\"])\n  File \"/run/osbuild/bin/org.osbuild.selinux\", line 53, in main\n    subprocess.run([\"setfiles\", \"-F\", \"-r\", f\"{tree}\", f\"{file_contexts}\", f\"{tree}\"], check=True)\n  File \"/usr/lib64/python3.6/subprocess.py\", line 438, in run\n    output=stdout, stderr=stderr)\nsubprocess.CalledProcessError: Command '['setfiles', '-F', '-r', '/run/osbuild/tree', '/run/osbuild/tree/etc/selinux/targeted/contexts/files/file_context', '/run/osbuild/tree']' returned non-zero exit status 255.\n",
        "success": false
      }
    ]
  }
}
`
