#!/bin/bash

# Created by argbash-init v2.6.1
# ARG_POSITIONAL_SINGLE([starting-directory])
# ARG_DEFAULTS_POS()
# ARG_HELP([<The general help message of my script>])
# ARGBASH_GO()
# needed because of Argbash --> m4_ignore([
### START OF CODE GENERATED BY Argbash v2.6.1 one line above ###
# Argbash is a bash code generator used to get arguments parsing right.
# Argbash is FREE SOFTWARE, see https://argbash.io for more info

die()
{
	local _ret=$2
	test -n "$_ret" || _ret=1
	test "$_PRINT_HELP" = yes && print_help >&2
	echo "$1" >&2
	exit ${_ret}
}

begins_with_short_option()
{
	local first_option all_short_options
	all_short_options='h'
	first_option="${1:0:1}"
	test "$all_short_options" = "${all_short_options/$first_option/}" && return 1 || return 0
}



# THE DEFAULTS INITIALIZATION - POSITIONALS
_positionals=()
_arg_starting_directory=
# THE DEFAULTS INITIALIZATION - OPTIONALS

print_help ()
{
	printf '%s\n' "<The general help message of my script>"
	printf 'Usage: %s [-h|--help] <starting-directory>\n' "$0"
	printf '\t%s\n' "-h,--help: Prints help"
}

parse_commandline ()
{
	while test $# -gt 0
	do
		_key="$1"
		case "$_key" in
			-h|--help)
				print_help
				exit 0
				;;
			-h*)
				print_help
				exit 0
				;;
			*)
				_positionals+=("$1")
				;;
		esac
		shift
	done
}


handle_passed_args_count ()
{
	_required_args_string="'starting-directory'"
	test ${#_positionals[@]} -ge 1 || _PRINT_HELP=yes die "FATAL ERROR: Not enough positional arguments - we require exactly 1 (namely: $_required_args_string), but got only ${#_positionals[@]}." 1
	test ${#_positionals[@]} -le 1 || _PRINT_HELP=yes die "FATAL ERROR: There were spurious positional arguments --- we expect exactly 1 (namely: $_required_args_string), but got ${#_positionals[@]} (the last one was: '${_positionals[*]: -1}')." 1
}

assign_positional_args ()
{
	_positional_names=('_arg_starting_directory' )

	for (( ii = 0; ii < ${#_positionals[@]}; ii++))
	do
		eval "${_positional_names[ii]}=\${_positionals[ii]}" || die "Error during argument parsing, possibly an Argbash bug." 1
	done
}

parse_commandline "$@"
handle_passed_args_count
assign_positional_args

# OTHER STUFF GENERATED BY Argbash

### END OF CODE GENERATED BY Argbash (sortof) ### ])
# [ <-- needed because of Argbash


generate_gcov_here() {
	local libs
	test -d .libs && libs=.libs
	gcno_files="$(find . $libs -maxdepth 1 -name '*.gcno')"
	test -n "$gcno_files" && "$GCOV" $gcno_files
	test -n "$libs" && mv $libs/*.gcov "$_arg_starting_directory"
}

recursively_generate_gcov() {
	cd "$1"
	generate_gcov_here
	for dir in $(find . -maxdepth 1 -type d -name '[^.]*'); do
		(recursively_generate_gcov "$dir")
	done
	return 0
}

find "$_arg_starting_directory" -name '*.gcno'
recursively_generate_gcov "$_arg_starting_directory"

# ] <-- needed because of Argbash
