/*
 * Copyright (c) 2011 Surfnet 
 * Copyright (c) 2011 .SE (The Internet Infrastructure Foundation).
 * Copyright (c) 2011 OpenDNSSEC AB (svb)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef _ENFORCER_ENFORCE_TASK_H_
#define _ENFORCER_ENFORCE_TASK_H_

#include "daemon/cfg.h"
#include "daemon/engine.h"
#include "scheduler/task.h"
#include "db/policy.h"

extern task_type *enforce_task(engine_type *engine, char const *owner);

extern time_t enforce_task_perform(task_type* task, char const *owner, void *context,
    void *dbconn);

/* Schedule enforce tasks for *now* for zone. */
extern void enforce_task_flush_zone(engine_type *engine, char const *zonename);

/* Schedule enforce tasks for *now* for ALL zones of policy. */
extern void enforce_task_flush_policy(engine_type *engine, db_connection_t *dbconn, policy_t const *policy);

/* Schedule enforce tasks for *now* for ALL zones. */
extern void enforce_task_flush_all(engine_type *engine, db_connection_t *dbconn);

#endif
