#include "pkcs11types.h"

#define MAX_KEY_SIZE  150 
#define MAX_DATA_SIZE 512
#define MAX_HASH_SIZE 64

CK_ULONG four = 4;
CK_ULONG ten = 10;
CK_ULONG sixteen = 16;
CK_ULONG twentyfour = 24;
CK_ULONG thirtytwo = 32;

struct DIGEST_TEST_VECTOR {
        CK_BYTE data[512];
        CK_ULONG data_len;
        CK_BYTE hash[512];
        CK_ULONG hash_len;
};


/** The hash function RIPEMD-160
    http://homes.esat.kuleuven.be/~bosselae/ripemd160.html
**/
struct DIGEST_TEST_VECTOR ripemd128_digest_test_vector[] = {
	{
		.data = "",
		.data_len = 0,
		.hash =		{ 0xcd,0xf2,0x62,0x13,0xa1,0x50,0xdc,0x3e,0xcb,
				  0x61,0x0f,0x18,0xf6,0xb3,0x8b,0x46 },
		.hash_len = 16,
	}
};

/** The hash function RIPEMD-160
    http://homes.esat.kuleuven.be/~bosselae/ripemd160.html
**/
struct DIGEST_TEST_VECTOR ripemd160_digest_test_vector[] = {
	{
		.data = "",
		.data_len = 0,
		.hash =		{ 0x9c,0x11,0x85,0xa5,0xc5,0xe9,0xfc,0x54,0x61,
				  0x28,0x08,0x97,0x7e,0xe8,0xf5,0x48,0xb2,0x25,
				  0x8d,0x31 },
		.hash_len = 20,
        }
};

/** The MD2 Message-Digest Algorithm
    http://tools.ietf.org/html/rfc1319
    A.5 Test suite
**/
struct DIGEST_TEST_VECTOR md2_digest_test_vector[] = {
	{
		.data = "",
		.data_len = 0,
		.hash =		{ 0x83,0x50,0xe5,0xa3,0xe2,0x4c,0x15,0x3d,0xf2,
				  0x27,0x5c,0x9f,0x80,0x69,0x27,0x73 },
		.hash_len = 16,
	}, {
		.data = "a",
		.data_len = 1,
		.hash =		{ 0x32,0xec,0x01,0xec,0x4a,0x6d,0xac,0x72,0xc0,
				  0xab,0x96,0xfb,0x34,0xc0,0xb5,0xd1 },
		.hash_len = 16,
	}, {
		.data = "abc",
		.data_len = 3,
		.hash =		{ 0xda,0x85,0x3b,0x0d,0x3f,0x88,0xd9,0x9b,0x30,
				  0x28,0x3a,0x69,0xe6,0xde,0xd6,0xbb },
		.hash_len = 16,
	}, {
		.data = "message digest",
		.data_len = 14,
		.hash =		{ 0xab,0x4f,0x49,0x6b,0xfb,0x2a,0x53,0x0b,0x21,
				  0x9f,0xf3,0x30,0x31,0xfe,0x06,0xb0 },
		.hash_len = 20,
	}, {
		.data = "abcdefghijklmnopqrstuvwxyz",
		.data_len = 26,
		.hash =		{ 0x4e,0x8d,0xdf,0xf3,0x65,0x02,0x92,0xab,0x5a,
				  0x41,0x08,0xc3,0xaa,0x47,0x94,0x0b },
		.hash_len = 20,
	}, {
		.data = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",
		.data_len = 62,
		.hash =		{ 0xda,0x33,0xde,0xf2,0xa4,0x2d,0xf1,0x39,0x75,
				  0x35,0x28,0x46,0xc3,0x03,0x38,0xcd },
		.hash_len = 20,
	}, {
		.data = "12345678901234567890123456789012345678901234567890123456789012345678901234567890",
		.data_len = 80,
		.hash =		{ 0xd5,0x97,0x6f,0x79,0xd8,0x3d,0x3a,0x0d,0xc9,
				  0x80,0x6c,0x3c,0x66,0xf3,0xef,0xd8 },
		.hash_len = 20,
	}
};

/** The MD5 Message-Digest Algorithm
    http://tools.ietf.org/html/rfc1321
    A.5 Test suite
**/
struct DIGEST_TEST_VECTOR md5_digest_test_vector[] = {
        {
		.data = "",
		.data_len = 0,
		.hash =		{ 0xd4,0x1d,0x8c,0xd9,0x8f,0x00,0xb2,0x04,0xe9,
				  0x80,0x09,0x98,0xec,0xf8,0x42,0x7e },
		.hash_len = 16,
	}, {
		.data = "a",
		.data_len = 1,
		.hash =		{ 0x0c,0xc1,0x75,0xb9,0xc0,0xf1,0xb6,0xa8,0x31,
				  0xc3,0x99,0xe2,0x69,0x77,0x26,0x61 },
		.hash_len = 16,
	}, {
		.data = "abc",
		.data_len = 3,
		.hash =		{ 0x90,0x01,0x50,0x98,0x3c,0xd2,0x4f,0xb0,0xd6,
				  0x96,0x3f,0x7d,0x28,0xe1,0x7f,0x72},
		.hash_len = 16,
	}
};

/** SHA test Vectors for Hashing Byte-Oriented Messages
    http://csrc.nist.gov/groups/STM/cavp/documents/shs/shabytetestvectors.zip
    SHA1ShortMsg.rsp

    FIPS PUB 180-1
    http://www.itl.nist.gov/fipspubs/fip180-1.htm
**/
struct DIGEST_TEST_VECTOR sha1_digest_test_vector[] = {
	{
		.data = "",
		.data_len = 0,
		.hash =		{ 0xda,0x39,0xa3,0xee,0x5e,0x6b,0x4b,0x0d,0x32,
				  0x55,0xbf,0xef,0x95,0x60,0x18,0x90,0xaf,0xd8,
				  0x07,0x09 },
		.hash_len = 20,
	}, {
		.data = "abc",
		.data_len = 3,
		.hash =		{0xA9,0x99,0x3E,0x36,0x47,0x06,0x81,0x6A,0xBA,
				 0x3E,0x25,0x71,0x78,0x50,0xC2,0x6C,0x9C,0xD0,
				 0xD8,0x9D },
		.hash_len = 20,
        }, {
		.data = "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq",
		.data_len = 56,
		.hash =		{ 0x84,0x98,0x3E,0x44,0x1C,0x3B,0xD2,0x6E,0xBA,
				  0xAE,0x4A,0xA1,0xF9,0x51,0x29,0xE5,0xE5,0x46,
				  0x70,0xF1 },
		.hash_len = 20,
	}
};

/** SHA test Vectors for Hashing Byte-Oriented Messages
    http://csrc.nist.gov/groups/STM/cavp/documents/shs/shabytetestvectors.zip
    SHA256ShortMsg.rsp & SHA256LongMsg.rsp

    http://csrc.nist.gov/groups/ST/toolkit/examples.html
**/
struct DIGEST_TEST_VECTOR sha256_digest_test_vector[] = {
	{
		.data =		{ 0x00 },
		.data_len = 0,
		.hash =		{ 0xe3,0xb0,0xc4,0x42,0x98,0xfc,0x1c,0x14,0x9a,
				  0xfb,0xf4,0xc8,0x99,0x6f,0xb9,0x24,0x27,0xae,
				  0x41,0xe4,0x64,0x9b,0x93,0x4c,0xa4,0x95,0x99,
				  0x1b,0x78,0x52,0xb8,0x55 },
		.hash_len = 32,
	}, {
		.data = "abc",
		.data_len = 3,
		.hash =		{ 0xba,0x78,0x16,0xbf,0x8f,0x01,0xcf,0xea,0x41,
				  0x41,0x40,0xde,0x5d,0xae,0x22,0x23,0xb0,0x03,
				  0x61,0xa3,0x96,0x17,0x7a,0x9c,0xb4,0x10,0xff,
				  0x61,0xf2,0x00,0x15,0xad },
		.hash_len = 32,
	}, {
		.data = "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq",
		.data_len = 56,
		.hash =		{ 0x24,0x8d,0x6a,0x61,0xd2,0x06,0x38,0xb8,0xe5,
				  0xc0,0x26,0x93,0x0c,0x3e,0x60,0x39,0xa3,0x3c,
				  0xe4,0x59,0x64,0xff,0x21,0x67,0xf6,0xec,0xed,
				  0xd4,0x19,0xdb,0x06,0xc1 },
		.hash_len = 32,
	}, {
		.data = 	{ 0x09,0xfc,0x1a,0xcc,0xc2,0x30,0xa2,0x05,0xe4,
				  0xa2,0x08,0xe6,0x4a,0x8f,0x20,0x42,0x91,0xf5,
				  0x81,0xa1,0x27,0x56,0x39,0x2d,0xa4,0xb8,0xc0,
				  0xcf,0x5e,0xf0,0x2b,0x95 },
		.data_len = 32,
		.hash = 	{ 0x4f,0x44,0xc1,0xc7,0xfb,0xeb,0xb6,0xf9,0x60,
				  0x18,0x29,0xf3,0x89,0x7b,0xfd,0x65,0x0c,0x56,
				  0xfa,0x07,0x84,0x4b,0xe7,0x64,0x89,0x07,0x63,
				  0x56,0xac,0x18,0x86,0xa4 },
		.hash_len = 32,
	}, {
		.data = 	{ 0x5a,0x86,0xb7,0x37,0xea,0xea,0x8e,0xe9,0x76,
				  0xa0,0xa2,0x4d,0xa6,0x3e,0x7e,0xd7,0xee,0xfa,
				  0xd1,0x8a,0x10,0x1c,0x12,0x11,0xe2,0xb3,0x65,
				  0x0c,0x51,0x87,0xc2,0xa8,0xa6,0x50,0x54,0x72,
				  0x08,0x25,0x1f,0x6d,0x42,0x37,0xe6,0x61,0xc7,
				  0xbf,0x4c,0x77,0xf3,0x35,0x39,0x03,0x94,0xc3,
				  0x7f,0xa1,0xa9,0xf9,0xbe,0x83,0x6a,0xc2,0x85,
				  0x09 },
		.data_len = 64,
		.hash = 	{ 0x42,0xe6,0x1e,0x17,0x4f,0xbb,0x38,0x97,0xd6,
				  0xdd,0x6c,0xef,0x3d,0xd2,0x80,0x2f,0xe6,0x7b,
				  0x33,0x19,0x53,0xb0,0x61,0x14,0xa6,0x5c,0x77,
				  0x28,0x59,0xdf,0xc1,0xaa },
		.hash_len = 32,
	}, {
		.data = 	{ 0x45,0x11,0x01,0x25,0x0e,0xc6,0xf2,0x66,0x52,
				  0x24,0x9d,0x59,0xdc,0x97,0x4b,0x73,0x61,0xd5,
				  0x71,0xa8,0x10,0x1c,0xdf,0xd3,0x6a,0xba,0x3b,
				  0x58,0x54,0xd3,0xae,0x08,0x6b,0x5f,0xdd,0x45,
				  0x97,0x72,0x1b,0x66,0xe3,0xc0,0xdc,0x5d,0x8c,
				  0x60,0x6d,0x96,0x57,0xd0,0xe3,0x23,0x28,0x3a,
				  0x52,0x17,0xd1,0xf5,0x3f,0x2f,0x28,0x4f,0x57,
				  0xb8,0x5c,0x8a,0x61,0xac,0x89,0x24,0x71,0x1f,
				  0x89,0x5c,0x5e,0xd9,0x0e,0xf1,0x77,0x45,0xed,
				  0x2d,0x72,0x8a,0xbd,0x22,0xa5,0xf7,0xa1,0x34,
				  0x79,0xa4,0x62,0xd7,0x1b,0x56,0xc1,0x9a,0x74,
				  0xa4,0x0b,0x65,0x5c,0x58,0xed,0xfe,0x0a,0x18,
				  0x8a,0xd2,0xcf,0x46,0xcb,0xf3,0x05,0x24,0xf6,
				  0x5d,0x42,0x3c,0x83,0x7d,0xd1,0xff,0x2b,0xf4,
				  0x62,0xac,0x41,0x98,0x00,0x73,0x45,0xbb,0x44,
				  0xdb,0xb7,0xb1,0xc8,0x61,0x29,0x8c,0xdf,0x61,
				  0x98,0x2a,0x83,0x3a,0xfc,0x72,0x8f,0xae,0x1e,
				  0xda,0x2f,0x87,0xaa,0x2c,0x94,0x80,0x85,0x8b,
				  0xec },
		.data_len = 163,
		.hash = 	{ 0x3c,0x59,0x3a,0xa5,0x39,0xfd,0xcd,0xae,0x51,
				  0x6c,0xdf,0x2f,0x15,0x00,0x0f,0x66,0x34,0x18,
				  0x5c,0x88,0xf5,0x05,0xb3,0x97,0x75,0xfb,0x9a,
				  0xb1,0x37,0xa1,0x0a,0xa2 },
		.hash_len = 32,
	}

};

/** SHA test Vectors for Hashing Byte-Oriented Messages
    http://csrc.nist.gov/groups/STM/cavp/documents/shs/shabytetestvectors.zip
    SHA384ShortMsg.rsp & SHA384LongMsg.rsp

    http://csrc.nist.gov/groups/ST/toolkit/examples.html
**/
struct DIGEST_TEST_VECTOR sha384_digest_test_vector[] = {
        {
		.data =		{ 0x00},
		.data_len = 0,
		.hash =		{ 0x38,0xb0,0x60,0xa7,0x51,0xac,0x96,0x38,0x4c,
				  0xd9,0x32,0x7e,0xb1,0xb1,0xe3,0x6a,0x21,0xfd,
				  0xb7,0x11,0x14,0xbe,0x07,0x43,0x4c,0x0c,0xc7,
				  0xbf,0x63,0xf6,0xe1,0xda,0x27,0x4e,0xde,0xbf,
				  0xe7,0x6f,0x65,0xfb,0xd5,0x1a,0xd2,0xf1,0x48,
				  0x98,0xb9,0x5b },
		.hash_len = 48,
	},{
		.data = "abc",
		.data_len = 3,
		.hash =		{ 0xcb,0x00,0x75,0x3f,0x45,0xa3,0x5e,0x8b,0xb5,
				  0xa0,0x3d,0x69,0x9a,0xc6,0x50,0x07,0x27,0x2c,
				  0x32,0xab,0x0e,0xde,0xd1,0x63,0x1a,0x8b,0x60,
				  0x5a,0x43,0xff,0x5b,0xed,0x80,0x86,0x07,0x2b,
				  0xa1,0xe7,0xcc,0x23,0x58,0xba,0xec,0xa1,0x34,
				  0xc8,0x25,0xa7 },
		.hash_len = 48,
	},{
		.data = "abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu",
		.data_len = 112,
		.hash =		{ 0x09,0x33,0x0c,0x33,0xf7,0x11,0x47,0xe8,0x3d,
				  0x19,0x2f,0xc7,0x82,0xcd,0x1b,0x47,0x53,0x11,
				  0x1b,0x17,0x3b,0x3b,0x05,0xd2,0x2f,0xa0,0x80,
				  0x86,0xe3,0xb0,0xf7,0x12,0xfc,0xc7,0xc7,0x1a,
				  0x55,0x7e,0x2d,0xb9,0x66,0xc3,0xe9,0xfa,0x91,
				  0x74,0x60,0x39 },
		.hash_len = 48,
	}, {
		.data = 	{ 0xbe,0x01,0xe5,0x20,0xe6,0x9f,0x04,0x17,0x4c,
				  0xcf,0x95,0x45,0x5b,0x1c,0x81,0x44,0x52,0x98,
				  0x26,0x4d,0x9a,0xdc,0x49,0x58,0x57,0x4a,0x52,
				  0x84,0x3d,0x95,0xb8,0xba },
		.data_len = 32,
		.hash =		{ 0xc5,0xcf,0x54,0xb8,0xe3,0x10,0x5b,0x1c,0x7b,
				  0xf7,0xa4,0x37,0x54,0xd9,0x15,0xb0,0x94,0x7f,
				  0x28,0xb6,0xdc,0x94,0xa0,0x19,0x18,0x29,0x29,
				  0xb5,0xc8,0x48,0xe1,0x14,0x41,0xc9,0xe4,0xe9,
				  0x0c,0x74,0x49,0xf4,0xc3,0xcd,0x12,0x95,0x4f,
				  0x0f,0x5d,0x99 },
		.hash_len = 48,
	}, {
		.data = 	{ 0x93,0x03,0x5d,0x3a,0x13,0xae,0x1b,0x06,0xdd,
				  0x03,0x3e,0x76,0x4a,0xca,0x01,0x24,0x96,0x1d,
				  0xa7,0x9c,0x36,0x6c,0x6c,0x75,0x6b,0xc4,0xbc,
				  0xc1,0x18,0x50,0xa3,0xa8,0xd1,0x20,0x85,0x4f,
				  0x34,0x29,0x0f,0xff,0x7c,0x8d,0x6d,0x83,0x53,
				  0x1d,0xbd,0xd1,0xe8,0x1c,0xc4,0xed,0x42,0x46,
				  0xe0,0x0b,0xd4,0x11,0x3e,0xf4,0x51,0x33,0x4d,
				  0xaa }, 
		.data_len = 64,
		.hash = 	{ 0x8d,0x46,0xcc,0x84,0xb6,0xc2,0xde,0xb2,0x06,
				  0xaa,0x5c,0x86,0x17,0x98,0x79,0x87,0x51,0xa2,
				  0x6e,0xe7,0x4b,0x1d,0xaf,0x3a,0x55,0x7c,0x41,
				  0xae,0xbd,0x65,0xad,0xc0,0x27,0x55,0x9f,0x7c,
				  0xd9,0x2b,0x25,0x5b,0x37,0x4c,0x83,0xbd,0x55,
				  0x56,0x8b,0x45 },
		.hash_len = 48,
	}, {
		.data = 	{ 0x3b,0xf5,0x2c,0xc5,0xee,0x86,0xb9,0xa0,0x19,
				  0x0f,0x39,0x0a,0x5c,0x03,0x66,0xa5,0x60,0xb5,
				  0x57,0x00,0x0d,0xbe,0x51,0x15,0xfd,0x9e,0xe1,
				  0x16,0x30,0xa6,0x27,0x69,0x01,0x15,0x75,0xf1,
				  0x58,0x81,0x19,0x8f,0x22,0x78,0x76,0xe8,0xfe,
				  0x68,0x5a,0x69,0x39,0xbc,0x8b,0x89,0xfd,0x48,
				  0xa3,0x4e,0xc5,0xe7,0x1e,0x13,0x14,0x62,0xb2,
				  0x88,0x67,0x94,0xdf,0xfa,0x68,0xcc,0xc6,0xd5,
				  0x64,0x73,0x3e,0x67,0xff,0xef,0x25,0xe6,0x27,
				  0xc6,0xf4,0xb5,0x46,0x07,0x96,0xe3,0xbc,0xe6,
				  0x7b,0xf5,0x8c,0xa6,0xe8,0xe5,0x55,0xbc,0x91,
				  0x6a,0x85,0x31,0x69,0x7a,0xc9,0x48,0xb9,0x0d,
				  0xc8,0x61,0x6f,0x25,0x10,0x1d,0xb9,0x0b,0x50,
				  0xc3,0xd3,0xdb,0xc9,0xe2,0x1e,0x42,0xff,0x38,
				  0x71,0x87 },
		.data_len = 128,
		.hash = 	{ 0x12,0xb6,0xcb,0x35,0xed,0xa9,0x2e,0xe3,0x73,
				  0x56,0xdd,0xee,0x77,0x78,0x1a,0x17,0xb3,0xd9,
				  0x0e,0x56,0x38,0x24,0xa9,0x84,0xfa,0xff,0xc6,
				  0xfd,0xd1,0x69,0x3b,0xd7,0x62,0x60,0x39,0x63,
				  0x55,0x63,0xcf,0xc3,0xb9,0xa2,0xb0,0x0f,0x9c,
				  0x65,0xee,0xfd },
		.hash_len = 48,
	}, {
		.data = 	{ 0x62,0xc6,0xa1,0x69,0xb9,0xbe,0x02,0xb3,0xd7,
				  0xb4,0x71,0xa9,0x64,0xfc,0x0b,0xcc,0x72,0xb4,
				  0x80,0xd2,0x6a,0xec,0xb2,0xed,0x46,0x0b,0x7f,
				  0x50,0x01,0x6d,0xda,0xf0,0x4c,0x51,0x21,0x87,
				  0x83,0xf3,0xaa,0xdf,0xdf,0xf5,0xa0,0x4d,0xed,
				  0x03,0x0d,0x7b,0x3f,0xb7,0x37,0x6b,0x61,0xba,
				  0x30,0xb9,0x0e,0x2d,0xa9,0x21,0xa4,0x47,0x07,
				  0x40,0xd6,0x3f,0xb9,0x9f,0xa1,0x6c,0xc8,0xed,
				  0x81,0xab,0xaf,0x8c,0xe4,0x01,0x6e,0x50,0xdf,
				  0x81,0xda,0x83,0x20,0x70,0x37,0x2c,0x24,0xa8,
				  0x08,0x90,0xaa,0x3a,0x26,0xfa,0x67,0x57,0x10,
				  0xb8,0xfb,0x71,0x82,0x66,0x24,0x9d,0x49,0x6f,
				  0x31,0x3c,0x55,0xd0,0xba,0xda,0x10,0x1f,0x8f,
				  0x56,0xee,0xcc,0xee,0x43,0x45,0xa8,0xf9,0x8f,
				  0x60,0xa3,0x66,0x62,0xcf,0xda,0x79,0x49,0x00,
				  0xd1,0x2f,0x94,0x14,0xfc,0xbd,0xfd,0xeb,0x85,
				  0x38,0x8a,0x81,0x49,0x96,0xb4,0x7e,0x24,0xd5,
				  0xc8,0x08,0x6e,0x7a,0x8e,0xdc,0xc5,0x3d,0x29,
				  0x9d,0x0d,0x03,0x3e,0x6b,0xb6,0x0c,0x58,0xb8,
				  0x3d,0x6e,0x8b,0x57,0xf6,0xc2,0x58,0xd6,0x08,
				  0x1d,0xd1,0x0e,0xb9,0x42,0xfd,0xf8,0xec,0x15,
				  0x7e,0xc3,0xe7,0x53,0x71,0x23,0x5a,0x81,0x96,
				  0xeb,0x9d,0x22,0xb1,0xde,0x3a,0x2d,0x30,0xc2,
				  0xab,0xbe,0x0d,0xb7,0x65,0x0c,0xf6,0xc7,0x15,
				  0x9b,0xac,0xbe,0x29,0xb3,0xa9,0x3c,0x92,0x10,
				  0x05,0x08 },
		.data_len = 227,
		.hash = 	{ 0x07,0x30,0xe1,0x84,0xe7,0x79,0x55,0x75,0x56,
				  0x9f,0x87,0x03,0x02,0x60,0xbb,0x8e,0x54,0x49,
				  0x8e,0x0e,0x5d,0x09,0x6b,0x18,0x28,0x5e,0x98,
				  0x8d,0x24,0x5b,0x6f,0x34,0x86,0xd1,0xf2,0x44,
				  0x7d,0x5f,0x85,0xbc,0xbe,0x59,0xd5,0x68,0x9f,
				  0xc4,0x94,0x25 },
		.hash_len = 48,
	}, {
		.data =		{ 0xff,0xd6,0x78,0x90,0xff,0x77,0xf3,0x44,0xad,
				  0x4f,0x06,0x7d,0xf2,0xf4,0xff,0x1d,0xb8,0xf5,
				  0x41,0xc7,0xa2,0xbd,0x9a,0xe9,0xfa,0xba,0xd0,
				  0xfa,0xeb,0xbf,0x7d,0x00,0xf0,0xa7,0x1d,0x56,
				  0x8c,0x3c,0x66,0xac,0x3c,0x57,0xd8,0x4f,0xaa,
				  0x48,0x94,0xab,0x23,0x77,0x71,0x0e,0x4b,0x4c,
				  0x4d,0xae,0x0f,0x4d,0xa1,0xee,0xdc,0x86,0x58,
				  0xdd,0x0e,0x2e,0xe2,0xff,0xac,0x87,0x84,0x51,
				  0x52,0x06,0xf2,0x87,0x6e,0xb4,0x1f,0x98,0xaf,
				  0xd4,0x54,0x7c,0xbb,0xc6,0x80,0x34,0x21,0x2b,
				  0xcf,0x0c,0x8e,0x4a,0x7d,0x1d,0x43,0xb3,0xed,
				  0x15,0xc6,0x21,0xf5,0x3b,0xd8,0xa5,0x7c,0xad,
				  0xa8,0x01,0x48,0xec,0x46,0x52,0x11,0x9b,0x5a,
				  0xf3,0xda,0x84,0x16,0x9d,0x81,0xdc,0x69,0xd3,
				  0x94,0xc8,0x76,0x7d,0x66,0x20,0x44,0xd3,0x62,
				  0x72,0xb7,0x7c,0xa0,0x4a,0xbf,0xf7,0xb6,0xb0,
				  0xcf,0x3b,0xd1,0xf3,0x91,0x9a,0x04,0xa5,0xd8,
				  0xeb,0xdf,0xe7,0xd6,0xe8,0x44,0xe7,0x8f,0xd5,
				  0x76,0xa6,0x8d,0x63,0x73,0xff,0xd5,0xd3,0x84,
				  0xe5,0x1b,0x5e,0x12,0xec,0x32,0xd5,0xbb,0x0a,
				  0xc6,0x85,0xa5,0x9f,0x4d,0x5d,0x12,0xb4,0x3b,
				  0x53,0x35,0x80,0x75,0x03,0x45,0x31,0x09,0x99,
				  0xcf,0xe9,0x1c,0xf2,0x50,0x06,0x24,0xfe,0x03,
				  0xa6,0x57,0x69,0xf8,0x6a,0x62,0x7a,0x66,0x7b,
				  0x5f,0x3b,0x42,0xcb,0x01,0xda,0x10,0x9e,0x12,
				  0x4f,0xfa,0x48,0x20,0x3f,0x1f,0x38,0x73,0x20,
				  0x2d,0x35,0x42,0x9f,0x32,0xe8,0x26,0x3e,0xaf,
				  0x9b,0xce,0x42,0xef,0x40,0xf5,0xcc,0x96,0xb5,
				  0x91,0x46,0x7d,0x46,0x4d,0x00,0xbd,0x74,0x3a,
				  0x1b,0x0a,0xf4,0xc1,0xa7,0x43,0xfb,0xdd,0x08,
				  0x46,0xb9,0x87,0x9e,0x09,0x23,0x71,0xa5,0xe7,
				  0xf6,0xf6,0x59,0x37,0xf9,0x51,0x5e,0x23,0x82,
				  0x0e,0x60,0xb8,0x3b,0xbf,0xf7,0x39,0x26,0xf0,
				  0xcd,0xb9,0xdf,0x5d,0x02,0xe8,0x22,0x62,0xcf,
				  0x2e,0x8c,0xb2,0x6a,0xf6,0xa6,0x4c,0x2a,0x4d,
				  0x1f,0xab,0xec,0xab,0x59,0x3d,0xb5,0x10,0x28,
				  0x17,0x99 },

		.data_len = 326, 

		.hash = 	{ 0x13,0x96,0xfe,0xa9,0x5c,0xe0,0xc1,0xc1,0xc2,
				  0x24,0xb5,0x0a,0x07,0xdd,0x71,0x97,0xf1,0xd6,
				  0x2b,0x99,0x3c,0x7f,0xe9,0xe1,0xcc,0x1a,0x56,
				  0x10,0x19,0x20,0xd4,0xb0,0xfe,0xce,0xf5,0x87,
				  0xfb,0xcd,0x56,0xb8,0x54,0xc8,0xc9,0xda,0x95,
				  0x13,0x2f,0x02 },
		.hash_len = 48,
	}
};

/** SHA test Vectors for Hashing Byte-Oriented Messages
    http://csrc.nist.gov/groups/STM/cavp/documents/shs/shabytetestvectors.zip
    SHA512ShortMsg.rsp & SHA512LongMsg.rsp

    http://csrc.nist.gov/groups/ST/toolkit/examples.html
**/
struct DIGEST_TEST_VECTOR sha512_digest_test_vector[] = {
	{
		.data =		{ 0x00 },
		.data_len = 0,
		.hash =		{ 0xcf,0x83,0xe1,0x35,0x7e,0xef,0xb8,0xbd,0xf1,
				  0x54,0x28,0x50,0xd6,0x6d,0x80,0x07,0xd6,0x20,
				  0xe4,0x05,0x0b,0x57,0x15,0xdc,0x83,0xf4,0xa9,
				  0x21,0xd3,0x6c,0xe9,0xce,0x47,0xd0,0xd1,0x3c,
				  0x5d,0x85,0xf2,0xb0,0xff,0x83,0x18,0xd2,0x87,
				  0x7e,0xec,0x2f,0x63,0xb9,0x31,0xbd,0x47,0x41,
				  0x7a,0x81,0xa5,0x38,0x32,0x7a,0xf9,0x27,0xda,
				  0x3e },
		.hash_len = 64,
	},{
		.data = "abc",
		.data_len = 3,
		.hash =		{ 0xdd,0xaf,0x35,0xa1,0x93,0x61,0x7a,0xba,0xcc,
				  0x41,0x73,0x49,0xae,0x20,0x41,0x31,0x12,0xe6,
				  0xfa,0x4e,0x89,0xa9,0x7e,0xa2,0x0a,0x9e,0xee,
				  0xe6,0x4b,0x55,0xd3,0x9a,0x21,0x92,0x99,0x2a,
				  0x27,0x4f,0xc1,0xa8,0x36,0xba,0x3c,0x23,0xa3,
				  0xfe,0xeb,0xbd,0x45,0x4d,0x44,0x23,0x64,0x3c,
				  0xe8,0x0e,0x2a,0x9a,0xc9,0x4f,0xa5,0x4c,0xa4,
				  0x9f },
		.hash_len = 64,
	}, {
		.data = "abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu",
		.data_len = 112,
		.hash =		{ 0x8e,0x95,0x9b,0x75,0xda,0xe3,0x13,0xda,0x8c,
				  0xf4,0xf7,0x28,0x14,0xfc,0x14,0x3f,0x8f,0x77,
				  0x79,0xc6,0xeb,0x9f,0x7f,0xa1,0x72,0x99,0xae,
				  0xad,0xb6,0x88,0x90,0x18,0x50,0x1d,0x28,0x9e,
				  0x49,0x00,0xf7,0xe4,0x33,0x1b,0x99,0xde,0xc4,
				  0xb5,0x43,0x3a,0xc7,0xd3,0x29,0xee,0xb6,0xdd,
				  0x26,0x54,0x5e,0x96,0xe5,0x5b,0x87,0x4b,0xe9,
				  0x09 },
		.hash_len = 64,
	}, {
		.data = 	{ 0xfd,0x22,0x03,0xe4,0x67,0x57,0x4e,0x83,0x4a,
				  0xb0,0x7c,0x90,0x97,0xae,0x16,0x45,0x32,0xf2,
				  0x4b,0xe1,0xeb,0x5d,0x88,0xf1,0xaf,0x77,0x48,
				  0xce,0xff,0x0d,0x2c,0x67,0xa2,0x1f,0x4e,0x40,
				  0x97,0xf9,0xd3,0xbb,0x4e,0x9f,0xbf,0x97,0x18,
				  0x6e,0x0d,0xb6,0xdb,0x01,0x00,0x23,0x0a,0x52,
				  0xb4,0x53,0xd4,0x21,0xf8,0xab,0x9c,0x9a,0x60,
				  0x43,0xaa,0x32,0x95,0xea,0x20,0xd2,0xf0,0x6a,
				  0x2f,0x37,0x47,0x0d,0x8a,0x99,0x07,0x5f,0x1b,
				  0x8a,0x83,0x36,0xf6,0x22,0x8c,0xf0,0x8b,0x59,
				  0x42,0xfc,0x1f,0xb4,0x29,0x9c,0x7d,0x24,0x80,
				  0xe8,0xe8,0x2b,0xce,0x17,0x55,0x40,0xbd,0xfa,
				  0xd7,0x75,0x2b,0xc9,0x5b,0x57,0x7f,0x22,0x95,
				  0x15,0x39,0x4f,0x3a,0xe5,0xce,0xc8,0x70,0xa4,
				  0xb2,0xf8 },
		.data_len = 128,
		.hash = 	{ 0xa2,0x1b,0x10,0x77,0xd5,0x2b,0x27,0xac,0x54,
				  0x5a,0xf6,0x3b,0x32,0x74,0x6c,0x6e,0x3c,0x51,
				  0xcb,0x0c,0xb9,0xf2,0x81,0xeb,0x9f,0x35,0x80,
				  0xa6,0xd4,0x99,0x6d,0x5c,0x99,0x17,0xd2,0xa6,
				  0xe4,0x84,0x62,0x7a,0x9d,0x5a,0x06,0xfa,0x1b,
				  0x25,0x32,0x7a,0x9d,0x71,0x0e,0x02,0x73,0x87,
				  0xfc,0x3e,0x07,0xd7,0xc4,0xd1,0x4c,0x60,0x86,
				  0xcc },
		.hash_len = 64,
	}, {
		.data = 	{ 0xc1,0xca,0x70,0xae,0x12,0x79,0xba,0x0b,0x91,
				  0x81,0x57,0x55,0x8b,0x49,0x20,0xd6,0xb7,0xfb,
				  0xa8,0xa0,0x6b,0xe5,0x15,0x17,0x0f,0x20,0x2f,
				  0xaf,0xd3,0x6f,0xb7,0xf7,0x9d,0x69,0xfa,0xd7,
				  0x45,0xdb,0xa6,0x15,0x05,0x68,0xdb,0x1e,0x2b,
				  0x72,0x85,0x04,0x11,0x3e,0xea,0xc3,0x4f,0x52,
				  0x7f,0xc8,0x2f,0x22,0x00,0xb4,0x62,0xec,0xbf,
				  0x5d },
		.data_len = 64,
		.hash =		{ 0x04,0x6e,0x46,0x62,0x39,0x12,0xb3,0x93,0x2b,
				  0x8d,0x66,0x2a,0xb4,0x25,0x83,0x42,0x38,0x43,
				  0x20,0x63,0x01,0xb5,0x8b,0xf2,0x0a,0xb6,0xd7,
				  0x6f,0xd4,0x7f,0x1c,0xbb,0xcf,0x42,0x1d,0xf5,
				  0x36,0xec,0xd7,0xe5,0x6d,0xb5,0x35,0x4e,0x7e,
				  0x0f,0x98,0x82,0x2d,0x21,0x29,0xc1,0x97,0xf6,
				  0xf0,0xf2,0x22,0xb8,0xec,0x52,0x31,0xf3,0x96,
				  0x7d },
		.hash_len = 64,
	}, {
		.data = 	{ 0x4f,0x05,0x60,0x09,0x50,0x66,0x4d,0x51,0x90,
				  0xa2,0xeb,0xc2,0x9c,0x9e,0xdb,0x89,0xc2,0x00,
				  0x79,0xa4,0xd3,0xe6,0xbc,0x3b,0x27,0xd7,0x5e,
				  0x34,0xe2,0xfa,0x3d,0x02,0x76,0x85,0x02,0xbd,
				  0x69,0x79,0x00,0x78,0x59,0x8d,0x5f,0xcf,0x3d,
				  0x67,0x79,0xbf,0xed,0x12,0x84,0xbb,0xe5,0xad,
				  0x72,0xfb,0x45,0x60,0x15,0x18,0x1d,0x95,0x87,
				  0xd6,0xe8,0x64,0xc9,0x40,0x56,0x4e,0xaa,0xfb,
				  0x4f,0x2f,0xea,0xd4,0x34,0x6e,0xa0,0x9b,0x68,
				  0x77,0xd9,0x34,0x0f,0x6b,0x82,0xeb,0x15,0x15,
				  0x88,0x08,0x72,0x21,0x3d,0xa3,0xad,0x88,0xfe,
				  0xba,0x9f,0x4f,0x13,0x81,0x7a,0x71,0xd6,0xf9,
				  0x0a,0x1a,0x17,0xc4,0x3a,0x15,0xc0,0x38,0xd9,
				  0x88,0xb5,0xb2,0x9e,0xdf,0xfe,0x2d,0x6a,0x06,
				  0x28,0x13,0xce,0xdb,0xe8,0x52,0xcd,0xe3,0x02,
				  0xb3,0xe3,0x3b,0x69,0x68,0x46,0xd2,0xa8,0xe3,
				  0x6b,0xd6,0x80,0xef,0xcc,0x6c,0xd3,0xf9,0xe9,
				  0xa4,0xc1,0xae,0x8c,0xac,0x10,0xcc,0x52,0x44,
				  0xd1,0x31,0x67,0x71,0x40,0x39,0x91,0x76,0xed,
				  0x46,0x70,0x00,0x19,0xa0,0x04,0xa1,0x63,0x80,
				  0x6f,0x7f,0xa4,0x67,0xfc,0x4e,0x17,0xb4,0x61,
				  0x7b,0xbd,0x76,0x41,0xaa,0xff,0x7f,0xf5,0x63,
				  0x96,0xba,0x8c,0x08,0xa8,0xbe,0x10,0x0b,0x33,
				  0xa2,0x0b,0x5d,0xaf,0x13,0x4a,0x2a,0xef,0xa5,
				  0xe1,0xc3,0x49,0x67,0x70,0xdc,0xf6,0xba,0xa4,
				  0xf7,0xbb },
		.data_len = 227,
		.hash = 	{ 0xa9,0xdb,0x49,0x0c,0x70,0x8c,0xc7,0x25,0x48,
				  0xd7,0x86,0x35,0xaa,0x7d,0xa7,0x9b,0xb2,0x53,
				  0xf9,0x45,0xd7,0x10,0xe5,0xcb,0x67,0x7a,0x47,
				  0x4e,0xfc,0x7c,0x65,0xa2,0xaa,0xb4,0x5b,0xc7,
				  0xca,0x11,0x13,0xc8,0xce,0x0f,0x3c,0x32,0xe1,
				  0x39,0x9d,0xe9,0xc4,0x59,0x53,0x5e,0x88,0x16,
				  0x52,0x1a,0xb7,0x14,0xb2,0xa6,0xcd,0x20,0x05,
				  0x25 },
		.hash_len = 64,
	}, {
		.data = 	{ 0xd5,0xe3,0x78,0xae,0x9f,0xc2,0x64,0x8f,0x4a,
				  0x13,0xbb,0xec,0x4b,0x09,0x35,0xaf,0xb4,0xf8,
				  0x22,0xf5,0xfe,0x0d,0x50,0x63,0x05,0x3d,0x2f,
				  0xbd,0x54,0x7b,0x33,0xb4,0xa3,0x2e,0x7a,0x00,
				  0x9e,0xe2,0xaf,0xaf,0xe8,0x3d,0x2e,0xbd,0x60,
				  0x35,0x68,0xe4,0xa3,0x81,0x89,0xb5,0xd2,0x4d,
				  0x59,0xe8,0x95,0x32,0x60,0xf1,0x5f,0x65,0x4e,
				  0xd4,0xf4,0x2f,0x9a,0x39,0x29,0x9d,0x68,0xc3,
				  0xeb,0x78,0xb0,0x9e,0x83,0x77,0x9d,0x57,0x18,
				  0xb4,0x33,0xf1,0x76,0x5d,0x35,0x35,0x0e,0xac,
				  0x46,0x49,0x3d,0x19,0x4e,0x84,0xd1,0xce,0x1f,
				  0x81,0xc9,0x5b,0x59,0x72,0x5c,0xab,0x8a,0xb7,
				  0x3d,0x36,0x9a,0xb0,0x1e,0x79,0x67,0xcf,0x73,
				  0xa3,0xac,0xf1,0x78,0x92,0x27,0xee,0x75,0xfd,
				  0xfb,0x6e,0x40,0xf3,0x53,0xff,0x04,0x84,0x48,
				  0x65,0x42,0xbe,0x05,0x31,0x15,0xdb,0x28,0x96,
				  0xba,0xb8,0x6c,0x77,0x4f,0x89,0x85,0xc4,0xdb,
				  0xcc,0x4c,0x07,0x8f,0x7b,0x1c,0x3a,0x4c,0x86,
				  0x7c,0xdc,0x65,0x80,0xfe,0x44,0xa5,0x98,0x67,
				  0x34,0x94,0xcc,0x0f,0xb1,0xf6,0x59,0x8b,0x12,
				  0x95,0x76,0x8a,0x58,0x40,0x41,0xfd,0xbd,0x14,
				  0xfa,0x7b,0x90,0xfa,0x6f,0xe3,0x3f,0x71,0xb7,
				  0x43,0xb6,0x8e,0x23,0xf8,0xe7,0x40,0x72,0x17,
				  0xaa,0xd9,0x44,0x0c,0xc8,0xca,0xd2,0x81,0x52,
				  0xae,0xdb,0x82,0x38,0x8b,0xe2,0xde,0x16,0x54,
				  0x96,0xd0,0x51,0xb2,0x92,0xde,0x63,0x03,0x46,
				  0x02,0x73,0xa4,0x35,0x08,0x29,0x6b,0x62,0x37,
				  0xc0,0x78,0x04,0x33,0x5d,0x2e,0x81,0x22,0x9f,
				  0x7c,0x9a,0x0e,0x77,0x61,0xe3,0x8a,0x3a,0xaf,
				  0x77,0x99,0xf4,0x0f,0xe9,0xcb,0x00,0x45,0x7e,
				  0xa9,0xd5,0xb5,0x99,0x53,0x23,0x26,0x76,0x68,
				  0x1f,0xc7,0x1b,0x26,0x1a,0x6f,0x8c,0xd3,0x59,
				  0x29,0x3f,0x5b,0x21,0xf0,0xcf,0x3a,0x11,0xb7,
				  0xf4,0x9c,0xb5,0xad,0xb3,0xc3,0x57,0xbe,0xd2,
				  0xaa,0x18,0x5d,0x8f,0xe8,0x40,0x81,0x92,0xd6,
				  0xd3,0xed,0x1f,0xf4,0x65,0xb5,0x90,0x89,0x2e,
				  0xfe,0x03 },
		.data_len = 326,
		.hash = 	{ 0xa7,0x0c,0x75,0xb9,0xb1,0xf0,0xac,0x2e,0xd2,
				  0xc2,0x79,0x77,0x63,0xac,0x9a,0x66,0x01,0xd9,
				  0x5f,0x46,0x88,0x9b,0x00,0xfc,0x3d,0xda,0xe4,
				  0xd0,0xac,0x69,0x23,0x75,0x0a,0x10,0x8d,0x79,
				  0xeb,0x76,0x4e,0x77,0xac,0x07,0xb7,0xcb,0x5c,
				  0x01,0xcb,0x4b,0x37,0x47,0xdc,0xf6,0x9b,0xa3,
				  0xb3,0x5c,0x51,0xfb,0x99,0x5d,0xa2,0x63,0x2e,
				  0x70 },
		.hash_len = 64,
	}
};

struct digest_test_suite_info {
        const char *name;
        unsigned int tvcount;
        struct DIGEST_TEST_VECTOR *tv;
        CK_MECHANISM mech;
};

#define NUM_DIGEST_TEST_SUITES 8
struct digest_test_suite_info digest_test_suites[] = {
        {
                .name = "SHA-1",
                .tvcount = 3,
                .tv = sha1_digest_test_vector,
                .mech = {CKM_SHA_1, 0, 0},
        }, {
                .name = "SHA-256",
                .tvcount = 6,
                .tv = sha256_digest_test_vector,
                .mech = {CKM_SHA256, 0, 0},
        }, {
                .name = "SHA-384",
                .tvcount = 8,
                .tv = sha384_digest_test_vector,
                .mech = {CKM_SHA384, 0, 0},
        }, {
                .name = "SHA-512",
                .tvcount = 7,
                .tv = sha512_digest_test_vector,
                .mech = {CKM_SHA512, 0, 0},
        }, {
                .name = "MD2",
                .tvcount = 7,
                .tv = md2_digest_test_vector,
                .mech = {CKM_MD2, 0, 0},
        }, {
                .name = "MD5",
                .tvcount = 3,
                .tv = md5_digest_test_vector,
                .mech = {CKM_MD5, 0, 0},
        }, {
                .name = "RIPEMD-128",
                .tvcount = 1,
                .tv = ripemd128_digest_test_vector,
                .mech = {CKM_RIPEMD128, 0, 0},
        }, {
                .name = "RIPEMD-160",
                .tvcount = 1,
                .tv = ripemd160_digest_test_vector,
                .mech = {CKM_RIPEMD160, 0, 0},
        }
};

/** MD5 HMAC and SHA1 HMAC test vectors from RFC2202:
 *  http://www.faqs.org/rfcs/rfc2202.html
 *
 *  Test vectors for SHA256 and SHA512 from RFC4868:
 *  http://tools.ietf.org/html/rfc4868
 **/

struct HMAC_TEST_VECTOR {
	/* test vector inputs */
	CK_BYTE         key[512];
	CK_ULONG        key_len;
	CK_BYTE         data[512];
	CK_ULONG        data_len;
	CK_ULONG        hash_len;
	CK_BYTE         result[512];
};

struct HMAC_TEST_VECTOR md5_hmac_test_vector[] = {
        {
                .key =        { 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
                                0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b },
                .key_len = 16,
                .data =       { "Hi There" },
                .data_len = 8,
                .hash_len = 16,
                .result =     { 0x92, 0x94, 0x72, 0x7a, 0x36, 0x38, 0xBB, 0x1C,
                                0x13, 0xf4, 0x8E, 0xf8, 0x15, 0x8b, 0xfc, 0x9d }
	}, {
	        .key =        { 'J', 'e', 'f', 'e' },
                .key_len = 4,
                .data =       { "what do ya want for nothing?" },
                .data_len = 28,
                .hash_len = 16,
                .result =     { 0x75, 0x0c, 0x78, 0x3e, 0x6a, 0xb0, 0xb5, 0x03,
                                0xea, 0xa8, 0x6e, 0x31, 0x0a, 0x5d, 0xb7, 0x38 }
	}, {
	        .key =        { 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },
                .key_len = 16,
                .data =       { 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                                0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                                0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                                0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                                0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                                0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                                0xDD, 0xDD },
                .data_len = 50,
                .hash_len = 16,
                .result =     { 0x56, 0xbe, 0x34, 0x52, 0x1d, 0x14, 0x4c, 0x88,
                                0xdb, 0xb8, 0xc7, 0x33, 0xf0, 0xe8, 0xb3, 0xf6 }
	}, {
	        .key =        { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
                                0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10,
                                0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
                                0x19 },
                .key_len = 25,
                .data =       { 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
                                0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
                                0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
                                0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
                                0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
                                0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
                                0xCD, 0xCD },
                .data_len = 50,
                .hash_len = 16,
                .result =     { 0x69, 0x7e, 0xaf, 0x0a, 0xca, 0x3a, 0x3a, 0xea,
                                0x3a, 0x75, 0x16, 0x47, 0x46, 0xff, 0xaa, 0x79 }
	}, {
	        .key =        { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
                                0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
                .key_len = 16,
                .data =       { "Test With Truncation" },
                .data_len = 20,
                .hash_len = 16,
                .result =     { 0x56, 0x46, 0x1e, 0xf2, 0x34, 0x2e, 0xdc, 0x00,
                                0xf9, 0xba, 0xb9, 0x95, 0x69, 0x0e, 0xfd, 0x4c}
	}, {
	        .key =        { 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },
                .key_len = 80,
                .data =       { "Test Using Larger Than Block-Size Key - Hash Key First" },
                .data_len = 54,
                .hash_len = 16,
                .result =     { 0x6b, 0x1a, 0xb7, 0xfe, 0x4b, 0xd7, 0xbf, 0x8f,
                                0x0b, 0x62, 0xe6, 0xce, 0x61, 0xb9, 0xd0, 0xcd }
	}, {
	        .key =        { 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },
                .key_len = 80,
                .data =       { "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data" },
                .data_len = 73,
                .hash_len = 16,
                .result =     { 0x6f, 0x63, 0x0f, 0xad, 0x67, 0xcd, 0xa0, 0xee,
                                0x1f, 0xb1, 0xf5, 0x62, 0xdb, 0x3a, 0xa5, 0x3e }
	},
};

struct HMAC_TEST_VECTOR sha1_hmac_test_vector[] = {
	{
		.key =		{ 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b },
		.key_len = 20,
		.data =		{ "Hi There" },
		.data_len = 8,
		.hash_len = 20,
		.result =	{ 0xb6,0x17,0x31,0x86,0x55,0x05,0x72,0x64,0xe2,
				  0x8b,0xc0,0xb6,0xfb,0x37,0x8c,0x8e,0xf1,0x46,
				  0xbe,0x00 }
	}, {
		.key =		{ 'J', 'e', 'f', 'e' },
		.key_len = 4,
		.data =		{ "what do ya want for nothing?" },
		.data_len = 28,
		.hash_len = 20,
		.result =	{ 0xef,0xfc,0xdf,0x6a,0xe5,0xeb,0x2f,0xa2,0xd2,
				  0x74,0x16,0xd5,0xf1,0x84,0xdf,0x9c,0x25,0x9a,
				  0x7c,0x79 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa },
		.key_len = 20,
		.data =		{ 0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD },
		.data_len = 50,
		.hash_len = 20,
	.result =		{ 0x12,0x5d,0x73,0x42,0xb9,0xac,0x11,0xcd,0x91,
				  0xa3,0x9a,0xf4,0x8a,0xa1,0x7b,0x4f,0x63,0xf1,
				  0x75,0xd3 }
	}, {
		.key =		{ 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,
				  0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,
				  0x13,0x14,0x15,0x16,0x17,0x18,0x19 },
		.key_len = 25,
		.data =		{ 0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD },
		.data_len = 50,
		.hash_len = 20,
		.result =	{ 0x4c,0x90,0x07,0xf4,0x02,0x62,0x50,0xc6,0xbc,
				  0x84,0x14,0xf9,0xbf,0x50,0xc8,0x6c,0x2d,0x72,
				  0x35,0xda }
	}, {
		.key =		{ 0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
				  0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
				  0x0c,0x0c },
		.key_len = 20,
		.data =		{ "Test With Truncation" },
		.data_len = 20,
		.hash_len = 20,
		.result =	{ 0x4c,0x1a,0x03,0x42,0x4b,0x55,0xe0,0x7f,0xe7,
				  0xf2,0x7b,0xe1,0xd5,0x8b,0xb9,0x32,0x4a,0x9a,
				  0x5a,0x04 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa },
		.key_len = 80,
		.data =		{ "Test Using Larger Than Block-Size Key - Hash Key First" },
		.data_len = 54,
		.hash_len = 20,
		.result =	{ 0xaa,0x4a,0xe5,0xe1,0x52,0x72,0xd0,0x0e,0x95,
				  0x70,0x56,0x37,0xce,0x8a,0x3b,0x55,0xed,0x40,
				  0x21,0x12 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa },
		.key_len = 80,
		.data =		{ "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data" },
		.data_len = 73,
		.hash_len = 20,
		.result =	{ 0xe8,0xe9,0x9d,0x0f,0x45,0x23,0x7d,0x78,0x6d,
				  0x6b,0xba,0xa7,0x96,0x5c,0x78,0x08,0xbb,0xff,
				  0x1a,0x91 }
	},
};

struct HMAC_TEST_VECTOR sha256_hmac_test_vector[] = {
        {
		.key =		{ 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b },
		.key_len = 20,
		.data =		{ "Hi There" },
		.data_len = 8,
		.hash_len = 32,
		.result =	{ 0xb0,0x34,0x4c,0x61,0xd8,0xdb,0x38,0x53,0x5c,
				  0xa8,0xaf,0xce,0xaf,0x0b,0xf1,0x2b,0x88,0x1d,
				  0xc2,0x00,0xc9,0x83,0x3d,0xa7,0x26,0xe9,0x37,
				  0x6c,0x2e,0x32,0xcf,0xf7 }
	}, {
		.key =		{ 'J', 'e', 'f', 'e' },
		.key_len = 4,
		.data =		{ "what do ya want for nothing?" },
		.data_len = 28,
		.hash_len = 32,
		.result =	{ 0x5b,0xdc,0xc1,0x46,0xbf,0x60,0x75,0x4e,0x6a,
				  0x04,0x24,0x26,0x08,0x95,0x75,0xc7,0x5a,0x00,
				  0x3f,0x08,0x9d,0x27,0x39,0x83,0x9d,0xec,0x58,
				  0xb9,0x64,0xec,0x38,0x43 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa },
		.key_len = 20,
		.data =		{ 0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD },
		.data_len = 50,
		.hash_len = 32,
		.result =	{ 0x77,0x3e,0xa9,0x1e,0x36,0x80,0x0e,0x46,0x85,
			 	  0x4d,0xb8,0xeb,0xd0,0x91,0x81,0xa7,0x29,0x59,
				  0x09,0x8b,0x3e,0xf8,0xc1,0x22,0xd9,0x63,0x55,
				  0x14,0xce,0xd5,0x65,0xfe }
	}, {
		.key =		{ 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,
				  0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,
				  0x13,0x14,0x15,0x16,0x17,0x18,0x19 },
		.key_len = 25,
		.data =		{ 0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD },
		.data_len = 50,
		.hash_len = 32,
		.result =	{ 0x82,0x55,0x8a,0x38,0x9a,0x44,0x3c,0x0e,0xa4,
				  0xcc,0x81,0x98,0x99,0xf2,0x08,0x3a,0x85,0xf0,
				  0xfa,0xa3,0xe5,0x78,0xf8,0x07,0x7a,0x2e,0x3f,
				  0xf4,0x67,0x29,0x66,0x5b }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa },
		.key_len = 131,
		.data = 	{ 0x54,0x65,0x73,0x74,0x20,0x55,0x73,0x69,0x6e,
				  0x67,0x20,0x4c,0x61,0x72,0x67,0x65,0x72,0x20,
				  0x54,0x68,0x61,0x6e,0x20,0x42,0x6c,0x6f,0x63,
				  0x6b,0x2d,0x53,0x69,0x7a,0x65,0x20,0x4b,0x65,
				  0x79,0x20,0x2d,0x20,0x48,0x61,0x73,0x68,0x20,
				  0x4b,0x65,0x79,0x20,0x46,0x69,0x72,0x73,0x74},
		.data_len = 54,
		.hash_len = 32,
		.result = 	{ 0x60,0xe4,0x31,0x59,0x1e,0xe0,0xb6,0x7f,0x0d,
				  0x8a,0x26,0xaa,0xcb,0xf5,0xb7,0x7f,0x8e,0x0b,
				  0xc6,0x21,0x37,0x28,0xc5,0x14,0x05,0x46,0x04,
				  0x0f,0x0e,0xe3,0x7f,0x54 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa },
		.key_len = 131,
		.data = 	{ 0x54,0x68,0x69,0x73,0x20,0x69,0x73,0x20,0x61,
				  0x20,0x74,0x65,0x73,0x74,0x20,0x75,0x73,0x69,
				  0x6e,0x67,0x20,0x61,0x20,0x6c,0x61,0x72,0x67,
				  0x65,0x72,0x20,0x74,0x68,0x61,0x6e,0x20,0x62,
				  0x6c,0x6f,0x63,0x6b,0x2d,0x73,0x69,0x7a,0x65,
				  0x20,0x6b,0x65,0x79,0x20,0x61,0x6e,0x64,0x20,
				  0x61,0x20,0x6c,0x61,0x72,0x67,0x65,0x72,0x20,
				  0x74,0x68,0x61,0x6e,0x20,0x62,0x6c,0x6f,0x63,
				  0x6b,0x2d,0x73,0x69,0x7a,0x65,0x20,0x64,0x61,
				  0x74,0x61,0x2e,0x20,0x54,0x68,0x65,0x20,0x6b,
				  0x65,0x79,0x20,0x6e,0x65,0x65,0x64,0x73,0x20,
				  0x74,0x6f,0x20,0x62,0x65,0x20,0x68,0x61,0x73,
				  0x68,0x65,0x64,0x20,0x62,0x65,0x66,0x6f,0x72,
				  0x65,0x20,0x62,0x65,0x69,0x6e,0x67,0x20,0x75,
				  0x73,0x65,0x64,0x20,0x62,0x79,0x20,0x74,0x68,
				  0x65,0x20,0x48,0x4d,0x41,0x43,0x20,0x61,0x6c,
				  0x67,0x6f,0x72,0x69,0x74,0x68,0x6d,0x2e },
		.data_len = 152,
		.hash_len = 32,
		.result = 	{ 0x9b,0x09,0xff,0xa7,0x1b,0x94,0x2f,0xcb,0x27,
				  0x63,0x5f,0xbc,0xd5,0xb0,0xe9,0x44,0xbf,0xdc,
				  0x63,0x64,0x4f,0x07,0x13,0x93,0x8a,0x7f,0x51,
				  0x53,0x5c,0x3a,0x35,0xe2 }
	}
};

struct HMAC_TEST_VECTOR sha384_hmac_test_vector[] = {
        {
		.key =		{ 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b },
		.key_len = 20,
		.data =		{ "Hi There" },
		.data_len = 8,
		.hash_len = 48,
		.result = 	{ 0xaf,0xd0,0x39,0x44,0xd8,0x48,0x95,0x62,0x6b,
				  0x08,0x25,0xf4,0xab,0x46,0x90,0x7f,0x15,0xf9,
				  0xda,0xdb,0xe4,0x10,0x1e,0xc6,0x82,0xaa,0x03,
				  0x4c,0x7c,0xeb,0xc5,0x9c,0xfa,0xea,0x9e,0xa9,
				  0x07,0x6e,0xde,0x7f,0x4a,0xf1,0x52,0xe8,0xb2,
				  0xfa,0x9c,0xb6 }
	}, {
		.key =		{ 'J', 'e', 'f', 'e' },
		.key_len = 4,
		.data =		{ "what do ya want for nothing?" },
		.data_len = 28,
		.hash_len = 48,
		.result = 	{ 0xaf,0x45,0xd2,0xe3,0x76,0x48,0x40,0x31,0x61,
				  0x7f,0x78,0xd2,0xb5,0x8a,0x6b,0x1b,0x9c,0x7e,
				  0xf4,0x64,0xf5,0xa0,0x1b,0x47,0xe4,0x2e,0xc3,
				  0x73,0x63,0x22,0x44,0x5e,0x8e,0x22,0x40,0xca,
				  0x5e,0x69,0xe2,0xc7,0x8b,0x32,0x39,0xec,0xfa,
				  0xb2,0x16,0x49 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa },
		.key_len = 20,
		.data =		{ 0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD },
		.data_len = 50,
		.hash_len = 48,
		.result = 	{ 0x88,0x06,0x26,0x08,0xd3,0xe6,0xad,0x8a,0x0a,
				  0xa2,0xac,0xe0,0x14,0xc8,0xa8,0x6f,0x0a,0xa6,
				  0x35,0xd9,0x47,0xac,0x9f,0xeb,0xe8,0x3e,0xf4,
				  0xe5,0x59,0x66,0x14,0x4b,0x2a,0x5a,0xb3,0x9d,
				  0xc1,0x38,0x14,0xb9,0x4e,0x3a,0xb6,0xe1,0x01,
				  0xa3,0x4f,0x27 }
	}, {
		.key =		{ 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,
				  0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,
				  0x13,0x14,0x15,0x16,0x17,0x18,0x19 },
		.key_len = 25,
		.data =		{ 0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD },
		.data_len = 50,
		.hash_len = 48,
		.result = 	{ 0x3e,0x8a,0x69,0xb7,0x78,0x3c,0x25,0x85,0x19,
				  0x33,0xab,0x62,0x90,0xaf,0x6c,0xa7,0x7a,0x99,
				  0x81,0x48,0x08,0x50,0x00,0x9c,0xc5,0x57,0x7c,
				  0x6e,0x1f,0x57,0x3b,0x4e,0x68,0x01,0xdd,0x23,
				  0xc4,0xa7,0xd6,0x79,0xcc,0xf8,0xa3,0x86,0xc6,
				  0x74,0xcf,0xfb }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa },
		.key_len = 131,
		.data = 	{ 0x54,0x65,0x73,0x74,0x20,0x55,0x73,0x69,0x6e,
				  0x67,0x20,0x4c,0x61,0x72,0x67,0x65,0x72,0x20,
				  0x54,0x68,0x61,0x6e,0x20,0x42,0x6c,0x6f,0x63,
				  0x6b,0x2d,0x53,0x69,0x7a,0x65,0x20,0x4b,0x65,
				  0x79,0x20,0x2d,0x20,0x48,0x61,0x73,0x68,0x20,
				  0x4b,0x65,0x79,0x20,0x46,0x69,0x72,0x73,0x74},
		.data_len = 54,
		.hash_len = 48,
		.result = 	{ 0x4e,0xce,0x08,0x44,0x85,0x81,0x3e,0x90,0x88,
				  0xd2,0xc6,0x3a,0x04,0x1b,0xc5,0xb4,0x4f,0x9e,
				  0xf1,0x01,0x2a,0x2b,0x58,0x8f,0x3c,0xd1,0x1f,
				  0x05,0x03,0x3a,0xc4,0xc6,0x0c,0x2e,0xf6,0xab,
				  0x40,0x30,0xfe,0x82,0x96,0x24,0x8d,0xf1,0x63,
				  0xf4,0x49,0x52 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa },
		.key_len = 131,
		.data = 	{ 0x54,0x68,0x69,0x73,0x20,0x69,0x73,0x20,0x61,
				  0x20,0x74,0x65,0x73,0x74,0x20,0x75,0x73,0x69,
				  0x6e,0x67,0x20,0x61,0x20,0x6c,0x61,0x72,0x67,
				  0x65,0x72,0x20,0x74,0x68,0x61,0x6e,0x20,0x62,
				  0x6c,0x6f,0x63,0x6b,0x2d,0x73,0x69,0x7a,0x65,
				  0x20,0x6b,0x65,0x79,0x20,0x61,0x6e,0x64,0x20,
				  0x61,0x20,0x6c,0x61,0x72,0x67,0x65,0x72,0x20,
				  0x74,0x68,0x61,0x6e,0x20,0x62,0x6c,0x6f,0x63,
				  0x6b,0x2d,0x73,0x69,0x7a,0x65,0x20,0x64,0x61,
				  0x74,0x61,0x2e,0x20,0x54,0x68,0x65,0x20,0x6b,
				  0x65,0x79,0x20,0x6e,0x65,0x65,0x64,0x73,0x20,
				  0x74,0x6f,0x20,0x62,0x65,0x20,0x68,0x61,0x73,
				  0x68,0x65,0x64,0x20,0x62,0x65,0x66,0x6f,0x72,
				  0x65,0x20,0x62,0x65,0x69,0x6e,0x67,0x20,0x75,
				  0x73,0x65,0x64,0x20,0x62,0x79,0x20,0x74,0x68,
				  0x65,0x20,0x48,0x4d,0x41,0x43,0x20,0x61,0x6c,
				  0x67,0x6f,0x72,0x69,0x74,0x68,0x6d,0x2e },
		.data_len = 152,
		.hash_len = 48,
		.result = 	{ 0x66,0x17,0x17,0x8e,0x94,0x1f,0x02,0x0d,0x35,
				  0x1e,0x2f,0x25,0x4e,0x8f,0xd3,0x2c,0x60,0x24,
				  0x20,0xfe,0xb0,0xb8,0xfb,0x9a,0xdc,0xce,0xbb,
				  0x82,0x46,0x1e,0x99,0xc5,0xa6,0x78,0xcc,0x31,
				  0xe7,0x99,0x17,0x6d,0x38,0x60,0xe6,0x11,0x0c,
				  0x46,0x52,0x3e }
	}
};

struct HMAC_TEST_VECTOR sha512_hmac_test_vector[] = {
        {
		.key =		{ 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b },
		.key_len = 20,
		.data =		{ "Hi There" },
		.data_len = 8,
		.hash_len = 64,
		.result =	{ 0x87,0xaa,0x7c,0xde,0xa5,0xef,0x61,0x9d,0x4f,
				  0xf0,0xb4,0x24,0x1a,0x1d,0x6c,0xb0,0x23,0x79,
				  0xf4,0xe2,0xce,0x4e,0xc2,0x78,0x7a,0xd0,0xb3,
				  0x05,0x45,0xe1,0x7c,0xde,0xda,0xa8,0x33,0xb7,
				  0xd6,0xb8,0xa7,0x02,0x03,0x8b,0x27,0x4e,0xae,
				  0xa3,0xf4,0xe4,0xbe,0x9d,0x91,0x4e,0xeb,0x61,
				  0xf1,0x70,0x2e,0x69,0x6c,0x20,0x3a,0x12,0x68,
				  0x54 }
	}, {
		.key =		{ 'J', 'e', 'f', 'e' },
		.key_len = 4,
		.data =		{ "what do ya want for nothing?" },
		.data_len = 28,
		.hash_len = 64,
		.result =	{ 0x16,0x4b,0x7a,0x7b,0xfc,0xf8,0x19,0xe2,0xe3,
				  0x95,0xfb,0xe7,0x3b,0x56,0xe0,0xa3,0x87,0xbd,
				  0x64,0x22,0x2e,0x83,0x1f,0xd6,0x10,0x27,0x0c,
				  0xd7,0xea,0x25,0x05,0x54,0x97,0x58,0xbf,0x75,
				  0xc0,0x5a,0x99,0x4a,0x6d,0x03,0x4f,0x65,0xf8,
				  0xf0,0xe6,0xfd,0xca,0xea,0xb1,0xa3,0x4d,0x4a,
				  0x6b,0x4b,0x63,0x6e,0x07,0x0a,0x38,0xbc,0xe7,
				  	0x37 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa },
		.key_len = 20,
		.data =		{ 0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD },
		.data_len = 50,
		.hash_len = 64,
		.result =	{ 0xfa,0x73,0xb0,0x08,0x9d,0x56,0xa2,0x84,0xef,
				  0xb0,0xf0,0x75,0x6c,0x89,0x0b,0xe9,0xb1,0xb5,
				  0xdb,0xdd,0x8e,0xe8,0x1a,0x36,0x55,0xf8,0x3e,
				  0x33,0xb2,0x27,0x9d,0x39,0xbf,0x3e,0x84,0x82,
				  0x79,0xa7,0x22,0xc8,0x06,0xb4,0x85,0xa4,0x7e,
				  0x67,0xc8,0x07,0xb9,0x46,0xa3,0x37,0xbe,0xe8,
				  0x94,0x26,0x74,0x27,0x88,0x59,0xe1,0x32,0x92,
				  0xfb }
	}, {
		.key =		{ 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,
				  0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,
				  0x13,0x14,0x15,0x16,0x17,0x18,0x19 },
		.key_len = 25,
		.data =		{ 0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD },
		.data_len = 50,
		.hash_len = 64,
		.result =	{ 0xb0,0xba,0x46,0x56,0x37,0x45,0x8c,0x69,0x90,
				  0xe5,0xa8,0xc5,0xf6,0x1d,0x4a,0xf7,0xe5,0x76,
				  0xd9,0x7f,0xf9,0x4b,0x87,0x2d,0xe7,0x6f,0x80,
				  0x50,0x36,0x1e,0xe3,0xdb,0xa9,0x1c,0xa5,0xc1,
				  0x1a,0xa2,0x5e,0xb4,0xd6,0x79,0x27,0x5c,0xc5,
				  0x78,0x80,0x63,0xa5,0xf1,0x97,0x41,0x12,0x0c,
				  0x4f,0x2d,0xe2,0xad,0xeb,0xeb,0x10,0xa2,0x98,
				  0xdd }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa },
		.key_len = 131,
		.data = 	{ 0x54,0x65,0x73,0x74,0x20,0x55,0x73,0x69,0x6e,
				  0x67,0x20,0x4c,0x61,0x72,0x67,0x65,0x72,0x20,
				  0x54,0x68,0x61,0x6e,0x20,0x42,0x6c,0x6f,0x63,
				  0x6b,0x2d,0x53,0x69,0x7a,0x65,0x20,0x4b,0x65,
				  0x79,0x20,0x2d,0x20,0x48,0x61,0x73,0x68,0x20,
				  0x4b,0x65,0x79,0x20,0x46,0x69,0x72,0x73,0x74},
		.data_len = 54,
		.hash_len = 64,
		.result =	{ 0x80,0xb2,0x42,0x63,0xc7,0xc1,0xa3,0xeb,0xb7,
				  0x14,0x93,0xc1,0xdd,0x7b,0xe8,0xb4,0x9b,0x46,
				  0xd1,0xf4,0x1b,0x4a,0xee,0xc1,0x12,0x1b,0x01,
				  0x37,0x83,0xf8,0xf3,0x52,0x6b,0x56,0xd0,0x37,
				  0xe0,0x5f,0x25,0x98,0xbd,0x0f,0xd2,0x21,0x5d,
				  0x6a,0x1e,0x52,0x95,0xe6,0x4f,0x73,0xf6,0x3f,
				  0x0a,0xec,0x8b,0x91,0x5a,0x98,0x5d,0x78,0x65,
				  0x98 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa },
		.key_len = 131,
		.data = 	{ 0x54,0x68,0x69,0x73,0x20,0x69,0x73,0x20,0x61,
				  0x20,0x74,0x65,0x73,0x74,0x20,0x75,0x73,0x69,
				  0x6e,0x67,0x20,0x61,0x20,0x6c,0x61,0x72,0x67,
				  0x65,0x72,0x20,0x74,0x68,0x61,0x6e,0x20,0x62,
				  0x6c,0x6f,0x63,0x6b,0x2d,0x73,0x69,0x7a,0x65,
				  0x20,0x6b,0x65,0x79,0x20,0x61,0x6e,0x64,0x20,
				  0x61,0x20,0x6c,0x61,0x72,0x67,0x65,0x72,0x20,
				  0x74,0x68,0x61,0x6e,0x20,0x62,0x6c,0x6f,0x63,
				  0x6b,0x2d,0x73,0x69,0x7a,0x65,0x20,0x64,0x61,
				  0x74,0x61,0x2e,0x20,0x54,0x68,0x65,0x20,0x6b,
				  0x65,0x79,0x20,0x6e,0x65,0x65,0x64,0x73,0x20,
				  0x74,0x6f,0x20,0x62,0x65,0x20,0x68,0x61,0x73,
				  0x68,0x65,0x64,0x20,0x62,0x65,0x66,0x6f,0x72,
				  0x65,0x20,0x62,0x65,0x69,0x6e,0x67,0x20,0x75,
				  0x73,0x65,0x64,0x20,0x62,0x79,0x20,0x74,0x68,
				  0x65,0x20,0x48,0x4d,0x41,0x43,0x20,0x61,0x6c,
				  0x67,0x6f,0x72,0x69,0x74,0x68,0x6d,0x2e },
		.data_len = 152,
		.hash_len = 64,
		.result =	{ 0xe3,0x7b,0x6a,0x77,0x5d,0xc8,0x7d,0xba,0xa4,
				  0xdf,0xa9,0xf9,0x6e,0x5e,0x3f,0xfd,0xde,0xbd,
				  0x71,0xf8,0x86,0x72,0x89,0x86,0x5d,0xf5,0xa3,
				  0x2d,0x20,0xcd,0xc9,0x44,0xb6,0x02,0x2c,0xac,
				  0x3c,0x49,0x82,0xb1,0x0d,0x5e,0xeb,0x55,0xc3,
				  0xe4,0xde,0x15,0x13,0x46,0x76,0xfb,0x6d,0xe0,
				  0x44,0x60,0x65,0xc9,0x74,0x40,0xfa,0x8c,0x6a,
				  0x58 }
	}
};

struct HMAC_TEST_VECTOR md5_hmac_general_test_vector[] = {
	{
	        .key =        { 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
                                0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b },
                .key_len = 16,
                .data =       { "Hi There" },
                .data_len = 8,
                .hash_len = 4,
                .result =     { 0x92, 0x94, 0x72, 0x7a, 0x36, 0x38, 0xBB, 0x1C,
                                0x13, 0xf4, 0x8E, 0xf8, 0x15, 0x8b, 0xfc, 0x9d }
	}, {
	        .key =        { 'J', 'e', 'f', 'e' },
                .key_len = 4,
                .data =       { "what do ya want for nothing?" },
                .data_len = 28,
                .hash_len = 4,
                .result =     { 0x75, 0x0c, 0x78, 0x3e, 0x6a, 0xb0, 0xb5, 0x03,
                                0xea, 0xa8, 0x6e, 0x31, 0x0a, 0x5d, 0xb7, 0x38 }
	}, {
	        .key =        { 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },
                .key_len = 16,
                .data =       { 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                                0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                                0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                                0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                                0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                                0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                                0xDD, 0xDD },
                .data_len = 50,
                .hash_len = 4,
                .result =     { 0x56, 0xbe, 0x34, 0x52, 0x1d, 0x14, 0x4c, 0x88,
                                0xdb, 0xb8, 0xc7, 0x33, 0xf0, 0xe8, 0xb3, 0xf6 }
	}, {
	        .key =        { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
                                0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10,
                                0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
                                0x19 },
                .key_len = 25,
                .data =       { 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
                                0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
                                0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
                                0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
                                0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
                                0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
                                0xCD, 0xCD },
                .data_len = 50,
                .hash_len = 4,
                .result =     { 0x69, 0x7e, 0xaf, 0x0a, 0xca, 0x3a, 0x3a, 0xea,
                                0x3a, 0x75, 0x16, 0x47, 0x46, 0xff, 0xaa, 0x79 }
	}, {
	        .key =        { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
                                0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },
                .key_len = 16,
                .data =       { "Test With Truncation" },
                .data_len = 20,
                .hash_len = 4,
                .result =     { 0x56, 0x46, 0x1e, 0xf2, 0x34, 0x2e, 0xdc, 0x00,
                                0xf9, 0xba, 0xb9, 0x95, 0x69, 0x0e, 0xfd, 0x4c}
	}, {
	        .key =        { 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },
                .key_len = 80,
                .data =       { "Test Using Larger Than Block-Size Key - Hash Key First" },
                .data_len = 54,
                .hash_len = 4,
                .result =     { 0x6b, 0x1a, 0xb7, 0xfe, 0x4b, 0xd7, 0xbf, 0x8f,
                                0x0b, 0x62, 0xe6, 0xce, 0x61, 0xb9, 0xd0, 0xcd }
	}, {
	        .key =        { 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
                                0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },
                .key_len = 80,
                .data =       { "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data" },
                .data_len = 73,
                .hash_len = 4,
                .result =     { 0x6f, 0x63, 0x0f, 0xad, 0x67, 0xcd, 0xa0, 0xee,
                                0x1f, 0xb1, 0xf5, 0x62, 0xdb, 0x3a, 0xa5, 0x3e }
	},
};

struct HMAC_TEST_VECTOR sha1_hmac_general_test_vector[] = {
        {
		.key =		{ 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b },
		.key_len = 20,
		.data =		{ "Hi There" },
		.data_len = 8,
		.hash_len = 10,
		.result =	{ 0xb6,0x17,0x31,0x86,0x55,0x05,0x72,0x64,0xe2,
				  0x8b,0xc0,0xb6,0xfb,0x37,0x8c,0x8e,0xf1,0x46,
				  0xbe,0x00 }
	}, {
		.key =		{ 'J', 'e', 'f', 'e' },
		.key_len = 4,
		.data =		{ "what do ya want for nothing?" },
		.data_len = 28,
		.hash_len = 10,
		.result =	{ 0xef,0xfc,0xdf,0x6a,0xe5,0xeb,0x2f,0xa2,0xd2,
				  0x74,0x16,0xd5,0xf1,0x84,0xdf,0x9c,0x25,0x9a,
				  0x7c,0x79 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa },
		.key_len = 20,
		.data =		{ 0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD },
		.data_len = 50,
		.hash_len = 10,
		.result =	{ 0x12,0x5d,0x73,0x42,0xb9,0xac,0x11,0xcd,0x91,
				  0xa3,0x9a,0xf4,0x8a,0xa1,0x7b,0x4f,0x63,0xf1,
				  0x75,0xd3 }
	}, {
		.key =		{ 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,
				  0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,
				  0x13,0x14,0x15,0x16,0x17,0x18,0x19 },
		.key_len = 25,
		.data =		{ 0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD },
		.data_len = 50,
		.hash_len = 10,
		.result =	{ 0x4c,0x90,0x07,0xf4,0x02,0x62,0x50,0xc6,0xbc,
				  0x84,0x14,0xf9,0xbf,0x50,0xc8,0x6c,0x2d,0x72,
				  0x35,0xda }
	}, {
		.key =		{ 0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
				  0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
				  0x0c,0x0c },
		.key_len = 20,
		.data =       { "Test With Truncation" },
		.data_len = 20,
		.hash_len = 10,
		.result =	{ 0x4c,0x1a,0x03,0x42,0x4b,0x55,0xe0,0x7f,0xe7,
				  0xf2,0x7b,0xe1,0xd5,0x8b,0xb9,0x32,0x4a,0x9a,
				  0x5a,0x04 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa },
		.key_len = 80,
		.data =		{ "Test Using Larger Than Block-Size Key - Hash Key First" },
		.data_len = 54,
		.hash_len = 10,
		.result =	{ 0xaa,0x4a,0xe5,0xe1,0x52,0x72,0xd0,0x0e,0x95,
				  0x70,0x56,0x37,0xce,0x8a,0x3b,0x55,0xed,0x40,
				  0x21,0x12 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa },
		.key_len = 80,
		.data =		{ "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data" },
		.data_len = 73,
		.hash_len = 10,
		.result =	{ 0xe8,0xe9,0x9d,0x0f,0x45,0x23,0x7d,0x78,0x6d,
				  0x6b,0xba,0xa7,0x96,0x5c,0x78,0x08,0xbb,0xff,
				  0x1a,0x91 }
	}
};

struct HMAC_TEST_VECTOR sha256_hmac_general_test_vector[] = {
        {
		.key =		{ 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b },
		.key_len = 32,
		.data =		{ "Hi There" },
		.data_len = 8,
		.hash_len = 16,
		.result = 	{ 0x19,0x8a,0x60,0x7e,0xb4,0x4b,0xfb,0xc6,0x99,
				  0x03,0xa0,0xf1,0xcf,0x2b,0xbd,0xc5 }
	}, {
		.key = 		{ 0x4a,0x65,0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,
				  0x65,0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,0x65,
				  0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,0x65,0x66,
				  0x65,0x4a,0x65,0x66,0x65 },
		.key_len = 32, 
		.data =		{ "what do ya want for nothing?" },
		.data_len = 28,
		.hash_len = 16,
		.result = 	{ 0x16,0x7f,0x92,0x85,0x88,0xc5,0xcc,0x2e,0xef,
				  0x8e,0x30,0x93,0xca,0xa0,0xe8,0x7c },
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa },
		.key_len = 32,
		.data =		{ 0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD },
		.data_len = 50,
		.hash_len = 16,
		.result = 	{ 0xcd,0xcb,0x12,0x20,0xd1,0xec,0xcc,0xea,0x91,
				  0xe5,0x3a,0xba,0x30,0x92,0xf9,0x62 }
	}, {
		.key = 		{ 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,
				  0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,
				  0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,
				  0x1c,0x1d,0x1e,0x1f,0x20 },
		.key_len = 32,
		.data =		{ 0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD },
                .data_len = 50,
                .hash_len = 16,
		.result = 	{ 0x37,0x2e,0xfc,0xf9,0xb4,0x0b,0x35,0xc2,0x11,
				  0x5b,0x13,0x46,0x90,0x3d,0x2e,0xf4 }
	}
};

struct HMAC_TEST_VECTOR sha384_hmac_general_test_vector[] = {
        {
		.key =		{ 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b },
		.key_len = 48,
		.data =		{ "Hi There" },
		.data_len = 8,
		.hash_len = 24,
		.result = 	{ 0xb6,0xa8,0xd5,0x63,0x6f,0x5c,0x6a,0x72,0x24,
				  0xf9,0x97,0x7d,0xcf,0x7e,0xe6,0xc7,0xfb,0x6d,
				  0x0c,0x48,0xcb,0xde,0xe9,0x73 }
	}, {
		.key =		{ 0x4a,0x65,0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,
				  0x65,0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,0x65,
				  0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,0x65,0x66,
				  0x65,0x4a,0x65,0x66,0x65,0x4a,0x65,0x66,0x65,
				  0x4a,0x65,0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,
				  0x65,0x66,0x65 },
		.key_len = 48,
		.data =		{ "what do ya want for nothing?" },
		.data_len = 28,
		.hash_len = 24,
		.result = 	{ 0x2c,0x73,0x53,0x97,0x4f,0x18,0x42,0xfd,0x66,
				  0xd5,0x3c,0x45,0x2c,0xa4,0x21,0x22,0xb2,0x8c,
				  0x0b,0x59,0x4c,0xfb,0x18,0x4d }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa },
		.key_len = 48,
		.data =		{ 0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD },
                .data_len = 50,
                .hash_len = 24,
		.result = 	{ 0x80,0x9f,0x43,0x9b,0xe0,0x02,0x74,0x32,0x1d,
				  0x4a,0x53,0x86,0x52,0x16,0x4b,0x53,0x55,0x4a,
				  0x50,0x81,0x84,0xa0,0xc3,0x16 }
	}, {
		.key =		{ 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,
				  0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,
				  0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,
				  0x1c,0x1d,0x1e,0x1f,0x20,0x0a,0x0b,0x0c,0x0d,
				  0x0e,0x0f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,
				  0x17,0x18,0x19 },
		.key_len = 48,
		.data =		{ 0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD, 
				  0xCD,0xCD,0xCD,0xCD,0xCD },
		.data_len = 50,
		.hash_len = 24,
		.result = 	{ 0x5b,0x54,0x00,0x85,0xc6,0xe6,0x35,0x80,0x96,
				  0x53,0x2b,0x24,0x93,0x60,0x9e,0xd1,0xcb,0x29,
				  0x8f,0x77,0x4f,0x87,0xbb,0x5c }
	}
};
			

struct HMAC_TEST_VECTOR sha512_hmac_general_test_vector[] = {
        {
		.key =		{ 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
				  0x0b },
		.key_len = 64,
		.data =		{ "Hi There" },
		.data_len = 8,
		.hash_len = 32,
		.result = 	{ 0x63,0x7e,0xdc,0x6e,0x01,0xdc,0xe7,0xe6,0x74,
				  0x2a,0x99,0x45,0x1a,0xae,0x82,0xdf,0x23,0xda,
				  0x3e,0x92,0x43,0x9e,0x59,0x0e,0x43,0xe7,0x61,
				  0xb3,0x3e,0x91,0x0f,0xb8 }
	}, {
		.key =		{ 0x4a,0x65,0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,
				  0x65,0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,0x65,
				  0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,0x65,0x66,
				  0x65,0x4a,0x65,0x66,0x65,0x4a,0x65,0x66,0x65,
				  0x4a,0x65,0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,
				  0x65,0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,0x65,
				  0x66,0x65,0x4a,0x65,0x66,0x65,0x4a,0x65,0x66,
				  0x65 },
                .key_len = 64,
		.data =		{ "what do ya want for nothing?" },
                .data_len = 28,
		.hash_len = 32, 
		.result = 	{ 0xcb,0x37,0x09,0x17,0xae,0x8a,0x7c,0xe2,0x8c,
				  0xfd,0x1d,0x8f,0x47,0x05,0xd6,0x14,0x1c,0x17,
				  0x3b,0x2a,0x93,0x62,0xc1,0x5d,0xf2,0x35,0xdf,
				  0xb2,0x51,0xb1,0x54,0x54 }
	}, {
		.key =		{ 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
				  0xaa },
		.key_len = 64,
		.data =		{ 0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
				  0xDD,0xDD,0xDD,0xDD,0xDD },
                .data_len = 50,
		.hash_len = 32,
		.result = 	{ 0x2e,0xe7,0xac,0xd7,0x83,0x62,0x4c,0xa9,0x39,
				  0x87,0x10,0xf3,0xee,0x05,0xae,0x41,0xb9,0xf9,
				  0xb0,0x51,0x0c,0x87,0xe4,0x9e,0x58,0x6c,0xc9,
				  0xbf,0x96,0x17,0x33,0xd8 }
	}, {
		.key =		{ 0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,
				  0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,
				  0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,
				  0x1c,0x1d,0x1e,0x1f,0x20,0x21,0x22,0x23,0x24,
				  0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,
				  0x2e,0x2f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,
				  0x37,0x38, 0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
				  0x40 },
		.key_len = 64,
		.data =		{ 0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,
				  0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD,0xCD, 
				  0xCD,0xCD,0xCD,0xCD,0xCD },
		.data_len = 50,
		.hash_len = 32,
		.result = 	{ 0x5e,0x66,0x88,0xe5,0xa3,0xda,0xec,0x82,0x6c,
				  0xa3,0x2e,0xae,0xa2,0x24,0xef,0xf5,0xe7,0x00,
				  0x62,0x89,0x47,0x47,0x0e,0x13,0xad,0x01,0x30,
				  0x25,0x61,0xba,0xb1,0x08 }
	}
};

struct HMAC_TEST_SUITE_INFO {
        const char *name;
        unsigned int tvcount;
        struct HMAC_TEST_VECTOR *tv;
        CK_MECHANISM mech;
};

#define NUM_OF_HMAC_TEST_SUITES 10 
struct HMAC_TEST_SUITE_INFO hmac_test_suites[] = {
        {
                .name = "SHA-1 HMAC",
                .tvcount = 7,
                .tv = sha1_hmac_test_vector,
                .mech = { CKM_SHA_1_HMAC, 0, 0 },
        }, {
                .name = "SHA-256 HMAC",
                .tvcount = 6,
                .tv = sha256_hmac_test_vector,
                .mech = { CKM_SHA256_HMAC, 0, 0 },
        }, {
                .name = "SHA-384 HMAC",
                .tvcount = 6,
                .tv = sha384_hmac_test_vector,
                .mech = { CKM_SHA384_HMAC, 0, 0 },
        }, {
                .name = "SHA-512 HMAC",
                .tvcount = 6,
                .tv = sha512_hmac_test_vector,
                .mech = { CKM_SHA512_HMAC, 0, 0 },
        }, {
                .name = "MD5 HMAC",
                .tvcount = 7,
                .tv = md5_hmac_test_vector,
                .mech = { CKM_MD5_HMAC, 0, 0 },
        }, {
                .name = "SHA-1 HMAC General",
                .tvcount = 7,
                .tv = sha1_hmac_general_test_vector,
                .mech = { CKM_SHA_1_HMAC_GENERAL, &ten, sizeof(CK_ULONG) },
        }, {
                .name = "SHA-256 HMAC General",
                .tvcount = 4,
                .tv = sha256_hmac_general_test_vector,
                .mech = { CKM_SHA256_HMAC_GENERAL, &sixteen, sizeof(CK_ULONG) },
        }, {
                .name = "SHA-384 HMAC General",
                .tvcount = 4,
                .tv = sha384_hmac_general_test_vector,
                .mech = {CKM_SHA384_HMAC_GENERAL,&twentyfour,sizeof(CK_ULONG)},
        }, {
                .name = "SHA-512 HMAC General",
                .tvcount = 4,
                .tv = sha512_hmac_general_test_vector,
                .mech = { CKM_SHA512_HMAC_GENERAL,&thirtytwo,sizeof(CK_ULONG) },
        }, {
                .name = "MD5 HMAC General",
                .tvcount = 7,
                .tv = md5_hmac_general_test_vector,
                .mech = { CKM_MD5_HMAC_GENERAL, &four, sizeof(CK_ULONG) },
        }
};
