//
/*
             Common Public License Version 0.5
 
             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 
             1. DEFINITIONS
 
             "Contribution" means:
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and
 
                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;
 
                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.
 
 
             "Contributor" means any person or entity that distributes
             the Program.
 
             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program.
 
             "Program" means the Contributions distributed in
             accordance with this Agreement.
             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.
 
             2. GRANT OF RIGHTS
 
                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.
 
                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.
 
                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.
 
                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.
 
             3. REQUIREMENTS
 
             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and
 
                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;
 
                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;
 
                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and
 
                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program.
 
             Contributors may not remove or alter any copyright notices
             contained within the Program.
 
             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution.
 
 
             4. COMMERCIAL DISTRIBUTION
 
             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.

             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.
 
 
             5. NO WARRANTY
 
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations.
 
             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL
 
             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.
 
 
             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.
 
             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive.
 
             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.
 
             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation.
 
*/

/************************************************************************
*                                                                       *
*      Copyright:       Corrent Corporation (c) 2000-2003               *
*                                                                       *
*      Filename:        dh_func.c                                       *
*      Created By:      Kapil Sood                                      *
*      Created On:      April 28, 2003                                  *
*      Description:     This is the file for testing Diffie-Hellman     *
*                       key pair generation and shared key derivation   *
*                       operations.                                     *
*                                                                       *
************************************************************************/

// File: dh_func.c
//

#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include "pkcs11types.h"
#include "regress.h"


// These values were obtained from IPsec second oakley group.
// These values are in big-endian format.
// These are required for generating DH keys and secrets.

CK_BYTE DH_PUBL_PRIME[128] =  {	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC9,
				0x0F,0xDA,0xA2,0x21,0x68,0xC2,0x34,0xC4,0xC6,
				0x62,0x8B,0x80,0xDC,0x1C,0xD1,0x29,0x02,0x4E,
				0x08,0x8A,0x67,0xCC,0x74,0x02,0x0B,0xBE,0xA6,
				0x3B,0x13,0x9B,0x22,0x51,0x4A,0x08,0x79,0x8E,
				0x34,0x04,0xDD,0xEF,0x95,0x19,0xB3,0xCD,0x3A,
				0x43,0x1B,0x30,0x2B,0x0A,0x6D,0xF2,0x5F,0x14,
				0x37,0x4F,0xE1,0x35,0x6D,0x6D,0x51,0xC2,0x45,
				0xE4,0x85,0xB5,0x76,0x62,0x5E,0x7E,0xC6,0xF4,
				0x4C,0x42,0xE9,0xA6,0x37,0xED,0x6B,0x0B,0xFF,
				0x5C,0xB6,0xF4,0x06,0xB7,0xED,0xEE,0x38,0x6B,
				0xFB,0x5A,0x89,0x9F,0xA5,0xAE,0x9F,0x24,0x11,
				0x7C,0x4B,0x1F,0xE6,0x49,0x28,0x66,0x51,0xEC,
				0xE6,0x53,0x81,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
				0xFF,0xFF };

CK_BYTE DH_PUBL_BASE[128] =   {	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
				0x00,0x02 };

/*
 * Generate DH key-pairs for parties A and B.
 * Derive keys based on Diffie Hellman key agreement defined in PKCS#3.
 *
 */
CK_RV do_DeriveDHKey(void)
{
	CK_SESSION_HANDLE   session;
	CK_MECHANISM        mech;
	CK_OBJECT_HANDLE    publ_key, priv_key;
	CK_OBJECT_HANDLE    peer_publ_key, peer_priv_key;
	CK_OBJECT_HANDLE    secret_key, peer_secret_key;
	CK_FLAGS            flags;
	CK_BYTE             user_pin[PKCS11_MAX_PIN_LEN];
	CK_ULONG            user_pin_len;
	CK_RV               rc = CKR_OK, loc_rc = CKR_OK;

	int i = 0;
	CK_BYTE clear    [32];
	CK_BYTE cipher   [32];
	CK_BYTE re_cipher[32];
	CK_ULONG cipher_len = 32;
	CK_ULONG re_cipher_len = 32;
	CK_BBOOL ltrue = 1;

	CK_OBJECT_CLASS     pub_key_class  = CKO_PUBLIC_KEY ;
	CK_KEY_TYPE         key_type   = CKK_DH ;
	CK_UTF8CHAR	    publ_label[] = "A DH public key object";
	CK_OBJECT_CLASS     priv_key_class = CKO_PRIVATE_KEY ;
        CK_UTF8CHAR	    priv_label[] = "A DH private key object";

	CK_ULONG secret_key_size = sizeof(DH_PUBL_PRIME);
	CK_OBJECT_CLASS secret_key_class = CKO_SECRET_KEY;
	CK_KEY_TYPE secret_key_type = CKK_GENERIC_SECRET;
	CK_UTF8CHAR secret_label[] = "A generic secret key object";

	CK_BYTE key1_value[sizeof(DH_PUBL_PRIME)*2];
	CK_BYTE key2_value[sizeof(DH_PUBL_PRIME)*2];

	CK_ATTRIBUTE  publ_tmpl[] =
	{
		{CKA_CLASS, &pub_key_class, sizeof(pub_key_class)},
		{CKA_KEY_TYPE, &key_type, sizeof(key_type)},
		{CKA_LABEL, publ_label, sizeof(publ_label)-1},
		{CKA_PRIME, DH_PUBL_PRIME, sizeof(DH_PUBL_PRIME)},
		{CKA_BASE, DH_PUBL_BASE, sizeof(DH_PUBL_BASE)}
	};

	CK_ATTRIBUTE  priv_tmpl[] =
	{
		{CKA_CLASS, &priv_key_class, sizeof(priv_key_class)},
		{CKA_KEY_TYPE, &key_type, sizeof(key_type)},
		{CKA_LABEL, priv_label, sizeof(priv_label)-1},
		{CKA_DERIVE, &ltrue, sizeof(ltrue) }
	};

	CK_ATTRIBUTE  secret_tmpl[] =
	{
		{CKA_CLASS, &secret_key_class, sizeof(secret_key_class)},
		{CKA_KEY_TYPE, &secret_key_type, sizeof(secret_key_type)},
		{CKA_VALUE_LEN, &secret_key_size, sizeof(secret_key_size)},
		{CKA_LABEL, secret_label, sizeof(secret_label)-1}
	};

	CK_ATTRIBUTE  extr1_tmpl[] =
	{
		{CKA_VALUE, key1_value, sizeof(key1_value)}
	};

	CK_ATTRIBUTE  extr2_tmpl[] =
	{
		{CKA_VALUE, key2_value, sizeof(key2_value)}
	};

	testcase_begin("starting do_DeriveDHKey...");
	testcase_rw_session();
	testcase_user_login();

	// Testcase #1 - Generate 2 DH key pairs.
	testcase_new_assertion();

	// First, generate the DH key Pair for Party A
	mech.mechanism = CKM_DH_PKCS_KEY_PAIR_GEN;
	mech.ulParameterLen = 0;
	mech.pParameter = NULL;

	rc = funcs->C_GenerateKeyPair(session, &mech, publ_tmpl, 5,
					priv_tmpl, 4, &publ_key, &priv_key);
	if (rc != CKR_OK) {
		testcase_fail("C_GenerateKeyPair #1: rc = %s", p11_get_ckr(rc));
		goto testcase_cleanup;
	}

	// Now generate a key-pair for party B (the peer)
	mech.mechanism = CKM_DH_PKCS_KEY_PAIR_GEN;
	mech.ulParameterLen = 0;
	mech.pParameter = NULL;

	rc = funcs->C_GenerateKeyPair(session, &mech, publ_tmpl, 5,
				priv_tmpl, 4, &peer_publ_key, &peer_priv_key);
	if (rc != CKR_OK) {
		testcase_fail("C_GenerateKeyPair #2: rc = %s", p11_get_ckr(rc));
		goto testcase_cleanup;
	}

	// Extract the peer's public key
	rc = funcs->C_GetAttributeValue(session, peer_publ_key, extr1_tmpl, 1);
	if (rc != CKR_OK) {
		testcase_error("C_GetAttributeValue #1: rc = %s", p11_get_ckr(rc));
		goto testcase_cleanup;
	}

	// Make sure peer's key is the right size
	if ((extr1_tmpl[0].ulValueLen != sizeof(DH_PUBL_PRIME)) &&
	    (extr1_tmpl[0].ulValueLen != sizeof(DH_PUBL_PRIME)-1)) {
		testcase_fail("ERROR:size error peer's key %ld\n",extr1_tmpl[0].ulValueLen );
		goto testcase_cleanup;
	} else
		testcase_pass("Successfully derived key.\n");

	// Testcase #2 - Now derive the secrets...
	if (!securekey) {
		// Note: this is a clear key token testcase since comparing
		//       key values.
		testcase_new_assertion();

		/* Now, derive a generic secret key using party A's
		 * private key and peer's public key
		 */
		mech.mechanism  = CKM_DH_PKCS_DERIVE;
		mech.ulParameterLen = extr1_tmpl[0].ulValueLen ;
		mech.pParameter = key1_value;

		rc = funcs->C_DeriveKey(session, &mech, priv_key, secret_tmpl,
					4, &secret_key) ;
		if (rc != CKR_OK) {
			testcase_fail("C_DeriveKey #1: rc = %s", p11_get_ckr(rc));
			goto testcase_cleanup;
		}

		// Do the same for the peer

		// Extract party A's public key
		rc = funcs->C_GetAttributeValue(session, publ_key,
						 extr2_tmpl, 1);
		if (rc != CKR_OK) {
			testcase_error("C_GetAttributeValue #2: rc = %s",
					p11_get_ckr(rc));
			goto testcase_cleanup;
		}

		// Make sure party A's key is the right size
		if ((extr2_tmpl[0].ulValueLen != sizeof(DH_PUBL_PRIME)) &&
			(extr2_tmpl[0].ulValueLen != sizeof(DH_PUBL_PRIME)-1)) {
			testcase_fail("ERROR:size error party A's key %ld\n",extr2_tmpl[0].ulValueLen);
			goto testcase_cleanup;
		}

		// Now, derive a generic secret key using peer's private key
		// and A's public key
		mech.mechanism = CKM_DH_PKCS_DERIVE;
		mech.ulParameterLen = extr2_tmpl[0].ulValueLen;
		mech.pParameter = key2_value;

		rc = funcs->C_DeriveKey(session, &mech, peer_priv_key,
					secret_tmpl, 4, &peer_secret_key);
		if (rc != CKR_OK) {
			testcase_fail("C_DeriveKey #2: rc = %s",
					p11_get_ckr(rc));
			goto testcase_cleanup;
		}

		// Extract the derived keys and compare them

		memset(key1_value,0,sizeof(key1_value));
		extr1_tmpl[0].ulValueLen= sizeof(key1_value);

		rc = funcs->C_GetAttributeValue(session, secret_key,
						extr1_tmpl, 1);
		if (rc != CKR_OK) {
			testcase_error("C_GetAttributeValue #3:rc = %s",
					p11_get_ckr(rc));
			goto testcase_cleanup;
		}

		if (extr1_tmpl[0].ulValueLen != sizeof(DH_PUBL_PRIME) ||
			*((int*)extr1_tmpl[0].pValue) == 0) {
			testcase_fail("ERROR:derived key #1 length or value %ld\n", extr1_tmpl[0].ulValueLen );
			goto testcase_cleanup;
		}

		memset(key2_value,0,sizeof(key2_value));
		extr2_tmpl[0].ulValueLen= sizeof(key2_value);

		rc = funcs->C_GetAttributeValue(session, peer_secret_key,
						extr2_tmpl, 1);
		if (rc != CKR_OK) {
			testcase_error("C_GetAttributeValue #4:rc = %s",
					p11_get_ckr(rc));
			goto testcase_cleanup;
		}

		if (extr2_tmpl[0].ulValueLen != sizeof(DH_PUBL_PRIME) ||
			*((int*)extr2_tmpl[0].pValue) == 0) {
			testcase_fail("ERROR:derived key #2 length or value %ld\n", extr2_tmpl[0].ulValueLen );
			goto testcase_cleanup;
		}

		if (memcmp(key1_value, key2_value, sizeof(DH_PUBL_PRIME)) != 0){
			testcase_fail("ERROR:derived key mismatch\n");
			goto testcase_cleanup;
		}

		testcase_pass("Generating DH key pairs and deriving secrets");

		goto testcase_cleanup;

	} else {

		// Testcase for secure key token - encode/decode with secrect key and peer secret key
		testcase_new_assertion();

		secret_key_size = 32;
		secret_key_type = CKK_AES;
		for (i = 0; i < 32; i++)
			clear[i] = i;

		/* Now, derive a generic secret key using party A's
		 * private key and peer's public key
		 */
		mech.mechanism  = CKM_DH_PKCS_DERIVE;
		mech.ulParameterLen = extr1_tmpl[0].ulValueLen ;
		mech.pParameter = key1_value;

		rc = funcs->C_DeriveKey(session, &mech, priv_key, secret_tmpl,
					4, &secret_key) ;
		if (rc != CKR_OK) {
			testcase_fail("C_DeriveKey #1: rc = %s", p11_get_ckr(rc));
			goto testcase_cleanup;
		}

		// Do the same for the peer

		// Extract party A's public key
		rc = funcs->C_GetAttributeValue(session, publ_key, extr2_tmpl, 1);
		if (rc != CKR_OK) {
			testcase_error("C_GetAttributeValue #2: rc = %s",
					p11_get_ckr(rc));
			goto testcase_cleanup;
		}

		// Make sure party A's key is the right size
		if ((extr2_tmpl[0].ulValueLen != sizeof(DH_PUBL_PRIME)) &&
			(extr2_tmpl[0].ulValueLen != sizeof(DH_PUBL_PRIME)-1)) {
			testcase_fail("ERROR:size error party A's key %ld\n",extr2_tmpl[0].ulValueLen);
			goto testcase_cleanup;
		}

		// Now, derive a generic secret key using peer's private key
		// and A's public key
		mech.mechanism = CKM_DH_PKCS_DERIVE;
		mech.ulParameterLen = extr2_tmpl[0].ulValueLen;
		mech.pParameter = key2_value;

		rc = funcs->C_DeriveKey(session, &mech, peer_priv_key,
					secret_tmpl, 4, &peer_secret_key);
		if (rc != CKR_OK) {
			testcase_fail("C_DeriveKey #2: rc = %s", p11_get_ckr(rc));
			goto testcase_cleanup;
		}

		// Extract the derived keys and compare them

		mech.mechanism = CKM_AES_ECB;
		mech.ulParameterLen = 0;
		mech.pParameter = NULL;

		rc = funcs->C_EncryptInit(session,&mech,secret_key);
		if (rc != CKR_OK) {
			testcase_error("C_EncryptInit secret_key: rc = %s",
					p11_get_ckr(rc));
			goto testcase_cleanup;
		}

		rc = funcs->C_Encrypt(session, clear, 32, cipher, &cipher_len);
		if (rc != CKR_OK) {
			testcase_error("C_Encrypt secret_key: rc = %s",
					p11_get_ckr(rc));
			goto testcase_cleanup;
		}

		rc = funcs->C_DecryptInit(session, &mech, peer_secret_key);
		if (rc != CKR_OK) {
			testcase_error("C_DecryptInit peer_secret_key: rc = %s",
					p11_get_ckr(rc));
			goto testcase_cleanup;
		}

		rc = funcs->C_Decrypt(session, cipher, cipher_len, re_cipher,
					&re_cipher_len);
		if (rc != CKR_OK) {
			testcase_error("C_Decrypt peer secret_key: rc = %s",
					p11_get_ckr(rc));
			goto testcase_cleanup;
		}

		if (memcmp(clear, re_cipher, 32) != 0) {
			testcase_fail("ERROR:data mismatch\n");
			goto testcase_cleanup;
		}

		testcase_pass("Generating DH key pairs and deriving secrets");
	}

testcase_cleanup:
	funcs->C_DestroyObject(session, publ_key);
	funcs->C_DestroyObject(session, priv_key);
	funcs->C_DestroyObject(session, peer_priv_key);
	funcs->C_DestroyObject(session, peer_publ_key);
	funcs->C_DestroyObject(session, secret_key);
	funcs->C_DestroyObject(session, peer_secret_key);

	loc_rc = funcs->C_CloseSession(session);
	if (loc_rc != CKR_OK)
		testcase_error("C_CloseSession, loc_rc = %s", p11_get_ckr(loc_rc));
	return rc;
} /* end do_DeriveDHKey() */

CK_RV dh_functions()
{
	CK_RV  rv, rv2;
	CK_MECHANISM_INFO mechinfo;

	/** get mech info **/
	rv = funcs->C_GetMechanismInfo(SLOT_ID, CKM_DH_PKCS_KEY_PAIR_GEN,
					&mechinfo);
	rv2 = funcs->C_GetMechanismInfo(SLOT_ID, CKM_DH_PKCS_DERIVE, &mechinfo);

	if ((rv == CKR_OK) && (rv2 == CKR_OK))
		rv = do_DeriveDHKey();
	else
		rv = CKR_MECHANISM_INVALID;

	return rv;
}

int main(int argc, char **argv)
{
	CK_C_INITIALIZE_ARGS cinit_args;
	int rc;
	CK_RV rv;
	
	rc = do_ParseArgs(argc, argv);
	if ( rc != 1)
		return rc;

	printf("Using slot #%lu...\n\n", SLOT_ID );
	printf("With option: no_init: %d\n", no_init);

	rc = do_GetFunctionList();
	if (!rc) {
		PRINT_ERR("ERROR do_GetFunctionList() Failed , rc = 0x%0x\n", rc);
		return rc;
	}
	
	memset( &cinit_args, 0x0, sizeof(cinit_args) );
	cinit_args.flags = CKF_OS_LOCKING_OK;

	// SAB Add calls to ALL functions before the C_Initialize gets hit

	funcs->C_Initialize( &cinit_args );

	{
		CK_SESSION_HANDLE  hsess = 0;

		rc = funcs->C_GetFunctionStatus(hsess);
		if (rc  != CKR_FUNCTION_NOT_PARALLEL)  
			return rc;

		rc = funcs->C_CancelFunction(hsess);
		if (rc  != CKR_FUNCTION_NOT_PARALLEL)
			return rc;

	}

	rv = dh_functions();
	/* make sure we return non-zero if rv is non-zero */
	return ((rv==0) || (rv % 256) ? rv : -1);
}

