/*
 * $Header: /cvsroot/opencryptoki/opencryptoki/usr/lib/pkcs11/common/defs.h,v 1.5 2008/07/16 22:27:48 mhalcrow Exp $
 */

//
/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001,2002          */


// File:  defs.h
//
// Contains various definitions needed by both the host-side
// and coprocessor-side code.
//

#ifndef _DEFS_H
#define _DEFS_H

#if (LEEDS)
  #pragma pack(1)
  #pragma options align=packed
#endif

#if (LEEDS)
#include <linuxdef.h>
#else
#define PACK_DATA
#endif


#define MAX_SESSION_COUNT     64
#define MAX_PIN_LEN           8
#define MIN_PIN_LEN           4

#define MAX_SLOT_ID           10

#define LEEDS_MAX_REQ_LEN     4096

#ifndef MIN
  #define MIN(a, b)  ((a) < (b) ? (a) : (b))
#endif

// the following constants are used for sccSignOn
//
#define PKCS_11_PRG_ID         "pkcs11 2.01"
#define PKCS_11_DEVELOPER_ID   0xE
#define PKCS_11_VERSION        1
#define PKCS_11_INSTANCE       0
#define PKCS_11_QUEUE          0
#define LEEDS_PRG_ID_PKCS_11   "PKCS11"

// the following are "boolean" attributes
//
#define CKA_IBM_TWEAK_ALLOW_KEYMOD    0x80000001
#define CKA_IBM_TWEAK_ALLOW_WEAK_DES  0x80000002
#define CKA_IBM_TWEAK_DES_PARITY_CHK  0x80000003
#define CKA_IBM_TWEAK_NETSCAPE        0x80000004

#define MODE_COPY       (1 << 0)
#define MODE_CREATE     (1 << 1)
#define MODE_KEYGEN     (1 << 2)
#define MODE_MODIFY     (1 << 3)
#define MODE_DERIVE     (1 << 4)
#define MODE_UNWRAP     (1 << 5)

// RSA block formatting types
//
#define PKCS_BT_1       1
#define PKCS_BT_2       2

#define OP_ENCRYPT_INIT 1
#define OP_DECRYPT_INIT 2
#define OP_WRAP         3
#define OP_UNWRAP       4
#define OP_SIGN_INIT    5
#define OP_VERIFY_INIT  6

// saved-state identifiers
//
enum {
   STATE_INVALID = 0,
   STATE_ENCR,
   STATE_DECR,
   STATE_DIGEST,
   STATE_SIGN,
   STATE_VERIFY
};


#define ENCRYPT	1
#define DECRYPT 0

#define MAX_RSA_KEYLEN		512

#define MAX_AES_KEY_SIZE	64	/* encompasses CCA key size */
#define AES_KEY_SIZE_256	32
#define AES_KEY_SIZE_192	24
#define AES_KEY_SIZE_128	16
#define AES_BLOCK_SIZE		16
#define AES_INIT_VECTOR_SIZE	AES_BLOCK_SIZE
#define AES_COUNTER_SIZE        16

#define MAX_DES_KEY_SIZE	64	/* encompasses CCA key size */
#define DES_KEY_SIZE    8
#define DES_BLOCK_SIZE  8

/*
 * It should be able to keep any kind of key (AES, 3DES, etc) and also
 * a PBKDF key
 */
#define MAX_KEY_SIZE 96

#define SHA1_HASH_SIZE  20
#define SHA1_BLOCK_SIZE 64
#define SHA1_BLOCK_SIZE_MASK (SHA1_BLOCK_SIZE - 1)
#define SHA2_HASH_SIZE  32
#define SHA2_BLOCK_SIZE 64
#define SHA2_BLOCK_SIZE_MASK (SHA2_BLOCK_SIZE - 1)
#define SHA3_HASH_SIZE  48
#define SHA3_BLOCK_SIZE 128
#define SHA3_BLOCK_SIZE_MASK (SHA3_BLOCK_SIZE - 1)
#define SHA5_HASH_SIZE  64
#define SHA5_BLOCK_SIZE 128
#define SHA5_BLOCK_SIZE_MASK (SHA5_BLOCK_SIZE - 1)
#define MAX_SHA_HASH_SIZE SHA5_HASH_SIZE
#define MAX_SHA_BLOCK_SIZE SHA5_BLOCK_SIZE

#ifndef PATH_MAX
#define PATH_MAX 4096
#endif

struct oc_sha_ctx {
   unsigned char hash[MAX_SHA_HASH_SIZE + 1];
   unsigned int hash_len, tail_len;
   int message_part; /* needs to be seen across calls to update and final */
   unsigned char tail[MAX_SHA_BLOCK_SIZE]; /* save the last (up to) block-size
				           * bytes which may need to be shaved */
   void *dev_ctx;
};

#define MD2_HASH_SIZE   16
#define MD2_BLOCK_SIZE  48

#define MD5_HASH_SIZE   16
#define MD5_BLOCK_SIZE  64

#define DSA_SIGNATURE_SIZE  40

#define DEFAULT_SO_PIN  "87654321"

#define MAX_TOK_OBJS 2048


typedef enum {
   ALL = 1,
   PRIVATE,
   PUBLIC
} SESS_OBJ_TYPE;

#if (LEEDS_BUILD)

enum cmdconst {
   FIRST_ENTRY = 0,
   DUMMYFUNCTION = 1,
   FCVFUNCTION,
   UPDATETWEAKVALUES,
   QUERYTWEAKVALUES,

   PK_DES_KEYGEN,
   PK_CDMF_KEYGEN,
   PK_CDMF_TRANSFORM_KEY,
   PK_RSA_KEYPAIR_GEN,
   PK_DSA_KEYPAIR_GEN,

   PK_GENERATE_RND,

   PK_DES_ECB_ENCRYPT,
   PK_DES_ECB_DECRYPT,
   PK_DES_CBC_ENCRYPT,
   PK_DES_CBC_DECRYPT,

   PK_DES3_ECB_ENCRYPT,
   PK_DES3_ECB_DECRYPT,
   PK_DES3_CBC_ENCRYPT,
   PK_DES3_CBC_DECRYPT,

   PK_RSA_ENCRYPT,
   PK_RSA_DECRYPT,

   PK_DSA_SIGN,
   PK_DSA_VERIFY,

   PK_SHA1_DIGEST,
   PK_SHA1_UPDATE,
   PK_SHA1_FINAL,

   LAST_ENTRY
};


typedef struct _LEEDS_REQUEST
{
   CK_ULONG    pid;
   CK_ULONG    req_len;      // size of request data
   CK_ULONG    repl_max[4];
   // any command-specific request data gets appended here
   //
} PACK_DATA LEEDS_REQUEST;

typedef struct _LEEDS_REPLY
{
   CK_RV     rc;
   CK_ULONG  repl_len[4];   // size of data
   // any command-specific reply data gets appended here
   //
} PACK_DATA LEEDS_REPLY;

#endif

// this is a flattened version of the CK_SSL3_RANDOM_DATA
//
typedef struct _SSL3_RANDOM_DATA
{
   CK_ULONG    client_data_len;
   CK_ULONG    server_data_len;
   // client data is appended here
   // server data is appended here
   //
} PACK_DATA SSL3_RANDOM_DATA;


//
//
typedef struct _SSL3_MASTER_KEY_DERIVE_PARAMS
{
   CK_VERSION  version;
   CK_ULONG    client_data_len;
   CK_ULONG    server_data_len;
   // client data is appended here
   // server data is appended here
   //
} PACK_DATA SSL3_MASTER_KEY_DERIVE_PARAMS;


//
//
typedef struct _SSL3_KEY_MAT_OUT
{
   CK_OBJECT_HANDLE  client_mac_secret;
   CK_OBJECT_HANDLE  server_mac_secret;
   CK_OBJECT_HANDLE  client_key;
   CK_OBJECT_HANDLE  server_key;
   CK_ULONG          iv_len; // in bytes
   // client IV is appended here
   // server IV is appended here
   //
} PACK_DATA SSL3_KEY_MAT_OUT;


//
//
typedef struct _SSL3_KEY_MAT_PARAMS
{
   CK_ULONG mac_size_bits;
   CK_ULONG key_size_bits;
   CK_ULONG iv_size_bits;
   CK_BBOOL export;
   CK_ULONG client_data_len;
   CK_ULONG server_data_len;
   // client data is appended here
   // server data is appended here
   //
} PACK_DATA SSL3_KEY_MAT_PARAMS;


typedef struct _DL_NODE
{
   struct _DL_NODE   *next;
   struct _DL_NODE   *prev;
   void              *data;
} DL_NODE;



// Token local
//
#define PK_LITE_DIR token_specific.token_directory
#define PK_DIR PK_LITE_DIR
#define SUB_DIR token_specific.token_subdir
#define DBGTAG token_specific.token_debug_tag

#define PK_LITE_NV   "NVTOK.DAT"
#define PK_LITE_OBJ_DIR "TOK_OBJ"
#define PK_LITE_OBJ_IDX "OBJ.IDX"

#define DEL_CMD "/bin/rm -f"

#if  (LEEDS)
  #pragma options align=full
  #pragma pack() 
#endif

#endif
