/*
 * $Header: /cvsroot/opencryptoki/opencryptoki/usr/include/pkcs11/stdll.h,v 1.2 2005/02/22 20:47:40 mhalcrow Exp $
 */

//
/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001          */


//
//  API Local control blocks within the PKCS11 Meta API
//
//
//


#include <pkcs11types.h>
#include <limits.h>
#include <local_types.h>
#include <slotmgr.h>

#ifndef _STDLL_H
#define _STDLL_H



typedef struct {
   CK_SLOT_ID  slotID;
   CK_SESSION_HANDLE  sessionh;
} ST_SESSION_T ;


typedef ST_SESSION_T ST_SESSION_HANDLE;

/* CK_FUNCTION_LIST is a structure holding a Cryptoki spec
 * version and pointers of appropriate types to all the
 * Cryptoki functions */
/* CK_FUNCTION_LIST is new for v2.0 */



typedef CK_RV (CK_PTR ST_C_Initialize)
   (void **ppFunctionList,CK_SLOT_ID slotID,CK_CHAR_PTR pCorrelator,
    CK_CHAR_PTR pConfName);

typedef CK_RV	(CK_PTR  ST_C_Finalize)
						(CK_VOID_PTR pReserved);
typedef CK_RV	(CK_PTR  ST_C_Terminate)
						(void);
typedef CK_RV	(CK_PTR  ST_C_GetInfo)
						(CK_INFO_PTR pInfo);
typedef CK_RV	(CK_PTR  ST_C_GetFunctionList)
						(CK_FUNCTION_LIST_PTR_PTR ppFunctionList);
typedef CK_RV	(CK_PTR  ST_C_GetSlotList)
						(CK_BBOOL tokenPresent, CK_SLOT_ID_PTR pSlotList,
						 CK_ULONG_PTR pusCount);
typedef CK_RV	(CK_PTR  ST_C_GetSlotInfo)
						(CK_SLOT_ID slotID, CK_SLOT_INFO_PTR pInfo);
typedef CK_RV	(CK_PTR  ST_C_GetTokenInfo)
						(CK_SLOT_ID slotID, CK_TOKEN_INFO_PTR pInfo);
typedef CK_RV	(CK_PTR  ST_C_GetMechanismList)
						(CK_SLOT_ID slotID, CK_MECHANISM_TYPE_PTR pMechanismList,
						 CK_ULONG_PTR pusCount);
typedef CK_RV	(CK_PTR  ST_C_GetMechanismInfo)
						(CK_SLOT_ID slotID, CK_MECHANISM_TYPE type,
						 CK_MECHANISM_INFO_PTR pInfo);
typedef CK_RV	(CK_PTR  ST_C_InitToken)
						(CK_SLOT_ID slotID, CK_CHAR_PTR pPin, CK_ULONG usPinLen,
						 CK_CHAR_PTR pLabel);
typedef CK_RV	(CK_PTR  ST_C_InitPIN)
						(ST_SESSION_T *hSession, CK_CHAR_PTR pPin,
						 CK_ULONG usPinLen);
typedef CK_RV	(CK_PTR  ST_C_SetPIN)
						(ST_SESSION_T *hSession, CK_CHAR_PTR pOldPin,
						 CK_ULONG usOldLen, CK_CHAR_PTR pNewPin,
						 CK_ULONG usNewLen);

// typedef CK_RV	(CK_PTR  ST_C_OpenSession)
// 						(CK_SLOT_ID slotID, CK_FLAGS flags,
// 						 CK_VOID_PTR pApplication,
// 						 CK_RV  (*Notify) (CK_SESSION_HANDLE hSession,
// 						 CK_NOTIFICATION event, CK_VOID_PTR pApplication),
// 						 CK_SESSION_HANDLE_PTR phSession);

typedef CK_RV	(CK_PTR  ST_C_OpenSession)
						(CK_SLOT_ID slotID, CK_FLAGS flags,
						 CK_SESSION_HANDLE_PTR phSession);

typedef CK_RV	(CK_PTR  ST_C_CloseSession)
						(ST_SESSION_T *hSession);
typedef CK_RV	(CK_PTR  ST_C_CloseAllSessions)
						(CK_SLOT_ID slotID);
typedef CK_RV	(CK_PTR  ST_C_GetSessionInfo)
						(ST_SESSION_T *hSession, CK_SESSION_INFO_PTR pInfo);
typedef CK_RV	(CK_PTR  ST_C_GetOperationState)
						(ST_SESSION_T *hSession, CK_BYTE_PTR pOperationState,
						 CK_ULONG_PTR pulOperationStateLen);
typedef CK_RV	(CK_PTR  ST_C_SetOperationState)
						(ST_SESSION_T *hSession, CK_BYTE_PTR pOperationState,
						 CK_ULONG ulOperationStateLen,
						 CK_OBJECT_HANDLE hEncryptionKey,
						 CK_OBJECT_HANDLE hAuthenticationKey);
typedef CK_RV	(CK_PTR  ST_C_Login)(ST_SESSION_T *hSession,
						 CK_USER_TYPE userType, CK_CHAR_PTR pPin,
						 CK_ULONG usPinLen);
typedef CK_RV	(CK_PTR  ST_C_Logout)(ST_SESSION_T *hSession);
typedef CK_RV	(CK_PTR  ST_C_CreateObject)
						(ST_SESSION_T *hSession, CK_ATTRIBUTE_PTR pTemplate,
						 CK_ULONG usCount, CK_OBJECT_HANDLE_PTR phObject);

typedef CK_RV	(CK_PTR  ST_C_CopyObject)
						(ST_SESSION_T *hSession, CK_OBJECT_HANDLE hObject,
						 CK_ATTRIBUTE_PTR pTemplate, CK_ULONG usCount,
						 CK_OBJECT_HANDLE_PTR phNewObject);
typedef CK_RV (CK_PTR  ST_C_DestroyObject)
                       (ST_SESSION_T *hSession, CK_OBJECT_HANDLE hObject);
typedef CK_RV(CK_PTR  ST_C_GetObjectSize)
                       (ST_SESSION_T *hSession, CK_OBJECT_HANDLE hObject,
                        CK_ULONG_PTR pusSize);
typedef CK_RV(CK_PTR  ST_C_GetAttributeValue)
                       (ST_SESSION_T *hSession, CK_OBJECT_HANDLE hObject,
                        CK_ATTRIBUTE_PTR pTemplate, CK_ULONG usCount);
typedef CK_RV(CK_PTR  ST_C_SetAttributeValue)
                       (ST_SESSION_T *hSession, CK_OBJECT_HANDLE hObject,
                        CK_ATTRIBUTE_PTR pTemplate, CK_ULONG usCount);
typedef CK_RV (CK_PTR  ST_C_FindObjectsInit)
                       (ST_SESSION_T *hSession, CK_ATTRIBUTE_PTR pTemplate,
                        CK_ULONG usCount);
typedef CK_RV (CK_PTR  ST_C_FindObjects)
                       (ST_SESSION_T *hSession,
                        CK_OBJECT_HANDLE_PTR phObject, CK_ULONG usMaxObjectCount,
                        CK_ULONG_PTR pusObjectCount);
typedef CK_RV (CK_PTR  ST_C_FindObjectsFinal)
                       (ST_SESSION_T *hSession);
typedef CK_RV (CK_PTR  ST_C_EncryptInit)
                       (ST_SESSION_T *hSession, CK_MECHANISM_PTR pMechanism,
                        CK_OBJECT_HANDLE hKey);
typedef CK_RV (CK_PTR  ST_C_Encrypt)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pData,
                        CK_ULONG usDataLen, CK_BYTE_PTR pEncryptedData,
                        CK_ULONG_PTR pusEncryptedDataLen);
typedef CK_RV (CK_PTR  ST_C_EncryptUpdate)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pPart,
                        CK_ULONG usPartLen, CK_BYTE_PTR pEncryptedPart,
                        CK_ULONG_PTR pusEncryptedPartLen);
typedef CK_RV (CK_PTR  ST_C_EncryptFinal)
                       (ST_SESSION_T *hSession,
                        CK_BYTE_PTR pLastEncryptedPart,
                        CK_ULONG_PTR pusLastEncryptedPartLen);
typedef CK_RV (CK_PTR  ST_C_DecryptInit)
                       (ST_SESSION_T *hSession, CK_MECHANISM_PTR pMechanism,
                        CK_OBJECT_HANDLE hKey);
typedef CK_RV (CK_PTR  ST_C_Decrypt)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pEncryptedData,
                        CK_ULONG usEncryptedDataLen, CK_BYTE_PTR pData,
                        CK_ULONG_PTR pusDataLen);
typedef CK_RV (CK_PTR  ST_C_DecryptUpdate)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pEncryptedPart,
                        CK_ULONG usEncryptedPartLen, CK_BYTE_PTR pPart,
                        CK_ULONG_PTR pusPartLen);
typedef CK_RV (CK_PTR  ST_C_DecryptFinal)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pLastPart,
                        CK_ULONG_PTR pusLastPartLen);
typedef CK_RV (CK_PTR  ST_C_DigestInit)
                       (ST_SESSION_T *hSession,
                        CK_MECHANISM_PTR pMechanism);
typedef CK_RV (CK_PTR  ST_C_Digest)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pData,
                        CK_ULONG usDataLen, CK_BYTE_PTR pDigest,
                        CK_ULONG_PTR pusDigestLen);
typedef CK_RV (CK_PTR  ST_C_DigestUpdate)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pPart,
                        CK_ULONG usPartLen);
typedef CK_RV (CK_PTR  ST_C_DigestKey)
                       (ST_SESSION_T *hSession, CK_OBJECT_HANDLE hKey);
typedef CK_RV (CK_PTR  ST_C_DigestFinal)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pDigest,
                        CK_ULONG_PTR pusDigestLen);
typedef CK_RV (CK_PTR  ST_C_SignInit)
                       (ST_SESSION_T *hSession, CK_MECHANISM_PTR pMechanism,
                        CK_OBJECT_HANDLE hKey);
typedef CK_RV (CK_PTR  ST_C_Sign)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pData,
                        CK_ULONG usDataLen, CK_BYTE_PTR pSignature,
                        CK_ULONG_PTR pusSignatureLen);
typedef CK_RV (CK_PTR  ST_C_SignUpdate)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pPart,
                        CK_ULONG usPartLen);
typedef CK_RV (CK_PTR  ST_C_SignFinal)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pSignature,
                        CK_ULONG_PTR pusSignatureLen);
typedef CK_RV (CK_PTR  ST_C_SignRecoverInit)
                       (ST_SESSION_T *hSession, CK_MECHANISM_PTR pMechanism,
                        CK_OBJECT_HANDLE hKey);
typedef CK_RV (CK_PTR  ST_C_SignRecover)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pData,
                        CK_ULONG usDataLen, CK_BYTE_PTR pSignature,
                        CK_ULONG_PTR pusSignatureLen);
typedef CK_RV (CK_PTR  ST_C_VerifyInit)
                       (ST_SESSION_T *hSession, CK_MECHANISM_PTR pMechanism,
                        CK_OBJECT_HANDLE hKey);
typedef CK_RV (CK_PTR  ST_C_Verify)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pData,
                        CK_ULONG usDataLen, CK_BYTE_PTR pSignature,
                        CK_ULONG usSignatureLen);
typedef CK_RV (CK_PTR  ST_C_VerifyUpdate)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pPart,
                        CK_ULONG usPartLen);
typedef CK_RV (CK_PTR  ST_C_VerifyFinal)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pSignature,
                        CK_ULONG usSignatureLen);
typedef CK_RV (CK_PTR  ST_C_VerifyRecoverInit)
                       (ST_SESSION_T *hSession, CK_MECHANISM_PTR pMechanism,
                        CK_OBJECT_HANDLE hKey);
typedef CK_RV (CK_PTR  ST_C_VerifyRecover)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pSignature,
                        CK_ULONG usSignatureLen, CK_BYTE_PTR pData,
                        CK_ULONG_PTR pusDataLen);
typedef CK_RV (CK_PTR  ST_C_DigestEncryptUpdate)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pPart,
                        CK_ULONG ulPartLen, CK_BYTE_PTR pEncryptedPart,
                        CK_ULONG_PTR pulEncryptedPartLen);
typedef CK_RV (CK_PTR  ST_C_DecryptDigestUpdate)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pEncryptedPart,
                        CK_ULONG ulEncryptedPartLen, CK_BYTE_PTR pPart,
                        CK_ULONG_PTR pulPartLen);
typedef CK_RV (CK_PTR  ST_C_SignEncryptUpdate)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pPart,
                        CK_ULONG ulPartLen, CK_BYTE_PTR pEncryptedPart,
                        CK_ULONG_PTR pulEncryptedPartLen);
typedef CK_RV (CK_PTR  ST_C_DecryptVerifyUpdate)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pEncryptedPart,
                        CK_ULONG ulEncryptedPartLen, CK_BYTE_PTR pPart,
                        CK_ULONG_PTR pulPartLen);
typedef CK_RV (CK_PTR  ST_C_GenerateKey)
                       (ST_SESSION_T *hSession, CK_MECHANISM_PTR pMechanism,
                        CK_ATTRIBUTE_PTR pTemplate, CK_ULONG usCount,
                        CK_OBJECT_HANDLE_PTR phKey);
typedef CK_RV (CK_PTR  ST_C_GenerateKeyPair)
                       (ST_SESSION_T *hSession, CK_MECHANISM_PTR pMechanism,
                        CK_ATTRIBUTE_PTR pPublicKeyTemplate,
                        CK_ULONG usPublicKeyAttributeCount,
                        CK_ATTRIBUTE_PTR pPrivateKeyTemplate,
                        CK_ULONG usPrivateKeyAttributeCount,
                        CK_OBJECT_HANDLE_PTR phPrivateKey,
                        CK_OBJECT_HANDLE_PTR phPublicKey);
typedef CK_RV (CK_PTR  ST_C_WrapKey)
                       (ST_SESSION_T *hSession, CK_MECHANISM_PTR pMechanism,
                        CK_OBJECT_HANDLE hWrappingKey, CK_OBJECT_HANDLE hKey,
                        CK_BYTE_PTR pWrappedKey, CK_ULONG_PTR pusWrappedKeyLen);
typedef CK_RV (CK_PTR  ST_C_UnwrapKey)
                       (ST_SESSION_T *hSession, CK_MECHANISM_PTR pMechanism,
                        CK_OBJECT_HANDLE hUnwrappingKey, CK_BYTE_PTR pWrappedKey,
                        CK_ULONG usWrappedKeyLen, CK_ATTRIBUTE_PTR pTemplate,
                        CK_ULONG usAttributeCount, CK_OBJECT_HANDLE_PTR phKey);
typedef CK_RV (CK_PTR  ST_C_DeriveKey)
                       (ST_SESSION_T *hSession, CK_MECHANISM_PTR pMechanism,
                        CK_OBJECT_HANDLE hBaseKey, CK_ATTRIBUTE_PTR pTemplate,
                        CK_ULONG usAttributeCount, CK_OBJECT_HANDLE_PTR phKey);
typedef CK_RV (CK_PTR  ST_C_SeedRandom)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pSeed,
                        CK_ULONG usSeedLen);
typedef CK_RV (CK_PTR  ST_C_GenerateRandom)
                       (ST_SESSION_T *hSession, CK_BYTE_PTR pRandomData,
                        CK_ULONG usRandomLen);
typedef CK_RV (CK_PTR  ST_C_GetFunctionStatus)
                       (ST_SESSION_T *hSession);
typedef CK_RV (CK_PTR  ST_C_CancelFunction)
                       (ST_SESSION_T *hSession);
typedef CK_RV	(CK_PTR  ST_Notify)
						(ST_SESSION_T *hSession, CK_NOTIFICATION event,
						 CK_VOID_PTR pApplication);
typedef CK_RV	(CK_PTR  ST_C_WaitForSlotEvent)
						(CK_FLAGS flags, CK_SLOT_ID_PTR pSlot,
						 CK_VOID_PTR pReserved);



struct ST_FCN_LIST{

   // Need initialization function But it is different than
   // the C_Initialize
	ST_C_Initialize ST_Initialize;
 
	ST_C_GetTokenInfo ST_GetTokenInfo;
	ST_C_GetMechanismList ST_GetMechanismList;
	ST_C_GetMechanismInfo ST_GetMechanismInfo;
	ST_C_InitToken ST_InitToken;
	ST_C_InitPIN ST_InitPIN;
	ST_C_SetPIN ST_SetPIN;

	ST_C_OpenSession ST_OpenSession;
	ST_C_CloseSession ST_CloseSession;
	ST_C_GetSessionInfo ST_GetSessionInfo;
	ST_C_GetOperationState ST_GetOperationState;  // Not used by Netscape
	ST_C_SetOperationState ST_SetOperationState;  // Not used by Netscape
	ST_C_Login ST_Login;
	ST_C_Logout ST_Logout;

	ST_C_CreateObject ST_CreateObject;
	ST_C_CopyObject ST_CopyObject;
	ST_C_DestroyObject ST_DestroyObject;
	ST_C_GetObjectSize ST_GetObjectSize;
	ST_C_GetAttributeValue ST_GetAttributeValue;
	ST_C_SetAttributeValue ST_SetAttributeValue;
	ST_C_FindObjectsInit ST_FindObjectsInit;
	ST_C_FindObjects ST_FindObjects;
	ST_C_FindObjectsFinal ST_FindObjectsFinal;


	ST_C_EncryptInit ST_EncryptInit;
	ST_C_Encrypt ST_Encrypt;
	ST_C_EncryptUpdate ST_EncryptUpdate;  // Not used by Netscape
	ST_C_EncryptFinal ST_EncryptFinal;  // Not used by Netscape
	ST_C_DecryptInit ST_DecryptInit;
	ST_C_Decrypt ST_Decrypt;
	ST_C_DecryptUpdate ST_DecryptUpdate;  // Not used by Netscape
	ST_C_DecryptFinal ST_DecryptFinal;  // Not used by Netscape
	ST_C_DigestInit ST_DigestInit;
	ST_C_Digest ST_Digest;
	ST_C_DigestUpdate ST_DigestUpdate;
	ST_C_DigestKey ST_DigestKey;
	ST_C_DigestFinal ST_DigestFinal;
	ST_C_SignInit ST_SignInit;
	ST_C_Sign ST_Sign;
	ST_C_SignUpdate ST_SignUpdate;
	ST_C_SignFinal ST_SignFinal;
	ST_C_SignRecoverInit ST_SignRecoverInit;
	ST_C_SignRecover ST_SignRecover;
	ST_C_VerifyInit ST_VerifyInit;
	ST_C_Verify ST_Verify;
	ST_C_VerifyUpdate ST_VerifyUpdate;
	ST_C_VerifyFinal ST_VerifyFinal;
	ST_C_VerifyRecoverInit ST_VerifyRecoverInit;
	ST_C_VerifyRecover ST_VerifyRecover;
	ST_C_DigestEncryptUpdate ST_DigestEncryptUpdate;
	ST_C_DecryptDigestUpdate ST_DecryptDigestUpdate;
	ST_C_SignEncryptUpdate ST_SignEncryptUpdate;
	ST_C_DecryptVerifyUpdate ST_DecryptVerifyUpdate;
	ST_C_GenerateKey ST_GenerateKey;
	ST_C_GenerateKeyPair ST_GenerateKeyPair;
	ST_C_WrapKey ST_WrapKey;    // Netscape optionsl will use En/Decrypt
	ST_C_UnwrapKey ST_UnwrapKey;
	ST_C_DeriveKey ST_DeriveKey;
	ST_C_SeedRandom ST_SeedRandom;
	ST_C_GenerateRandom ST_GenerateRandom;
   // Question if these have to be implemented for Netscape support
	ST_C_GetFunctionStatus ST_GetFunctionStatus;
	ST_C_CancelFunction ST_CancelFunction;

}; 

typedef struct ST_FCN_LIST  STDLL_FcnList_t;

#endif
