/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/SchemaTypesXml/ClassIdentifierXml.h"
#include "Doc/DocXml/SchemaTypesXml/InstanceParameterXml.h"
#include "Doc/DocXml/SchemaTypesXml/MethodParameterXml.h"

#include "Doc/SchemaTypesDoc/CClassIdentifierDoc.h"
#include "Doc/SchemaTypesDoc/CInstanceParameterDoc.h"
#include "Doc/SchemaTypesDoc/CMethodDoc.h"
#include "Doc/SchemaTypesDoc/CMethodParameterDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/SchemaTypesXml/MethodXml.h"

using namespace Caf;

void MethodXml::add(
	const SmartPtrCMethodDoc methodDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("MethodXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(methodDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string nameVal = methodDoc->getName();
		CAF_CM_VALIDATE_STRING(nameVal);
		thisXml->addAttribute("name", nameVal);

		const std::deque<SmartPtrCMethodParameterDoc> parameterVal =
			methodDoc->getParameterCollection();
		if (! parameterVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCMethodParameterDoc> > parameterIter(parameterVal);
				parameterIter; parameterIter++) {
				const SmartPtrCXmlElement parameterXml =
					thisXml->createAndAddElement("parameter");
				MethodParameterXml::add(*parameterIter, parameterXml);
			}
		}

		const std::deque<SmartPtrCInstanceParameterDoc> instanceParameterVal =
			methodDoc->getInstanceParameterCollection();
		if (! instanceParameterVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCInstanceParameterDoc> > instanceParameterIter(instanceParameterVal);
				instanceParameterIter; instanceParameterIter++) {
				const SmartPtrCXmlElement instanceParameterXml =
					thisXml->createAndAddElement("instanceParameter");
				InstanceParameterXml::add(*instanceParameterIter, instanceParameterXml);
			}
		}

		const std::deque<SmartPtrCClassIdentifierDoc> returnValVal =
			methodDoc->getReturnValCollection();
		if (! returnValVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCClassIdentifierDoc> > returnValIter(returnValVal);
				returnValIter; returnValIter++) {
				const SmartPtrCXmlElement returnValXml =
					thisXml->createAndAddElement("return");
				ClassIdentifierXml::add(*returnValIter, returnValXml);
			}
		}

		const std::deque<SmartPtrCClassIdentifierDoc> eventValVal =
			methodDoc->getEventValCollection();
		if (! eventValVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCClassIdentifierDoc> > eventValIter(eventValVal);
				eventValIter; eventValIter++) {
				const SmartPtrCXmlElement eventValXml =
					thisXml->createAndAddElement("event");
				ClassIdentifierXml::add(*eventValIter, eventValXml);
			}
		}

		const std::deque<SmartPtrCClassIdentifierDoc> errorVal =
			methodDoc->getErrorCollection();
		if (! errorVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCClassIdentifierDoc> > errorIter(errorVal);
				errorIter; errorIter++) {
				const SmartPtrCXmlElement errorXml =
					thisXml->createAndAddElement("error");
				ClassIdentifierXml::add(*errorIter, errorXml);
			}
		}

		const std::string displayNameVal = methodDoc->getDisplayName();
		if (! displayNameVal.empty()) {
			thisXml->addAttribute("displayName", displayNameVal);
		}

		const std::string descriptionVal = methodDoc->getDescription();
		if (! descriptionVal.empty()) {
			thisXml->addAttribute("description", descriptionVal);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCMethodDoc MethodXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("MethodXml", "parse");

	SmartPtrCMethodDoc methodDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string nameStrVal =
			thisXml->findRequiredAttribute("name");
		const std::string nameVal = nameStrVal;

		const CXmlElement::SmartPtrCElementCollection parameterChildrenXml =
			thisXml->findOptionalChildren("parameter");

		std::deque<SmartPtrCMethodParameterDoc> parameterVal;
		if (! parameterChildrenXml.IsNull() && ! parameterChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> parameterXmlIter(*parameterChildrenXml);
				parameterXmlIter; parameterXmlIter++) {
				const SmartPtrCXmlElement parameterXml = parameterXmlIter->second;
				const SmartPtrCMethodParameterDoc parameterDoc =
					MethodParameterXml::parse(parameterXml);
				parameterVal.push_back(parameterDoc);
			}
		}

		const CXmlElement::SmartPtrCElementCollection instanceParameterChildrenXml =
			thisXml->findOptionalChildren("instanceParameter");

		std::deque<SmartPtrCInstanceParameterDoc> instanceParameterVal;
		if (! instanceParameterChildrenXml.IsNull() && ! instanceParameterChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> instanceParameterXmlIter(*instanceParameterChildrenXml);
				instanceParameterXmlIter; instanceParameterXmlIter++) {
				const SmartPtrCXmlElement instanceParameterXml = instanceParameterXmlIter->second;
				const SmartPtrCInstanceParameterDoc instanceParameterDoc =
					InstanceParameterXml::parse(instanceParameterXml);
				instanceParameterVal.push_back(instanceParameterDoc);
			}
		}

		const CXmlElement::SmartPtrCElementCollection returnValChildrenXml =
			thisXml->findOptionalChildren("return");

		std::deque<SmartPtrCClassIdentifierDoc> returnValVal;
		if (! returnValChildrenXml.IsNull() && ! returnValChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> returnValXmlIter(*returnValChildrenXml);
				returnValXmlIter; returnValXmlIter++) {
				const SmartPtrCXmlElement returnValXml = returnValXmlIter->second;
				const SmartPtrCClassIdentifierDoc returnValDoc =
					ClassIdentifierXml::parse(returnValXml);
				returnValVal.push_back(returnValDoc);
			}
		}

		const CXmlElement::SmartPtrCElementCollection eventValChildrenXml =
			thisXml->findOptionalChildren("event");

		std::deque<SmartPtrCClassIdentifierDoc> eventValVal;
		if (! eventValChildrenXml.IsNull() && ! eventValChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> eventValXmlIter(*eventValChildrenXml);
				eventValXmlIter; eventValXmlIter++) {
				const SmartPtrCXmlElement eventValXml = eventValXmlIter->second;
				const SmartPtrCClassIdentifierDoc eventValDoc =
					ClassIdentifierXml::parse(eventValXml);
				eventValVal.push_back(eventValDoc);
			}
		}

		const CXmlElement::SmartPtrCElementCollection errorChildrenXml =
			thisXml->findOptionalChildren("error");

		std::deque<SmartPtrCClassIdentifierDoc> errorVal;
		if (! errorChildrenXml.IsNull() && ! errorChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> errorXmlIter(*errorChildrenXml);
				errorXmlIter; errorXmlIter++) {
				const SmartPtrCXmlElement errorXml = errorXmlIter->second;
				const SmartPtrCClassIdentifierDoc errorDoc =
					ClassIdentifierXml::parse(errorXml);
				errorVal.push_back(errorDoc);
			}
		}

		const std::string displayNameStrVal =
			thisXml->findOptionalAttribute("displayName");
		const std::string displayNameVal = displayNameStrVal;

		const std::string descriptionStrVal =
			thisXml->findOptionalAttribute("description");
		const std::string descriptionVal = descriptionStrVal;

		methodDoc.CreateInstance();
		methodDoc->initialize(
			nameVal,
			parameterVal,
			instanceParameterVal,
			returnValVal,
			eventValVal,
			errorVal,
			displayNameVal,
			descriptionVal);
	}
	CAF_CM_EXIT;

	return methodDoc;
}

