/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *
 */

#ifndef CSchemaDoc_h_
#define CSchemaDoc_h_


#include "Doc/SchemaTypesDoc/CActionClassDoc.h"
#include "Doc/SchemaTypesDoc/CDataClassDoc.h"
#include "Doc/SchemaTypesDoc/CLogicalRelationshipDoc.h"
#include "Doc/SchemaTypesDoc/CPhysicalRelationshipDoc.h"

namespace Caf {

/// Set of elements describing the objects that can be generated by the provider
class PROVIDERRESULTSDOC_LINKAGE CSchemaDoc {
public:
	CSchemaDoc();
	virtual ~CSchemaDoc();

public:
	/// Initializes the object with everything required by this
	/// container. Once initialized, this object cannot
	/// be changed (i.e. it is immutable).
	void initialize(
		const std::deque<SmartPtrCDataClassDoc> dataClassCollection,
		const std::deque<SmartPtrCActionClassDoc> actionClassCollection,
		const std::deque<SmartPtrCLogicalRelationshipDoc> logicalRelationshipCollection = std::deque<SmartPtrCLogicalRelationshipDoc>(),
		const std::deque<SmartPtrCPhysicalRelationshipDoc> physicalRelationshipCollection = std::deque<SmartPtrCPhysicalRelationshipDoc>());

public:
	/// Accessor for the DataClassCollection
	std::deque<SmartPtrCDataClassDoc> getDataClassCollection() const;

	/// Accessor for the ActionClassCollection
	std::deque<SmartPtrCActionClassDoc> getActionClassCollection() const;

	/// Accessor for the LogicalRelationshipCollection
	std::deque<SmartPtrCLogicalRelationshipDoc> getLogicalRelationshipCollection() const;

	/// Accessor for the PhysicalRelationshipCollection
	std::deque<SmartPtrCPhysicalRelationshipDoc> getPhysicalRelationshipCollection() const;

private:
	bool _isInitialized;

	std::deque<SmartPtrCDataClassDoc> _dataClassCollection;
	std::deque<SmartPtrCActionClassDoc> _actionClassCollection;
	std::deque<SmartPtrCLogicalRelationshipDoc> _logicalRelationshipCollection;
	std::deque<SmartPtrCPhysicalRelationshipDoc> _physicalRelationshipCollection;

private:
	CAF_CM_DECLARE_NOCOPY(CSchemaDoc);
};

CAF_DECLARE_SMART_POINTER(CSchemaDoc);

}

#endif
