/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafCoreTypesDoc/CClassFiltersDoc.h"
#include "Doc/CafCoreTypesDoc/CClassSpecifierDoc.h"
#include "Doc/CafCoreTypesDoc/CFullyQualifiedClassGroupDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/ClassSpecifierXml.h"
#include "Doc/DocXml/CafCoreTypesXml/FullyQualifiedClassGroupXml.h"
#include "Doc/DocXml/CafCoreTypesXml/ClassFiltersXml.h"

using namespace Caf;

void ClassSpecifierXml::add(
	const SmartPtrCClassSpecifierDoc classSpecifierDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ClassSpecifierXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(classSpecifierDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const SmartPtrCFullyQualifiedClassGroupDoc fullyQualifiedClassVal =
			classSpecifierDoc->getFullyQualifiedClass();
		if (! fullyQualifiedClassVal.IsNull()) {
			const SmartPtrCXmlElement fullyQualifiedClassXml =
				thisXml->createAndAddElement("fullyQualifiedClass");
			FullyQualifiedClassGroupXml::add(fullyQualifiedClassVal, fullyQualifiedClassXml);
		}

		const SmartPtrCClassFiltersDoc classFiltersVal =
			classSpecifierDoc->getClassFilters();
		if (! classFiltersVal.IsNull()) {
			const SmartPtrCXmlElement classFiltersXml =
				thisXml->createAndAddElement("classFilters");
			ClassFiltersXml::add(classFiltersVal, classFiltersXml);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCClassSpecifierDoc ClassSpecifierXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ClassSpecifierXml", "parse");

	SmartPtrCClassSpecifierDoc classSpecifierDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const SmartPtrCXmlElement fullyQualifiedClassXml =
			thisXml->findOptionalChild("fullyQualifiedClass");

		SmartPtrCFullyQualifiedClassGroupDoc fullyQualifiedClassVal;
		if (! fullyQualifiedClassXml.IsNull()) {
			fullyQualifiedClassVal = FullyQualifiedClassGroupXml::parse(fullyQualifiedClassXml);
		}

		const SmartPtrCXmlElement classFiltersXml =
			thisXml->findOptionalChild("classFilters");

		SmartPtrCClassFiltersDoc classFiltersVal;
		if (! classFiltersXml.IsNull()) {
			classFiltersVal = ClassFiltersXml::parse(classFiltersXml);
		}

		classSpecifierDoc.CreateInstance();
		classSpecifierDoc->initialize(
			fullyQualifiedClassVal,
			classFiltersVal);
	}
	CAF_CM_EXIT;

	return classSpecifierDoc;
}

