/*
 *	 Author: bwilliams
 *  Created: April 6, 2012
 *
 *	Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 */

#ifndef CAFCORETYPESDOCTYPES_H_
#define CAFCORETYPESDOCTYPES_H_

#include "Doc/CafCoreTypesDoc/CafCoreTypesDocTypes.h"

namespace Caf {
	typedef enum {
		PROPERTY_NONE,
		PROPERTY_STRING,
		PROPERTY_SINT32,
		PROPERTY_UINT32,
		PROPERTY_SINT64,
		PROPERTY_UINT64,
		PROPERTY_DECIMAL,
		PROPERTY_DOUBLE,
		PROPERTY_BOOLEAN,
		PROPERTY_DATETIME
	} PROPERTY_TYPE;

	typedef enum {
		PARAMETER_NONE,
		PARAMETER_STRING,
		PARAMETER_SINT32,
		PARAMETER_UINT32,
		PARAMETER_SINT64,
		PARAMETER_UINT64,
		PARAMETER_DECIMAL,
		PARAMETER_DOUBLE,
		PARAMETER_BOOLEAN,
		PARAMETER_DATETIME
	} PARAMETER_TYPE;

	typedef enum {
		LOGGINGLEVEL_NONE,
		LOGGINGLEVEL_DEBUG,
		LOGGINGLEVEL_INFO,
		LOGGINGLEVEL_WARN,
		LOGGINGLEVEL_ERROR,
		LOGGINGLEVEL_CRITICAL
	} LOGGINGLEVEL_TYPE;

	typedef enum {
		LOGGINGCOMPONENT_NONE,
		LOGGINGCOMPONENT_COMMUNICATIONS,
		LOGGINGCOMPONENT_MANAGEMENTAGENT,
		LOGGINGCOMPONENT_UINT32,
		LOGGINGCOMPONENT_PROVIDERFRAMEWORK,
		LOGGINGCOMPONENT_PROVIDER
	} LOGGINGCOMPONENT_TYPE;

	typedef enum {
		CMS_POLICY_NONE,
		CMS_POLICY_CAF_ENCRYPTED,
		CMS_POLICY_CAF_SIGNED,
		CMS_POLICY_CAF_ENCRYPTED_AND_SIGNED,
		CMS_POLICY_APP_SIGNED,
		CMS_POLICY_APP_ENCRYPTED,
		CMS_POLICY_APP_ENCRYPTED_AND_SIGNED
	} CMS_POLICY;
}

#endif /* CAFCORETYPESDOCTYPES_H_ */
