/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafCoreTypesDoc/CAuthnAuthzDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/AuthnAuthzXml.h"

using namespace Caf;

void AuthnAuthzXml::add(
	const SmartPtrCAuthnAuthzDoc authnAuthzDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("AuthnAuthzXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(authnAuthzDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string typeVal = authnAuthzDoc->getType();
		CAF_CM_VALIDATE_STRING(typeVal);
		thisXml->addAttribute("type", typeVal);

		const std::string valueVal = authnAuthzDoc->getValue();
		CAF_CM_VALIDATE_STRING(valueVal);
		const SmartPtrCXmlElement valueXml =
			thisXml->createAndAddElement("value");
		valueXml->setValue(valueVal);

		const std::string nameVal = authnAuthzDoc->getName();
		if (! nameVal.empty()) {
			thisXml->addAttribute("name", nameVal);
		}

		const std::string sequenceNumberVal =
				CStringConv::toString<int32>(authnAuthzDoc->getSequenceNumber());
		if (! sequenceNumberVal.empty()) {
			thisXml->addAttribute("sequenceNumber", sequenceNumberVal);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCAuthnAuthzDoc AuthnAuthzXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("AuthnAuthzXml", "parse");

	SmartPtrCAuthnAuthzDoc authnAuthzDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string typeVal =
			thisXml->findRequiredAttribute("type");

		const std::string valueVal =
			thisXml->findRequiredChild("value")->getValue();

		const std::string nameVal =
			thisXml->findOptionalAttribute("name");

		const std::string sequenceNumberStrVal =
			thisXml->findOptionalAttribute("sequenceNumber");
		int32 sequenceNumberVal = 0;
		if (! sequenceNumberStrVal.empty()) {
			sequenceNumberVal = CStringConv::fromString<int32>(sequenceNumberStrVal);
		}

		authnAuthzDoc.CreateInstance();
		authnAuthzDoc->initialize(
			typeVal,
			valueVal,
			nameVal,
			sequenceNumberVal);
	}
	CAF_CM_EXIT;

	return authnAuthzDoc;
}

