/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/ResponseDoc/CEventKeyDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ResponseXml/EventKeyXml.h"

using namespace Caf;

void EventKeyXml::add(
	const SmartPtrCEventKeyDoc eventKeyDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("EventKeyXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(eventKeyDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string nameVal = eventKeyDoc->getName();
		CAF_CM_VALIDATE_STRING(nameVal);
		thisXml->addAttribute("name", nameVal);

		const std::string valueVal = eventKeyDoc->getValue();
		CAF_CM_VALIDATE_STRING(valueVal);
		thisXml->addAttribute("value", valueVal);
	}
	CAF_CM_EXIT;
}

SmartPtrCEventKeyDoc EventKeyXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("EventKeyXml", "parse");

	SmartPtrCEventKeyDoc eventKeyDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string nameStrVal =
			thisXml->findRequiredAttribute("name");
		const std::string nameVal = nameStrVal;

		const std::string valueStrVal =
			thisXml->findRequiredAttribute("value");
		const std::string valueVal = valueStrVal;

		eventKeyDoc.CreateInstance();
		eventKeyDoc->initialize(
			nameVal,
			valueVal);
	}
	CAF_CM_EXIT;

	return eventKeyDoc;
}

